<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Barcode extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('barcode_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	var $master_url='https://bigcashew.com/inventory';
	public function fpIssue()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->barcode_model->get_FPItems($branch_id);
		$data['outlet'] = $this->barcode_model->get_outletout();
		$data['vehicle'] = $this->barcode_model->get_vehicle();
		$this->load->view('Barcode/fp_isuue_entry',$data);
	}
	
	public function lastScanned()
	{
		$bcode = $this->input->post('bcode');
		$this->barcode_model->lastScanned($bcode);
	}
	
	public function updateQty(){
	    $recipe_id = $this->input->post('recipe_id');
	    $qty = $this->input->post('qty');
	    $this->db->query("update recipe set scan_count='$qty' where ecipe_id='$recipe_id'");
	}
	
	public function addIssue()
	{
		$isid=$this->barcode_model->addPrIssue($this->input->post());
		
		if($isid)
		{
		    redirect('Barcode/issuePView/'.$isid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Barcode/issueFPEntry/');
		}
	}
	
	public function issuePView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		
		$data['issue'] = $this->barcode_model->getPrIssue($isid);
		$data['issue_item'] = $this->barcode_model->getPrIssueItem($isid);
		
		$this->load->view('Barcode/issue_pview',$data);
	}
}