<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Invoice extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('invoice_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	//var $master_url='https://gsrgroup.biz/inv_final_test';
    var $master_url='https://cake-master.com/inv_mod';
    
	public function invoiceCreation(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		
		$data['getCustomer'] = $this->master_model->getCustomer($branch_id);
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$this->load->view('Invoice/invoiceCreation',$data);
	}

	public function addInvice(){
		$in_id=$this->invoice_model->addInvice($this->input->post());
		if($in_id)
		{
		    redirect('Invoice/invoiceReceipt/'.$in_id);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Invoice/invoiceCreation/');
		}
		
	}
	
	public function invoiceReceipt($in_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['invoice_receipt'] = $this->invoice_model->invoice_receipt($in_id);
		$data['invoice_receipt_item'] = $this->invoice_model->invoice_receipt_item($in_id);
		$data['invoice_total_sum'] = $this->invoice_model->invoice_total_sum($in_id);
		$this->load->view('Invoice/invoiceReceipt',$data);
	}

	public function invoiceList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$branch = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);		
		$data['getCustomer'] = $this->master_model->getCustomer($branch_id);
		$data['getItemList'] = $this->master_model->get_Items($branch_id);		
		$data['invoice'] = $this->invoice_model->invoice_list($branch_id);
		$this->load->view('Invoice/invoiceList',$data);
	}
	
	public function getInvoice(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->invoice_model->invoice_list($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Invoice/viewInvoice/$row->invoice_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    
    	    $test[] = array(
    	        $count,
    	        $row->invoice_no,
    	        $row->invoice_date,
                $row->outlet_name,
                $row->value,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function viewInvoice($in_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['invoice_receipt'] = $this->invoice_model->invoice_receipt($in_id);
		$data['invoice_receipt_item'] = $this->invoice_model->invoice_receipt_item($in_id);
		$data['invoice_total_sum'] = $this->invoice_model->invoice_total_sum($in_id);
		$this->load->view('Invoice/viewInvoice',$data);
	}

	public function search_invoice(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$sub_mod_id=$this->input->post('sub_mod_id');
			
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$outlet_name = $this->input->post('outlet_name');
		$item_name = $this->input->post('item_name');
		$data = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'outlet_name' => $outlet_name,
		'item_name' => $item_name
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "Both feilds are required";
			} else {
			$result = $this->invoice_model->search_invoice($data);
			
			
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['sub_mod_id']=$sub_mod_id;
		$data['getCustomer'] = $this->master_model->getCustomer($branch_id);
		$data['getItemList'] = $this->master_model->get_Items($branch_id);	
		//$data['getItemList'] = $this->master_model->getItemList($branch_id);	
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);	
		$this->load->view('Invoice/invoiceList', $data);
	}

	public function productInvoice()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['getCustomer'] = $this->master_model->getCustomer($branch_id);
		$data['category'] = $this->master_model->getCategory();
		$data['products'] = $this->master_model->getProducts($branch_id);
		$this->load->view('Invoice/product_invoice',$data);
	}

	public function addProductInvoice()
	{
		$isid=$this->invoice_model->addProductInvoice($this->input->post());
		if($isid)
		{
		    redirect('Invoice/invoiceView/'.$isid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Invoice/productInvoice/');
		}
	}
	
	public function invoiceView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd'] = $this->invoice_model->getProductInvoice($isid);
		$data['prd_item'] = $this->invoice_model->getProductInvoiceItem($isid);
		$this->load->view('Invoice/invoice_view',$data);
	}
	
	public function productInvoiceList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['invoice_list'] = $this->invoice_model->getProductInvoiceList($branch_id);
		$this->load->view('Invoice/product_invoicelist',$data);
	}
	
	public function CinvoiceList ()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);		
		$data['branch'] = $this->user_model->get_branch();
		$data['invoice'] = $this->invoice_model->cInvoice_list();
		$this->load->view('Invoice/CinvoiceList',$data);
	}

	public function searchCInvoice(){
		$user_id = $_SESSION['user_id'];
		//$branch = $_SESSION['branch_name'];
		$sub_mod_id=$this->input->post('sub_mod_id');
			
		
		$branch = $this->input->post('branch');
		$data = array(
		'branch' => $branch
		);
		if ($branch == "") {
			$data['date_range_error_message'] = "Both feilds are required";
			} else {
			$result = $this->invoice_model->search_Cinvoice($data);
			
			
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['sub_mod_id']=$sub_mod_id;
		$data['branch'] = $this->user_model->get_branch();	
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);	
		$this->load->view('Invoice/CinvoiceList', $data);
	}

	public function export_CInvoice(){

		$branchn = $this->input->post('branchn');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Invoice_Report.csv";
		$query = "SELECT i.invoice_no,i.outlet_name,DATE_FORMAT(i.invoice_date, '%d-%m-%Y') as invoice_date,i.branchname,sum(p.total_amount) as value from invoice i inner join invoice_item p on i.invoice_id=p.invoice_id where i.branchname='$branchn' group by p.invoice_id";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
}
?>