<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Issues extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('issue_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	var $master_url='https://bigcashew.com/inventory';
	public function issueEntry()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['outlet'] = $this->issue_model->get_outlet_by_branch($branch,$sub_mod_id);
		$data['vehicle'] = $this->issue_model->get_vehicle();
		$this->load->view('Issues/isuue_entry',$data);
	}
	
	
	public function vehicle_fetch(){
		$keyword = $this->input->post('vehicle_id');
		$this->issue_model->vehicle_fetch($keyword);
	}
	
	public function issueFPEntry()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->issue_model->get_FPItems($branch_id);
		$data['outlet'] = $this->issue_model->get_outletout();
		$data['vehicle'] = $this->issue_model->get_vehicle();
		$this->load->view('Issues/isuue_FPentry',$data);
	}
	public function get_PItemDetails()
	{
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->issue_model->get_PItemDetails($iname,$br_id);
	}
	
	public function addIssue()
	{
		$isid=$this->issue_model->addPrIssue($this->input->post());
		
		if($isid)
		{
		    redirect('Issues/issuePView/'.$isid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Issues/issueFPEntry/');
		}
	}
	
	public function addRMIssue()
	{
		$isid=$this->issue_model->addIssue($this->input->post());
		
		if($isid)
		{
		    redirect('Issues/issueView/'.$isid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Issues/issueEntry/');
		}
	}
	
	public function issueView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);
		$this->load->view('Issues/issue_view',$data);
	}
	
	public function issuePView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		/*$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);*/
		
		$data['issue'] = $this->issue_model->getPrIssue($isid);
		$data['issue_item'] = $this->issue_model->getPrIssueItem($isid);
		$data['issue_total'] = $this->issue_model->getPrIssueTotalItem($isid);
		$this->load->view('Issues/issue_pview',$data);
	}
	
	public function issuetList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->issue_model->getIssueList($branch_id);
		$this->load->view('Issues/issue_list',$data);
	}
	
	public function issueRMList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->issue_model->getRMIssueList($branch_id);
		$this->load->view('Issues/issue_rlist',$data);
	}
	
	public function issuesCList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$this->load->view('Issues/issue_rlist',$data);
	}
	
	public function get_issuesCList(){
		
		//$data = $this->issue_model->get_CIssueList();
		$data = $this->issue_model->get_PRCIssueList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Issues/issueView/$row->mid' class=''><i class='ft-eye'></i></a>";
    	    $test[] = array(
    	        $count,
    	        $row->issue_no,
    	        $row->issue_date,
                $row->outlet,
                $view,
                
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}

	public function getCIssueList()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$item_data = $this->issue_model->getCIssueList($row,$rowperpage);
		foreach ($item_data as $item) 
		{ 
			$data[] = array(
			"issue_no"=>$item->issue_no,
			"issue_date"=>$item->issue_date,
			"outlet_name"=>$item->outlet_name,
			"total"=>$item->total,
			"mid"=>$item->mid
			);
		} 
		echo json_encode($data);
	}

	public function searchCissueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->issue_model->getIssueListReport($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Issues/issue_rlist',$data);
	}

	public function exportIssueReport()
	{
		$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));;
		$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
		$branchn = $this->input->post('branchn');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Issue_Report.csv";
		$query = "SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM product_issues_creation where issue_date between '$from_date' and '$to_date' and outlet='$branchn' ORDER BY issue_id desc";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	public function issueRMTax()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['outlet'] = $this->issue_model->get_outletout();
		$data['vehicle'] = $this->issue_model->get_vehicle();
		$this->load->view('Issues/isuue_RMentry',$data);
	}
	
	public function addRMTIssue()
	{
		$isid=$this->issue_model->addTaxIssue($this->input->post());
		
		if($isid)
		{
		    redirect('Issues/issueRMView/'.$isid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Issues/issueRMTax/');
		}
	}
	
	public function issueRMView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);
		$this->load->view('Issues/issue_RMView',$data);
	}
	
	
	public function taxIssueList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->issue_model->getIssueTaxList($branch_id);
		$this->load->view('Issues/issue_taxlist',$data);
	}
	
	
	public function issueFPTaxList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->issue_model->getIssueFPTaxList($branch_id);
		$this->load->view('Issues/issue_FPTlist',$data);
	}
	
	public function issueCRMView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);
		$this->load->view('Issues/issue_CRMView',$data);
	}
	
	public function productCIssueList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['outlet'] = $this->issue_model->get_outletout();
		$data['issue_list'] = $this->issue_model->get_CPIssueList();
		$this->load->view('Issues/productCIssueList',$data);
	}
	
	public function get_PissuesCList(){
		
		$data = $this->issue_model->get_CPIssueList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Issues/issueCFPView/$row->mid' class=''><i class='ft-eye'></i></a>";
    	    $test[] = array(
    	        $count,
    	        $row->issue_no,
    	        $row->issue_date,
    	        $row->dc_no,
                $row->outlet,
                round($row->basic,2),
                round($row->tax_amt,2),
                round($row->tot_amt,2),
                $view,
                
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function searchCPissueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->issue_model->getPIssueListReport($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['outlet'] = $this->issue_model->get_outletout();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Issues/productCIssueList',$data);
	}
	
	public function issueCPView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		/*$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);*/
		
		$data['issue'] = $this->issue_model->getPrIssue($isid);
		$data['issue_item'] = $this->issue_model->getPrIssueItem($isid);
		
		$this->load->view('Issues/issue_Cpview',$data);
	}
	
	public function issuesCTList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['outlet'] = $this->issue_model->get_outletout();
		//$data['issue_list'] = $this->materialrequest_model->getCIssueList();
		$this->load->view('Issues/issuesCTList',$data);
	}
	
	public function get_issuesCTList(){
		
		$data = $this->issue_model->get_CTIssueList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Issues/issueCRMTView/$row->mid' class=''><i class='ft-eye'></i></a>";
    	    $test[] = array(
    	        $count,
    	        $row->issue_no,
    	        $row->issue_date,
    	        $row->dc_no,
                $row->outlet_name,
                round($row->basic,2),
                round($row->tax_amt,2),
                round($row->tot_amt,2),
                $view,
                
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	

	public function searchCTissueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->issue_model->getTIssueListReport($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['outlet'] = $this->issue_model->get_outletout();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Issues/issuesCTList',$data);
	}
	
	public function issueCRMTView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);
		$this->load->view('Issues/issue_CRMTView',$data);
	}
	
	public function issuePDCEntry()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->issue_model->get_FPItems($branch_id);
		$data['outlet'] = $this->issue_model->get_outlet_by_branch($branch,$sub_mod_id);
		//$data['outlet'] = $this->issue_model->get_outletout();
		$data['vehicle'] = $this->issue_model->get_vehicle();
		$this->load->view('Issues/isuue_DCPentry',$data);
	}
	
	public function addDCIssue()
	{
		$isid=$this->issue_model->addPrDCIssue($this->input->post());
		
		if($isid)
		{
		    redirect('Issues/issueDCPView/'.$isid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Issues/isuue_DCPentry/');
		}
	}
	
	public function issueDCPView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		/*$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);*/
		
		$data['issue'] = $this->issue_model->getPrIssue($isid);
		$data['issue_item'] = $this->issue_model->getPrIssueItem($isid);
		$data['issue_total'] = $this->issue_model->getPrIssueTotalItem($isid);
		
		$this->load->view('Issues/issue_pdcview',$data);
	}
	
	public function issueDCPRView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		/*$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);*/
		
		$data['issue'] = $this->issue_model->getPrIssue($isid);
		$data['issue_item'] = $this->issue_model->getPrIssueItem($isid);
		$data['issue_total'] = $this->issue_model->getPrIssueTotalItem($isid);
		
		$this->load->view('Issues/issue_prdcview',$data);
	}
	public function issueDCPList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->issue_model->getIssueFPDCList($branch_id);
		$this->load->view('Issues/issue_DCPlist',$data);
	}
	
	public function action_status(){
		$billid = $this->input->post('billid');
		$bill_status = $this->input->post('bill_status');
		$cdate = date('Y-m-d');
		$lm=date("d/m/YH:i:s",time());
		if($billid != ''){
			$q = $this->db->query("select * from product_issues_creation where issue_id='$billid'");
			foreach($q->result_array() as $r)
			$branch_id = $r['branch_id'];
			$branch_name = $r['branch_name'];
			$pissue_ref_no = $r['invoice_no'].'-Rev';
			//$outlet_id = $r['outlet_id'];
			$outlet_name = $r['outlet'];
			//$login_id = $r['login_id'];
			
			$query = $this->db->query("select * from product_issues_item where issue_id='$billid'");
			if($query->num_rows() >0){
				$num_rows = $query->num_rows();
				foreach($query->result_array() as $row1)
				{
					$product_name = $row1['issue_item_name'];
					$qty = $row1['issued_qty'];
					$product_id = $row1['recipe_id'];
					$issue_pr_id=$row1['issue_order_id'];
					//echo $product_name;
					$q2 = $this->db->query("select * from recipe where recipe_id='$product_id'");
					foreach($q2->result_array() as $r1)
					$product_stk = $r1['production_stock'];
					$recipe_no = $r1['recipe_no'];
					$pr_cat_id = $r1['pr_cat_id'];
					$stk = $product_stk+$qty;
					$this->db->query("update recipe set production_stock='$stk' where recipe_id='$product_id'");
					
					/*$q3 = $this->db->query("select * from recipe where product_name='$product_name' and branch_id='$outlet_id'");
					foreach($q3->result_array() as $r3)
					$product_stk3 = $r3['product_stk'];
					$stk3 = $product_stk3-$qty;
					$this->db->query("update product_creation set product_stk='$stk3' where product_name='$product_name' and branch_id='$outlet_id'");
					*/
					$this->db->query("insert into stock_detail(item_name,trans_ref_no,transaction_date,opening_stock,in_qty,closing_stock,last_modified,branch_id,branchname ,item_id,category_id,recipe_no)values('$product_name','$pissue_ref_no','$cdate','$product_stk','$qty','$stk','$lm','$branch_id','$branch_name','$product_id','$pr_cat_id','$recipe_no')");
					
					//$this->db->query("insert into product_stock_detail(product_name,trans_ref_no,transaction_date,opening_stk,out_qty,closing_stk,last_modified,branch_id,branch_name)values('$product_name','$pissue_ref_no','$cdate','$product_stk3','$qty','$stk3','$lm','$outlet_id','$outlet_name')");
				}
			}
			$sql1 = $this->db->query("update product_issues_creation set issue_status='$bill_status',cancel_date='$cdate' where issue_id='$billid'");
			echo '1';
		}else{
		echo 0;
		}
	}

}