<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Issues extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('issue_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	
	public function issueEntry()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['outlet'] = $this->issue_model->get_outlet_by_branch($branch,$sub_mod_id);
		$this->load->view('Issues/isuue_entry',$data);
	}
	
	public function addIssue()
	{
		$isid=$this->issue_model->addIssue($this->input->post());
		if($isid)
		{
		    redirect('Issues/issueView/'.$isid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Issues/issueEntry/');
		}
	}
	
	public function issueView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->issue_model->getIssue($isid);
		$data['issue_item'] = $this->issue_model->getIssueItem($isid);
		$this->load->view('Issues/issue_view',$data);
	}
	
	public function issuetList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->issue_model->getIssueList($branch_id);
		$this->load->view('Issues/issue_list',$data);
	}
}