<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Maintainance extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('maintain_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}	
	//var $master_url='https://gsrgroup.biz/inv_final_test';
    var $master_url='https://bigcashew.com/inventory';
    
	public function maintainance_grn()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['tax'] = $this->master_model->get_Tax();
		$data['vendor'] = $this->maintain_model->get_vendor();
		$this->load->view('Maintainance/maintainance_grn',$data);
	}
	
	
	public function addMaintainance()
	{
		$grn_id=$this->maintain_model->addMaintainance($this->input->post());
		if($grn_id)
		{
		    redirect('Maintainance/maintainance_invoice/'.$grn_id);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Maintainance/maintainance_grn/');
		}
	}
	
	public function maintainance_invoice($grn_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mnt_grn'] = $this->maintain_model->get_mnt_grn($grn_id);
		$data['mnt_grn_item'] = $this->maintain_model->get_mnt_grn_item($grn_id);
		$data['mnt_grn_total_sum'] = $this->maintain_model->mnt_grn_total_sum($grn_id);
		$this->load->view('Maintainance/preview_maintainance',$data);
		
	}
	public function mnt_grn_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		//$data['maintainance_grn'] = $this->maintain_model->mnt_grn_list($branch_id);
		$this->load->view('Maintainance/mnt_grn_list',$data);	
	}
	
	public function get_mntGrndata(){
	    
	    $branch_id = $_SESSION['branch_id'];
	    $data = $this->maintain_model->mnt_grn_list($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	     
    	    $view ="<a href='$this->master_url/index.php/Maintainance/maintainance_view/$row->m_grn_id' ><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
    	        $row->m_grn_no,
    	        $row->grn_date,
    	        $row->vendor_name,
    	        $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas); 
	}
	
	public function maintainance_view($grn_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['mnt_grn'] = $this->maintain_model->get_mnt_grn($grn_id);
		$data['mnt_grn_item'] = $this->maintain_model->get_mnt_grn_item($grn_id);
		$data['mnt_grn_total_sum'] = $this->maintain_model->mnt_grn_total_sum($grn_id);
		$this->load->view('Maintainance/maintainance_view',$data);
		
	}
	
	public function cmaintainance_view($grn_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['mnt_grn'] = $this->maintain_model->get_mnt_grn($grn_id);
		$data['mnt_grn_item'] = $this->maintain_model->get_mnt_grn_item($grn_id);
		$data['mnt_grn_total_sum'] = $this->maintain_model->mnt_grn_total_sum($grn_id);
		$this->load->view('Maintainance/cmaintainance_view',$data);
		
	}
	
	public function mnt_stock(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mnt_stock'] = $this->maintain_model->mnt_stock($branch_id);
		$this->load->view('Maintainance/mnt_stock',$data);	
	}
	
	public function cmnt_stock(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch'] = $this->user_model->get_branch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mnt_stock'] = $this->maintain_model->cmnt_stock();
		$this->load->view('Maintainance/cmnt_stock',$data);	
	}
	
	public function searchCommonStock()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
				
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'branch' => $branch
		);
		if ($branch == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->maintain_model->cmnt_stockBranch($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Maintainance/cmnt_stock',$data);
	}
	
	public function get_mntStock(){
	    $branch_id = $_SESSION['branch_id'];
	    $data = $this->maintain_model->mnt_stock($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	     
    	    $tax_amt = ($row->price * $row->tax) / 100;
    	    $tot_amt=round(($row->price + $tax_amt),2);
    	    $test[] = array(
    	        $count,
    	        $row->item_name,
    	        $row->price,
    	        $row->tax,
    	        $tot_amt,
    	        $row->stock
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas); 
	}
	
	public function cmnt_grn_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['maintainance_grn'] = $this->maintain_model->cmnt_grn_list();
		$this->load->view('Maintainance/ceo_mnt_grn_list',$data);	
	}
	
	public function get_CmntGrndata(){
	    $branch_id = $_SESSION['branch_id'];
	    $data = $this->maintain_model->cmnt_grn_list();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	     
    	    $view ="<a href='$this->master_url/index.php/Maintainance/cmaintainance_view/$row->m_grn_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
    	        $row->m_grn_no,
    	        $row->grn_date,
    	        $row->vendor_name,
    	        $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas); 
	}
	
	public function maintainance_dgrn()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_dmnt_item($branch_id);
		$data['vendor'] = $this->maintain_model->get_vendor();
		$this->load->view('Maintainance/maintainance_dgrn',$data);
	}
	
	
	public function directGrn(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['submod_id']= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['vendor'] = $this->master_model->get_vendors($branch_id);
		$this->load->view('Maintainance/directGrn',$data);
	}
	
	public function addGrn(){
		$gid=$this->maintain_model->addDGrn($this->input->post());
		if($gid)
		{
		    redirect('Maintainance/inward_invoice/'.$gid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Maintainance/directGrn/');
		}
	}
	
	public function inward_invoice($gid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['grn_data'] = $this->maintain_model->get_dgrn($gid);
		$data['get_grn_item'] = $this->maintain_model->get_dgrn_details($gid);
		$data['grn_total_amount'] = $this->maintain_model->grn_total_amount($gid);
		$data['grn_upload'] = $this->maintain_model->get_uploaded_invoice($gid);
		
		$this->load->view('Maintainance/inward_print',$data);
		
	}
	
	public function mnt_dgrn_list(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['maintainance_grn'] = $this->maintain_model->d_grn_list($branch_id);
		$this->load->view('Maintainance/dgrn_list',$data);	
	}
	
	public function rejection_po($mid,$sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['mid']=$mid;
		$data['smid']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['get_rejection'] = $this->maintain_model->get_drjection_grn($mid);
		$data['get_rejection_item'] = $this->maintain_model->get_drejection_item($mid);
		$this->load->view('Maintainance/rejection_po',$data);
		
	}

	public function addRejection(){
		$gid=$this->maintain_model->addRejection($this->input->post());
		$grn_id = $this->input->post('gnr_id');
		$smid = $this->input->post('smid');
		if($gid)
		{
		    redirect('Maintainance/rejection_receipt/'.$gid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Maintainance/rejection_po/'.$grn_id.'/'.$smid);
		}
	}
	
	public function rejection_receipt($rejection_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rejection'] = $this->maintain_model->get_drejection_receipt_details($rejection_id);
		$data['rejection_item'] = $this->maintain_model->get_dreceipt_rejection_print_list($rejection_id);
		$data['rejection_sum_amount'] = $this->maintain_model->total_sum_drejection_amount($rejection_id);
		$this->load->view('Maintainance/rejection_receipt',$data);
		
	}
	
	public function rejection_list($sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rejection_list'] = $this->maintain_model->get_rejection_list($branch_id);
		$this->load->view('Maintainance/rejection_list',$data);		
	}
	
	public function rejection_view($rejection_id,$sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
	    $data['rejection'] = $this->maintain_model->get_drejection_receipt_details($rejection_id);
		$data['rejection_item'] = $this->maintain_model->get_dreceipt_rejection_print_list($rejection_id);
		$data['rejection_sum_amount'] = $this->maintain_model->total_sum_drejection_amount($rejection_id);
		$this->load->view('Maintainance/rejection_receipt',$data);
	}
}