<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Master extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->db2 = $this->load->database('otherdb', TRUE);
		$this->db3 = $this->load->database('otherdb1', TRUE);
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('stockmanage_model');
		$this->load->model('productrequest_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	
	//Module
	public function category($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawCategory'] = $this->report_model->getRawCategory();
		$this->load->view('master/category',$data);
		//redirect('Master/category/'.$sub_mod_id);
	}
	
	public function ccategory($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawCategory'] = $this->report_model->getRawCategory();
		$this->load->view('master/ccategory',$data);
		//redirect('Master/category/'.$sub_mod_id);
	}
	
	public function categoryInsert(){
		$this->master_model->addRawCategory($this->input->post());
		$sub_mod_id = $this->input->post('sub_modid');
		//redirect('Master/category');
		redirect('Master/category/'.$sub_mod_id);
	}
	
	public function categoryEdit($sub_mod_id,$category_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['cat_view'] = $this->report_model->getCategoryId($category_id);
		$this->load->view('master/editCategory',$data);
	}
	
	public function category_update($category_id){
		
		$user_id = $_SESSION['user_id'];
		
		$category_name= $this->input->post('category_name');
		$sub_mod_id= $this->input->post('sub_mod_id');
		$data1 = array('category_name' => $category_name);
		$this->db->where('category_id',$category_id);
		$this->db->update('category',$data1);
		
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawCategory'] = $this->report_model->getRawCategory();
		redirect('Master/category/'.$sub_mod_id);
	}
	
	public function categoryDelete($sub_mod_id,$category_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$this->db->query("delete from item_creation where category_id='$category_id'");
		$this->db->query("delete from item where category_id='$category_id'");
		$this->db->query("delete from category where category_id='$category_id'");
		redirect('Master/category/'.$sub_mod_id);
	}
	
	public function change_cat_status(){
		$cat_id = $this->input->post('cat_id');
		$status = $this->input->post('cat_status');
		
		if($status != ''){
			$this->db->query("update item set status='$status' where category_id='$cat_id'");
			$this->db->query("update item_creation set status='$status' where category_id='$cat_id'");
			$this->db->query("update category set status='$status' where category_id='$cat_id'");
			echo 1;
		}else{
			echo 0;
		}
	}
		
	public function recipeCategory($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['productCategory'] = $this->report_model->getProductCategory();
		$data['combination'] = $this->master_model->getCombination();
		$data['counter'] = $this->master_model->get_CounterUser();
		$this->load->view('master/productCategory',$data);
		//$this->load->view('master/recipeCategory',$data);
	}
	
	public function recipeCategoryInsert(){
		$this->master_model->addRecipeCategory($this->input->post());
		$sub_mod_id = $this->input->post('sub_mod_id');
		redirect('Master/recipeCategory/'.$sub_mod_id);
	}
	
	public function recipeCatEdit($sub_mod_id,$pr_cat_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['cat_view'] = $this->report_model->getRecipeCategoryId($pr_cat_id);
		$data['combination'] = $this->master_model->getCombination();
		$data['counter'] = $this->master_model->get_CounterUser();
		$this->load->view('master/editPrCategory',$data);
	}
	
	public function prCat_update($pr_cat_id){
		
		$user_id = $_SESSION['user_id'];
		$pr_cat_name= $this->input->post('pr_cat_name');
		$sub_mod_id= $this->input->post('sub_mod_id');
		
		
		$crt_date = date('Y-m-d H:i:s');
		
		$data1 = array(
			'pr_cat_name' => $pr_cat_name
		);
		$this->db->where('pr_cat_id',$pr_cat_id);
		$this->db->update('product_category',$data1);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['productCategory'] = $this->report_model->getProductCategory();
		redirect('Master/recipeCategory/'.$sub_mod_id);
	}
	
	public function rccategoryDelete($sub_mod_id,$pr_cat_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$this->db->query("delete from recipe where pr_cat_id='$pr_cat_id'");
		$this->db->query("delete from product_category where pr_cat_id='$pr_cat_id'");
		redirect('Master/recipeCategory/'.$sub_mod_id);
	}
	
	public function change_prcat_status(){
		$this->db2 = $this->load->database('otherdb', TRUE);
		$cat_id = $this->input->post('cat_id');
		$status = $this->input->post('cat_status');
		$effective = $this->input->post('effective');
		
		$effective_date = date('Y-m-d',strtotime($effective));
		if($status == 'Enabled')
		{
			$cat_status = 'Active';
		}
		else
		{
			$cat_status = 'InActive';
		}
		
		if($status != ''){
			$this->db->query("update recipe set status='$status',status_effective='$effective_date' where pr_cat_id='$cat_id'");
			
			$this->db->query("update product_category set status='$status',effective_from='$effective_date' where pr_cat_id='$cat_id'");
			$this->db2->query("update product_category set status='$cat_status',effective_from='$effective_date' where cat_ref='$cat_id'");
			$this->db3->query("update product_category set status='$cat_status',effective_from='$effective_date' where cat_ref='$cat_id'");
			
			$q1 = $this->db2->query("select * from product_category where cat_ref='$cat_id'");
			$row = $q1->row_array();
			$pcatid = $row['pr_cat_code'];
			
			$this->db2->query("update product set product_status='$cat_status',effective_from='$effective_date' where pr_cat_id='$pcatid'");
			$this->db3->query("update product set product_status='$cat_status',effective_from='$effective_date' where pr_cat_id='$pcatid'");
		
			echo 1;
		}else{
			echo 0;
		}
	}
	
	public function productCatList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['productCategory'] = $this->master_model->get_pCategory();
		$this->load->view('master/cRecipe_category',$data);
		//redirect('Master/category/'.$sub_mod_id);
	}
	
	public function chef()
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('master/chef',$data);
	}
	
	public function chefInsert(){
		$this->master_model->addChef($this->input->post());
		redirect('Master/chef');
	}
	
	public function supplier()
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_supbranch();
		$this->load->view('master/supplier',$data);
	}

	public function addSupplier()
	{
		$this->master_model->addSupplier($this->input->post());
		redirect('Master/supplierList');
	}
	
	public function supplierList()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['supplier'] = $this->master_model->getSupplier();
		$this->load->view('master/supplier_list',$data);
	}
	
	public function supplierData()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['supplier'] = $this->master_model->getSupplier();
		$this->load->view('master/supplierList',$data);
	}
	
	public function csupplierList()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['supplier'] = $this->master_model->getSupplier();
		$this->load->view('master/csupplier_list',$data);
	}
	
	public function admsupplierList()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['supplier'] = $this->master_model->getSupplier();
		$this->load->view('master/admsupplier_list',$data);
	}
	
	/*public function accsupplierList()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['supplier'] = $this->master_model->getSupplier();
		$this->load->view('master/accSupplier_list',$data);
	}*/
	
	public function supplierEdit($vid,$vref)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$data['submod_id']=$submod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['supplier'] = $this->master_model->getSupplierDetail($vid);
		$data['supplierbr'] = $this->master_model->getSupplierDetailBranch($vref);
		$this->load->view('master/supplier_edit',$data);
	}
	
	public function edtSupplier()
	{
		$this->master_model->edtSupplier($this->input->post());
		$sub_mod_id = $this->input->post('sub_mod_id');
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getSupplier();
		redirect('Master/supplierList/'.$sub_mod_id);
	}
	
	public function rawMaterial()
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['branch'] = $this->user_model->get_Rawbranch();
		//$data['rcpbranch'] = $this->user_model->get_rmrcpbranch();
		///$data['salebranch'] = $this->master_model->get_salesBranch();
		//$data['santhebranch'] = $this->master_model->get_santheBranch();
		$this->load->view('master/rawMaterial',$data);
	}
	
	public function itemInsert() {
		$this->master_model->addItem($this->input->post());
		redirect('Master/rawMaterial');
	}
	
	public function rawMaterialList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getRawItem();
		$this->load->view('Report/rawMaterialList',$data);
	}
	
	public function crawMaterialList()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
	//	$data['rawItem'] = $this->report_model->getRawItem();
		$data['rawItem'] = $this->master_model->get_CWitemall();
		$this->load->view('Report/crawMaterialList',$data);
	}
	
	public function cRawMaterialApprove()
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		//$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getApproveRawItem();
		$this->load->view('Report/rawMaterialApprove',$data);
	}
	
	public function approveItem($itm_id)
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->db->query("update item set active_status='active' where itm_id='$itm_id'");
		$data['rawItem'] = $this->report_model->getApproveRawItem();
		$this->load->view('Report/rawMaterialApprove',$data);
	}
	
	public function itemEdit($sub_mod_id,$item_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['category'] = $this->master_model->getCategory();
		$data['branch'] = $this->user_model->get_branch();
		$data['rbranch'] = $this->report_model->Rbranch($item_id);
		$data['rcpbranch'] = $this->user_model->get_rmrcpbranch();
		$data['salebranch'] = $this->master_model->get_salesBranch();
		$data['santhebranch'] = $this->master_model->get_santheBranch();
		$data['rawItem'] = $this->report_model->RawItemId($item_id);
		$this->load->view('master/editItem',$data);
	}
	
	public function updateRaw(){
		
		$user_id = $_SESSION['user_id'];
		
		$sub_mod_id= $this->input->post('sub_mod_id');
		$data['usergroup'] = $this->master_model->updateItem($this->input->post());
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getRawItem();
		redirect('Master/rawMaterialList/'.$sub_mod_id);
	}
	
	public function itemDelete($sub_mod_id,$itm_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$this->db->query("delete from item_creation where itm_id='$itm_id'");
		$this->db->query("delete from item where itm_id='$itm_id'");
		redirect('Master/rawMaterialList/'.$sub_mod_id);
	}
	
	public function rcitemDelete($rc_item_id,$recipe_id,$recipe_no){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->db->query("delete from recipe_item where rc_item_id='$rc_item_id'");
		redirect('Master/productEdit/'.$recipe_id.'/'.$recipe_no);
	}
	
	public function srcitemDelete($src_item_id,$recipe_id,$recipe_no){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->db->query("delete from sub_recipe_item where sub_rc_item_id='$src_item_id'");
		redirect('Master/productEdit/'.$recipe_id.'/'.$recipe_no);
	}
	
	public function change_item_status(){
		$itm_id = $this->input->post('itm_id');
		$status = $this->input->post('item_status');
		
		if($status != ''){
			$this->db->query("update item_creation set status='$status' where itm_id='$itm_id'");
			$this->db->query("update item set status='$status' where itm_id='$itm_id'");
			echo 1;
		}else{
			echo 0;
		}
	}
	
	public function product()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->get_Category();
		$data['tax'] = $this->master_model->get_Tax();
		$data['kitchen'] = $this->master_model->get_KitchenUser();
		$data['chef'] = $this->master_model->get_Chef();
		$data['counter'] = $this->master_model->get_CounterUser();
		$data['branch'] = $this->user_model->get_branch();
		$data['items'] = $this->master_model->get_RcpItems();
		$data['products'] = $this->master_model->get_Products($branch_id);
		$data['combination'] = $this->master_model->getCombination();
		$this->load->view('master/productCreate',$data);
		//$this->load->view('master/product',$data);
	}
	
	public function get_ItemDetails()
	{
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->master_model->get_ItemDetails($iname,$br_id);
	}
	
	public function get_PItemDetails()
	{
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->master_model->get_PItemDetails($iname,$br_id);
	}
	
	public function get_GDWItemDetails()
	{
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->master_model->get_GDWItemDetails($iname,$br_id);
	}
	
	public function get_Item_Details(){
	    $iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->master_model->get_Item_Details($iname,$br_id);
	}
	public function get_OouItemDetails()
	{
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->master_model->get_OutItemDetails($iname,$br_id);
	}
	
	public function get_ItemProductDetails()
	{
		$itype = $this->input->post('item_type');
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->master_model->get_ItemProductDetails($itype,$iname,$br_id);
	}
	
	public function get_RecipeDetails()
	{
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->master_model->get_RecipeDetails($iname,$br_id);
	}
	
	public function get_RcpDetails()
	{
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->master_model->get_RcpDetails($iname,$br_id);
	}
	
	public function addProduct()
	{
		//$this->master_model->addProduct($this->input->post());
		$this->master_model->addFProduct($this->input->post());
		redirect('master/product');
	}
	
	public function productList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['products'] = $this->master_model->getProducts($branch_id);
		$this->load->view('master/product_list',$data);
	}
	
	public function cproductList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = 34;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['products'] = $this->master_model->getProducts($branch_id);
		$this->load->view('master/product_Clist',$data);
	}
	
	public function productApprove()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['products'] = $this->master_model->getApproveProducts();
		$this->load->view('master/product_approve',$data);
	}
	
	public function productApproveView($id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['product'] = $this->master_model->getProductDetails($id);
		$data['category'] = $this->master_model->get_Category();
		$data['tax'] = $this->master_model->get_Tax();
		$data['kitchen'] = $this->master_model->get_KitchenUser();
		$data['chef'] = $this->master_model->get_Chef();
		$data['sales_price'] = $this->master_model->get_CounterSalesPrice($id);
		$data['branch'] = $this->user_model->get_branch();
		$data['rcpbranch'] = $this->user_model->get_rcpbranch();
		$data['counter'] = $this->master_model->get_CounterUser();
		$data['santhe'] = $this->master_model->get_SantheUser();
		$data['recipe_items'] = $this->master_model->get_RecipeItems($id);
		$data['sub_recipe_items'] = $this->master_model->get_SubRecipeItems($id);
		$data['combination'] = $this->master_model->getCombination();
		$this->load->view('master/product_approve_view',$data);
	}
	
	public function productEdit($id,$rc_no)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['product'] = $this->master_model->getProductDetails($id);
		$data['category'] = $this->master_model->get_Category();
		$data['tax'] = $this->master_model->get_Tax();
		$data['kitchen'] = $this->master_model->get_KitchenUser();
		$data['chef'] = $this->master_model->get_Chef();
		$data['sales_price'] = $this->master_model->get_CounterSalesPrice($id);
		$data['branch'] = $this->user_model->get_branch();
		$data['pbranch'] = $this->master_model->getProductBranch($rc_no);
		$data['rcpbranch'] = $this->user_model->get_rcpbranch();
		$data['counter'] = $this->master_model->get_CounterUser();
		$data['santhe'] = $this->master_model->get_SantheUser();
		$data['recipe_items'] = $this->master_model->get_RecipeItems($id);
		$data['sub_recipe_items'] = $this->master_model->get_SubRecipeItems($id);
		$data['items'] = $this->master_model->get_cwItems();
		$data['products'] = $this->master_model->get_Products($branch_id);
		$data['combination'] = $this->master_model->getCombination();
		$this->load->view('master/product_edit',$data);
	}
	
	public function productView($id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->master_model->get_thead_permission($user_id,$sub_mod_id);
		$data['products'] = $this->master_model->getProducts($branch_id);
		$this->load->view('master/product_list',$data);
	}
	
	public function updateProduct(){
		$this->master_model->updateProduct($this->input->post());
		redirect('master/product');
	}
/*	public function productUpdate($id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->master_model->get_thead_permission($user_id,$sub_mod_id);
		$data['products'] = $this->master_model->getProducts($branch_id);
		$this->load->view('master/product_list',$data);
	}*/
	
	public function approveProduct()
	{
		$this->master_model->approveProduct($this->input->post());
		redirect('master/productApprove');
	}
	
	public function change_product_status(){
		//$this->db2 = $this->load->database('otherdb', TRUE);
		$pr_no = $this->input->post('pr_no');
		$status = $this->input->post('pr_status');
		$effective = $this->input->post('effective');
		
		$effective_date = date('Y-m-d',strtotime($effective));
		if($pr_status == 'Enabled')
		{
			$pr_status = 'Active';
		}
		else
		{
			$pr_status = 'InActive';
		}
		
		if($status != ''){
			$this->db->query("update recipe set status='$status',status_effective='$effective_date' where recipe_no='$pr_no'");
			//$this->db2->query("update product set product_status='$pr_status',effective_from='$effective_date',data_transfer='pending' where product_no='$pr_no'");
			//$this->db3->query("update product set product_status='$pr_status',effective_from='$effective_date',data_transfer='pending' where product_no='$pr_no'");
			echo 1;
		}else{
			echo 0;
		}
	}
	
	public function vendor_auto(){
		$keyword = $this->input->post('term');
		$query = $this->master_model->get_vendor($keyword);
		if($query->num_rows() > 0){
			foreach($query->result() as $row)
				//$data[] = array('company_name'=> $row->company_name);
				//$data[] = array('contact_no'=> $row->contact_no, 'value'=> $row->company_name);
				$data[] = $row->company_name;
                echo json_encode($data);
		
		}
		//echo json_encode($data);
	}
	
	public function get_auoto_item_name(){
		$keyword = $this->input->post('term');
		$branch_id = $_SESSION['branch_id'];
		$query = $this->master_model->get_item_branchid($keyword,$branch_id);
		if($query->num_rows() > 0){
			foreach($query->result() as $row)
				$data[] = array('price'=> $row->price, 'value'=> $row->item_name);
				echo json_encode($data);
		
		}
		//echo json_encode($data);
	}
	
	public function supplier_name_auto(){
		$keyword = $this->input->post('term');
		$query = $this->master_model->get_supplier_name($keyword);
		if($query->num_rows() > 0){
			foreach($query->result() as $row)
				$data[] = $row->vendor_name;
                echo json_encode($data);
		
		}
	}
	
	public function combination()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('master/combination',$data);
	}
	
	public function addCombination()
	{
		$this->master_model->addCombination($this->input->post());
		redirect('master/combination');
	}
	
	public function combinationList()
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['combination'] = $this->master_model->getCombination();
		$this->load->view('master/combination_list',$data);
	}
	
	public function combinationDelete($comb_id){
		$this->db2 = $this->load->database('otherdb', TRUE);
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->db2->query("delete from combination where comb_id='$comb_id'");
		$this->db->query("delete from combination where comb_id='$comb_id'");
		redirect('Master/combinationList/');
	}
	
	public function rawMaterial_List($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getRawItems($branch_id);
		$this->load->view('Master/rawMaterial_List',$data);
	}

	public function itemEdits($sub_mod_id,$item_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['category'] = $this->master_model->getCategory();
		$data['branch'] = $this->user_model->get_branch();
		$data['rbranch'] = $this->report_model->Rbranch($item_id);
		$data['salebranch'] = $this->master_model->get_salesBranch();
		$data['santhebranch'] = $this->master_model->get_santheBranch();
		$data['rawItem'] = $this->report_model->RawItemId($item_id);
		$this->load->view('master/editItems',$data);
	}
	
	public function updateRaws(){
		
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->input->post('sub_mod_id');
		$data['usergroup'] = $this->master_model->updateItem($this->input->post());
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getRawItems($branch_id);
		redirect('Master/rawMaterial_List/'.$sub_mod_id);
	}
	

	public function product_List($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		//$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['products'] = $this->master_model->get_Products();
		$this->load->view('master/product_Clist',$data);
	}
	
	public function supplierDelete($sub_mod_id,$vender_ref_no){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$this->db->query("delete from address WHERE address_id='$vender_ref_no'");
		$this->db->query("delete from user WHERE address_id='$vender_ref_no'");
	    redirect('Master/branchList/'.$sub_mod_id);
	}
	
	public function supplier_List()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		//$data['supplier'] = $this->master_model->getSupplier();
		$data['supplier'] = $this->master_model->getSupplierList($branch_id);
		
		$this->load->view('master/supplier_list',$data);
	}
	
	public function get_auoto_uom(){
		$keyword = $this->input->post('term');
		$branch_id = $_SESSION['branch_id'];
		$query = $this->master_model->get_uom($keyword);
		if($query->num_rows() > 0){
			foreach($query->result() as $row)
				$data[] = array('unitid'=> $row->unit_id, 'value'=> $row->unit_measure);
				echo json_encode($data);
		
		}
		//echo json_encode($data);
	}
	
	public function get_auoto_item(){
		$keyword = $this->input->post('term');
		$branch_id = $_SESSION['branch_id'];
		$query = $this->master_model->get_auoto_item($keyword);
		if($query->num_rows() > 0){
			foreach($query->result() as $row)
				$data[] = array('unitid'=> $row->itm_id, 'value'=> $row->item_name);
				echo json_encode($data);
		
		}
		//echo json_encode($data);
	}
	
	public function item_check(){
		$pname = $this->input->post('product_name');
		$this->master_model->get_item($pname);
	}
	
	public function product_check(){
		$pname = $this->input->post('product_name');
		$this->master_model->get_product($pname);
	}
	
	public function accRawMaterial(){
	    $user_id = $_SESSION['user_id'];
	    $sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['category'] = $this->master_model->getAllCategory();
		$data['rawItem'] = $this->master_model->get_itemall();
		$this->load->view('master/accRawMaterial',$data);
	}
	
	public function ceoRawMaterial(){
	    $user_id = $_SESSION['user_id'];
	    $sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['category'] = $this->master_model->getAllCategory();
		$data['rawItem'] = $this->master_model->get_itemall();
		$this->load->view('master/ceoRawMaterial',$data);
	}
	
	public function CRawMaterial(){
	    $user_id = $_SESSION['user_id'];
	    $sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['branch'] = $this->user_model->get_branch();
		$data['category'] = $this->master_model->getAllCategory();
		$data['rawItem'] = $this->master_model->get_itemall();
		$this->load->view('master/cRawMaterial',$data);
	}
	
	public function single_rawItem(){
	    $item_id = $_POST['item_id'];
		$item_name = $_POST['item_name'];
		$branchname = $_POST['branchname'];
		//$this->data['item_id'] = $item_id;
		$this->data['item_name'] = $item_name;
		$this->data['branchname'] = $branchname;
		$this->data['history1']=$this->master_model->get_item_history1($item_name,$branchname);
		$this->data['history2']=$this->master_model->get_item_history2($item_name,$branchname);
		//echo $item_name;
		//echo $branchname;

		$this->load->view('master/Itemsingle_view', $this->data);
		//$item_id = $_POST['item_id'];
		/*$item_name = $_POST['item_name'];
		$branchname = 'CW';
		//$this->data['item_id'] = $item_id;
		$this->data['item_name'] = $item_name;
		$this->data['branchname'] = $branchname;
		$this->data['history1']=$this->master_model->get_item_history1($item_name,$branchname);
		$this->data['history2']=$this->master_model->get_item_history2($item_name,$branchname);
		$this->load->view('master/Itemsingle_view', $this->data,FALSE);*/
	}
	
	public function getCatname()
	{
		$cat_id = $this->input->post('cat_id');
		$this->master_model->getCatname($cat_id);
	}
	
	
	public function searchCeoCat(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$branch = $this->input->post('branch');
		$to_date = $this->input->post('to_date');
		$category_name = $this->input->post('category_name');
		
		$data1 = array(
		'branch' => $branch,
		'to_date' => $to_date,
		'category_name' => $category_name
		);
		if ($to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->master_model->searchAccCat($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['category'] = $this->master_model->getAllCategory();
		$this->load->view('master/cRawMaterial',$data);
	}
	
	public function searchAccCat(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$branch = $this->input->post('branch');
		$to_date = $this->input->post('to_date');
		$category_name = $this->input->post('category_name');
		
		$data1 = array(
		'branch' => $branch,
		'to_date' => $to_date,
		'category_name' => $category_name
		);
		if ($to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->master_model->searchAccCat($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['category'] = $this->master_model->getAllCategory();
		$this->load->view('master/accRawMaterial',$data);
	}
	
	
	public function exportCategoryReport(){
	    $to_date = date('Y-m-d',strtotime($this->input->post('to_date1')));
		$branchn = $this->input->post('branches');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Category-Report".date('d-m-Y').".csv";
		$query = "select c.category_name,i.item_name,i.uom,st.closing_stock,i.item_price as rate,i.item_tax,(round((i.item_price+i.tax),2)) as price,i.avg_price,i.vendor_name,(round(((i.item_price+i.tax)*st.closing_stock),2)) as total_value from (select * from category) c inner join (select item_name,uom,vendor_name,item_price,item_tax,((item_price*item_tax)/100) as tax,avg_price,category_id from item_creation where branchname='$branchn') i on c.category_id=i.category_id inner join (select * from stock_detail) st on i.item_name=st.item_name inner join (select item_name,transaction_date,closing_stock,MAX(last_modified) as maxdate from stock_detail where branchname='$branchn' and transaction_date<='$to_date' group by item_name) stk on st.item_name=stk.item_name and st.last_modified=stk.maxdate";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	public function exportCategory_Report(){
	    $to_date1 = date('Y-m-d',strtotime($this->input->post('to_date1')));
		$branch_name = $this->input->post('branch1');
		$category = $this->input->post('category');
		$cat = $this->input->post('cat');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Category-Report".date('d-m-Y').".csv";
		if($category == 'All')
		{
    		$query = "select c.category_name,i.item_name,i.uom,st.closing_stock,i.item_price as rate,i.item_tax,(round((i.item_price+i.tax),2)) as price,i.avg_price,i.vendor_name,(round(((i.item_price+i.tax)*st.closing_stock),2)) as total_value from (select * from add_category) c inner join (select item_name,uom,item_price,item_tax,((item_price*item_tax)/100) as tax,avg_price,i.vendor_name,category_id from item_creation where branchname='$branch_name') i on c.category_id=i.category_id inner join (select * from stock_detail) st on i.item_name=st.item_name inner join (select item_name,transaction_date,closing_stock,MAX(last_modified) as maxdate from stock_detail where branchname='$branch_name' and transaction_date<='$to_date1' group by item_name) stk on st.item_name=stk.item_name and st.last_modified=stk.maxdate";
		}
		else{
		    $query = "select c.category_name,i.item_name,i.uom,st.closing_stock,i.item_price as rate,i.item_tax,(round((i.item_price+i.tax),2)) as price,i.avg_price,i.vendor_name,(round(((i.item_price+i.tax)*st.closing_stock),2)) as total_value from (select * from add_category) c inner join (select item_name,uom,item_price,item_tax,((item_price*item_tax)/100) as tax,avg_price,vendor_name,category_id from item_creation where branchname='$branch_name' and category_id='$category') i on c.category_id=i.category_id inner join (select * from stock_detail) st on i.item_name=st.item_name inner join (select item_name,transaction_date,closing_stock,MAX(last_modified) as maxdate from stock_detail where branchname='$branch_name' and transaction_date<='$to_date1' group by item_name) stk on st.item_name=stk.item_name and st.last_modified=stk.maxdate";
		}
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	
	
	public function getSupplierList() {
	    $company_name = $_POST['company_name'];
	    $this->data['vendorname']=$company_name;
		$this->data['vendordata']=$this->master_model->get_vendordata($company_name);
		$this->load->view('master/ItemVendor_view', $this->data);
	
	}
	
		public function ARawMaterial(){
	    $user_id = $_SESSION['user_id'];
	    $sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['branch'] = $this->user_model->get_branch();
		$data['category'] = $this->master_model->getAllCategory();
		$data['rawItem'] = $this->master_model->get_itemall();
		$this->load->view('master/adminRawMaterial',$data);
	}
	
	public function searchAdmCat(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$to_date = $this->input->post('to_date');
		$category_name = $this->input->post('category_name');
		
		$data1 = array(
		'to_date' => $to_date,
		'category_name' => $category_name
		);
		if ($to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->master_model->searchAdmCat($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['category'] = $this->master_model->getAllCategory();
		$this->load->view('master/adminRawMaterial',$data);
	}
	
	public function accsupplierList()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['supplier'] = $this->master_model->getSupplier();
		$this->load->view('master/accSuplier_list',$data);
	}
	
	public function CWRawMaterial(){
	    $user_id = $_SESSION['user_id'];
	    $sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['category'] = $this->master_model->getAllCategory();
		$data['rawItem'] = $this->master_model->get_CWitemall();
		$this->load->view('master/cwRawMaterial',$data);
	}
	
	public function searchCWCat(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		$to_date = $this->input->post('to_date');
		$category_name = $this->input->post('category_name');
		
		$data1 = array(
		'to_date' => $to_date,
		'category_name' => $category_name
		);
		if ($to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->master_model->searchCWCat($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['category'] = $this->master_model->getAllCategory();
		$this->load->view('master/cwRawMaterial',$data);
	}
	
	public function exportCWCategory_Report(){
	    $to_date1 = date('Y-m-d',strtotime($this->input->post('to_date1')));
		$branch_name = $_SESSION['branch_name'];
		$category = $this->input->post('category');
		$cat = $this->input->post('cat');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Category-Report".date('d-m-Y').".csv";
		if($category == 'All')
		{
    		$query = "select c.category_name,i.item_name,i.uom,st.closing_stock,i.item_price as rate,i.item_tax,(round((i.item_price+i.tax),2)) as price,i.avg_price,i.vendor_name,(round(((i.item_price+i.tax)*st.closing_stock),2)) as total_value from (select * from add_category) c inner join (select item_name,uom,item_price,item_tax,((item_price*item_tax)/100) as tax,avg_price,i.vendor_name,category_id from item_creation where branchname='$branch_name') i on c.category_id=i.category_id inner join (select * from stock_detail) st on i.item_name=st.item_name inner join (select item_name,transaction_date,closing_stock,MAX(last_modified) as maxdate from stock_detail where branchname='$branch_name' and transaction_date<='$to_date1' group by item_name) stk on st.item_name=stk.item_name and st.last_modified=stk.maxdate";
		}
		else{
		    $query = "select c.category_name,i.item_name,i.uom,st.closing_stock,i.item_price as rate,i.item_tax,(round((i.item_price+i.tax),2)) as price,i.avg_price,i.vendor_name,(round(((i.item_price+i.tax)*st.closing_stock),2)) as total_value from (select * from add_category) c inner join (select item_name,uom,item_price,item_tax,((item_price*item_tax)/100) as tax,avg_price,vendor_name,category_id from item_creation where branchname='$branch_name' and category_id='$category') i on c.category_id=i.category_id inner join (select * from stock_detail) st on i.item_name=st.item_name inner join (select item_name,transaction_date,closing_stock,MAX(last_modified) as maxdate from stock_detail where branchname='$branch_name' and transaction_date<='$to_date1' group by item_name) stk on st.item_name=stk.item_name and st.last_modified=stk.maxdate";
		}
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	public function itemCWEdit($item_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
	//	$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getRawItemId($item_id);
		$this->load->view('master/cwItemEdit',$data);
	}
	
	public function itemCEOEdit($item_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
	//	$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getRawItemId($item_id);
		$this->load->view('master/ceoItemEdit',$data);
	}
	
	public function itemCEdit($item_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
	//	$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getRawItemId($item_id);
		$this->load->view('master/cItemEdit',$data);
	}
	
	public function updateRawMaterial(){
		
		$user_id = $_SESSION['user_id'];
		
		$sub_mod_id= $this->input->post('sub_mod_id');
		$price = $this->input->post('price');
		$aprice = $this->input->post('aprice');
		$item_id = $this->input->post('item_id');
		$data = array('item_price' => $price,
		'avg_price' => $aprice);
		
			$this->db->where('item_id',$item_id);
			$this->db->update('item_creation',$data);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->report_model->getRawItem();
		redirect('Master/CWRawMaterial/'.$sub_mod_id);
	}
	
	public function updateCRawMaterial(){
		
		$user_id = $_SESSION['user_id'];
		
		$sub_mod_id= $this->input->post('sub_mod_id');
		$price = $this->input->post('price');
		$tax = $this->input->post('tax');
		$item_id = $this->input->post('item_id');
		$data = array('item_price' => $price,
		'item_tax' => $tax);
		
		$this->db->where('item_id',$item_id);
		$this->db->update('item_creation',$data);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->master_model->get_CWitemall();
		redirect('Master/crawMaterialList/'.$sub_mod_id);
	}
	
	public function updateCEORawMaterial(){
		
		$user_id = $_SESSION['user_id'];
		
		$sub_mod_id= $this->input->post('sub_mod_id');
		$price = $this->input->post('price');
		$tax = $this->input->post('tax');
		$item_id = $this->input->post('item_id');
		$data = array('item_tax' => $tax,
		'avg_price' => $aprice);
		
		$this->db->where('item_id',$item_id);
		$this->db->update('item_creation',$data);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['rawItem'] = $this->master_model->get_CWitemall();
		redirect('Master/CEORawMaterial/'.$sub_mod_id);
	}
	
	public function supplierC_list()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['supplier'] = $this->master_model->getSupplierList($branch_id);
		
		$this->load->view('master/supplier_cwList',$data);
	}
	
	public function supplierCEdit($vid,$vref)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$data['submod_id']=$submod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['supplier'] = $this->master_model->getSupplierDetail($vid);
		$data['supplierbr'] = $this->master_model->getSupplierDetailBranch($vref);
		$this->load->view('master/supplier_cedit',$data);
	}
	
	public function updteSupplier()
	{
		$this->master_model->edtSupplier($this->input->post());
		$sub_mod_id = $this->input->post('sub_mod_id');
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getSupplier();
		redirect('Master/supplier_list/'.$sub_mod_id);
	}
	
	public function changePasswrd(){
	    
	    $user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
	    $this->load->view('changePwd',$data);
	}
	
	public function changePwd(){
	    $new_pass = $this->input->post('new_pass');
		$conf_pass = $this->input->post('conf_pass');
		$user_id = $this->input->post('user_id');
	    $phash = password_hash($new_pass, PASSWORD_DEFAULT);
		$this->db->query("update user set password='$phash',br_id='$new_pass' where user_id='$user_id'");
		redirect('Master/changePasswrd');
	}
	
	public function productMapping()
	{
		$sub_mod_id = $this->uri->segment(3);
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submdid'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['kitchen'] = $this->productrequest_model->getKitchen($sub_mod_id,$branch_id);
		$data['products'] = $this->master_model->getProducts($branch_id);
		$this->load->view('master/product_mapping',$data);
	}
	
	public function fetchCategory()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$smd_id = $request->md_id;
		//$sub_mod_id = $this->uri->segment(3);
		$cat_data = $this->master_model->fetchCategory($smd_id);
		unset($data);
		foreach ($cat_data as $cat) 
		{ 
			$data[] = array(
			"cat_name"          => $cat->access_category,
			"pr_cat_id"  		=> $cat->access_cat_id
			);
		} 
		echo json_encode($data);
		//file_put_contents('cat_list.json', json_encode($itemarray));
	}
	
	public function fetchPr()
	{
		$branch_id = $_SESSION['branch_id'];
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		//$sub_mod_id = $this->uri->segment(3);
		$pr_data = $this->master_model->get_Recipe($branch_id);
		unset($data);
		foreach ($pr_data as $pr) 
		{ 
			$data[] = array(
			"rname"          => $pr->rname
			);
		} 
		echo json_encode($data);
		//file_put_contents('cat_list.json', json_encode($itemarray));
	}
	
	public function fetchProduct()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$cat = $request->cat;
		$branch_id = $request->branch_id;
		$item_data = $this->master_model->fetchProduct($cat,$branch_id);
		if ($item_data != false) {
			foreach ($item_data as $item) 
    		{ 
    			$data[] = array(
    			"iname"          => $item->rname,
    			"uom"  			=> $item->uom,
    			"cat_id"          => $item->pr_cat_id,
    			"flavour"  			=> $item->flavour,
    			"f_code"          => $item->f_code,
    			"id"  			=> $item->recipe_id,
    			"qty"          => $item->req_qty,
    			"rno"  			=> $item->recipe_no
    			);
    		} 
		} else {
			$data = '';
		}
		
		echo json_encode($data);
	}
	
	public function addMapping()
	{
	    $sub_mod_id=$this->input->post('module_id');
		$this->master_model->addMapping($this->input->post());
		redirect('Master/productMapping/'.$sub_mod_id);
	}
	
	public function exportProduct(){
	    $branchname = $_SESSION['branch_name'];
		$branch_id = $_SESSION['branch_id'];
		
        $filename = '(FP)_'.date('d-m-Y').'.csv';
       header("Content-Description: File Transfer"); 
       header("Content-Disposition: attachment; filename=$filename"); 
       header("Content-Type: application/csv; ");
       
       // get data 
       $branch_id = $_SESSION['branch_id'];
       $usersData = $this->master_model->getProductDetail($branch_id);
    
       // file creation 
       $file = fopen('php://output', 'w');
     
       $header = array("recipe_id","recipe_no","pr_cat_id","pr_cat_name","product_name","map_recipe_no"); 
       fputcsv($file, $header);
       foreach ($usersData as $key=>$line){
         fputcsv($file,$line); 
       }
       fclose($file); 
       exit;
	}
	
	public function import_Product(){
		if(isset($_POST["prupload"]))
		{
			$filename=$_FILES["prstk_upload"]["tmp_name"];
			$sub_mod_id=$this->input->post('smodule_id');
			if($_FILES["prstk_upload"]["size"] > 0)
			{
				$file = fopen($filename, "r");
				$branchname = $_SESSION['branch_name'];
				$branch_id = $_SESSION['branch_id'];
				$user = $_SESSION['full_name'];
				$stk_date = date("Y-m-d");
				$order_time = date("h:i A");
				$lm=date("Y-m-dH:i:s",time());
		    	$i=0;
				while (($data = fgetcsv($file, 10000, ",")) !== FALSE)
				{
					$res5=$this->db->query("UPDATE recipe set map_recipe_no='$data[5]' WHERE  recipe_no= '$data[1]'");
        			
				}                   
				fclose($file);
				$this->session->set_flashdata('message', 'Data are imported successfully..');
				//redirect('Master/productMapping');
				redirect('Master/productMapping/'.$sub_mod_id);
			}else{
				$this->session->set_flashdata('message', 'Something went wrong..');
				//redirect('Master/productMapping');
				redirect('Master/productMapping/'.$sub_mod_id);
			}
		}
	}
	
	public function mapping_list()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['prMapping'] = $this->master_model->prMappingList($branch_id);
		
		$this->load->view('master/mappingList',$data);
	}
	
	public function supplierAccEdit($vid,$vref)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$data['submod_id']=$submod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['supplier'] = $this->master_model->getSupplierDetail($vid);
		$data['supplierbr'] = $this->master_model->getSupplierDetailBranch($vref);
		$this->load->view('master/supplier_Accedit',$data);
	}
	
	public function edtASupplier()
	{
		$this->master_model->edtSupplier($this->input->post());
		$sub_mod_id = $this->input->post('sub_mod_id');
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getSupplier();
		redirect('Master/AccsupplierList/'.$sub_mod_id);
	}
	
	//Excel Recipe price update
	public function rcpPriceUpdate(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('master/rcpPriceUpdate',$data);
	}
	
	public function export_recipe(){
		$branchname = $_SESSION['branch_name'];
		$branch_id = $_SESSION['branch_id'];
		
        $filename = '(FP)_'.date('d-m-Y').'.csv';
       header("Content-Description: File Transfer"); 
       header("Content-Disposition: attachment; filename=$filename"); 
       header("Content-Type: application/csv; ");
       
       // get data 
       $branch_id = $_SESSION['branch_id'];
       $usersData = $this->master_model->getrecipe($branch_id);
    
       // file creation 
       $file = fopen('php://output', 'w');
     
       $header = array("recipe_id","recipe_no","pr_cat_id","pr_cat_name","product_name","total_price","tax","food_delivery","fd_total_price","fd_tax","effective_date","outlet","branch_id"); 
       fputcsv($file, $header);
       foreach ($usersData as $key=>$line){
         fputcsv($file,$line); 
       }
       fclose($file); 
       exit;
   	}
	
/*	public function import_rcPriceUpdate(){
	    $db2 = $this->load->database('otherdb', TRUE);
		$db3 = $this->load->database('otherdb1', TRUE);
		if(isset($_POST["rcupload"]))
		{
			$filename=$_FILES["rcprice_upload"]["tmp_name"];
		//	$sub_mod_id=$this->input->post('smodule_id');
			if($_FILES["rcprice_upload"]["size"] > 0)
			{
				$file = fopen($filename, "r");
				$branchname = $_SESSION['branch_name'];
				$branch_id = $_SESSION['branch_id'];
				$user = $_SESSION['full_name'];
				$up_date = date("Y-m-d");
				$order_time = date("h:i A");
				$lm=date("Y-m-dH:i:s",time());
		    	$i=0;
				while (($data = fgetcsv($file, 10000, ",")) !== FALSE)
				{
				    $eff_date = date('Y-m-d',strtotime($data[10]));
				    
				    $tax_div = ((float)$data[6]/100) + (float)1;
			        $basic = round(((float)$data[5]/$tax_div),2);
			        $tax_amt = round(((float)$data[5] - $basic),2);
			        
			        $sotax_div = ((float)$data[9]/100)+1;
			        $sobasic = round(((float)$data[8]/$sotax_div),2);
			        $sotax_amt = round(((float)$data[8] - $sobasic),2);
			        
				    $ctsgst_tax = (float)$data[6]/2;
    				$ctsgst_tax_amt = $tax_amt/2;
    				$soctsgst_tax = (float)$data[9]/2;
    				$soctsgst_tax_amt = $sotax_amt/2;
    				
					$res5=$this->db->query("UPDATE recipe set price='$basic',tax='$data[6]',tax_amount='$tax_amt',total_price='$data[5]',food_delivery='$data[7]',tprice='$sobasic',ttax='$data[9]',ttax_amount='$sotax_amt',ttotal_price='$data[8]',effective_from='$eff_date',sls_price_up_date='$up_date' WHERE  recipe_id= '$data[0]'");
					if($data[11] == 'CW-CTR')
					{
					    $q1 = $this->db->query("select recipe_id from recipe where recipe_no='$data[1]' and branch_id='34'");
		                $row = $q1->row_array();
		                $rc_id = $row['recipe_id'];
					    $res5=$this->db->query("UPDATE recipe set price='$basic',tax='$data[6]',tax_amount='$tax_amt',total_price='$data[5]',food_delivery='$data[7]',tprice='$sobasic',ttax='$data[9]',ttax_amount='$sotax_amt',ttotal_price='$data[8]',effective_from='$eff_date',sls_price_up_date='$up_date' WHERE recipe_id='$rc_id'");
					}
					$res6=$this->db->query("UPDATE recipe_sales_price set price='$basic',tax='$data[6]',tax_amount='$tax_amt',total_price='$data[5]' WHERE recipe_no='$data[1]' and branchname='$data[11]'");
					$res7=$this->db2->query("UPDATE product set basic_rate='$basic',basic_tax_percent='$data[6]',basic_tax_amount='$tax_amt',sgst_tax='$ctsgst_tax',sgst_tax_amount='$ctsgst_tax_amt',cgst_tax='$ctsgst_tax',cgst_tax_amount='$ctsgst_tax_amt',price='$data[5]',effective_from='$eff_date' WHERE  product_no='$data[1]' and social_order!='1' and branch_id='$data[12]'");
					$res8=$this->db2->query("UPDATE product set basic_rate='$sobasic',basic_tax_percent='$data[9]',basic_tax_amount='$sotax_amt',sgst_tax='$soctsgst_tax',sgst_tax_amount='$soctsgst_tax_amt',cgst_tax='$soctsgst_tax',cgst_tax_amount='$soctsgst_tax_amt',price='$data[8]',effective_from='$eff_date' WHERE  product_no='$data[1]' and social_order='1' and branch_id='$data[12]'");
					$res9=$this->db3->query("UPDATE product set basic_rate='$basic',basic_tax_percent='$data[6]',basic_tax_amount='$tax_amt',sgst_tax='$ctsgst_tax',sgst_tax_amount='$ctsgst_tax_amt',cgst_tax='$ctsgst_tax',cgst_tax_amount='$ctsgst_tax_amt',price='$data[5]',effective_from='$eff_date' WHERE  product_no='$data[1]' and social_order!='1' and branch_id='$data[12]'");
					$res10=$this->db3->query("UPDATE product set basic_rate='$sobasic',basic_tax_percent='$data[9]',basic_tax_amount='$sotax_amt',sgst_tax='$soctsgst_tax',sgst_tax_amount='$soctsgst_tax_amt',cgst_tax='$soctsgst_tax',cgst_tax_amount='$soctsgst_tax_amt',price='$data[8]',effective_from='$eff_date' WHERE  product_no='$data[1]' and social_order='1' and branch_id='$data[12]'");
        		}                  
				fclose($file);
				$this->session->set_flashdata('message', 'Data are imported successfully..');
				//redirect('Master/productMapping');
				redirect('Master/rcpPriceUpdateView/');
			}else{
				$this->session->set_flashdata('message', 'Something went wrong..');
				//redirect('Master/productMapping');
				redirect('Master/rcpPriceUpdate/');
			}
		}
	} */
	
	public function import_rcPriceUpdate(){
	    $db2 = $this->load->database('otherdb', TRUE);
		$db3 = $this->load->database('otherdb1', TRUE);
		if(isset($_POST["rcupload"]))
		{
			$filename=$_FILES["rcprice_upload"]["tmp_name"];
		//	$sub_mod_id=$this->input->post('smodule_id');
			if($_FILES["rcprice_upload"]["size"] > 0)
			{
				$file = fopen($filename, "r");
				$branchname = $_SESSION['branch_name'];
				$branch_id = $_SESSION['branch_id'];
				$user = $_SESSION['full_name'];
				$up_date = date("Y-m-d");
				$order_time = date("h:i A");
				$lm=date("Y-m-dH:i:s",time());
		    	$i=0;
				while (($data = fgetcsv($file, 10000, ",")) !== FALSE)
				{
				    if($data[0] != 'recipe_id')
				    {
    				    $eff_date = date('Y-m-d',strtotime($data[10]));
    				    
    				    $tax_div = ((float)$data[6]/100) + (float)1;
    			        $basic = round(((float)$data[5]/$tax_div),2);
    			        $tax_amt = round(((float)$data[5] - $basic),2);
    			        
    			        $sotax_div = ((float)$data[9]/100)+1;
    			        $sobasic = round(((float)$data[8]/$sotax_div),2);
    			        $sotax_amt = round(((float)$data[8] - $sobasic),2);
    			        
    				    $ctsgst_tax = (float)$data[6]/2;
        				$ctsgst_tax_amt = $tax_amt/2;
        				$soctsgst_tax = (float)$data[9]/2;
        				$soctsgst_tax_amt = $sotax_amt/2;
        				
    					$res5=$this->db->query("UPDATE recipe set price='$basic',tax='$data[6]',tax_amount='$tax_amt',total_price='$data[5]',food_delivery='$data[7]',tprice='$sobasic',ttax='$data[9]',ttax_amount='$sotax_amt',ttotal_price='$data[8]',effective_from='$eff_date',sls_price_up_date='$up_date' WHERE  recipe_id='$data[0]'");
    				//	if($data[11] == 'CW-CTR')
    				//	{
    					    $q1 = $this->db->query("select recipe_id from recipe where recipe_no='$data[1]' and branch_id='34'");
    		                $row = $q1->row_array();
    		                $rc_id = $row['recipe_id'];
    					    $res5=$this->db->query("UPDATE recipe set price='$basic',tax='$data[6]',tax_amount='$tax_amt',total_price='$data[5]',food_delivery='$data[7]',tprice='$sobasic',ttax='$data[9]',ttax_amount='$sotax_amt',ttotal_price='$data[8]',effective_from='$eff_date',sls_price_up_date='$up_date' WHERE recipe_id='$rc_id'");
    				//	}
    					$res6=$this->db->query("UPDATE recipe_sales_price set price='$basic',tax='$data[6]',tax_amount='$tax_amt',total_price='$data[5]' WHERE recipe_no='$data[1]' and branchname='$data[11]'");
    					
    					
    					$q1 = $this->db2->query("select * from category_master where cat_ref='$data[2]'");
            		//	if($q1->num_rows() > 0)
            		//	{
            				$row = $q1->row_array();
            				$cat_ref = $row['category_master_id'];
            		//	}
            			$q2 = $this->db2->query("select * from product_category where cat_ref='$data[2]' and branch_id='$data[12]'");
                	//	if($q2->num_rows() > 0)
                	//	{
                			$row2 = $q2->row_array();
                			$cat_ref_id = $row2['pr_cat_id'];
                			$br_code = $row2['branch'];
                	//	}
                		$q3 = $this->db->query("select * from recipe where recipe_no='$data[1]' and branch_id='34'");
                		$row3 = $q3->row_array();
                		$hsn_code = $row3['hsn_code'];
                		$uom = $row3['uom'];
                		$discount = $row3['discount'];
                		$comb = $row3['combination'];
                		$product_type = $row3['product_type'];
                		$product_image = $row3['product_image'];
                		$new_year = $row3['carnival_sale'];
                		
                		$q4 = $db2->query("select * from product where product_no='$data[1]' and branch_id='$data[12]' and social_order!='1'");
                		if($q4->num_rows() > 0){
                		    $res9=$this->db3->query("UPDATE product set basic_rate='$basic',basic_tax_percent='$data[6]',basic_tax_amount='$tax_amt',sgst_tax='$ctsgst_tax',sgst_tax_amount='$ctsgst_tax_amt',cgst_tax='$ctsgst_tax',cgst_tax_amount='$ctsgst_tax_amt',price='$data[5]',effective_from='$eff_date',data_transfer='pending' WHERE  product_no='$data[1]' and social_order!='1' and branch_id='$data[12]'");
                		    $res7=$this->db2->query("UPDATE product set basic_rate='$basic',basic_tax_percent='$data[6]',basic_tax_amount='$tax_amt',sgst_tax='$ctsgst_tax',sgst_tax_amount='$ctsgst_tax_amt',cgst_tax='$ctsgst_tax',cgst_tax_amount='$ctsgst_tax_amt',price='$data[5]',effective_from='$eff_date',data_transfer='pending' WHERE  product_no='$data[1]' and social_order!='1' and branch_id='$data[12]'");
                		}
                		else
                		{
                		    $data4 = array(
    							'product_name' => $data[4],
    							'hsn_code' => $hsn_code,
    							'product_no' => $data[1],
    							'uom' => $uom,
    							'basic_rate' => $basic,
    							'basic_tax_percent' => $data[6],
    							'basic_tax_amount' => $tax_amt,
    							'sgst_tax' => $ctsgst_tax,
    							'sgst_tax_amount' => $ctsgst_tax_amt,
    							'cgst_tax' => $ctsgst_tax,
    							'cgst_tax_amount' => $ctsgst_tax_amt,
    							'price' => $data[5],
    							'discount_perc' => $discount,
    							'product_status' => 'Active',
    							'pr_cat_id' => $cat_ref,
    							'effective_from' => $eff_date,
    							'branch' => $br_code,
    							'branch_id' => $data[12],
    							'data_transfer' => 'pending',
    							'combination' => $comb,
    							'client_id' => '0',
    							'api_status' => '0',
    							'product_type' => $product_type,
    							'cat_id' => $cat_ref_id,
    							'product_image' => $product_image,
    							'newyear_sale' => $new_year
    						);
    						$db3->insert('product', $data4);
    						$prd_id1 = $db3->insert_id();
    						
    						$data4 = array(
    						    'pr_id' => $prd_id1,
    							'product_name' => $data[4],
    							'hsn_code' => $hsn_code,
    							'product_no' => $data[1],
    							'uom' => $uom,
    							'basic_rate' => $basic,
    							'basic_tax_percent' => $data[6],
    							'basic_tax_amount' => $tax_amt,
    							'sgst_tax' => $ctsgst_tax,
    							'sgst_tax_amount' => $ctsgst_tax_amt,
    							'cgst_tax' => $ctsgst_tax,
    							'cgst_tax_amount' => $ctsgst_tax_amt,
    							'price' => $data[5],
    							'discount_perc' => $discount,
    							'product_status' => 'Active',
    							'pr_cat_id' => $cat_ref,
    							'effective_from' => $eff_date,
    							'branch' => $br_code,
    							'branch_id' => $data[12],
    							'data_transfer' => 'pending',
    							'combination' => $comb,
    							'client_id' => '0',
    							'api_status' => '0',
    							'product_type' => $product_type,
    							'cat_id' => $cat_ref_id,
    							'product_image' => $product_image,
    							'newyear_sale' => $new_year
    						);
    						$db2->insert('product', $data4);
                		}
                		
                		if($data[7] == 'Yes')
        				{
        				    $q2 = $db2->query("select * from product where product_no='$data[1]' and branch='$data[12]' and social_order='1'");
        				    if($q2->num_rows() > 0){
    					    $res10=$this->db3->query("UPDATE product set basic_rate='$sobasic',basic_tax_percent='$data[9]',basic_tax_amount='$sotax_amt',sgst_tax='$soctsgst_tax',sgst_tax_amount='$soctsgst_tax_amt',cgst_tax='$soctsgst_tax',cgst_tax_amount='$soctsgst_tax_amt',price='$data[8]',effective_from='$eff_date',data_transfer='pending',fd_status='Pending' WHERE  product_no='$data[1]' and social_order='1' and branch_id='$data[12]'");
    					    $res8=$this->db2->query("UPDATE product set basic_rate='$sobasic',basic_tax_percent='$data[9]',basic_tax_amount='$sotax_amt',sgst_tax='$soctsgst_tax',sgst_tax_amount='$soctsgst_tax_amt',cgst_tax='$soctsgst_tax',cgst_tax_amount='$soctsgst_tax_amt',price='$data[8]',effective_from='$eff_date',data_transfer='pending',fd_status='Pending' WHERE  product_no='$data[1]' and social_order='1' and branch_id='$data[12]'");
    					    }
    					    else
    					    {
    					        $data7 = array(
    								'product_name' => $data[4],
        							'hsn_code' => $hsn_code,
        							'product_no' => $data[1],
        							'uom' => $uom,
    								'basic_rate' => $sobasic,
    								'basic_tax_percent' => $data[9],
    								'basic_tax_amount' => $sotax_amt,
    								'sgst_tax' => $soctsgst_tax,
    								'sgst_tax_amount' => $soctsgst_tax_amt,
    								'cgst_tax' => $soctsgst_tax,
    								'cgst_tax_amount' => $soctsgst_tax_amt,
    								'price' => $data[8],
    								'discount_perc' => $discount,
    								'product_status' => 'Active',
    								'pr_cat_id' => $cat_ref,
    								'effective_from' => $eff_date,
    								'branch' => $br_code,
    							    'branch_id' => $data[12],
    								'data_transfer' => 'pending',
    								'social_order' => '1',
    								'combination' => $comb,
    								'client_id' => '0',
    								'api_status' => '0',
    								'product_type' => $product_type,
    								'cat_id' => $cat_ref_id,
    								'newyear_sale' => '0',
    								'product_image' => $product_image,
                                    'fd_status' => 'Pending'
    							);
    							$db3->insert('product', $data7);
    							$prd_id2 = $db3->insert_id();
    												
    							$data7 = array(
    							    'pr_id'=>$prd_id2,
    								'product_name' => $data[4],
        							'hsn_code' => $hsn_code,
        							'product_no' => $data[1],
        							'uom' => $uom,
    								'basic_rate' => $sobasic,
    								'basic_tax_percent' => $data[9],
    								'basic_tax_amount' => $sotax_amt,
    								'sgst_tax' => $soctsgst_tax,
    								'sgst_tax_amount' => $soctsgst_tax_amt,
    								'cgst_tax' => $soctsgst_tax,
    								'cgst_tax_amount' => $soctsgst_tax_amt,
    								'price' => $data[8],
    								'discount_perc' => $discount,
    								'product_status' => 'Active',
    								'pr_cat_id' => $cat_ref,
    								'effective_from' => $eff_date,
    								'branch' => $br_code,
    							    'branch_id' => $data[12],
    								'data_transfer' => 'pending',
    								'social_order' => '1',
    								'combination' => $comb,
    								'client_id' => '0',
    								'api_status' => '0',
    								'product_type' => $product_type,
    								'cat_id' => $cat_ref_id,
    								'newyear_sale' => '0',
    								'product_image' => $product_image,
                                    'fd_status' => 'Pending'
    							);
    							$db2->insert('product', $data7);
    							$prid1 = $this->db->insert_id();
    					    }
        				}
        				else
        				{
        				    $res10=$this->db3->query("UPDATE product set effective_from='$eff_date',data_transfer='pending',fd_status='Pending',product_status='Inactive' WHERE  product_no='$data[1]' and social_order='1' and branch_id='$data[12]'");
    					    $res8=$this->db2->query("UPDATE product set effective_from='$eff_date',data_transfer='pending',fd_status='Pending',product_status='Inactive' WHERE  product_no='$data[1]' and social_order='1' and branch_id='$data[12]'");
        				}
    				}
				}                  
				fclose($file);
				$this->session->set_flashdata('message', 'Data are imported successfully..');
				//redirect('Master/productMapping');
				redirect('Master/rcpPriceUpdateView/');
			}else{
				$this->session->set_flashdata('message', 'Something went wrong..');
				//redirect('Master/productMapping');
				redirect('Master/rcpPriceUpdate/');
			}
		}
	}
	
	public function rcpPriceUpdateView()
	{
		$user_id = $_SESSION['user_id'];
		$up_date = date("Y-m-d");
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['sls_price'] = $this->master_model->getPriceUpdateRecipe($up_date);
		$this->load->view('master/sls_price_updates',$data);
	}
	
	public function rcpPriceUpdateList()
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['sls_price_list'] = $this->master_model->getPriceUpdateRecipeList();
		$this->load->view('master/sls_price_update_list',$data);
	}
	
	public function rcpPriceUpdateLView($up_date)
	{
		$user_id = $_SESSION['user_id'];
	    $data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['sls_price'] = $this->master_model->getPriceUpdateRecipe($up_date);
		$this->load->view('master/sls_price_updates',$data);
	}
	
	//Excel DC price update
	public function dcPriceUpdate(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('master/dcPriceUpdate',$data);
	}
	
	public function export_dcrecipe(){
		$branchname = $_SESSION['branch_name'];
		$branch_id = $_SESSION['branch_id'];
		
        $filename = '(FP-DC)_'.date('d-m-Y').'.csv';
       header("Content-Description: File Transfer"); 
       header("Content-Disposition: attachment; filename=$filename"); 
       header("Content-Type: application/csv; ");
       
       // get data 
       $branch_id = $_SESSION['branch_id'];
       $usersData = $this->master_model->getdcrecipe();
    
       // file creation 
       $file = fopen('php://output', 'w');
     
       $header = array("recipe_id","recipe_no","pr_cat_id","pr_cat_name","product_name","cw_total_price","cw_tax","cw4_total_price","cw4_tax","cw5_total_price","cw5_tax","kitchen","branch","branch_id"); 
       fputcsv($file, $header);
       foreach ($usersData as $key=>$line){
         fputcsv($file,$line); 
       }
       fclose($file); 
       exit;
   	}
   	
   	public function import_dcPriceUpdate(){
	    $db2 = $this->load->database('otherdb', TRUE);
		$db3 = $this->load->database('otherdb1', TRUE);
		if(isset($_POST["dcupload"]))
		{
			$filename=$_FILES["dcprice_upload"]["tmp_name"];
		//	$sub_mod_id=$this->input->post('smodule_id');
			if($_FILES["dcprice_upload"]["size"] > 0)
			{
				$file = fopen($filename, "r");
				$branchname = $_SESSION['branch_name'];
				$branch_id = $_SESSION['branch_id'];
				$user = $_SESSION['full_name'];
				$up_date = date("Y-m-d");
				$order_time = date("h:i A");
				$lm=date("Y-m-dH:i:s",time());
		    	$i=0;
				while (($data = fgetcsv($file, 10000, ",")) !== FALSE)
				{
				    $eff_date = date('Y-m-d',strtotime($data[10]));
				    
				    $tax_div1 = ((float)$data[6]/100) + (float)1;
			        $cw1_basic = round(((float)$data[5]/$tax_div1),2);
			        $cw1_tax_amt = round(((float)$data[5] - $cw1_basic),2);
			        
			        $tax_div4 = ((float)$data[8]/100) + (float)1;
			        $cw4_basic = round(((float)$data[7]/$tax_div4),2);
			        $cw4_tax_amt = round(((float)$data[7] - $cw4_basic),2);
			        
				    $tax_div5 = ((float)$data[10]/100) + (float)1;
			        $cw5_basic = round(((float)$data[9]/$tax_div5),2);
			        $cw5_tax_amt = round(((float)$data[9] - $cw5_basic),2);
    				
					$res5=$this->db->query("UPDATE recipe set cw_price='$cw1_basic',cw_tax='$data[6]',cw_tax_amount='$cw1_tax_amt',cw_total_price='$data[5]',cw4_price='$cw4_basic',cw4_tax='$data[8]',cw4_tax_amount='$cw4_tax_amt',cw4_total_price='$data[7]',cw5_price='$cw5_basic',cw5_tax='$data[10]',cw5_tax_amount='$cw5_tax_amt',cw5_total_price='$data[9]',dc_price_up_date='$up_date' WHERE recipe_id= '$data[0]'");
				}                  
				fclose($file);
				$this->session->set_flashdata('message', 'Data are imported successfully..');
				//redirect('Master/productMapping');
				redirect('Master/dcPriceUpdateView/');
			}else{
				$this->session->set_flashdata('message', 'Something went wrong..');
				//redirect('Master/productMapping');
				redirect('Master/dcPriceUpdate/');
			}
		}
	}
	
	public function dcPriceUpdateView()
	{
		$user_id = $_SESSION['user_id'];
		$up_date = date("Y-m-d");
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['dc_price'] = $this->master_model->getDCPriceUpdateRecipe($up_date);
		$this->load->view('master/dc_price_updates',$data);
	}
	
	public function dcPriceUpdateList()
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['dc_price_list'] = $this->master_model->getDcPriceUpdateRecipeList();
		$this->load->view('master/dc_price_update_list',$data);
	}
	
	public function dcPriceUpdateLView($up_date)
	{
		$user_id = $_SESSION['user_id'];
	    $data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['dc_price'] = $this->master_model->getDCPriceUpdateRecipe($up_date);
		$this->load->view('master/dc_price_updates',$data);
	}
	
	public function accsupplierAppoveList()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['supplier'] = $this->master_model->getSupplierPending();
		$this->load->view('master/accSuplier_ApproveList',$data);
	}
	

	public function supplierAEdit($vid,$vref,$submod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$submod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['supplier'] = $this->master_model->getSupplierDetail($vid);
		$data['supplierbr'] = $this->master_model->getSupplierDetailBranch($vref);
		$this->load->view('master/supplierApproval',$data);
	}
	
	public function approvalSupplier()
	{
		$this->master_model->approvalSupplier($this->input->post());
		$sub_mod_id = $this->input->post('sub_mod_id');
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getSupplier();
		redirect('Master/accsupplierAppoveList/'.$sub_mod_id);
	}
	
	public function supplierADelete($sub_mod_id,$vender_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$this->db->query("delete from vendor_creation WHERE vender_id='$vender_id'");
	    redirect('Master/accsupplierAppoveList/'.$sub_mod_id);
	}
	
	public function branchCreation(){
	    $user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('master/outlet',$data);
	}
	
	public function addBranch()
	{
		$this->master_model->addBranch($this->input->post());
		redirect('Master/branchList');
	}
	
	
	public function branchList()
	{
		$user_id = $_SESSION['user_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		//$data['supplier'] = $this->master_model->getbranchList();
		$data['nobranch'] = $this->master_model->getNobranchList();
		$this->load->view('master/branch_List',$data);
	}
	
	public function productFEdit($id,$rc_no)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['product'] = $this->master_model->getProductDetails($id);
		$data['category'] = $this->master_model->get_Category();
		$data['tax'] = $this->master_model->get_Tax();
		
		$this->load->view('master/product_fedit',$data);
	}
	
	public function updateFProduct(){
		$this->master_model->updateFProduct($this->input->post());
		redirect('master/product');
	}
	
/*	public function customerEdit($vid,$vref)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$data['submod_id']=$submod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['supplier'] = $this->master_model->getCustomerDetail($vid);
		$data['supplierbr'] = $this->master_model->getCustomerDetailBranch($vref);
		$this->load->view('master/customer_edit',$data);
	}
	
	public function custUpdate()
	{
		$this->master_model->edtCust($this->input->post());
		$sub_mod_id = $this->input->post('sub_mod_id');
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getbranchList();
		$data['nobranch'] = $this->master_model->getNobranchList();
		redirect('Master/branchList/'.$sub_mod_id);
	}*/
	
	
	public function outletEdit($vid,$vref)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$data['submod_id']=$submod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['supplier'] = $this->master_model->getOutletDetail($vid);
		$data['userdata'] = $this->master_model->getUserDetail($vid);
		$this->load->view('master/outlet_edit',$data);
	}
	
	public function outletUpdate()
	{
		$this->master_model->edtOutlet($this->input->post());
		$sub_mod_id = $this->input->post('sub_mod_id');
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getbranchList();
		$data['nobranch'] = $this->master_model->getNobranchList();
		redirect('Master/branchList/'.$sub_mod_id);
	}
}