<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MaterialRequest extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('materialrequest_model');
		$this->load->model('stockmanage_model');
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	
	
	//var $master_url='https://gsrgroup.biz/inv_final_test';
    var $master_url='https://bigcashew.com/inventory';
	public function materialRequest()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['store'] = $this->materialrequest_model->getStore($sub_mod_id,$branch_id);
		$this->load->view('MaterialRequest/material_request',$data);
	}
	
	public function addRequest()
	{
		$rid=$this->materialrequest_model->addRequest($this->input->post());
		if($rid)
		{
		    redirect('MaterialRequest/requestView/'.$rid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('MaterialRequest/materialRequest/');
		}
	}
	
	public function requestView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequest($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$this->load->view('MaterialRequest/request_view',$data);
	}
	
	public function requestList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->materialrequest_model->getRequestList($branch_id);
		$this->load->view('MaterialRequest/request_list',$data);
	}
	
	public function reqView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequest($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$this->load->view('MaterialRequest/req_view',$data);
	}
	
	public function editRequest($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequest($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$this->load->view('MaterialRequest/edit_request',$data);
	}
	
	public function updateRequest()
	{
		$rid=$this->materialrequest_model->updateRequest($this->input->post());
		redirect('MaterialRequest/reqView/'.$rid);
	}
	
	public function issuePendingList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->materialrequest_model->getIssuePendingList($uname);
		$this->load->view('MaterialRequest/issue_pending_list',$data);
	}
	
	public function get_IssueData(){
		
		$uname = $_SESSION['username'];
		$data = $this->materialrequest_model->getIssuePendingList($uname);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/strreqView/$row->request_id' class=''><i class='ft-eye'></i></a>";
    	    $addissue = "<a href='$this->master_url/index.php/MaterialRequest/requestIssue/$row->request_id' class='btn btn-sm btn-info md-btn-success'>Add Issue</a>";
    	    if($row->status=='Pending'){
    	       $i_status="<span class='pending_data'>$row->status</span>";
    	    }
    	    else{
    	        $i_status="<span class='success_data'>$row->status</span>";
    	    }
    	    
    	    $test[] = array(
    	        $count,
    	        $row->mat_req_no,
    	        $row->request_date,
                $row->username,
                $i_status,
                $addissue,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function strreqView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequestIss($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$this->load->view('MaterialRequest/strreq_view',$data);
	}
	
	public function requestIssue($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequestIss($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestIssItem($rid);
		$this->load->view('MaterialRequest/item_issue',$data);
	}
	
	public function addIssue()
	{
		$isid=$this->materialrequest_model->addIssue($this->input->post());
		$req_id = $this->input->post('req_id');
		if($isid)
		{
		    redirect('MaterialRequest/issueView/'.$isid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('MaterialRequest/requestIssue/'.$req_id);
		}
	}
	
	public function issueView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->materialrequest_model->getIssue($isid);
		$data['issue_item'] = $this->materialrequest_model->getIssueItem($isid);
		$this->load->view('MaterialRequest/issue_view',$data);
	}
	
	public function requestRmkUpdate(){
		$req_id = $this->input->post('req_id');
		$req_remark = $this->input->post('req_remark');
		$this->db->query("update material_request set status='Closed',remark='$req_remark' where request_id='$req_id'");
		echo 1;
	}
	
	public function requestRmkissUpdate(){
		$req_id = $this->input->post('req_id');
		$req_remark = $this->input->post('req_remark');
		$this->db->query("update material_request set receipt_status='Closed',issue_remark='$req_remark' where request_id='$req_id'");
		echo 1;
	}
	
	public function requestIssueList($req_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->materialrequest_model->getRequesIssuetList($req_id);
		$data['req_iss_list'] = $this->materialrequest_model->getRequesIssuetLists($req_id);
		$this->load->view('MaterialRequest/request_issue_list',$data);
	}
	
	public function issueInward($req_id,$issue_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->materialrequest_model->getIssue($issue_id);
		$data['issue_item'] = $this->materialrequest_model->getIssuedItem($issue_id);
		$this->load->view('MaterialRequest/issue_inward',$data);
	}
	
	public function addInward()
	{
		$inid=$this->materialrequest_model->addInward($this->input->post());
		$req_id = $this->input->post('req_id');
		$issue_id = $this->input->post('iss_id');
		if($inid)
		{
		    redirect('MaterialRequest/inwardView/'.$inid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('MaterialRequest/issueInward/'.$req_id.'/'.$issue_id);
		}
	}
	
	public function inwardView($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->materialrequest_model->getInward($inid);
		$data['inward_item'] = $this->materialrequest_model->getInwardItem($inid);
		$this->load->view('MaterialRequest/inward_view',$data);
	}
	
	public function prideInward($req_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req'] = $this->materialrequest_model->getMatRequest($req_id);
		$data['req_item'] = $this->materialrequest_model->getMatReqItem($req_id);
		$this->load->view('MaterialRequest/pride_inward',$data);
	}
	
	public function addPrideInward()
	{
		$inid=$this->materialrequest_model->addPrideInward($this->input->post());
		
		$req_id = $this->input->post('req_id');
		if($inid)
		{
		    redirect('MaterialRequest/inwardPrideView/'.$inid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('MaterialRequest/prideInward/'.$req_id);
		}
	}
	
	public function inwardPrideView($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->materialrequest_model->getPrideInward($inid);
		$data['inward_item'] = $this->materialrequest_model->getPrideInwardItem($inid);
		$data['inward_rmk'] = $this->materialrequest_model->getPrideInwardRemark($inid);
		$data['dc_up'] = $this->materialrequest_model->getDcUpload($inid);
		$this->load->view('MaterialRequest/pride_inward_view',$data);
	}
	
	public function inwardTicket()
	{
		$this->materialrequest_model->addinwardTicket($this->input->post());
		$inid = $this->input->post('inw_id');
		redirect('MaterialRequest/inwardPrideView/'.$inid);
	}
	
	public function dcUpload()
	{
		$this->materialrequest_model->addDcUpload($this->input->post());
		$inid = $this->input->post('rcp_id');
		redirect('MaterialRequest/inwardPrideView/'.$inid);
	}
	
	public function requestClosedList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->materialrequest_model->getRequestClosedList($branch_id);
		$this->load->view('MaterialRequest/request_closed_list',$data);
	}
	
	public function reqCloseView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequest($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$this->load->view('MaterialRequest/req_close_view',$data);
	}
	
	public function reqClosedView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_rec'] = $this->materialrequest_model->getMatReceipt($rid);
		$this->load->view('MaterialRequest/req_closed_view',$data);
	}
	
	public function req_single_recipt(){
		$rc_id = $_POST['rc_id'];
		$data['inward'] = $this->materialrequest_model->getInward($rc_id);
		$data['inward_item'] = $this->materialrequest_model->getInwardItem($rc_id);
		$this->load->view('MaterialRequest/rc_single_view', $data);
	}
	
	public function prideReqClosedView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_rec'] = $this->materialrequest_model->getPrideMatReceipt($rid);
		$this->load->view('MaterialRequest/pride_req_closed_view',$data);
	}
	
	public function preq_single_recipt(){
		$rc_id = $_POST['rc_id'];
		$data['inward'] = $this->materialrequest_model->getPrideInward($rc_id);
		$data['inward_item'] = $this->materialrequest_model->getPrideInwardItem($rc_id);
		$this->load->view('MaterialRequest/prc_single_view', $data);
	}
	
	public function receiptList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rec_list'] = $this->materialrequest_model->getReceiptList($branch_id);
		$this->load->view('MaterialRequest/receipt_list',$data);
	}
	
	public function prideReceiptList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rec_list'] = $this->materialrequest_model->getPrideReceiptList($branch_id);
		$this->load->view('MaterialRequest/pride_receipt_list',$data);
	}
	
	public function issueClosedList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->materialrequest_model->getIssueClosedList($uname);
		$this->load->view('MaterialRequest/issue_closed_list',$data);
	}
	
	public function get_IssueClosedData(){
		
		$uname = $_SESSION['username'];
		$data = $this->materialrequest_model->getIssueClosedList($uname);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $viewReq = "<a href='$this->master_url/index.php/MaterialRequest/strrequestView/$row->request_id' class=''><i class='ft-eye'></i></a>";
    	    $viewIss = "<a href='$this->master_url/index.php/MaterialRequest/issueClosedView/$row->request_id' class=''><i class='ft-eye'></i></a>";
    	    if($row->status=='Pending'){
    	       $i_status="<span class='pending_data'><?php echo $row->status; ?></span>";
    	    }
    	    else{
    	        $i_status="<span class='success_data'>$row->status</span>";
    	    }
    	    
    	    $test[] = array(
    	        $count,
    	        $row->mat_req_no,
    	        $row->request_date,
                $row->username,
                $i_status,
                $row->remark,
                $viewReq,
                $viewIss,
                
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function strrequestView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequestIss($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$this->load->view('MaterialRequest/strrequest_view',$data);
	}
	
	public function issueClosedView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_iss'] = $this->materialrequest_model->getMatIssues($rid);
		$this->load->view('MaterialRequest/issue_closed_view',$data);
	}
	
	public function issue_single_recipt(){
		$is_id = $_POST['is_id'];
		$data['issue'] = $this->materialrequest_model->getIssue($is_id);
		$data['issue_item'] = $this->materialrequest_model->getIssueItem($is_id);
		$this->load->view('MaterialRequest/iss_single_view', $data);
	}
	
	public function issuetList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->materialrequest_model->getIssueList($branch_id);
		$this->load->view('MaterialRequest/issue_list',$data);
	}
	
	public function issuetListAll()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['outlet'] = $this->user_model->get_outlet_by_branch_cw5();
		$data['item'] = $this->user_model->getItemCW();
		$data['issue_list'] = $this->materialrequest_model->getAllIssueList($branch_id);
		$this->load->view('MaterialRequest/aissue_list',$data);
	}
	
	public function rejection($rcid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['receipt'] = $this->materialrequest_model->getrjReceipt($rcid);
		$data['receipt_item'] = $this->materialrequest_model->getrjReceiptItem($rcid);
		$this->load->view('MaterialRequest/rejection',$data);
	}
	
	public function addRejection()
	{
		$rjid=$this->materialrequest_model->addRejection($this->input->post());
		redirect('MaterialRequest/rejectionView/'.$rjid);
		$rc_id = $this->input->post('rcp_id');
		if($rjid)
		{
		    redirect('MaterialRequest/rejectionView/'.$rjid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('MaterialRequest/rejection/'.$rc_id);
		}
	}
	
	public function rejectionView($rjid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rjn'] = $this->materialrequest_model->getRejection($rjid);
		$data['rjn_item'] = $this->materialrequest_model->getRejectionItem($rjid);
		$this->load->view('MaterialRequest/rejection_view',$data);
	}
	
	public function rejectionList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rjn_list'] = $this->materialrequest_model->getRejectionList($branch_id);
		$this->load->view('MaterialRequest/rejection_list',$data);
	}
	
	public function inwardRemark()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inw_rmk'] = $this->materialrequest_model->getInwardTicket($branch_id);
		$this->load->view('MaterialRequest/inward_ticket',$data);
	}
	
	public function prideCRemarks()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inw_rmk'] = $this->materialrequest_model->getcInwardTicket();
		$this->load->view('MaterialRequest/cinward_ticket',$data);
	}
	
	public function reqPrdPendingList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->materialrequest_model->getIssuePendingList($uname);
		$this->load->view('MaterialRequest/prdreq_pending_list',$data);
	}
	
	public function prdreqView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequestIss($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$this->load->view('MaterialRequest/prdreq_view',$data);
	}
	
	public function approveReq()
	{
		$req_id = $this->input->post('req_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update material_request set status='Approved',approval_date='$apporval_date' where request_id='$req_id'");
		redirect('MaterialRequest/reqPrdPendingList/');
	}
	
	//ceo
	public function issueRequestOList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->materialrequest_model->getRequestIssueList();
		$this->load->view('MaterialRequest/issueRequestOList',$data);

	}
	
	public function get_CIssueData(){
		
		$data = $this->materialrequest_model->getRequestIssueList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/ceo_requestView/$row->request_id' class=''><i class='ft-eye'></i></a>";
    	   
    	    if($row->status=='Pending'){
    	       $i_status="<span class='badge badge-danger '><?php echo $row->status; ?></span>";
    	    }
    	    else{
    	        $i_status="<span class='badge badge-success '>$row->status</span>";
    	    }
    	    if($row->mclose_status=='Pending'){
    	       $m_status="<span class='badge badge-danger '><?php echo $row->status; ?></span>";
    	    }
    	    else{
    	        $m_status="<span class='badge badge-success '>$row->status</span>";
    	    }
    	    $test[] = array(
    	        $count,
    	        $row->mat_req_no,
    	        $row->request_date,
                $row->username,
                $i_status,
                $m_status,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}

	public function issueCClosedList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->materialrequest_model->getCRequestClosedList();
		$this->load->view('MaterialRequest/issueRequestClosedList',$data);
	}


    public function get_CIssueClosedData(){
		
		$data = $this->materialrequest_model->getCRequestClosedList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $viewReq = "<a href='$this->master_url/index.php/MaterialRequest/strrequestView/$row->request_id' class=''><i class='ft-eye'></i> </i></a>";
    	    $viewIss = "<a href='$this->master_url/index.php/MaterialRequest/issueClosedView/$row->request_id' class=''><i class='ft-eye'></i> </i></a>";
    	    if($row->status=='Pending'){
    	       $i_status="<span class='badge badge-danger pending_data'><?php echo $row->status; ?></span>";
    	    }
    	    else{
    	        $i_status="<span class='badge badge-success success_data'>$row->status</span>";
    	    }
    	    
    	    $test[] = array(
    	        $count,
    	        $row->mat_req_no,
    	        $row->request_date,
                $row->username,
                $i_status,
                $row->remark,
                $row->issue_remark,
                $viewReq,
                $viewIss,
                
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function issuesCList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		//$data['issue_list'] = $this->materialrequest_model->getCIssueList();
		$this->load->view('MaterialRequest/issuesCList',$data);
	}
	
	public function get_issuesCList(){
		
		$data = $this->materialrequest_model->get_CIssueList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Issues/issueCRMView/$row->mid' class=''><i class='ft-eye'></i></a>";
    	    $test[] = array(
    	        $count,
    	        $row->issue_no,
    	        $row->issue_date,
    	        $row->dc_no,
                $row->outlet_name,
                round($row->basic,2),
                round($row->tax_amt,2),
                round($row->tot_amt,2),
                $view,
                
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}

	public function getCIssueList()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$item_data = $this->materialrequest_model->getCIssueList($row,$rowperpage);
		foreach ($item_data as $item) 
		{ 
			$data[] = array(
			"issue_no"=>$item->issue_no,
			"issue_date"=>$item->issue_date,
			"outlet_name"=>$item->outlet_name,
			"total"=>$item->total,
			"mid"=>$item->mid
			);
		} 
		echo json_encode($data);
	}

	public function searchCissueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->getIssueListReport($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/issuesCList',$data);
	}

	public function exportIssueReport()
	{
		$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));;
		$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
		$branchn = $this->input->post('branchn');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Issue_Report.csv";
		$query = "SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation where issue_date between '$from_date' and '$to_date' and branchname='$branchn' ORDER BY issue_id desc";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}

	//Pride Bakers issue list
	public function prideCList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['pissue_list'] = $this->materialrequest_model->getCPrideIssueList();
		$this->load->view('MaterialRequest/prideCList',$data);
	}

    public function get_prideCList(){
		
		$data = $this->materialrequest_model->getCPrideIssueList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/inwardPrideView/$row->req_rec_id' class=''><i class='ft-eye'></i></a>";
    	    if($row->receipt_approval=='Pending'){
    	       $r_approval="<span class='badge badge-danger pending_data'><?php echo $row->receipt_approval; ?></span>";
    	    }
    	    else{
    	        $r_approval="<span class='badge badge-success success_data'>$row->receipt_approval</span>";
    	    }
    	    $test[] = array(
    	        $count,
    	        $row->req_rec_no,
    	        $row->receipt_date,
    	        $r_approval,
                $row->approval_date,
                $row->username,
                $row->total,
                $view,
                
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
    
	public function searchCPrideissueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->getPrideIssueListReport($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/prideCList',$data);
	}

	public function exportPIssueReport(){
		$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));;
		$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
		$branchn = $this->input->post('branchn');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Pride_Issue_Report.csv";
		if($outlet_name == 'All')
		{
			$query = "SELECT R.req_rec_no,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,R.receipt_approval as status,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id";
			
		}
		else if($outlet_name == 'cw4_out') {
		    $query = "SELECT R.req_rec_no,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,R.receipt_approval as status,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW4%' group by RI.req_rec_id";
			
		}
		else
		{
			$query = "SELECT R.req_rec_no,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,R.receipt_approval as status,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$outlet_name' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id";
			
		}
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	public function prIissueClosedList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->materialrequest_model->getIssueClosedList($uname);
		$this->load->view('MaterialRequest/prdreq_closed_list',$data);
	}
	
	public function prreqCloseView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getprMatRequest($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$this->load->view('MaterialRequest/prreq_close_view',$data);
	}
	
	public function prdReqClosedView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_rec'] = $this->materialrequest_model->getPrideMatReceipt($rid);
		$this->load->view('MaterialRequest/prd_req_closed_view',$data);
	}
	
	public function prreq_single_recipt(){
		$rc_id = $_POST['rc_id'];
		$data['inward'] = $this->materialrequest_model->getPrideInward($rc_id);
		$data['inward_item'] = $this->materialrequest_model->getPrideInwardItem($rc_id);
		$this->load->view('MaterialRequest/prd_single_view', $data);
	}
	
	public function prdeReceiptList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rec_list'] = $this->materialrequest_model->getPrdReceiptList($uname);
		$this->load->view('MaterialRequest/prd_receipt_list',$data);
	}
	
	public function prdinView($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->materialrequest_model->getPrideInward($inid);
		$data['inward_item'] = $this->materialrequest_model->getPrideInwardItem($inid);
		$data['inward_rmk'] = $this->materialrequest_model->getPrideInwardRemark($inid);
		$data['dc_up'] = $this->materialrequest_model->getDcUpload($inid);
		$this->load->view('MaterialRequest/prd_inward_view',$data);
	}
	
	public function accIssuesList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->user_model->get_branch();
		$data['outlet'] = $this->user_model->getOutlet();
		$data['item'] = $this->user_model->getItemCW();
		//$data['issue_list'] = $this->materialrequest_model->getCIssueList();
		$this->load->view('MaterialRequest/accIssueList',$data);
	}
	
	public function getAccIssueList()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch='CW';
		$item_data = $this->materialrequest_model->getAccIssueList($row,$rowperpage,$branch);
		foreach ($item_data as $item) 
		{ 
			$data[] = array("mat_req_no"=>$item->mat_req_no,
			"request_date"=>$item->request_date,
			"issue_no"=>$item->issue_no,
			"issue_date"=>$item->issue_date,
			"outlet_name"=>$item->outlet_name,
			"total"=>$item->total,
			"mid"=>$item->mid);
		} 
		echo json_encode($data);
	}
	
	public function search_issue_report_byOutlet(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$outlet_name = $this->input->post('outlet_name');
		$item_name = $this->input->post('item_name');
		$br_name = $this->input->post('br_name');
		//echo $br_name;
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'outlet_name'=>$outlet_name,
		'item_name' => $item_name,
		'br_name' =>$br_name);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->get_issue_report_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['outlet'] = $this->user_model->getOutlet();
		$data['item'] = $this->user_model->getItemCW();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/accIssueList',$data);
	}
	
	public function export_outlet_item(){
	
		$from_date1 = $this->input->post('from_date1');
		$to_date1 = $this->input->post('to_date1');
		$item_name = $this->input->post('item_name');
		$outlet_name = $this->input->post('outlet_name');
		$branch_name = $this->input->post('branchname');
		
		$from_date = date("Y-m-d", strtotime($from_date1));
		$to_date = date("Y-m-d", strtotime($to_date1));
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Stock-Outlet-Item-Report.csv";
		$query = "SELECT i.indent_item_name,c.outlet_name,sum(i.indent_qty)as qty,sum(i.total_amount) as total FROM issues_order_item i inner join issues_order_creation c on i.issue_id=c.issue_id WHERE i.indent_item_name='$item_name' and c.outlet_name='$outlet_name' and c.branchname='$branch_name' and issue_date between '$from_date' and '$to_date' group by c.outlet_name";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
		
	}
	
	public function export_all_outlet_item(){
	
		$from_date1 = $this->input->post('from_date1');
		$to_date1 = $this->input->post('to_date1');
		$item_name = $this->input->post('item_name');
		//$outlet_name = $this->input->post('outlet_name');
		$branch_name = $this->input->post('branchname');
		
		$from_date = date("Y-m-d", strtotime($from_date1));
		$to_date = date("Y-m-d", strtotime($to_date1));
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Stock-Outlet-Item-Report.csv";
		$query = "SELECT i.indent_item_name,c.outlet_name,sum(i.indent_qty)as qty,sum(i.total_amount) as total FROM issues_order_item i inner join issues_order_creation c on i.issue_id=c.issue_id WHERE i.indent_item_name='$item_name' and c.branchname='$branch_name' and issue_date between '$from_date' and '$to_date' group by c.outlet_name";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
		
	}
	
	public function export_outlet_all_item(){
	
		$from_date1 = $this->input->post('from_date1');
		$to_date1 = $this->input->post('to_date1');
		//$item_name = $this->input->post('item_name');
		$outlet_name = $this->input->post('outlet_name');
		$branch_name = $this->input->post('branchname');
		
		$from_date = date("Y-m-d", strtotime($from_date1));
		$to_date = date("Y-m-d", strtotime($to_date1));
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Stock-Outlet-Item-Report.csv";
		$query = "SELECT i.indent_item_name,c.outlet_name,sum(i.indent_qty)as qty,sum(i.total_amount) as total FROM issues_order_item i inner join issues_order_creation c on i.issue_id=c.issue_id WHERE c.outlet_name='$outlet_name' and c.branchname='$branch_name' and issue_date between '$from_date' and '$to_date' group by i.indent_item_name";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
		
	}
	
	public function export_issue(){
	    $from_date1 = $this->input->post('from_date1');
		$to_date1 = $this->input->post('to_date1');
		$outlet_name = $this->input->post('outlet_name');
		$branch_name = $this->input->post('branchname');
		
		$from_date = date("Y-m-d", strtotime($from_date1));
		$to_date = date("Y-m-d", strtotime($to_date1));
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Issue-Report.csv";
		$query = "SELECT *, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation where branchname='$branch_name' and outlet_name='$outlet_name' and (issue_date between '$from_date' and '$to_date')";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	//Ceo View
	public function ceo_requestView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['mat_req'] = $this->materialrequest_model->getMatRequestIss($rid);
		$data['mat_req_item'] = $this->materialrequest_model->getMatRequestItem($rid);
		$data['mat_req_status'] = $this->materialrequest_model->getMatRequestStatus($rid);
		$this->load->view('MaterialRequest/ceostrreq_view',$data);
	}
	
	public function approveStatus(){
	    $apporval_date = date("Y-m-d", strtotime($this->input->post('apporval_date')));
	    $req_id=$this->input->post('req_id');
	    $this->db->query("update material_request set mclose_status='Approved',mclsoe_aprvd_date='$apporval_date' where request_id='$req_id'");
	    redirect('MaterialRequest/ceo_requestView/'.$req_id);
	}
	
	
	public function issuesAList($sub_mod_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		//$data['issue_list'] = $this->materialrequest_model->getCIssueList();
		$this->load->view('MaterialRequest/aIssueList',$data);
	}

	public function getAIssueList()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		
		$item_data = $this->materialrequest_model->getAIssueList($row,$rowperpage);
		foreach ($item_data as $item) 
		{ 
			$data[] = array(
			"issue_no"=>$item->issue_no,
			"issue_date"=>$item->issue_date,
			"outlet_name"=>$item->outlet_name,
			"total"=>$item->total,
			"mid"=>$item->mid
			);
		} 
		echo json_encode($data);
	}

	public function searchAissueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->getAIssueListReport($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/aIssueList',$data);
	}

	public function exportAIssueReport()
	{
		$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));;
		$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
		$branchn = $this->input->post('branchn');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Issue_Report.csv";
		$query = "SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation where issue_date between '$from_date' and '$to_date' and branchname='$branchn' ORDER BY issue_id desc";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	public function prd_ReceiptList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['submod_id'] = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->materialrequest_model->get_outlet_for_pride();
		$data['rec_list'] = $this->materialrequest_model->getPrdReceiptList($uname);
		$this->load->view('MaterialRequest/prideReceiptList',$data);
	}
	
	public function get_PrideRecList(){
		
		$uname = $_SESSION['username'];
		$data = $this->materialrequest_model->getPrdReceiptList($uname);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/prdinView/$row->req_rec_id' class=''><i class='ft-eye'></i></a>";
    	    if($row->receipt_approval=='Pending'){
    	       $receipt_approval="<span class=' pending_data'>$row->receipt_approval</span>";
    	    }
    	    else{
    	        $receipt_approval="<span class=' success_data'>$row->receipt_approval</span>";
    	    }
    	    $branch = $row->branchname;
			$q1 = $this->db->query("select * from user where branch_name='$branch'");
			$rows = $q1->row_array();
			$outlet = $rows['username'];
    	    $test[] = array(
    	        $count,
    	        $row->req_rec_no,
    	        $row->receipt_date,
                $receipt_approval,
                $row->approval_date,
                $outlet,
                $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function searchReceiptList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('outlet_name');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->get_pride_receipt_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->materialrequest_model->get_outlet_for_pride();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$this->load->view('MaterialRequest/prideReceiptList',$data);
		$this->load->view('MaterialRequest/acc_prideReceiptList',$data);
	}
	
	public function export_prideIssue()
	{
		$from_date = date('Y-m-d',strtotime($this->input->post('from_date1')));
		$to_date = date('Y-m-d',strtotime($this->input->post('to_date1')));
		$outlet_name = $this->input->post('outlet_name1');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Pride_Issue_Report.csv";
		if($outlet_name == 'All')
		{
			$query = "SELECT R.req_rec_no,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,R.receipt_approval as status,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id";
		}
		else if($outlet_name == 'cw4_out') {
		    $query = "SELECT R.req_rec_no,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,R.receipt_approval as status,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW4%' group by RI.req_rec_id";
		}
		else
		{
			$query = "SELECT R.req_rec_no,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,R.receipt_approval as status,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$outlet_name' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id";

		}
		
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	public function issuesCWList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$sub_mod_id = 
		$data['submod_id']=$this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['branch'] = $this->user_model->get_branch();
		$data['outlet'] = $this->user_model->get_outlet_by_branch_cw();
		$data['item'] = $this->user_model->getItemCW();
	    //$data['issue_list'] = $this->materialrequest_model->getIssueList($branch_id);
		$this->load->view('MaterialRequest/issuesCWList',$data);
	}


    public function get_issCwList(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->materialrequest_model->getIssueList($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/issueCWView/$row->issue_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
    	        $row->mat_req_no,
    	        $row->request_date,
                $row->issue_no,
                $row->issue_date,
                $row->issue_time,
                $row->outlet_name,
                $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function issueCWView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->materialrequest_model->getIssue($isid);
		$data['issue_item'] = $this->materialrequest_model->getIssueItem($isid);
		$this->load->view('MaterialRequest/issueCWView',$data);
	}
	
	public function search_Cissue_report_byOutlet(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$br_name = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$outlet_name = $this->input->post('outlet_name');
		$item_name = $this->input->post('item_name');
		//$br_name = $this->input->post('br_name');
		//echo $br_name;
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'outlet_name'=>$outlet_name,
		'item_name' => $item_name,
		'br_name' =>$br_name);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->get_issue_report_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['outlet'] = $this->user_model->get_outlet_by_branch_cw();
		$data['item'] = $this->user_model->getItemCW();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/issuesCWList',$data);
	}
	
	public function search_issues_report_byOutlet(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$br_name = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$outlet_name = $this->input->post('outlet_name');
		$item_name = $this->input->post('item_name');
		//$br_name = $this->input->post('br_name');
		//echo $br_name;
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'outlet_name'=>$outlet_name,
		'item_name' => $item_name,
		'br_name' =>$br_name);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->get_issue_report_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['outlet'] = $this->user_model->get_outlet_by_branch_cw5();
		$data['item'] = $this->user_model->getItemCW();
		//$data['issue_list'] = $this->materialrequest_model->getAllIssueList($branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/aissue_list',$data);
	}
	
	public function get_PrideRecipeData(){
		
		$uname = $_SESSION['username'];
		$branch_id = $_SESSION['branch_id'];
		//$data = $this->materialrequest_model->getPrdReceiptList($uname);
		$data = $this->materialrequest_model->getPrideReceiptList($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/inwardPrideView/$row->req_rec_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    
    	    $test[] = array(
    	        $count,
    	        $row->mat_req_no,
    	        $row->request_date,
                $row->req_rec_no,
                $row->receipt_date,
                $row->store,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function acc_prideReceiptList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['submod_id'] = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->materialrequest_model->get_outlet_for_pride();
		$data['rec_list'] = $this->materialrequest_model->getPrdReceiptList($uname);
		$this->load->view('MaterialRequest/acc_prideReceiptList',$data);
	}
	
	public function get_AccPrideRecList(){
		$uname = $_SESSION['username'];
		$data = $this->materialrequest_model->get_AccPrideRecList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a target='_blank' href='$this->master_url/index.php/MaterialRequest/acc_prdinView/$row->req_rec_id' class=''><i class='ft-eye'></i></a>";
    	    if($row->receipt_approval=='Pending'){
    	       $receipt_approval="<span class=' pending_data'>$row->receipt_approval</span>";
    	    }
    	    else{
    	        $receipt_approval="<span class=' success_data'>$row->receipt_approval</span>";
    	    }
    	    $branch = $row->branchname;
			$q1 = $this->db->query("select * from user where branch_name='$branch'");
			$rows = $q1->row_array();
			$outlet = $rows['username'];
    	    $test[] = array(
    	        $count,
    	        $row->req_rec_no,
    	        $row->receipt_date,
                $receipt_approval,
                $row->approval_date,
                $outlet,
                $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function acc_prdinView($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->materialrequest_model->getPrideInward($inid);
		$data['inward_item'] = $this->materialrequest_model->getPrideInwardItem($inid);
		$data['inward_rmk'] = $this->materialrequest_model->getPrideInwardRemark($inid);
		$data['dc_up'] = $this->materialrequest_model->getDcUpload($inid);
		$data['tot_amt'] = $this->materialrequest_model->rcp_total_sum_calc($inid);
		
		$this->load->view('MaterialRequest/acc_prd_inward_view',$data);
	}
	
	
	public function pride_inward_approval()
	{
		$rcp_id = $this->input->post('rcp_id');
		$apporval_date = date("Y-m-d", strtotime($this->input->post('apporval_date')));
		$this->db->query("update request_receipt set receipt_approval='Approved',approval_date='$apporval_date' where req_rec_id='$rcp_id'");
		redirect('MaterialRequest/acc_prideReceiptList');
		
	}
	
	
	public function pride_List()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['submod_id'] = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->materialrequest_model->get_outlet_for_pride();
		$data['rec_list'] = $this->materialrequest_model->getPrdReceiptList($uname);
		$this->load->view('MaterialRequest/pride_list',$data);
	}
	
	public function prideinView($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->materialrequest_model->getPrideInward($inid);
		$data['inward_item'] = $this->materialrequest_model->getPrideInwardItem($inid);
		$data['inward_rmk'] = $this->materialrequest_model->getPrideInwardRemark($inid);
		$data['dc_up'] = $this->materialrequest_model->getDcUpload($inid);
		$data['tot_amt'] = $this->materialrequest_model->rcp_total_sum_calc($inid);
		
		$this->load->view('MaterialRequest/prideInwardView',$data);
	}
	
	public function get_PrideList(){
		
		$uname = $_SESSION['username'];
		$data = $this->materialrequest_model->get_PrideList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/prideinView/$row->req_rec_id' class=''><i class='ft-eye'></i></a>";
    	    if($row->receipt_approval=='Pending'){
    	       $receipt_approval="<span class=' pending_data'>$row->receipt_approval</span>";
    	    }
    	    else{
    	        $receipt_approval="<span class=' success_data'>$row->receipt_approval</span>";
    	    }
    	    $branch = $row->branchname;
			$q1 = $this->db->query("select * from user where branch_name='$branch'");
			$rows = $q1->row_array();
			$outlet = $rows['username'];
    	    $test[] = array(
    	        $count,
    	        $row->req_rec_no,
    	        $row->receipt_date,
                $receipt_approval,
                $row->approval_date,
                $outlet,
                $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function searchPrideList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('outlet_name');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->get_pride_receipt_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->materialrequest_model->get_outlet_for_pride();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/pride_list',$data);
	}
	
	public function receiptDeptList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rec_list'] = $this->materialrequest_model->getReceiptList($branch_id);
		$this->load->view('MaterialRequest/receipt_deptList',$data);
	}
	
	
	public function issuesEshList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$sub_mod_id = 
		$data['submod_id']=$this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['branch'] = $this->user_model->get_branch();
		$data['outlet'] = $this->user_model->get_outlet_by_branch_esh();
		$data['item'] = $this->user_model->getItemCW();
	    //$data['issue_list'] = $this->materialrequest_model->getIssueList($branch_id);
		$this->load->view('MaterialRequest/issuesEshList',$data);
	}
	
	public function issuesCMSList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$sub_mod_id = 
		$data['submod_id']=$this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['branch'] = $this->user_model->get_branch();
		//$data['outlet'] = $this->user_model->get_outlet_by_branch_esh();
		$data['item'] = $this->user_model->getItemCW();
	    //$data['issue_list'] = $this->materialrequest_model->getIssueList($branch_id);
		$this->load->view('MaterialRequest/issuesCmsList',$data);
	}


    public function get_issEshList(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->materialrequest_model->getIssueList($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/issueEshView/$row->issue_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
                $row->issue_no,
                $row->issue_date,
                $row->issue_time,
                $row->outlet_name,
                $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function get_issCmsList(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->materialrequest_model->getCmsIssueList($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Issues/issueView/$row->issue_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
                $row->issue_no,
                $row->issue_date,
                $row->issue_time,
                $row->outlet_name,
                $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function issueEshView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->materialrequest_model->getIssue($isid);
		$data['issue_item'] = $this->materialrequest_model->getIssueItem($isid);
		$this->load->view('MaterialRequest/issueEshView',$data);
	}
	
	public function search_Cissue_report_byEOutlet(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$br_name = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$outlet_name = $this->input->post('outlet_name');
		$item_name = $this->input->post('item_name');
		//$br_name = $this->input->post('br_name');
		//echo $br_name;
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'outlet_name'=>$outlet_name,
		'item_name' => $item_name,
		'br_name' =>$br_name);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->get_issue_report_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['outlet'] = $this->user_model->get_outlet_by_branch_esh();
		$data['item'] = $this->user_model->getItemCW();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/issuesEshList',$data);
	}
	
	public function search_Cissue_report_byCmsOutlet(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$br_name = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$outlet_name = $this->input->post('outlet_name');
		$item_name = $this->input->post('item_name');
		//$br_name = $this->input->post('br_name');
		//echo $br_name;
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'outlet_name'=>$outlet_name,
		'item_name' => $item_name,
		'br_name' =>$br_name);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->get_issue_report_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['outlet'] = $this->user_model->get_outlet_by_branch_esh();
		$data['item'] = $this->user_model->getItemCW();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('MaterialRequest/issuesCmsList',$data);
	}
	
	public function prd_Cw4ReceiptList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['submod_id'] = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['branch'] = $this->materialrequest_model->get_outlet_forCW4_pride();
		$data['rec_list'] = $this->materialrequest_model->getPrdReceiptList($uname);
		$this->load->view('MaterialRequest/prideCw4ReceiptList',$data);
	}
	
	public function get_PrideRecCw4List(){
		
		$uname = $_SESSION['username'];
		$data = $this->materialrequest_model->getPrdReceiptList($uname);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/MaterialRequest/prdinCw4View/$row->req_rec_id' class=''><i class='ft-eye'></i></a>";
    	    if($row->receipt_approval=='Pending'){
    	       $receipt_approval="<span class=' pending_data'>$row->receipt_approval</span>";
    	    }
    	    else{
    	        $receipt_approval="<span class=' success_data'>$row->receipt_approval</span>";
    	    }
    	    $branch = $row->branchname;
			$q1 = $this->db->query("select * from user where branch_name='$branch'");
			$rows = $q1->row_array();
			$outlet = $rows['username'];
    	    $test[] = array(
    	        $count,
    	        $row->req_rec_no,
    	        $row->receipt_date,
                $receipt_approval,
                $row->approval_date,
                $outlet,
                $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function prdinCw4View($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->materialrequest_model->getPrideInward($inid);
		$data['inward_item'] = $this->materialrequest_model->getPrideInwardItem($inid);
		$data['inward_rmk'] = $this->materialrequest_model->getPrideInwardRemark($inid);
		$data['dc_up'] = $this->materialrequest_model->getDcUpload($inid);
		$this->load->view('MaterialRequest/prd_cw4inward_view',$data);
	}
	
	public function searchcw4ReceiptList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('outlet_name');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->materialrequest_model->get_pride_receipt_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->materialrequest_model->get_outlet_forCW4_pride();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$this->load->view('MaterialRequest/prideReceiptList',$data);
		$this->load->view('MaterialRequest/prideCw4ReceiptList',$data);
	}
}