<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PStockManagement extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('issue_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('pstockmanage_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	
	public function PresentStk()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = '1';
		$data['branch'] = $this->user_model->get_branch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prstock'] = $this->pstockmanage_model->getPresentStock($branch_id);
		$this->load->view('Product_StockManagement/PresentStk',$data);
	}
	
	public function cPresentStk()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = '1';
		$data['branch'] = $this->user_model->get_branch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['prstock'] = $this->pstockmanage_model->getPresentStock($branch_id);
		$this->load->view('Product_StockManagement/cPresentStk',$data);
	}
	
	public function searchCPresentStock()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
				
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'branch' => $branch
		);
		if ($branch == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->pstockmanage_model->getPrStock($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['category'] = $this->pstockmanage_model->getCategory();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Product_StockManagement/cPresentStk',$data);
	}

	public function export_PrPresent(){
		$branch_name = $this->input->post('branchname');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "ProductPresent_Stk_Report.csv";
		$query = "SELECT C.pr_cat_name as category,R.rname as product_name,R.uom,R.production_stock,R.recipe_price as price from recipe R inner join product_category C on R.pr_cat_id=C.pr_cat_id where R.branchname='$branch_name' and R.status='Enabled' order by rname asc";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}

	
	
	public function cStockledger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = '2';
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->issue_model->get_useroutlet();
		
		$data['recipe'] = $this->master_model->getCatRecipe($branch_id);
		$this->load->view('Product_StockManagement/prStockLedger',$data);
	}
	
	public function searchCStockLedger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = '3';
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$item_name = $this->input->post('item_name');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'item_name' => $item_name,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->pstockmanage_model->getCStockLedger($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->issue_model->get_useroutlet();
		
		$data['recipe'] = $this->master_model->getCatRecipe($branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Product_StockManagement/prStockLedger',$data);
	}

	public function export_PrStockLedger(){
		$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
		$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
		$item_name = $this->input->post('item_name');
		$branch = $this->input->post('branch');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Product_StkLedger_Report.csv";
		$query = "SELECT DATE_FORMAT(transaction_date, '%d-%m-%Y') as Date,trans_ref_no as Transaction,opening_stock,in_qty as inward,out_qty as outward,closing_stock from stock_detail where item_name='$item_name' and branchname='$branch' and (transaction_date between '$from_date' and '$to_date') and recipe_no!='' order by stock_id asc";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}
	
	
	
	public function stkMovement()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch'] = $this->user_model->get_branch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Product_StockManagement/stkMovement',$data);
	}
	
	public function searchCStockMovement()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
				
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' => $branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->pstockmanage_model->searchCStockMovement($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Product_StockManagement/stkMovement',$data);
	}
	
	public function export_PrStockMovement(){
		$from_date = date('Y-m-d',strtotime($this->input->post('from_date')));
		$to_date = date('Y-m-d',strtotime($this->input->post('to_date')));
		$branchname = $this->input->post('branch');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "Product_StkMovement_Report.csv";
		$query = "SELECT s2.item_name,s2.opening_stock,s2.inward,s2.outward,s3.closing_stock from (select opening_stock,item_name,recipe_no,transaction_date,sum(in_qty) as inward,sum(out_qty) as outward,branchname from stock_detail where branchname='$branchname' and (transaction_date between '$from_date' and '$to_date') group by recipe_no) s2 inner join (select * from stock_detail where branchname='$branchname') s3 on s2.recipe_no=s3.recipe_no inner join (select item_name,recipe_no,transaction_date,closing_stock,max(last_modified) as maxdate,branchname from stock_detail where branchname='$branchname' and (transaction_date between '$from_date' and '$to_date') group by recipe_no) s4 on s3.recipe_no=s4.recipe_no and s3.last_modified=s4.maxdate";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
	}

	
}