<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ProductRequest extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('productrequest_model');
		$this->load->model('issue_model');
		$this->load->model('materialrequest_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	//var $master_url='https://gsrgroup.biz/inventory_final';
    var $master_url='https://bigcashew.com/inventory';
	public function productRequest()
	{
		$sub_mod_id = $this->uri->segment(3);
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submdid'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['kitchen'] = $this->productrequest_model->getKitchen($sub_mod_id,$branch_id);
		$this->load->view('ProductRequest/product_request',$data);
	}
	
	public function productRequestSanthe()
	{
		$sub_mod_id = $this->uri->segment(3);
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['kitchen'] = $this->productrequest_model->getKitchen($sub_mod_id,$branch_id);
		$this->load->view('ProductRequest/product_request_santhe',$data);
	}
			
	public function fetchCategory()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$dept = $request->dept;
		$smd_id = $request->md_id;
		//$sub_mod_id = $this->uri->segment(3);
		$cat_data = $this->productrequest_model->fetchCategory($dept,$smd_id);
		unset($data);
		foreach ($cat_data as $cat) 
		{ 
			$data[] = array(
			"cat_name"          => $cat->access_category,
			"pr_cat_id"  			=> $cat->access_cat_id
			);
		} 
		/*$itemarray = array(
		'products' => $data
		);*/
		echo json_encode($data);
		//file_put_contents('cat_list.json', json_encode($itemarray));
	}
	
/*	public function fetchProduct()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$cat = $request->cat;
		$branch_id = $request->branch_id;
		$dept = $request->dept;
		$item_data = $this->productrequest_model->fetchProduct($cat,$branch_id,$dept);
		if ($item_data != false) {
			foreach ($item_data as $item) 
    		{ 
    			$data[] = array(
    			"iname"          => $item->rname,
    			"uom"  			=> $item->uom,
    			"cat_id"          => $item->pr_cat_id,
    			"flavour"  			=> $item->flavour,
    			"f_code"          => $item->f_code,
    			"id"  			=> $item->recipe_id,
    			"qty"          => $item->req_qty,
    			"rno"  			=> $item->recipe_no
    			);
    		} 
		} else {
			$data = '';
		}
		
		echo json_encode($data);
	} */
	
	public function fetchProduct()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$cat = $request->cat;
		$branch_id = $request->branch_id;
		$dept = $request->dept;
		$this->productrequest_model->fetchProduct($cat,$branch_id,$dept);
	}
	
	public function fetchStProduct()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$branch_id = $request->branch_id;
		$dept = $request->dept;
		$item_data = $this->productrequest_model->fetchStProduct($branch_id,$dept);
		if(empty($item_data)){
		    $data="no data";
		}
		else{
		    foreach ($item_data as $item) 
		{ 
			$data[] = array(
			"iname"          => $item->rname,
			"uom"  			=> $item->uom,
			"cat_id"          => $item->pr_cat_id,
			"flavour"  			=> $item->flavour,
			"f_code"          => $item->f_code,
			"id"  			=> $item->recipe_id,
			"qty"          => $item->req_qty,
			"rno"  			=> $item->recipe_no
			);
		} 
		}
		
		echo json_encode($data);
	}
	
	public function updateIndentQty()
	{
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$value = $request->value;
		$item_id = $request->item_id;
		$query=$this->db->query("UPDATE recipe set req_qty='$value' WHERE recipe_id='$item_id'");
	}
	
	public function addRequest()
	{
		$rid=$this->productrequest_model->addRequest($this->input->post());
		if($rid)
		{
		    redirect('ProductRequest/requestView/'.$rid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('ProductRequest/productRequest/');
		}
	}
	
	public function addStRequest()
	{
		$rid=$this->productrequest_model->addStRequest($this->input->post());
		if($rid)
		{
		    redirect('ProductRequest/requestView/'.$rid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('ProductRequest/productRequestSanthe/');
		}
	}
	
	public function requestView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->getPrdRequest($rid);
		$data['prd_req_item'] = $this->productrequest_model->getPrdRequestItem($rid);
		$this->load->view('ProductRequest/request_view',$data);
	}
	
	public function requestList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->productrequest_model->getRequestList($branch_id);
		$this->load->view('ProductRequest/request_list',$data);
	}
	
	public function requestIssueList($req_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->productrequest_model->getPrdRequest($req_id);
		$data['req_iss_list'] = $this->productrequest_model->getRequesIssuetLists($req_id);
		$this->load->view('ProductRequest/request_issue_list',$data);
	}
	
	public function requestReport()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/request_report',$data);
	}

	public function requestReportbyDate()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];

		$req_date = $this->input->post('req_date');
		$submod = $this->input->post('sub_mod_id');

		$data1 = array(
		'uname' => $uname,
		'req_date' => $req_date
		);
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
		    $result = $this->productrequest_model->getIndentItemsQty($data1);
		   
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod'] = $submod;
		$data['access_tab'] = $this->productrequest_model->get_accessTab($submod,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['spl_ord'] = $this->productrequest_model->getSplOrders($data1);
		$data['run_ord'] = $this->productrequest_model->getRunningOrders($data1);
		$data['car_ord'] = $this->productrequest_model->getCarnivalIndentItemsQty($data1);
		$data['st_ord'] = $this->productrequest_model->getStIndentItemsQty($data1);
		$data['stspl_ord'] = $this->productrequest_model->getStSplOrders($data1);
		$data['store_ord'] = $this->productrequest_model->getStoreIndentItemsQty($data1);
		$data['esh_ord'] = $this->productrequest_model->getEshIndentItemsQty($data1);
		$this->load->view('ProductRequest/request_report',$data);
	}
	
	public function crequestReport()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/cmsrequest_report',$data);
	}
	
	public function cmsRequestReportbyDate()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];

		$req_date = $this->input->post('req_date');
		$submod = $this->input->post('sub_mod_id');

		$data1 = array(
		'uname' => $uname,
		'req_date' => $req_date
		);
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
		    $result = $this->productrequest_model->getIndentItemsQty($data1);
		   
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod'] = $submod;
		$data['access_tab'] = $this->productrequest_model->get_accessTab($submod,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['spl_ord'] = $this->productrequest_model->getSplOrders($data1);
		$data['run_ord'] = $this->productrequest_model->getRunningOrders($data1);
		$data['car_ord'] = $this->productrequest_model->getCarnivalIndentItemsQty($data1);
		$data['st_ord'] = $this->productrequest_model->getStIndentItemsQty($data1);
		$data['stspl_ord'] = $this->productrequest_model->getStSplOrders($data1);
		$data['store_ord'] = $this->productrequest_model->getStoreIndentItemsQty($data1);
		$data['esh_ord'] = $this->productrequest_model->getEshIndentItemsQty($data1);
		$this->load->view('ProductRequest/cmsrequest_report',$data);
	}

	public function productIssue()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/product_issue',$data);
	}
	
	public function productIssueByDate()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		
		$req_date = $this->input->post('req_date');
		$sub_mod_id = $this->input->post('sub_mod_id');

		$data1 = array(
		'uname' => $uname,
		'req_date' => $req_date,
		'branch_id' => $branch_id
		);
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
			$result = $this->productrequest_model->getIndentItems($data1);
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod'] = $sub_mod_id;
		$data['access_tab'] = $this->productrequest_model->get_accessTab($sub_mod_id,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['vkitchen'] = $this->productrequest_model->getVkitchens($data1);
		$data['ecounters'] = $this->productrequest_model->getECounters($data1);
		$data['esh_ord'] = $this->productrequest_model->getEIndentItems($data1);
		$data['car_ord'] = $this->productrequest_model->getCarIndentItems($data1);
		$data['spl_ord'] = $this->productrequest_model->getSplOrders($data1);
		$data['run_ord'] = $this->productrequest_model->getRunningOrders($data1);
		$data['stspl_ord'] = $this->productrequest_model->getStSplOrders($data1);
		$data['st_ord'] = $this->productrequest_model->getStIndentItems($data1);
		$data['stcounters'] = $this->productrequest_model->getStCounters($data1);
		$data['strcounters'] = $this->productrequest_model->getStrCounters($data1);
		$data['str_ord'] = $this->productrequest_model->getStrIndentItems($data1);
		$this->load->view('ProductRequest/product_issue',$data);
	}
	
	public function addRegularIssue()
	{
	    $branch= $_SESSION['branch_name'];
		$this->productrequest_model->addRegularIssue($this->input->post());
		if($branch == 'CW')
		{
		    redirect('ProductRequest/productCWIssueList/');
		}
		else
		{
		    redirect('ProductRequest/productIssueList/');
		}
	}
	
	public function addCarnivalIssue()
	{
	    $branch= $_SESSION['branch_name'];
		$this->productrequest_model->addCarnivalIssue($this->input->post());
		redirect('ProductRequest/productIssueList/');
	}
	
	public function addEshRegularIssue()
	{
		$this->productrequest_model->addEshRegularIssue($this->input->post());
		redirect('ProductRequest/productIssueList/');
	}
	
	public function addStrRegularIssue()
	{
		$this->productrequest_model->addStrRegularIssue($this->input->post());
		redirect('ProductRequest/productIssueList/');
	}
	
	public function addStRegularIssue()
	{
		$this->productrequest_model->addStRegularIssue($this->input->post());
		redirect('ProductRequest/productIssueList/');
	}
	
	public function splOrder(){
		$req_id = $_POST['req_id'];
		$branch_id = $_SESSION['branch_id'];;
		$data['prd_req'] = $this->productrequest_model->getPrdRequest($req_id);
		$data['prd_reqitem'] = $this->productrequest_model->getPrdRequestItm($req_id,$branch_id);
		$this->load->view('ProductRequest/spl_order',$data);
	}
	
	public function addSplOrdIssue()
	{
		$this->productrequest_model->addSplOrdIssue($this->input->post());
		redirect('ProductRequest/productIssueList/');
	}
		
	public function productionIssue()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/production_issue',$data);
	}
	
	public function productionIssueByDate()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];

		$req_date = $this->input->post('req_date');
		$sub_mod_id = $this->input->post('sub_mod_id');

		$data1 = array(
		'uname' => $uname,
		'req_date' => $req_date,
		'branch_id' => $branch_id
		);
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
			$result = $this->productrequest_model->getIndentItems($data1);
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod'] = $sub_mod_id;
		$data['access_tab'] = $this->productrequest_model->get_accessTab($sub_mod_id,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['vkitchen'] = $this->productrequest_model->getVkitchens($data1);
		$data['car_ord'] = $this->productrequest_model->getCarIndentItems($data1);
		$data['spl_ord'] = $this->productrequest_model->getSplOrders($data1);
		$data['run_ord'] = $this->productrequest_model->getRunningOrders($data1);
		$post_data = $this->session->userdata('post_data');
        if ($post_data == $_POST){
            $this->session->unset_userdata('post_data');
            $this->load->view('ProductRequest/production_issue',$data);
            //redirect("ProductRequest/productionIssue/","refresh");
            //redirect(current_url(), 'refresh');
        }else{
            $this->session->set_userdata('post_data', $_POST );
            //redirect('ProductRequest/productionIssue/'.$sub_mod_id.'',"refresh");
            $this->load->view('ProductRequest/production_issue',$data);
        }
		//$this->load->view('ProductRequest/production_issue',$data);
	}
	
	public function addProductionIssue()
	{
		$this->productrequest_model->addProductionIssue($this->input->post());
		redirect('ProductRequest/productIssueList/');
		//redirect('ProductRequest/productionIssue/');
	}
	
	public function productionSplOrder(){
		$req_id = $_POST['req_id'];
		$branch_id = $_SESSION['branch_id'];;
		$data['prd_req'] = $this->productrequest_model->getPrdRequest($req_id);
		$data['prd_reqitem'] = $this->productrequest_model->getPrdRequestItm($req_id,$branch_id);
		$this->load->view('ProductRequest/production_spl_order',$data);
	}
	
	public function addProductionSplOrdIssue()
	{
		$this->productrequest_model->addProductionSplOrdIssue($this->input->post());
		redirect('ProductRequest/productIssueList/');
	}
	
	public function productIssueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issues_list'] = $this->productrequest_model->getIssuetList($branch_id);
		$this->load->view('ProductRequest/issue_list',$data);
	}
	
	public function productIssueCList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$username = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issues_list'] = $this->productrequest_model->getIssuetCList($username);
		$this->load->view('ProductRequest/issue_Clist',$data);
	}
	
	public function productCWIssueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issues_list'] = $this->productrequest_model->getIssueCwList();
		$this->load->view('ProductRequest/issue_CWlist',$data);
	}
	
	public function get_prCwList(){
		
		$uname = $_SESSION['username'];
		$data = $this->productrequest_model->getIssueCwList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/ProductRequest/issueCWView/$row->issue_id' class=''><i class='ft-eye'></i></a>";
    	   
    	    $test[] = array(
    	        $count,
    	        $row->pr_req_no,
    	        $row->request_date,
                $row->dept,
                $row->issue_no,
                $row->issue_date,
                $row->outlet,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function issueCWView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getIssue($isid);
		$data['issue_item'] = $this->productrequest_model->getIssueItem($isid);
		$this->load->view('ProductRequest/issue_cwView',$data);
	}
	
	public function accproductIssueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issues_list'] = $this->productrequest_model->getAccIssuetList();  
		$data['kitchen'] = $this->productrequest_model->getkitchenList();
		$data['counter'] = $this->productrequest_model->getCounterList();
		$this->load->view('ProductRequest/accissue_list',$data);
	}
	
	public function searchAccissueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$ktn = $this->input->post('kitchen');
		$ctr = $this->input->post('counter');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'ktn' =>$ktn,
		'ctr' =>$ctr
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->productrequest_model->getIssuesReport($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['kitchen'] = $this->productrequest_model->getkitchenList();
		$data['counter'] = $this->productrequest_model->getCounterList();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/accissue_list',$data);
	}
	
	public function issueView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getIssue($isid);
		$data['issue_item'] = $this->productrequest_model->getIssueItem($isid);
		$this->load->view('ProductRequest/issue_view',$data);
	}
	
	public function issuePView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getIssue($isid);
		$data['issue_item'] = $this->productrequest_model->getIssueItem($isid);
		$this->load->view('ProductRequest/issue_pview',$data);
	}
	
	public function issuePTaxView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getIssue($isid);
		$data['issue_item'] = $this->productrequest_model->getIssueItem($isid);
		$this->load->view('ProductRequest/issue_ptaxview',$data);
	}
	
	public function issuePCView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getIssue($isid);
		$data['issue_item'] = $this->productrequest_model->getIssueItem($isid);
		$this->load->view('ProductRequest/issue_pcview',$data);
	}
	
	public function accissueView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getIssue($isid);
		$data['issue_item'] = $this->productrequest_model->getIssueItem($isid);
		$this->load->view('ProductRequest/accissue_view',$data);
	}
	
	public function issueInward($req_id,$issue_id)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getIssue($issue_id);
		$data['issue_item'] = $this->productrequest_model->getIssuedItemDetail($issue_id);
		$this->load->view('ProductRequest/issue_inward',$data);
	}
	
	public function addInward()
	{
		$inid = $this->productrequest_model->addInward($this->input->post());
		$req_id = $this->input->post('req_id');
		$issue_id = $this->input->post('iss_id');
		if($inid)
		{
		    redirect('ProductRequest/inwardView/'.$inid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('ProductRequest/issueInward/'.$req_id.'/'.$issue_id);
		}
	}
	
	public function inwardtList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inw_list'] = $this->productrequest_model->getInwardtList($branch_id);
		$this->load->view('ProductRequest/inward_list',$data);
	}
	
	public function inwardView($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->productrequest_model->getInward($inid);
		$data['inward_item'] = $this->productrequest_model->getInwardItem($inid);
		$this->load->view('ProductRequest/inward_view',$data);
	}
	
	public function requestClosedList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->productrequest_model->getRequestClosedList($branch_id);
		$this->load->view('ProductRequest/request_closed_list',$data);
	}
	
	public function reqCloseView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->getPrdRequest($rid);
		$data['prd_req_item'] = $this->productrequest_model->getPrdRequestItem($rid);
		$this->load->view('ProductRequest/req_close_view',$data);
	}
	
	public function reqClosedView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_rec'] = $this->productrequest_model->getPrdReceipt($rid);
		$this->load->view('ProductRequest/req_closed_view',$data);
	}
	
	public function req_single_recipt(){
		$inid = $_POST['rc_id'];
		$data['inward'] = $this->productrequest_model->getInward($inid);
		$data['inward_item'] = $this->productrequest_model->getInwardItem($inid);
		$this->load->view('ProductRequest/rc_single_view', $data);
	}
	
	public function issueClosedList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->productrequest_model->getIssueClosedList($uname);
		$this->load->view('ProductRequest/issue_closed_list',$data);
	}
	
	public function prdrequestView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->getPrdRequestIss($rid);
		$data['prd_req_item'] = $this->productrequest_model->getPrdRequestItem($rid);
		$this->load->view('ProductRequest/pirequest_view',$data);
	}
	
	public function issueClosedView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_iss'] = $this->productrequest_model->getPrdIssues($rid);
		$this->load->view('ProductRequest/issue_closed_view',$data);
	}
	
	public function issue_single_recipt(){
		$is_id = $_POST['is_id'];
		$data['issue'] = $this->productrequest_model->getIssue($is_id);
		$data['issue_item'] = $this->productrequest_model->getIssueItem($is_id);
		$this->load->view('ProductRequest/iss_single_view', $data);
	}
	
	public function issuePendingList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['iss_list'] = $this->productrequest_model->getIssuePendingList($uname);
		$this->load->view('ProductRequest/issue_pending_list',$data);
	}
	
	public function requestRmkissUpdate(){
		$req_id = $this->input->post('req_id');
		$req_remark = $this->input->post('req_remark');
		$this->db->query("update product_request set receipt_status='Closed',status='Closed',issue_status='Closed',in_remark='$req_remark' where request_id='$req_id'");
		echo 1;
	}
	
	public function requestCReport()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['sub_mod_id'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['pr_data'] = $this->productrequest_model->pr_userdata();
		$this->load->view('ProductRequest/requestC_report',$data);
	}

	public function requestCReportbyDate()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$uname = $_SESSION['username'];
        $uname=$this->input->post('dept');
		$req_date = $this->input->post('req_date');
		$submod = $this->input->post('sub_mod_id');

		$data1 = array(
		'uname' => $uname,
		'req_date' => $req_date
		);
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
			$result = $this->productrequest_model->getIndentItemsQty($data1);
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod'] = $submod;
		$data['access_tab'] = $this->productrequest_model->get_accessTab($submod,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['spl_ord'] = $this->productrequest_model->getSplOrders($data1);
		$data['run_ord'] = $this->productrequest_model->getRunningOrders($data1);
		$data['st_ord'] = $this->productrequest_model->getStIndentItemsQty($data1);
		$data['stspl_ord'] = $this->productrequest_model->getStSplOrders($data1);
	//	$this->load->view('ProductRequest/request_report',$data);
	/*	$data1 = array(
		'uname' => $uname,
		'req_date' => $req_date
		);
		$data1 = array(
		'uname' => $dept,
		'req_date' => $req_date
		);
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
			$result = $this->productrequest_model->getIndentItemsQty($data1);
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['santhe_req_item'] = $this->productrequest_model->get_santhe_req_item($req_date,$dept);
		$data['santhe_req_qty'] = $this->productrequest_model->get_santhe_req_qty($req_date,$dept);
		$data['special_req_item'] = $this->productrequest_model->get_req_item_special($req_date,$dept);
		$data['special_req_qty'] = $this->productrequest_model->get_req_qty_special($req_date,$dept);
		$data['regular_req_qty'] = $this->productrequest_model->get_req_qty_regular($req_date,$dept);
		$data['regular_req_item'] = $this->productrequest_model->get_req_item_regular($req_date,$dept);
		$data['access_tab'] = $this->productrequest_model->get_accessTab($sub_mod_id,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['spl_ord'] = $this->productrequest_model->getSplOrders($data1);
		$data['run_ord'] = $this->productrequest_model->getRunningOrders($data1);*/
		$this->load->view('ProductRequest/requestC_report',$data);
	}
	
	public function prideInwardList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$branch_name = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inlist'] = $this->productrequest_model->get_pride_inward_list($branch_name);
		$this->load->view('ProductRequest/pride_inward_list',$data);
	}

	public function inwardPrideView($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->productrequest_model->getPrideInward($inid);
		$data['inward_item'] = $this->productrequest_model->getPrideInwardItem($inid);
		$data['inward_rmk'] = $this->productrequest_model->getPrideInwardRemark($inid);
		$data['dc_up'] = $this->productrequest_model->getDcUpload($inid);
		$this->load->view('ProductRequest/pride_inward_view',$data);
	}

	public function getPrideRemarkList(){
	    $user_id = $_SESSION['user_id'];
	    $branch_name = $_SESSION['branch_name'];
        $c_date = date('Y-m-d');
		$cdate = date('Y-m-d',strtotime($c_date. '- 6 days'));
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inwtkt'] = $this->productrequest_model->get_inw_tickets($cdate,$c_date,$branch_name);
		$data['inwcnt'] = $this->productrequest_model->get_inw_count($cdate,$c_date,$branch_name);
		$this->load->view('ProductRequest/inward_ticket',$data);
	}
	
	public function getPrideRmkkList(){
	    $user_id = $_SESSION['user_id'];
	    $branch_name = $_SESSION['branch_name'];
        $c_date = date('Y-m-d');
		$cdate = date('Y-m-d',strtotime($c_date. '- 6 days'));
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inwtkt'] = $this->productrequest_model->get_pinw_tickets($cdate,$c_date);
		$data['inwcnt'] = $this->productrequest_model->get_pinw_count($cdate,$c_date);
		$this->load->view('ProductRequest/inward_ticket',$data);
	}
	
	public function prReqPendingList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['iss_list'] = $this->productrequest_model->pride_orders($uname);
		$this->load->view('ProductRequest/pride_requestList',$data);
	}
	
	public function prdProductView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->pride_order_approve($rid);
		$data['prd_req_item'] = $this->productrequest_model->getPrdRequestItem($rid); 
		$this->load->view('ProductRequest/piProduct_view',$data);
	}
	
	public function request_approval_update() {
        $req_id=$this->input->post('req_id');
        $apporval_date = date("Y-m-d", strtotime($this->input->post('apporval_date')));
		$query = $this->db->query("update product_request set status='Approved',approval_date='$apporval_date' where request_id='$req_id'");
		redirect('ProductRequest/prReqPendingList/');
	    //$this->load->view('ProductRequest/pride_requestList',$data);
	}
	
	public function stRequestList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->productrequest_model->getRequestList($branch_id);
		$this->load->view('ProductRequest/stRequest_list',$data);
	}
	
	public function add_pride_inward($request_id){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req'] = $this->productrequest_model->getPrdRequest($request_id);
		$data['req_item'] = $this->productrequest_model->get_recieved_product($request_id);
		$this->load->view('ProductRequest/add_pride_inward',$data);
	}
	
	public function addPrideInward()
	{
		$rec_id= $this->productrequest_model->add_pride_product($this->input->post());
		$branch_name = $_SESSION['branch_name'];
		$req_id = $this->input->post('req_id');
		if($rec_id)
		{
		if($branch_name=='CW-STR'){
		    redirect('ProductRequest/str_pride_product_inward/'.$rec_id);
		}
		else{
		    redirect('ProductRequest/pride_product_inward/'.$rec_id);
		}
	}
	else
	{
	    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('ProductRequest/add_pride_inward/'.$req_id);
	}
		
	}
	
	
	public function str_pride_product_inward($rec_id){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->get_pride_product_detail($rec_id);
		$data['prd_req_item'] = $this->productrequest_model->get_pride_product_inward($rec_id);
		$this->load->view('ProductRequest/str_pride_product_inward',$data);
	}
	
	public function pride_product_inward($rec_id){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->get_pride_product_detail($rec_id);
		$data['prd_req_item'] = $this->productrequest_model->get_pride_product_inward($rec_id);
		$this->load->view('ProductRequest/pride_product_inward',$data);
	}
	
	public function addinwardComunication(){
	    $this->productrequest_model->inward_ticket($this->input->post());
	    $rec_id = $this->input->post('inw_id');
	    $branch_name = $_SESSION['branch_name'];
		if($branch_name=='CW-STR'){
		    redirect('ProductRequest/str_pride_product_inward/'.$rec_id);
		}
		else{
		    redirect('ProductRequest/pride_product_inward/'.$rec_id);
		}
	    
	}
	
	public function dcUpload()
	{
		$this->productrequest_model->addDcUpload($this->input->post());
		$rec_id = $this->input->post('rcp_id');
		$branch_name = $_SESSION['branch_name'];
		if($branch_name=='CW-STR'){
		    redirect('ProductRequest/str_pride_product_inward/'.$rec_id);
		}
		else{
		    redirect('ProductRequest/pride_product_inward/'.$rec_id);
		}
	}
	
	public function SplOrderReport()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['spl_ord'] = $this->productrequest_model->gettSplOrders($uname);
		$this->load->view('ProductRequest/todateSpecial',$data);
	}
	public function RunningReport()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['run_ord'] = $this->productrequest_model->gettRunningOrders($uname);
		$this->load->view('ProductRequest/todateRunning',$data);
	}
	
	public function requestAReport()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['sub_mod_id'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['pr_data'] = $this->productrequest_model->pr_userdata();
		$this->load->view('ProductRequest/admRequestReport',$data);
	}
	
	public function requestAdmReportbyDate()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$uname = $_SESSION['username'];
        $uname=$this->input->post('dept');
		$req_date = $this->input->post('req_date');
		$submod = $this->input->post('sub_mod_id');

		$data1 = array(
		'uname' => $uname,
		'req_date' => $req_date
		);
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
			$result = $this->productrequest_model->getAIndentItemsQty($data1);
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod'] = $submod;
		$data['access_tab'] = $this->productrequest_model->get_accessTab($submod,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['spl_ord'] = $this->productrequest_model->getASplOrders($data1);
		$data['run_ord'] = $this->productrequest_model->getARunningOrders($data1);
		$data['st_ord'] = $this->productrequest_model->getAStIndentItems($data1);
		$data['stspl_ord'] = $this->productrequest_model->getAStSplOrders($data1);
		$this->load->view('ProductRequest/admRequestReport',$data);
	}
	
	public function str_pride_inward(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$branch_name = $_SESSION['branch_name'];
		$data['submod_id'] = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['inlist'] = $this->productrequest_model->get_strpride_inward_list();
		$this->load->view('ProductRequest/str_pride_inward',$data);
	}
	
	public function get_strPrideInward(){
		
		$data = $this->productrequest_model->get_strpride_inward_list();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/ProductRequest/Strpride_product_inward/$row[req_rec_id]' class=''><i class='ft-eye'></i></a>";
    	    
    	    if($row['receipt_approval']=='Pending'){
    	       $rec_approval="<span class=' pending_data'>$row[receipt_approval]</span>";
    	    }
    	    else{
    	        $rec_approval="<span class=' success_data'>$row[receipt_approval]</span>";
    	    }
    	    $branch = $row['branchname'];
			$q1 = $this->db->query("select * from user where branch_name='$branch'");
			$rows = $q1->row_array();
			$outlet = $rows['username'];
			
    	    $test[] = array(
    	        $count,
    	        $row['req_rec_no'],
    	        $row['receipt_date'],
                $outlet,
                $rec_approval,
                $row['approval_date'],
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function searchInwardList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('outlet_name');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->productrequest_model->get_pride_receipt_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/str_pride_inward',$data);
	}
	
	public function productIssueKit()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['submod'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/product_issueKit',$data);
	}
	
	public function productIssueByDateKitchen()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$uname = $_SESSION['username'];
		
		$req_date = $this->input->post('req_date');
		$department = $this->input->post('department');
		$r1=$this->db->query("SELECT * from user where username='$department'");
		foreach($r1->result_array() as $row1)
		$uname = $row1['branch_name'];
		$sub_mod_id = $this->input->post('sub_mod_id');
		$data['uname']=$uname;
		$data1 = array(
		'uname' => $department,
		'req_date' => $req_date,
		'branch_id' => $branch_id,
		'brname'=>$uname
		);
		//echo $department;
		//echo $uname;
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
			$result = $this->productrequest_model->getIndentItemsKitchen($data1);
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod'] = $sub_mod_id;
		$data['access_tab'] = $this->productrequest_model->get_accessTab($sub_mod_id,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['spl_ord'] = $this->productrequest_model->getSplOrdersKit($data1);
		$data['run_ord'] = $this->productrequest_model->getRunningOrdersKit($data1);
		$data['stspl_ord'] = $this->productrequest_model->getStSplOrders($data1);
		$data['st_ord'] = $this->productrequest_model->getStIndentItems($data1);
		$data['stcounters'] = $this->productrequest_model->getStCounters($data1);
		$this->load->view('ProductRequest/product_issueKit',$data);
	}
	
	public function productIssueByDateKit()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		
		$req_date = $this->input->post('req_date');
		$sub_mod_id = $this->input->post('sub_mod_id');
		$department = $this->input->post('department');
		$data1 = array(
		'uname' => $uname,
		'req_date' => $req_date,
		'branch_id' => $branch_id,
		'department'=>$department
		);
		if($req_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
		} else {
			$result = $this->productrequest_model->getIndentItemsKit($data1);
			if ($result != false) {
				$data['result_display'] = $result;
			} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod'] = $sub_mod_id;
		$data['access_tab'] = $this->productrequest_model->get_accessTab($sub_mod_id,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['counters'] = $this->productrequest_model->getCounters($data1);
		$data['spl_ord'] = $this->productrequest_model->getSplOrders($data1);
		$data['run_ord'] = $this->productrequest_model->getRunningOrders($data1);
		$data['stspl_ord'] = $this->productrequest_model->getStSplOrders($data1);
		$data['st_ord'] = $this->productrequest_model->getStIndentItems($data1);
		$data['stcounters'] = $this->productrequest_model->getStCounters($data1);
		$this->load->view('ProductRequest/product_issueKit',$data);
	}
	
	public function acc_str_pride_inward(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$uname = $_SESSION['username'];
		$branch_name = $_SESSION['branch_name'];
		$data['submod_id'] = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['inlist'] = $this->productrequest_model->get_strpride_inward_list();
		$this->load->view('ProductRequest/acc_str_pride_inward',$data);
	}
	
	public function get_accstrPrideInward(){
		
		$data = $this->productrequest_model->get_strpride_inward_list();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a target='_blank' href='$this->master_url/index.php/ProductRequest/strAccpride_product_inward/$row[req_rec_id]' class=''><i class='ft-eye'></i></a>";
    	    
    	    if($row['receipt_approval']=='Pending'){
    	       $rec_approval="<span class=' pending_data'>$row[receipt_approval]</span>";
    	    }
    	    else{
    	        $rec_approval="<span class=' success_data'>$row[receipt_approval]</span>";
    	    }
    	    $branch = $row['branchname'];
			$q1 = $this->db->query("select * from user where branch_name='$branch'");
			$rows = $q1->row_array();
			$outlet = $rows['username'];
			
    	    $test[] = array(
    	        $count,
    	        $row['pr_req_no'],
    	        $row['request_date'],
    	        $row['req_rec_no'],
    	        $row['receipt_date'],
                $row['branchname'],
                $rec_approval,
                $row['approval_date'],
                $row['total_amount'],
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function strAccpride_product_inward($rec_id){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->get_pride_product_detail($rec_id);
		$data['prd_req_item'] = $this->productrequest_model->get_pride_product_inward($rec_id);
		$this->load->view('ProductRequest/str_pride_product_inward_print',$data);
	}
	
	public function santhe_inward_approval()
	{
		$inw_id = $this->input->post('inw_id');
		$apporval_date = date("Y-m-d", strtotime($this->input->post('apporval_date')));
		$this->db->query("update product_req_rec set receipt_approval='Approved',approval_date='$apporval_date' where req_rec_id='$inw_id'");
		redirect('ProductRequest/acc_str_pride_inward');
		
	}
	
	public function searchAccInwardList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('outlet_name');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->productrequest_model->get_pride_receipt_byOutlet($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/acc_str_pride_inward',$data);
	}
	
	public function carnivalProductRequest()
	{
		$sub_mod_id = $this->uri->segment(3);
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submdid'] = $sub_mod_id;
		$data['cdept'] = $this->productrequest_model->getCounter($sub_mod_id,$branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['kitchen'] = $this->productrequest_model->getKitchen($sub_mod_id,$branch_id);
		$this->load->view('ProductRequest/carnivalProductRequest',$data);
	}
	
	public function addCarnivalRequest()
	{
		$rid=$this->productrequest_model->addCarnivalRequest($this->input->post());
		if($rid)
		{
		    redirect('ProductRequest/requestCarniView/'.$rid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('ProductRequest/carnivalProductRequest/');
		}
	}
	
	public function requestCarniView($rid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->getPrdRequest($rid);
		$data['prd_req_item'] = $this->productrequest_model->getPrdRequestItem($rid);
		$this->load->view('ProductRequest/requestCarnivalView',$data);
	}
	
	public function requestCarnivalList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->productrequest_model->getCarnivalRequestList($branch_id);
		$this->load->view('ProductRequest/requestCarnivalList',$data);
	}
	
	public function requestCarnivalClosedList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->productrequest_model->getRequestCarnivalClosedList($branch_id);
		$this->load->view('ProductRequest/Carnivalrequest_closed_list',$data);
	}
	
	public function carnival_InwardList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inw_list'] = $this->productrequest_model->getCInwardtList($branch_id);
		$this->load->view('ProductRequest/carnival_InwardList',$data);
	}
	
	public function inwardCarnivalView($inid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['inward'] = $this->productrequest_model->getCInward($inid);
		$data['inward_item'] = $this->productrequest_model->getCInwardItem($inid);
		$this->load->view('ProductRequest/inwardCarnivalView',$data);
	}
	
	public function productCarnivalIssueEntry()
	{
	    $sub_mod_id = $this->uri->segment(3);
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['cdept'] = $this->productrequest_model->getCounter($sub_mod_id,$branch_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->productrequest_model->get_CarnivalProducts($branch_id);
		$data['ctr'] = $this->productrequest_model->get_Counter();
		
		$this->load->view('ProductRequest/productIssueCarnival',$data);
	}
	
	public function productCCarnivalIssueEntry()
	{
	    $sub_mod_id = $this->uri->segment(3);
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['cdept'] = $this->productrequest_model->getCounter($sub_mod_id,$branch_id);
		$data['category'] = $this->master_model->getCategory();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->productrequest_model->get_CarnivalProducts($branch_id);
		$data['ctr'] = $this->productrequest_model->get_Counter();
		$data['vnk'] = $this->productrequest_model->get_Vkitchens();
		
		$this->load->view('ProductRequest/productIssueCCarnival',$data);
	}
	
	public function getVkitchenProduct()
	{
		$br_id = $this->input->post('branch_id');
		$temp = Array();
		$query = $this->db->query("SELECT rname from recipe where branch_id='$br_id'");
		$result = $query->result();
		foreach($result as $res)
		{
			$temp[] = $res;
		}
		echo json_encode($temp);
		file_put_contents('vitm_list.json', json_encode($temp));
	}
	
	public function get_ProductDetails()
	{
		$iname = $this->input->post('iname');
		$br_id = $this->input->post('br_id');
		$this->productrequest_model->get_ProductDetails($iname,$br_id);
	}
	
	public function addPrCarnivalIssue()
	{
		$iss_id=$this->productrequest_model->addPrCarnivalIssue($this->input->post());
		
		if($iss_id)
		{
		    redirect('ProductRequest/issueCarnivalPrView/'.$iss_id);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('ProductRequest/productCarnivalIssueEntry/');
		}
	}
	
	public function addPrCCarnivalIssue()
	{
		$iss_id=$this->productrequest_model->addPrCCarnivalIssue($this->input->post());
		
		if($iss_id)
		{
		    redirect('ProductRequest/issueCarnivalPrView/'.$iss_id);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('ProductRequest/productCCarnivalIssueEntry/');
		}
	}
	
	public function issueCarnivalPrView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getPrIssue($isid);
		$data['issue_item'] = $this->productrequest_model->getPrIssueItem($isid);
		$this->load->view('ProductRequest/issue_CarnivalPrview',$data);
	}
	
	public function issueCCarnivalPrView($isid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue'] = $this->productrequest_model->getPrIssue($isid);
		$data['issue_item'] = $this->productrequest_model->getPrIssueItem($isid);
		$this->load->view('ProductRequest/issue_CCarnivalPrview',$data);
	}
	
	public function issuePrList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->productrequest_model->issuePrList($branch_id);
		$this->load->view('ProductRequest/issue_CarnivalPrlist',$data);
	}
	
	public function issueCPrList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['issue_list'] = $this->productrequest_model->issueCPrList();
		$this->load->view('ProductRequest/issue_CarnivalCPrlist',$data);
	}
	
	public function issue_PrList(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->productrequest_model->issuePrList($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/ProductRequest/issueCarnivalPrView/$row->issue_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    
    	    $test[] = array(
    	        $count,
    	        $row->issue_no,
    	        $row->issue_date,
    	        $row->outlet,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function issue_CPrList(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->productrequest_model->issueCPrList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/ProductRequest/issueCCarnivalPrView/$row->issue_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    
    	    $test[] = array(
    	        $count,
    	        $row->issue_no,
    	        $row->issue_date,
    	        $row->outlet,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function Strpride_product_inward($rec_id){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->get_pride_product_detail($rec_id);
		$data['prd_req_item'] = $this->productrequest_model->get_pride_product_inward($rec_id);
		$this->load->view('ProductRequest/strPrideInwardView',$data);
	}
	
	public function splKitOrder(){
		$req_id = $_POST['req_id'];
		$branch_id = $_SESSION['branch_id'];;
		$data['prd_req'] = $this->productrequest_model->getPrdRequest($req_id);
		$data['prd_reqitem'] = $this->productrequest_model->getPrdRequestItm($req_id,$branch_id);
		$this->load->view('ProductRequest/spl_kitorder',$data);
	}
	
	public function CarIssueList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['vnk'] = $this->productrequest_model->get_Vkitchens();
		$data['issue_list'] = $this->productrequest_model->issueCPrList();
		$this->load->view('ProductRequest/carIssueList',$data);
	}
	
	public function carIssuebyKitchen(){
	    $user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$br_name = $_SESSION['branch_name'];
		
		
		$kitchen = $this->input->post('kitchen');
		
		$data1 = array(
		'kitchen' => $kitchen
		);
		if ($kitchen == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->productrequest_model->getCarIssue($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['vnk'] = $this->productrequest_model->get_Vkitchens();
		$data['issue_list'] = $this->productrequest_model->issueCPrList();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/carIssueList',$data);
	}
	
	 public function productRequestIof()
	{
		$sub_mod_id = $this->uri->segment(3);
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['sub_mod_id'] = $sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['items'] = $this->master_model->get_Products1($branch_id);
		//	$data['items'] = $this->master_model->get_Products1($branch_id);
		//$data['kitchen'] = $this->productrequest_model->getKitchen($sub_mod_id,$branch_id);
		$this->load->view('ProductRequest/prRequestIof',$data);
	}

	public function addPr_RequestIOF(){
		$req_id=$this->productrequest_model->addPr_RequestIOF($this->input->post());
		redirect('ProductRequest/pr_RequestView/'.$req_id);
	}

	public function pr_RequestView($req_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->getPrdRequest($req_id);
		$data['prd_req_item'] = $this->productrequest_model->getPrdRequestItem($req_id);
		$this->load->view('ProductRequest/prRequest_view',$data);
	}

	public function request_issuePendingList()
	{
		$user_id = $_SESSION['user_id'];
		$uname = $_SESSION['username'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['req_list'] = $this->productrequest_model->get_pr_request_list_for_issue($uname);
		$this->load->view('ProductRequest/request_issuePending',$data);
	}

	public function addPrIssue($request_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->get_product_request_detail($request_id);
		$data['prd_req_item'] = $this->productrequest_model->get_product_issue_item($request_id,$branch_name);
		$data['vehicle'] = $this->issue_model->get_vehicle();
		$this->load->view('ProductRequest/addPrIssue',$data);
	}

	public function add_product_Issue(){
	    $outlet_branch=$this->input->post('outlet_branch');
		$is_id=$this->productrequest_model->add_product_Issue($this->input->post());
		if($outlet_branch=='NB'){
		    redirect('ProductRequest/pr_taxissue_receipt/'.$is_id);
		}else{
		    redirect('ProductRequest/pr_issue_receipt/'.$is_id);
		}
		
	}

	public function pr_issue_receipt($is_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_iss'] = $this->productrequest_model->get_pr_issue($is_id);
		$data['prd_iss_item'] = $this->productrequest_model->get_pr_issue_item($is_id);
		$this->load->view('ProductRequest/pr_issue_receipt',$data);
	}
	
	
	public function pr_taxissue_receipt($is_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_iss'] = $this->productrequest_model->get_pr_issue($is_id);
		$data['prd_iss_item'] = $this->productrequest_model->get_pr_issue_item($is_id);
		$this->load->view('ProductRequest/pr_tax_issue_receipt',$data);
	}
	
	public function pr_request_remark_update(){
		$request_id=$this->input->post('request_id');
		$req_remark = $this->input->post('req_remark');
		$this->db->query("update product_request set status='Closed',remark='$req_remark' where request_id='$request_id'");
	}
	
	public function productIssueDCList($sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$username = $_SESSION['username'];
		$data['submod_id']=$sub_mod_id;
		
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['outlet'] = $this->issue_model->get_outletin();
		
		$data['issues_list'] = $this->productrequest_model->getIssuetDCList();
		$this->load->view('ProductRequest/issue_DClist',$data);
	}
	
	public function searchCPissueList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->productrequest_model->getPIssueListReport($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['outlet'] = $this->issue_model->get_outletin();
		
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('ProductRequest/issue_DClist',$data);
	}
	
	public function addPrOIssue($request_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd_req'] = $this->productrequest_model->get_product_request_detail($request_id);
		$data['prd_req_item'] = $this->productrequest_model->get_product_issue_item($request_id,$branch_name);
		$data['vehicle'] = $this->issue_model->get_vehicle();
		$this->load->view('ProductRequest/addPrOIssue',$data);
	}

	public function add_product_OutletIssue(){
	    $outlet_branch=$this->input->post('outlet_branch');
		$is_id=$this->productrequest_model->add_product_OutletIssue($this->input->post());
		if($outlet_branch=='NB'){
		    redirect('ProductRequest/pr_taxissue_receipt/'.$is_id);
		}else{
		    redirect('ProductRequest/pr_issue_receipt/'.$is_id);
		}
		
	}
}