<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Production extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('production_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	
	//var $master_url='https://gsrgroup.biz/inventory_final';
    var $master_url='https://bigcashew.com/inventory';
    
    public function production()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['chef'] = $this->master_model->get_Chef();
		$data['category'] = $this->master_model->get_Category();
		$data['recipe'] = $this->master_model->getCatRecipe($branch_id);
		$this->load->view('Production/production',$data);
	}
	
	public function addProduction()
	{
		$bid=$this->production_model->addProduction($this->input->post());
		if($bid)
		{
		    redirect('Production/production_view/'.$bid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Production/production/');
		}
	}
	
	public function production_view($bid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prd'] = $this->production_model->getProduction($bid);
		$data['prd_item'] = $this->production_model->getProductionItem($bid);
		$this->load->view('Production/production_view',$data);
	}
	
	public function productionList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['production_list'] = $this->production_model->getProductionList($branch_id);
		$this->load->view('Production/production_list',$data);
	}
	
	public function CProductionList($sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['production_list'] = $this->production_model->getCProductionList();
		$this->load->view('Production/cProductionList',$data);
	}
	
	public function searchCProduction()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->production_model->searchCProduction($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('Production/cProductionList',$data);
	}
	
	public function bom()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['chef'] = $this->master_model->get_Chef();
		$data['category'] = $this->master_model->get_Category();
		$data['recipe'] = $this->master_model->getCatRecipe($branch_id);
		$this->load->view('Production/bom',$data);
	}
	
	public function buildDropProduct(){
        //set selected country id from POST
        $branch_id = $_SESSION['branch_id'];
        $cat_id = $this->input->post('id',TRUE);  
        //run the query for the cities we specified earlier  
        $productData['productDrop']=$this->production_model->get_product($cat_id,$branch_id);  
        $output = null;  
        $output .= "<option value=''>Select</option>";
        foreach ($productData['productDrop'] as $row)  
        {  
            //here we build a dropdown item line for each   query result  
            $output .= "<option value='".$row->recipe_id."'>".$row->rname."</option>";  
        }  
        echo $output;
    }
	
	public function get_RcpDetails()
	{
		$iname = $this->input->post('iname');
		//$br_id = $this->input->post('br_id');
		$this->production_model->get_RcpDetails($iname);
	}
	
	public function fetchbom(){
	    $name = $this->input->post('name');
    	$act_yld = $this->input->post('act_yld');
    	$yld = $this->input->post('yld');
    	$rc_no = $this->input->post('rc_no');
        //Conect with the database
               
    
        $query=$this->db->query("SELECT * FROM recipe_item where recipe_no ='$rc_no'");
    	
        //$result = mysqli_query($query);
        $msg ='';
        $msg = $msg." <table border='1' style='padding: 2px; margin-left: 194px; width: 586px;line-height: 39px;text-align: center;'>";
    
        $msg = $msg. '<tr>';
       
    	$msg = $msg.    '<th> Item Name </th>';
    	$msg = $msg.    '<th> UOM </th>';
    	$msg = $msg.    '<th> Quantity </th>';
        $msg = $msg. '</tr>';
    
        //while($row = mysqli_fetch_array($sql)) {
        foreach($query->result_array() as $row){
    
           $msg = $msg. '<tr>';
    		   $msg = $msg. '</tr>';
    		
    		$msg = $msg. '<td><input type="text" name="item_id[]" value="'.$row['item_id'].'"><input type="text" name="it_id[]" value="'.$row['itm_id'].'"><input type="text" name="name[]" value="'.$row['item_name'].'">'.$row['item_name'].'</td>';
    			$msg = $msg. '<td><input type="text" name="iuom[]" value="'.$row['uom'].'">'.$row['uom'].'</td>';
    			$it_id = $row['item_id'];
    			 $query1 = $this->db->query("SELECT * FROM item_creation where item_id ='$it_id'");
    			//while($row5 = mysqli_fetch_array($sql5)) {
    			foreach($query1->result_array() as $row5){    
    			    $tax_amt = ($row5['item_price']*$row5['item_tax'])/100;
    			 $price = $row5['item_price'] + $tax_amt;
    			$msg = $msg. '<td><input type="hidden" class="price" name="price[]" value="'.number_format(($price*(($row['qty']*$act_yld)/$yld)),3, '.', '').'"><input type="hidden" name="quantity[]" value="'.number_format((($row['qty']*$act_yld)/$yld),3, '.', '').'">'.number_format((($row['qty']*$act_yld)/$yld),3, '.', '').'</td>';
    			}
    			    
    			}
    	$query2 = $this->db->query("SELECT * FROM sub_recipe_item where rc_no ='$rc_no'");
    	//if(mysqli_num_rows($sql1)>0)
    	if($query2->num_rows() >0)
    	{
    		//while($row1 = mysqli_fetch_array($sql1)) {
            foreach($query2->result_array() as $row1){ 
    			$msg = $msg. '<tr>';
    				$msg = $msg. '<td><input type="hidden" name="sub_item_id[]" value="'.$row1['sub_recipe_id'].'"><input type="hidden" name="sub_rc_id[]" value="'.$row1['recipe_no'].'"><input type="hidden" name="sub_name[]" value="'.$row1['item_name'].'">'.$row1['item_name'].'</td>';
    				$msg = $msg. '<td><input type="hidden" name="sub_uom[]" value="'.$row1['uom'].'">'.$row1['uom'].'</td>';
    				$msg = $msg. '<td><input type="hidden" class="sub_price" name="sub_price[]" value="'.number_format((($row1['total']*$act_yld)/$yld),3, '.', '').'"><input type="hidden" name="sub_quantity[]" value="'.number_format((($row1['qty']*$act_yld)/$yld),3, '.', '').'">'.number_format((($row1['qty']*$act_yld)/$yld),3, '.', '').'</td>';
    			$msg = $msg. '</tr>';
    			
    		/*	$msg = $msg. '<td><input type="hidden" name="sub_item_id[]" value="'.$row1['sub_rc_item_id'].'"><input type="hidden" name="sub_name[]" value="'.$row1['item_name'].'">'.$row1['item_name'].'</td>';
    			$msg = $msg. '<td><input type="hidden" name="suom[]" value="'.$row1['uom'].'">'.$row1['uom'].'</td>';
    			$msg = $msg. '<td><input type="hidden" class="sub_price" name="sub_price[]" value="'.number_format((($row1['total']*$act_yld)/$yld),3, '.', '').'"><input type="hidden" name="sub_quantity[]" value="'.number_format((($row1['qty']*$act_yld)/$yld),3, '.', '').'">'.number_format((($row1['qty']*$act_yld)/$yld),3, '.', '').'</td>';*/
    		}
    	}
    	else
    	{
    		$msg = $msg. '<input type="hidden" name="sub_item_id[]" value="0"><input type="hidden" name="sub_name[]" value="">';
    		$msg = $msg. '<input type="hidden" name="suom[]" value="">';
    		$msg = $msg. '<input type="hidden" name="sub_price[]" value=""><input type="hidden" name="sub_quantity[]" value="">';
    	}
    
        $msg = $msg. '</table>';
        $msg = $msg. '<input type="hidden" id="tot" name="tot">';
        echo $msg;
	}
	
	public function addBOM(){
	    $bid=$this->production_model->addBOM($this->input->post());
		if($bid)
		{
		    redirect('Production/bom_view/'.$bid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Production/bom/');
		}
	}
	
	public function bom_view($bid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['bomview'] = $this->production_model->BomVList($bid);
		$this->load->view('Production/bom_view',$data);
	}
	
	public function BomList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['bom_list'] = $this->production_model->BomList();
		$this->load->view('Production/bom_list',$data);
	}
	
	public function change_issue_status(){
		$bill_id = $this->input->post('bill_id');
		
		$bom_date = date("Y-m-d");
		$lm=date("Y-m-dH:i:s",time());
		$branch = $_SESSION['branch_name'];
		$branch_id = $_SESSION['branch_id'];
		
		if($bill_id != ''){
			$this->db->query("update billdetails set store_status='Issued' where billno='$bill_id'");
			$q1 = $this->db->query("select * from billdetails where billno='$bill_id'");
			if($q1->num_rows() > 0)
			{
				$row = $q1->row_array();
				$ref_no = $row['bill_id'];
				
				$q2 = $this->db->query("select * from bproduct where billno='$bill_id'");
				foreach($q2->result_array() as $row2){
					$iname = $row2['iname'];
					$uom = $row2['iuom'];
					$item_id = $row2['item_id'];
					$rqty = $row2['quantity'];
					
					$q3 = $this->db->query("select * from item_creation where item_id='$item_id'");
					if($q3->num_rows() > 0)
					{
						$row3 = $q3->row_array();
						$qty = $row3['stock_item'];
    					$qty1 = $qty - $rqty;
						$itm_id = $row3['itm_id'];
						$cat_id = $row3['category_id'];
						
						$q4 = $this->db->query("update item_creation set stock_item='$qty1' where item_id='$item_id'");
						
						$data = array(
							'item_name' => $iname,
							'trans_ref_no' => $ref_no,
							'transaction_date' => $bom_date,
							'opening_stock' => $qty,
							'out_qty' => $rqty,
							'closing_stock' => $qty,
							'last_modified' => $lm,
							'branchname' => $branch,
							'item_id' => $item_id,
							'itm_id' => $itm_id,
							'category_id' => $cat_id,
							'branch_id' => $branch_id	
						);
						$this->db->insert('stock_detail', $data);
					}
				}
			}
			echo 1;
		}else{
			echo 0;
		}
	}
	
	public function productionData()
	{
	    $branch_id = $_SESSION['branch_id'];
        $data = $this->production_model->getProductionList($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	   
    	    $view = "<a href='$this->master_url/index.php/Production/production_view/$row->billno' class=''><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
    	        date('d-m-Y',strtotime($row->orderdate)),
    	        $row->bill_id,
    	        $row->ordertime,
    	        $view
    	        
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
        
	}
	
	public function productionCData()
	{
	    $data = $this->production_model->getCProductionList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Production/production_view/$row->billno' class=''><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
    	        date('d-m-Y',strtotime($row->orderdate)),
    	        $row->bill_id,
    	        $row->ordertime,
    	        $view
    	        
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
        
	}
}