<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Purchase extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('purchase_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	//var $master_url='https://gsrgroup.biz/inv_final_test';
    var $master_url='https://bigcashew.com/inventory';
    
	public function purchase_order()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['category'] = $this->master_model->getCategory();
		$data['branch'] = $this->user_model->get_branch();
		$data['salebranch'] = $this->master_model->get_salesBranch();
		$data['santhebranch'] = $this->master_model->get_santheBranch();
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['vendor'] = $this->master_model->get_vendors($branch_id);
		$this->load->view('Purchase/purchase_order',$data);
	}
	public function addPurchase()
	{
		$pid=$this->purchase_model->addPurchase($this->input->post());
		if($pid)
		{
		    redirect('Purchase/purchase_invoice/'.$pid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Purchase/purchase_order/');
		}
	}
	
	public function purchase_invoice($pid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['purchase_order'] = $this->purchase_model->view_order($pid);
		$data['purchase_item'] = $this->purchase_model->view_order_item($pid);
		$data['purchase_sum_amount'] = $this->purchase_model->total_sum_amount($pid);
		$this->load->view('Purchase/preview_purchase',$data);
		
	}
	
	public function pending_list()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['pending_purchase'] = $this->purchase_model->pending_purchase($branch_id);
		$this->load->view('Purchase/purchasePending',$data);
	}
	
	public function approvePO()
	{
		$po_id = $this->input->post('po_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update purchase_order set purchase_status='Approved',po_apporval_date='$apporval_date' where purchase_id='$po_id'");
		redirect('Purchase/pending_list/');
	}
	
	public function all_pending_list()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['pending_purchase'] = $this->purchase_model->all_pending_purchase();
		$this->load->view('Purchase/allPurchasePending',$data);
	}
	
	public function all_pendingData(){
		
		$data = $this->purchase_model->all_pending_purchase();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Purchase/viewCPurchase/$row->mid' class=''><i class='ft-eye'></i></a>";
    	    if($row->purchase_status=='Pending'){
    	       $p_status="<span class='pending_data'>$row->purchase_status</span>";
    	    }
    	    else{
    	        $p_status="<span class='success_data'>$row->purchase_status</span>";
    	    }
    	    
    	    $test[] = array(
    	        $count,
    	        $row->purchase_no,
    	        $row->purchase_date,
                $row->venders_name,
                $p_status,
                $row->po_apporval_date,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function viewPurchase($mid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);		
		$data['purchase_order'] = $this->purchase_model->view_order($mid);
		$data['purchase_item'] = $this->purchase_model->view_order_item($mid);
		$data['purchase_sum_amount'] = $this->purchase_model->total_sum_amount($mid);
		$this->load->view('Purchase/purchaseView',$data);
	}
	
	public function viewCPurchase($mid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id = $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);		
		$data['purchase_order'] = $this->purchase_model->view_order($mid);
		$data['purchase_item'] = $this->purchase_model->view_order_item($mid);
		$data['purchase_sum_amount'] = $this->purchase_model->total_sum_amount($mid);
		$this->load->view('Purchase/purchaseCView',$data);
	}
	
	public function editPurchase($mid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']= $this->uri->segment(4);
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['purchase_order'] = $this->purchase_model->view_order($mid);
		$data['purchase_item'] = $this->purchase_model->view_order_item($mid);
		$data['purchase_sum_amount'] = $this->purchase_model->total_sum_amount($mid);
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$this->load->view('Purchase/editPurchase_order',$data);
	}
	
	public function updatePurchase(){
	    $pid=$this->purchase_model->updatePurchase($this->input->post());
		redirect('Purchase/purchase_invoice/'.$pid);
		//redirect('Purchase/pending_list/');
	}
	
	public function inword($mid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['submod_id']= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['purchase_order'] = $this->purchase_model->view_order($mid);
		$data['purchase_item'] = $this->purchase_model->ordered_purchase_item($mid);
		//$data['purchase_sum_amount'] = $this->purchase_model->total_sum_amount($mid);
		$data['tax'] = $this->master_model->get_Tax();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$this->load->view('Purchase/inword',$data);
	}
	
	public function po_close_update() {
		$indent_id=$this->input->post('indent_id');
		$remarks=$this->input->post('remarks');
		$this->db->query("update purchase_order set purchase_status='Closed',purchase_remarks='$remarks' where purchase_id='$indent_id'");
		echo 1;
	}
	
	public function addGrn(){
		$gid=$this->purchase_model->addGrn($this->input->post());
		$pid = $this->input->post('indent_id');
		if($gid)
		{
		    redirect('Purchase/inward_invoice/'.$gid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Purchase/inword/'.$pid);
		}
	}
	
	public function inward_invoice($gid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['grn_data'] = $this->purchase_model->get_grndata($gid);
		$data['get_grn_item'] = $this->purchase_model->get_grn_item($gid);
		$data['grn_total_amount'] = $this->purchase_model->grn_total_amount($gid);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($gid);
		
		$this->load->view('Purchase/inward_print',$data);
		
	}

	public function Closed_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Purchase/po_closed',$data);
	}
	
	public function AllClosed_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Purchase/all_po_closed',$data);
	}
	
	public function all_ClosedData(){
		
		$data = $this->purchase_model->all_ClosedData();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Purchase/view_po_close/$row->mid' class=''><i class='ft-eye'></i></a>";
    	    if($row->purchase_status=='Pending'){
    	       $p_status="<span class=' pending_data'>$row->purchase_status</span>";
    	    }
    	    else{
    	        $p_status="<span class=' success_data'>$row->purchase_status</span>";
    	    }
    	    
    	    $test[] = array(
    	        $count,
    	        $row->purchase_no,
    	        $row->purchase_date,
                $row->venders_name,
                $p_status,
                $row->purchase_remarks,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}

	public function get_closeddata(){
		$data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch_id = $_SESSION['branch_id'];
		$query = $this->db->query("SELECT *,purchase_id as mid, DATE_FORMAT(purchase_date, '%d-%m-%Y') as purchase_date FROM purchase_order  where purchase_status='Closed' and branch_id='$branch_id' ORDER BY purchase_id desc limit $row,$rowperpage");
		foreach($query->result_array() as $row){
			$data[] = array("purchase_no"=>$row['purchase_no'],
				"purchase_date"=>$row['purchase_date'],
				"venders_name"=>$row['venders_name'],
				"purchase_status"=>$row['purchase_status'],
				"purchase_remarks"=>$row['purchase_remarks'],
				"mid"=>$row['mid']);
		}
		echo json_encode($data);
	}
	
	public function get_allcloseddata(){
		$data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$cw_ceo = $_SESSION['cw_ceo'];
		if($cw_ceo=='CW')
        {
            $query = $this->db->query("SELECT *,purchase_id as mid, DATE_FORMAT(purchase_date, '%d-%m-%Y') as purchase_date FROM purchase_order  where purchase_status='Closed' ORDER BY purchase_id desc limit $row,$rowperpage");
        }
        else{
            $query = $this->db->query("SELECT *,purchase_id as mid, DATE_FORMAT(purchase_date, '%d-%m-%Y') as purchase_date FROM purchase_order  where purchase_status='Closed' and branchname='$cw_ceo' ORDER BY purchase_id desc limit $row,$rowperpage");
        }
		/*if($branch_name =='CW4_CEO'){
		    $query = $this->db->query("SELECT *,purchase_id as mid, DATE_FORMAT(purchase_date, '%d-%m-%Y') as purchase_date FROM purchase_order  where purchase_status='Closed' and branchname='CW4' ORDER BY purchase_id desc limit $row,$rowperpage");
		}
		else if($branch_name =='CW5_CEO'){
		    $query = $this->db->query("SELECT *,purchase_id as mid, DATE_FORMAT(purchase_date, '%d-%m-%Y') as purchase_date FROM purchase_order  where purchase_status='Closed' and branchname='CW5' ORDER BY purchase_id desc limit $row,$rowperpage");
		}
		else if($branch_name =='CW6_CEO'){
		    $query = $this->db->query("SELECT *,purchase_id as mid, DATE_FORMAT(purchase_date, '%d-%m-%Y') as purchase_date FROM purchase_order  where purchase_status='Closed' and branchname='CW6' ORDER BY purchase_id desc limit $row,$rowperpage");
		}
		else{
		    $query = $this->db->query("SELECT *,purchase_id as mid, DATE_FORMAT(purchase_date, '%d-%m-%Y') as purchase_date FROM purchase_order  where purchase_status='Closed' ORDER BY purchase_id desc limit $row,$rowperpage");
		}*/
		foreach($query->result_array() as $row){
			$data[] = array("purchase_no"=>$row['purchase_no'],
				"purchase_date"=>$row['purchase_date'],
				"venders_name"=>$row['venders_name'],
				"purchase_status"=>$row['purchase_status'],
				"purchase_remarks"=>$row['purchase_remarks'],
				"mid"=>$row['mid']);
		}
		echo json_encode($data);
	}

	public function view_po_close($mid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['grn_data'] = $this->purchase_model->get_grn_closed_report($mid);
		$this->load->view('Purchase/view_po_closed',$data);
	}

	public function grn_single_recipt(){
		$mid = $_POST['mid'];
		$data['single_recipt']=$this->purchase_model->get_ordered_gnr($mid);
		$data['single_recipt_item']=$this->purchase_model->get_ordered_gnr_item($mid);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($mid);
		$this->load->view('Purchase/single_view', $data);
	}

	public function grn_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Purchase/grn_list',$data);
	}
	
	public function Allgrn_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['grn_list']=$this->purchase_model->grn_AllGrnList();
		$this->load->view('Purchase/all_grn_list',$data);
	}
	
	public function pendingGRN(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['pnd_grn']=$this->purchase_model->get_pending_grn();
		$this->load->view('Purchase/pending_grn_list',$data);
	}
	
	public function approvedGRN(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['pnd_grn']=$this->purchase_model->get_approved_grn();
		$this->load->view('Purchase/approved_grn_list',$data);
	}
	
	public function holdedGrn_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['hld_grn']=$this->purchase_model->get_holded_grn($branch_id);
		$this->load->view('Purchase/holded_grn_list',$data);
	}
	
	public function cw5GRN(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['cw5_grn']=$this->purchase_model->get_cw5_grn();
		$this->load->view('Purchase/cw5_grn_list',$data);
	}

	public function get_grn(){
		$data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch_id = $_SESSION['branch_id'];
		$query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date,G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.branch_id='$branch_id' and G.rjn_status='Pending' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		foreach($query->result_array() as $row){
			$data[] = array("purchase_no"=>$row['purchase_no'],
				"purchase_date"=>$row['purchase_date'],
				"grn_no"=>$row['grn_no'],
				"grn_date"=>$row['grn_date'],
				"invoice_no"=>$row['invoice_no'],
				"vendor_name"=>$row['vendor_name'],
				"gnr_status"=>$row['gnr_status'],
				"mid"=>$row['mid'],
				"invoice_upload"=>$row['invoice_upload']);
		}
		echo json_encode($data);
	}
	
	public function get_allgrn(){
		$data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$cw_ceo = $_SESSION['cw_ceo'];
		if($cw_ceo=='CW')
        {
            $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date,G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' ORDER BY G.gnr_id desc limit $row,$rowperpage");
        }
        else{
            $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='$cw_ceo' ORDER BY G.gnr_id desc limit $row,$rowperpage");
        }
		/*if($branch_name =='CW4_CEO'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='CW4' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}
		else if($branch_name =='CW5_CEO'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='CW5' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}
		else if($branch_name =='CW6_CEO'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='CW6' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}
		else{
	    	$query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date,G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}*/
		foreach($query->result_array() as $row){
			$data[] = array("purchase_no"=>$row['purchase_no'],
				"purchase_date"=>$row['purchase_date'],
				"grn_no"=>$row['grn_no'],
				"grn_date"=>$row['grn_date'],
				"invoice_no"=>$row['invoice_no'],
				"vendor_name"=>$row['vendor_name'],
				"gnr_status"=>$row['gnr_status'],
				"mid"=>$row['mid'],
				"invoice_upload"=>$row['invoice_upload']);
		}
		echo json_encode($data);
	}
	
	public function getAccGrn(){
		$data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$cw_ceo = $_SESSION['cw_ceo'];
		if($cw_ceo=='CW')
        {
            $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date,G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.branchname!='CW4' and G.rjn_status='Pending' ORDER BY G.gnr_id desc limit $row,$rowperpage");
        }
        else{
            $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='$cw_ceo' ORDER BY G.gnr_id desc limit $row,$rowperpage");
        }
		/*if($branch_name=='CW-ACC'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date,G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.branchname!='CW4' and G.rjn_status='Pending' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}
		else if($branch_name=='CW4_ACC'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='CW4' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}
		else if($branch_name=='CW5-ACC'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='CW5' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}*/
		foreach($query->result_array() as $row){
			$data[] = array("purchase_no"=>$row['purchase_no'],
				"purchase_date"=>$row['purchase_date'],
				"grn_no"=>$row['grn_no'],
				"grn_date"=>$row['grn_date'],
				"invoice_no"=>$row['invoice_no'],
				"vendor_name"=>$row['vendor_name'],
				"gnr_status"=>$row['gnr_status'],
				"mid"=>$row['mid'],
				"invoice_upload"=>$row['invoice_upload']);
		}
		echo json_encode($data);
	}

	public function grn_view($mid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$mid;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($mid);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($mid);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($mid);
		$data['rejection_view']=$this->purchase_model->rejection_view($mid);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($mid);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($mid);
		
		$this->load->view('Purchase/grn_view',$data);
	}
	
	public function ceo_grn_view($id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($id);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($id);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($id);
		$data['rejection_view']=$this->purchase_model->rejection_view($id);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($id);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($id);
		
		$this->load->view('Purchase/ceo_grn_view',$data);
	}
	
	public function ceo_agrn_view($id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($id);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($id);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($id);
		$data['rejection_view']=$this->purchase_model->rejection_view($id);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($id);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($id);
		
		$this->load->view('Purchase/ceo_agrn_view',$data);
	}
	
	public function ceo_cw5_view($id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($id);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($id);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($id);
		$data['rejection_view']=$this->purchase_model->rejection_view($id);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($id);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($id);
		
		$this->load->view('Purchase/cw5grn_view',$data);
	}
	
	public function adm_grn_view($id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($id);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($id);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($id);
		$data['rejection_view']=$this->purchase_model->rejection_view($id);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($id);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($id);
		
		$this->load->view('Purchase/admgrn_view',$data);
	}
	
	public function poHistory(){
		$item_id = $_POST['item_id'];
		$bname = $_POST['bname'];
		$data['pohistory']=$this->purchase_model->getPoHistory($item_id,$bname);
		$this->load->view('Purchase/po_history', $data);
	}
	
	public function dGRN(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['dgrn_list']=$this->purchase_model->get_dgrn();
		$this->load->view('Purchase/dgrn_list',$data);
	}
	
	public function dgrn_view($id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_dgnr($id);
		$data['grn_item']=$this->purchase_model->get_dgnrDetail($id);
		$data['grn_sumamount']=$this->purchase_model->get_dgnr_sumamount($id);
		$data['ordered_gnr_approve']=$this->purchase_model->get_dgnr_forapprove($id);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($id);
		
		$this->load->view('Purchase/dgrn_view',$data);
	}
	
	public function approveGRN()
	{
		$grn_id = $this->input->post('grn_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update gnr_creation set gnr_status='Approved' where gnr_id='$grn_id'");
		redirect('Purchase/pendingGRN/');
	}
	
	public function admapproveGRN()
	{
		$grn_id = $this->input->post('grn_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update gnr_creation set gnr_status='Approved' where gnr_id='$grn_id'");
		redirect('Purchase/Allgrn_list/');
	}
	
	public function holdGRN()
	{
		$grn_id = $this->input->post('grn_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update gnr_creation set gnr_status='Holded' where gnr_id='$grn_id'");
		redirect('Purchase/pendingGRN/');
	}
	
	public function admholdGRN()
	{
		$grn_id = $this->input->post('grn_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update gnr_creation set gnr_status='Holded' where gnr_id='$grn_id'");
		redirect('Purchase/Allgrn_list/');
	}
	
	public function aprvdGRN()
	{
		$grn_id = $this->input->post('grn_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update gnr_creation set gnr_status='Approved' where gnr_id='$grn_id'");
		redirect('Purchase/dGRN/');
	}
	
	public function holdDGRN()
	{
		$grn_id = $this->input->post('grn_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update gnr_creation set gnr_status='Holded' where gnr_id='$grn_id'");
		redirect('Purchase/dGRN/');
	}
		
	public function remark_insertion(){
		$uname = $this->input->post('uname');
		$gnr_id = $this->input->post('gnr_id');
		$pg_id = $this->input->post('pg_id');
		$login_id = $this->input->post('login_id');
		$remarks = $this->input->post('remarks');
		$item_id = $this->input->post('item_id');
		$lm=date("Y-m-dH:i:s",time());
		if($uname == 'Cakewala')
		{
			$status='CWSeen';
		}
		else if($uname == 'CEO')
		{
			$status='CEOSeen';
		}
		else if($uname == 'Eshanya')
		{
			$status='ESHSeen';
		}
		else if($uname == 'Cakewala4')
		{
			$status='CW4Seen';
		}
		else if($uname == 'cw4-admin')
		{
			$status='CW4AdmSeen';
		}
		$q3 = $this->db->query("select max(rm_id) from remarks where gnr_id='$gnr_id' and purchase_grn_id='$pg_id'");
		if($q3->num_rows() > 0){
			foreach($q3->result_array() as $rows)
			$rm_id = $rows['max(rm_id)'];
			$this->db->query("update remarks set status='$status' where rm_id='$rm_id' and gnr_id='$gnr_id' and purchase_grn_id='$pg_id'");
		}
		$this->db->query("insert into remarks(last_remark,frm_user,remark,item_id,gnr_id,purchase_grn_id,login_id,status,remark_status)values('$lm','$uname','$remarks','$item_id','$gnr_id','$pg_id','$login_id','UnSeen','Pending')");
		$this->db->query("update purchase_order_grn set grn_remarks='$remarks' where purchase_grn_id='$pg_id'");
			
	}

	public function grn_price_update(){
		$columns = array(
		1 =>'item_name', 
		6 =>'grn_item_price', 
		7 =>'grn_tax', 
		
		);
		$error = false;
		$colVal = '';
		$colIndex = $rowId = 0;
		
		$msg = array('status' => !$error, 'msg' => 'Failed! updation Stock');
		
		if(isset($_POST)){
			if(isset($_POST['val']) && !empty($_POST['val']) && !$error) {
				$colVal = $_POST['val'];
				$error = false;
				
				} else {
				$error = true;
			}
			if(isset($_POST['index']) && $_POST['index'] >= 0 &&  !$error) {
				$colIndex = $_POST['index'];
				$error = false;
				} else {
				$error = true;
			}
			if(isset($_POST['id']) && $_POST['id'] > 0 && !$error) {
				$rowId = $_POST['id'];
				$error = false;
				} else {
				$error = true;
			}
			
			if(!$error) {
				$this->db->query("UPDATE purchase_order_grn SET ".$columns[$colIndex]." = '".$colVal."' WHERE purchase_grn_id='".$rowId."'");
				//$status = mysqli_query($c, $sql) or die("database error:". mysqli_error($c));
				$msg = array('error' => $error, 'msg' => 'Success! Stock updated');
				} else {
				$msg = array('error' => $error, 'msg' => 'Failed! updation in Stock');
			}
		}
		
		$q3 = $this->db->query("select * from purchase_order_grn where purchase_grn_id='".$rowId."'");
		$grn_total = 0;
		foreach($q3->result_array() as $rst1){
			$grn_id = $rst1['gnr_id'];
			$gqty = $rst1['grn_item_qty'];
			$gprice = $rst1['grn_item_price'];
			$gtax = $rst1['grn_tax'];
			$gtprice = $gqty * $gprice;
			$gtax_amt = ($gtprice * $gtax)/100;
			$gtotal = $gtprice + $gtax_amt;
			$q3 = $this->db->query("update purchase_order_grn set grn_total_amount='$gtprice',grn_tax_amount='$gtax_amt',grn_grand='$gtotal' where purchase_grn_id='".$rowId."'");
		}
		$q5 = $this->db->query("select * from purchase_order_grn where gnr_id='$grn_id'");
		foreach($q5->result_array() as $rst2){
			$grn_total = $grn_total + $rst2['grn_grand'];
		}
		$q6 = $this->db->query("select * from gnr_creation where gnr_id='$grn_id'");
		foreach($q6->result_array() as $rst3)
		{		
			$courier = $rst3['courier'];
			$transport = $rst3['transport'];
			$insurance = $rst3['insurance'];
			$gt = $grn_total + $courier + $transport + $insurance;
		}
		$q7 = $this->db->query("update gnr_creation set tot_amt='$gt',total_amount='$gt',reject_amt='$gt' where gnr_id='$grn_id'");
		// send data as json format
		echo json_encode($msg);
	}
	
	public function rejection_po($mid,$sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['mid']=$mid;
		$data['smid']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['get_rejection'] = $this->purchase_model->get_rjection_purchase_id($mid);
		$data['get_rejection_item'] = $this->purchase_model->get_ordered_rejection_item_id($mid);
		$this->load->view('Purchase/rejection_po',$data);
		
	}

	public function addRejection(){
		$rid=$this->purchase_model->addRejection($this->input->post());
		$gid = $this->input->post('gnr_id');
		$smid = $this->input->post('smid');
		if($rid)
		{
		    redirect('Purchase/rejection_receipt/'.$rid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Purchase/rejection_po/'.$gid.'/'.$smid);
		}
	}
	
	public function rejection_receipt($rejection_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rejection'] = $this->purchase_model->get_rejection_receipt_details($rejection_id);
		$data['rejection_item'] = $this->purchase_model->get_receipt_rejection_print_list($rejection_id);
		$data['rejection_sum_amount'] = $this->purchase_model->total_sum_rejection_amount($rejection_id);
		$this->load->view('Purchase/rejection_receipt',$data);
		
	}
	
	public function rejection_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['sub_mod_id']=$sub_mod_id;
		//$data['rejection_list'] = $this->purchase_model->get_rejection_list($branch_id);
		
		$this->load->view('Purchase/rejection_list',$data);		
	}
	
	public function eshstore2rejection_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['sub_mod_id']=$sub_mod_id;
		//$data['rejection_list'] = $this->purchase_model->get_rejection_list($branch_id);
		
		$this->load->view('Purchase/eshstore2_rejectionlist',$data);		
	}
	
	public function get_rejectiondata($sub_mod_id){
	    $branch_id = $_SESSION['branch_id'];
	   $data = $this->purchase_model->get_rejection_list($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	     
    	    $view ="<a href='$this->master_url/index.php/Purchase/rejection_view/$row->mid/$sub_mod_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
    	        $row->purchase_no,
    	        $row->purchase_date,
    	        $row->grn_no,
    	        $row->grn_date,
    	        $row->rejection_no,
    	        $row->rejection_date,
    	        $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas); 
	}
	
	public function get_eshstore2rejectiondata($sub_mod_id){
	    $branch_id = '68';
	    
	    $data = $this->purchase_model->get_rejection_list($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	     
    	    $view ="<a href='$this->master_url/index.php/Purchase/rejection_view/$row->mid/$sub_mod_id' class=''><i class='ft-eye'></i></a>";
    	    
    	    $test[] = array(
    	        $count,
    	        $row->purchase_no,
    	        $row->purchase_date,
    	        $row->grn_no,
    	        $row->grn_date,
    	        $row->rejection_no,
    	        $row->rejection_date,
    	        $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas); 
	}
	
	public function rejection_view($mid,$sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['mid']=$mid;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['rejection'] = $this->purchase_model->get_rejection_receipt_details($mid);
		$data['rejection_item'] = $this->purchase_model->get_receipt_rejection_print_list($mid);
		$data['rejection_sum_amount'] = $this->purchase_model->total_sum_rejection_amount($mid);
		$this->load->view('Purchase/rejection_receipt',$data);
	}
	
	public function ceorejection_list($sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['rejection_list'] = $this->purchase_model->get_ceorejection_list();
		$this->load->view('Purchase/ceorejection_list',$data);		
	}
		
	public function grn_in_upload(){
		$gid=$this->purchase_model->grn_in_upload($this->input->post());
		redirect('Purchase/inward_invoice/'.$gid);
	}
	
	public function grn_detail($mid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$mid;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($mid);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($mid);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($mid);
		$data['rejection_view']=$this->purchase_model->rejection_view($mid);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($mid);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($mid);
		
		$this->load->view('Purchase/grn_detail',$data);
	}
	
	public function exportGRN() {
		$grn_id = $this->input->post('grn_id');
		$fileName = 'data-'.time().'.xlsx';
		// load excel library
		$this->load->library('excel');
		$listInfo = $this->purchase_model->get_ordered_gnr($grn_id);
		$listInfo1 = $this->purchase_model->get_ordered_gnr_item($grn_id);
		$listInfo12 = $this->purchase_model->grn_sumamount($grn_id);
		$listInfo13 = $this->purchase_model->rejection_view($grn_id);
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Purchase No');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Purchase date');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'GRN No');
		$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'GRN date');
		$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Supplier');
		$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Invoice no');
		// set Row
		$rowCount = 2;
		foreach ($listInfo as $list) {
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $list->purchase_no);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $list->purchase_date);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $list->grn_no);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $list->grn_date);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $list->venders_name);
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $list->invoice_no);
			
			$rowCount++;
		}
		$rowCount = $rowCount + 1;
		$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, 'Product Name');
		$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, 'UOM');
		$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, 'Qty');
		$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, 'Price');
		$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, 'Qty');
		$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, 'Price');
		$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, 'Tax(%)');
		$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Tax Amt');
		$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'Total Amount');
		$objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Remarks');
		$rowCount1 = $rowCount + 1;
		foreach ($listInfo1 as $list1) {
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount1, $list1->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount1, $list1->unit_measurement);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount1, $list1->required_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount1, $list1->item_price);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount1, $list1->grn_item_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount1, $list1->grn_item_price);
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount1, $list1->grn_tax);
			$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount1, $list1->grn_tax_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount1, $list1->grn_grand);
			$objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount1, $list1->grn_remarks);
			
			$rowCount1++;
		}
		$rowCount2 = $rowCount1 + 1;
		foreach ($listInfo12 as $list2) {
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount2, 'Total Amount');
			$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount2, $list2->sum_tax_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, $list2->sum_amount);
					
			$rowCount2++;
		}
		foreach ($listInfo as $list)
		if($list->courier != 0)
		{
			$rowCount2 = $rowCount2 + 1;
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount2, 'Courier Charge');
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, $list->courier);
		}
		if($list->transport != 0)
		{
			$rowCount2 = $rowCount2 + 1;
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount2, 'Transport Charge');
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, $list->transport);
		}
		if($list->insurance != 0)
		{
			$rowCount2 = $rowCount2 + 1;
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount2, 'Insurance Charge');
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, $list->insurance);
		}
		$rowCount2 = $rowCount2 + 1;
		$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount2, 'Total Charge');
		$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, $list->tot_amt);
		$rowCount2 = $rowCount2 + 1;
		$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount2, 'Round Off');
		$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, $list->round_off);
		$rowCount2 = $rowCount2 + 1;
		$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount2, 'Final Charge');
		$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, $list->total_amount);
				
		foreach ($listInfo13 as $list3)
		{
			$rjid = $list3->rejection_id;
			$listInfo4 = $this->purchase_model->rejection_view_detail($rjid);
			
			$rowCount2 = $rowCount2 + 2;
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount2, 'Rejected Products');
			
			$rowCount2 = $rowCount2 + 1;
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount2, 'Product Name');
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount2, 'UOM');
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount2, 'PO Qty');
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount2, 'GRN Qty');
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount2, 'GRN Price');
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount2, 'RJN Qty');
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount2, 'Price');
			$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount2, 'Tax');
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, 'Amount');
			$objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount2, 'Remarks');
			
			$rowCount3 = $rowCount2 + 1;
			$rej_amt = 0;
			foreach ($listInfo4 as $list4)
			{
				$rej_amt = $rej_amt + $list4->rejection_total_amount;
				$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount3, $list4->item_name);
				$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount3, $list4->unit_measurement);
				$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount3, $list4->required_qty);
				$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount3, $list4->grn_item_qty);
				$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount3, $list4->grn_item_price);
				$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount3, $list4->rejection_qty);
				$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount3, $list4->rejection_price);
				$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount3, $list4->rejection_tax);
				$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount3, $list4->rejection_total_amount);
				$objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount3, $list4->rejection_remarks);
				
				$rowCount3++;
			}
			$grn_amt = $list->total_amount;
			$ttl_amt = $grn_amt - $rej_amt;
			
			$rowCount3 = $rowCount3 + 1;
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount3, 'Total Amount');
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount3, $rej_amt);
			$rowCount3 = $rowCount3 + 1;
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount3, 'GRN Total After Rejection');
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount3, $ttl_amt);
		}
				
		$filename = "GRN-Detail". date("d-m-Y").".csv";
		header('Content-Type: application/vnd.ms-excel'); 
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Cache-Control: max-age=0'); 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'CSV');  
		$objWriter->save('php://output'); 
 	}
	
	public function accGrnList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Purchase/acc_grn_list',$data);
	}

	public function cw3grn_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Purchase/cw3_grsn_list',$data);
	}
	
	public function eshStore2grn_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Purchase/eshstore2_grnlist',$data);
	}


	public function angbranch_grn(){
		$data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch = $request->branch;
		$branch_id = $_SESSION['branch_id'];
		$query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date,G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.branchname='$branch' and G.rjn_status='Pending' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		foreach($query->result_array() as $row){
			$data[] = array("purchase_no"=>$row['purchase_no'],
				"purchase_date"=>$row['purchase_date'],
				"grn_no"=>$row['grn_no'],
				"grn_date"=>$row['grn_date'],
				"invoice_no"=>$row['invoice_no'],
				"vendor_name"=>$row['vendor_name'],
				"gnr_status"=>$row['gnr_status'],
				"mid"=>$row['mid'],
				"invoice_upload"=>$row['invoice_upload']);
		}
		echo json_encode($data);
	}

	public function cw3grn_view($mid,$sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$mid;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($mid);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($mid);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($mid);
		$data['rejection_view']=$this->purchase_model->rejection_view($mid);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($mid);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($mid);
		
		$this->load->view('Purchase/cw3grn_view',$data);
	}
	
	public function poitemdelete($po_id,$p_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		//$data['submod_id']=$sub_mod_id;
		$this->db->query("delete from purchase_order_item where purchase_order_id='$po_id' and purchase_id='$p_id'");
		
		redirect('Purchase/editPurchase/'.$p_id);
	}
	
	public function commissaryStoreGRN(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['pnd_grn']=$this->purchase_model->get_cms_grn_list();
		$this->load->view('Purchase/cmsAcc_grn_list',$data);
	}
	
	public function exportPurchase() {
		$pid = $this->input->post('pid');
		$po_no = $this->input->post('po_no');
		$po_date = $this->input->post('po_date');
		$vendor_name = $this->input->post('vendor_name');
		$total_actual_amount = $this->input->post('tot_actual_amt');
		$total_tax_amount = $this->input->post('tot_tax_amt');
		$total_grand_amount = $this->input->post('total_grand_amt');
		$fileName = 'data-'.time().'.xlsx';
		// load excel library
		$this->load->library('excel');
		$listInfo = $this->purchase_model->getPurchaseDetail($pid);
		
		$objPHPExcel = new PHPExcel();
		$objPHPExcel->setActiveSheetIndex(0);
		// set Header
		$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Purchase No');
		$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Purchase date');
		$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Vendor Name');
		
		// set Row
		$rowCount = 2;
		//foreach ($listInfo as $list) {
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $po_no);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $po_date);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $vendor_name);
			$rowCount++;
	//	}
		$rowCount = $rowCount + 1;
		$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, 'Product Name');
		$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, 'UOM');
		$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, 'Qty');
		$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, 'Closing Stock');
		$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, 'Price');
		$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, 'Total Amount');
		$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, 'Tax');
		$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, 'Tax Amt');
		$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, 'Amount');
		$objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, 'Remarks');
		$rowCount1 = $rowCount + 1;
		foreach ($listInfo as $list1) {
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount1, $list1->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount1, $list1->unit_measurement);
			$objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount1, $list1->required_qty);
			$objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount1, $list1->close_stock);
			$objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount1, $list1->item_price);
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount1, $list1->actual_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount1, $list1->po_tax);
			$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount1, $list1->po_tax_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount1, $list1->total_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount1, $list1->remarks);
			
			$rowCount1++;
		}
		$rowCount2 = $rowCount1 + 1;
		
			$objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount2, 'Total Amount');
			$objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount2, $total_actual_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount2, $total_tax_amount);
			$objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount2, $total_grand_amount);		
			$rowCount2++;
	
				
		$filename = "Purchase-Detail". date("d-m-Y").".csv";
		header('Content-Type: application/vnd.ms-excel'); 
		header('Content-Disposition: attachment;filename="'.$filename.'"');
		header('Cache-Control: max-age=0'); 
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'CSV');  
		$objWriter->save('php://output'); 
 	}
 	
 	public function expiry_report()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['exp_date']=$this->purchase_model->get_exp_date();
		$this->load->view('Purchase/expiry_report',$data);
	}
	
	public function closedgrn_view($gid){
	    
	    $this->db->query("update remarks set remark_status='Closed' where gnr_id='$gid'");
		redirect('Purchase/grn_list/');
	}
	
	public function get_Pendingdata()
	{
	   
        $data = $this->purchase_model->get_Pendingdata();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	     
    	    $view = "<a href='$this->master_url/index.php/Purchase/viewPurchase/$row->mid'><i class='ft-eye'></i></a>";
    	    if($row->purchase_status == 'Approved') {
    	        $edit = "<a  href='$this->master_url/index.php/Purchase/editPurchase/$row->mid' id='view' name='view' class='btn btn-sm btn-success disabled'>Edit</a>";
    	    } else if($row->purchase_status == 'Closed') {
    	        $edit = "<a  href='$this->master_url/index.php/Purchase/editPurchase/$row->mid' id='view' name='view' class='btn btn-sm btn-success disabled'>Edit</a>";
    	    } else {
    	        $edit = "<a href='$this->master_url/index.php/Purchase/editPurchase/$row->mid' id='view' name='view' class='btn btn-sm btn-info md-btn-success'>Edit</a>";
    	    }
    	    if($row->purchase_status == 'Pending') {
    	        $grn="<a  href='$this->master_url/index.php/Purchase/inword/$row->mid'  id='view' name='view' class='btn btn-sm btn-success disabled'>ADD GRN</a>";
    	    } else {
    	        $grn="<a  href='$this->master_url/index.php/Purchase/inword/$row->mid' id='view' name='view' class='btn btn-sm btn-info md-btn-success'>ADD GRN</a>";
    	    }
    	    $test[] = array(
    	        $count,
    	        $row->purchase_no,
    	        $row->purchase_date,
    	        $row->venders_name,
    	        $row->purchase_status,
    	        $row->po_apporval_date,
    	        $view,
    	        $edit,
    	        $grn
    	        
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
        
	}
	
	public function get_PCloseddata(){
		
		$data = $this->purchase_model->get_Closingdata();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	      
    	    $view ="<a href='$this->master_url/index.php/Purchase/view_po_close/$row->mid' ><i class='ft-eye'></i></a>";
    	    
    	    if($row->purchase_status=='Pending'){
    	       $p_status="<span class='pending_data'>$row->purchase_status</span>";
    	    }
    	    else{
    	        $p_status="<span class='success_data'>$row->purchase_status</span>";
    	    }
    	    $test[] = array(
    	        $count,
    	        $row->purchase_no,
    	        $row->purchase_date,
    	        $row->venders_name,
    	        $p_status,
    	        $row->purchase_remarks,
    	        $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function get_GrnList($sub_mod_id){
		
		$data = $this->purchase_model->get_Grn_data();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Purchase/grn_view/$row->mid' ><i class='ft-eye'></i></a>";
    	    $rejection = "<a href='$this->master_url/index.php/Purchase/rejection_po/$row->mid/$sub_mod_id' class=''><i class='ft-eye'></i></a>";
    	    if($row->gnr_status=='Pending'){
    	       $g_status="<span class=' pending_data'>$row->gnr_status</span>";
    	    }
    	    else if($row->gnr_status=='Approved'){
    	        $g_status="<span class=' success_data'>$row->gnr_status</span>";
    	    }
    	    else{
    	        $g_status="<span class='hold_data'>$row->gnr_status</span>";
    	    }
    	    if($row->invoice_upload == '') {
    	        $img="<img src='$this->master_url/app-assets/images/wrong.png'  class='img_main'/>";
    	    } else {
    	        $img="<img src='$this->master_url/app-assets/images/right.png'  class='img_main'/>";
    	    }
    	    $test[] = array(
    	        $count,
    	        $row->purchase_no,
    	        $row->purchase_date,
                $row->grn_no,
                $row->grn_date,
                $row->invoice_no,
                $row->vendor_name,
                $g_status,
                $view,
                $rejection,
                $img
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function Accgrn_view($mid){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$mid;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($mid);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($mid);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($mid);
		$data['rejection_view']=$this->purchase_model->rejection_view($mid);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($mid);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($mid);
		
		$this->load->view('Purchase/Accgrn_view',$data);
	}
	
	public function close_remark($gnr_id){
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$this->db->query("update remarks set remark_status='Closed' where gnr_id='$gnr_id'");
		redirect('Purchase/ceo_agrn_view/'.$gnr_id);
	}
	
	public function cw3_cwgrn_list(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id= $this->uri->segment(4);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Purchase/cw3_cwgrn_list',$data);
	}


	public function angCW3branch_grn(){
		$data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch = $request->branch;
		$branch_id = $_SESSION['branch_id'];
		$query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date,G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.branchname='CW3' and G.rjn_status='Pending' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		foreach($query->result_array() as $row){
			$data[] = array("purchase_no"=>$row['purchase_no'],
				"purchase_date"=>$row['purchase_date'],
				"grn_no"=>$row['grn_no'],
				"grn_date"=>$row['grn_date'],
				"invoice_no"=>$row['invoice_no'],
				"vendor_name"=>$row['vendor_name'],
				"gnr_status"=>$row['gnr_status'],
				"mid"=>$row['mid'],
				"invoice_upload"=>$row['invoice_upload']);
		}
		echo json_encode($data);
	}

	public function cw3cwgrn_view($mid,$sub_mod_id){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['mid']=$mid;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['get_ordered_gnr']=$this->purchase_model->get_ordered_gnr($mid);
		$data['grn_item']=$this->purchase_model->get_ordered_gnr_item($mid);
		$data['grn_sumamount']=$this->purchase_model->grn_sumamount($mid);
		$data['rejection_view']=$this->purchase_model->rejection_view($mid);
		$data['ordered_gnr_approve']=$this->purchase_model->ordered_gnr_approve_id($mid);
		$data['grn_upload'] = $this->purchase_model->get_uploaded_invoice($mid);
		
		$this->load->view('Purchase/cw3cwgrn_view',$data);
	}
}