<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class StockManagement extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('stockmanage_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	
	//var $master_url='http://gsrgroup.biz/inv_final_test';
    var $master_url='https://bigcashew.com/inventory';
    
	public function present_stock()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prstock'] = $this->stockmanage_model->getPresentStock($branch_id);
		//$data['gprstock'] = $this->stockmanage_model->getGPresentStock();
		$this->load->view('StockManagement/present_stock',$data);
	}
	
	public function Gpresent_stock()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['gprstock'] = $this->stockmanage_model->getGPresentStock();
		$this->load->view('StockManagement/Gpresent_stock',$data);
	}
	
	public function getGPrsentStk(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->stockmanage_model->getGPresentStock();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    $tax_a = ($row->price * $row->tax)/100;
    	    $total_amt = round(($row->price + $tax_a),2);
    	    $test[] = array(
    	        $count,
    	        $row->item_name,
    	        $row->uom,
    	        $row->price,
    	        $row->tax,
    	        $total_amt,
    	        $row->stock
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	public function getPrsentStk(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->stockmanage_model->getPresentStock($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    $tax_a = ($row->item_price * $row->item_tax)/100;
    	    $total_amt = round(($row->item_price + $tax_a),2);
    	    $test[] = array(
    	        $count,
    	        $row->item_name,
    	        $row->uom,
    	        $row->item_price,
    	        $row->item_tax,
    	        $total_amt,
    	        $row->stock_item
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function cpresent_stock()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = '1';
		$data['branch'] = $this->user_model->get_branch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prstock'] = $this->stockmanage_model->getCPresentStock();
		$data['gprstock'] = $this->stockmanage_model->getGPresentStock();
		$this->load->view('StockManagement/cpresent_stock',$data);
	}
	
	public function searchPresentStock()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
				
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'branch' => $branch
		);
		if ($branch == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getPrStock($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branch'] = $this->user_model->get_branch();
		$data['category'] = $this->master_model->getCategory();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('StockManagement/cpresent_stock',$data);
	}
	
	public function stock_ledger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['items'] = $this->master_model->get_Items($branch_id);
		$this->load->view('StockManagement/stock_ledger',$data);
	}
	
	public function searchStockLedger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$item_name = $this->input->post('item_name');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'item_name' => $item_name,
		'branch_id' =>$branch_id
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getStockLedger($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('StockManagement/stock_ledger',$data);
	}
	
	public function cstock_ledger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = '1';
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$this->load->view('StockManagement/cstock_ledger',$data);
	}
	
	public function searchCStockLedger()
	{
		$user_id = $_SESSION['user_id'];
		//$branch_id = $_SESSION['branch_id'];
		$branch_id = '1';
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$item_name = $this->input->post('item_name');
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'item_name' => $item_name,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getCStockLedger($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('StockManagement/cstock_ledger',$data);
	}
	
	public function stock_movement()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('StockManagement/stock_movement',$data);
	}
	
	public function searchStockMovement()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
				
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch_id' =>$branch_id
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getStockMovement($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('StockManagement/stock_movement',$data);
	}
	
	public function cstock_movement()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('StockManagement/cstock_movement',$data);
	}
	
	public function searchCStockMovement()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$branch = $this->input->post('branch');
				
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'branch' => $branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getCStockMovement($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		//$data['branch'] = $this->user_model->get_branch();
		$data['branch'] = $this->stockmanage_model->get_Abranch();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('StockManagement/cstock_movement',$data);
	}
	
	public function vendor_ledger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getSupplierList($branch_id);
		$data['vnd_ledger'] = $this->stockmanage_model->getBAdmVendorLedger();
		$this->load->view('StockManagement/vendor_ledger',$data);
	}
	
	public function searchVendorLedger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$supplier = $this->input->post('supplier');
				
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'supplier' => $supplier,
		'branch_id' =>$branch_id
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getVendorLedger($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getSupplierList($branch_id);
		$this->load->view('StockManagement/vendor_ledger',$data);
	}
	
	public function accvendor_ledger()
	{
		$sub_mod_id = $this->uri->segment(3);
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getAllSupplier();
		$data['branch'] = $this->master_model->getUserAccess($sub_mod_id,$branch_id);
		$data['submodid'] = $sub_mod_id;
		$this->load->view('StockManagement/acc_vendor_ledger',$data);
	}
	
	public function searchAccVendorLedger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
						
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$supplier = $this->input->post('supplier');
		$branch = $this->input->post('branch');
		$sub_mod_id = $this->input->post('sub_mod_id');
				
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'supplier' => $supplier,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getAccVendorLedger($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getAllSupplier();
		$data['submodid'] = $sub_mod_id;
		$data['branch'] = $this->master_model->getUserAccess($sub_mod_id,$branch_id);
		$this->load->view('StockManagement/acc_vendor_ledger',$data);
	}
	
	public function ceovendor_ledger()
	{
		//$sub_mod_id = $this->uri->segment(3);
		$sub_mod_id = '64';
		$user_id = $_SESSION['user_id'];
		$branch_id = '11';
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getAllSupplier();
		$data['branch'] = $this->master_model->getUserAccess($sub_mod_id,$branch_id);
		$data['sub_mod_id'] = $sub_mod_id;
		$this->load->view('StockManagement/ceo_vendor_ledger',$data);
	}
	
	public function searchCeoVendorLedger()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = '11';
		$data['branch_name'] = $_SESSION['branch_name'];
						
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$supplier = $this->input->post('supplier');
		$branch = $this->input->post('branch');
		//$sub_mod_id = $this->input->post('sub_mod_id');
		$sub_mod_id = '64';
				
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'supplier' => $supplier,
		'branch' =>$branch
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getAccVendorLedger($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['supplier'] = $this->master_model->getAllSupplier();
		$data['branch'] = $this->master_model->getUserAccess($sub_mod_id,$branch_id);
		$this->load->view('StockManagement/ceo_vendor_ledger',$data);
	}
	
	public function voucherGeneration($fdate,$tdate,$vname)
	{
		//$sub_mod_id = $this->uri->segment(3);
		$f_date =date('Y-m-d', strtotime($fdate));
		$t_date =date('Y-m-d', strtotime($tdate));
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$vndname = urldecode($vname);
		$data['vname'] = $vndname;
		$data['fr_date'] = $f_date;
		$data['to_date'] = $t_date;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['grn'] = $this->stockmanage_model->getGrns($f_date,$t_date,$vndname);
		$data['grn_detail'] = $this->stockmanage_model->getGrnDetails($f_date,$t_date,$vndname);
		//$data['branch'] = $this->master_model->getUserAccess($sub_mod_id,$branch_id);
		//$data['sub_mod_id'] = $sub_mod_id;
		$this->load->view('StockManagement/voucher_generation',$data);
	}
	
	public function export_vgrnlist(){
	
		$from_date = date('Y-m-d',strtotime($this->input->post('from_date1')));;
		$to_date = date('Y-m-d',strtotime($this->input->post('to_date1')));
		$vname = $this->input->post('vname1');
		$this->load->dbutil();
		$this->load->helper('file');
		$this->load->helper('download');
		$delimiter = ",";
		$newline = "\r\n";
		
		$filename = "GRN_list.csv";
		$query = "select g.grn_no,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.invoice_no,g.total_amount as grn_value,round((g.total_amount - g.reject_amt),2) as rejected_amt,round((g.reject_amt),2) as final_value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$vname' and (g.grn_date between '$from_date' and '$to_date') group by p.gnr_id";
		$result = $this->db->query($query);
		$data = $this->dbutil->csv_from_result($result, $delimiter, $newline);
		force_download($filename, $data);
		
	}
	
	public function generateVoucher()
	{
		$vc_id=$this->stockmanage_model->generateVoucher($this->input->post());
		redirect('StockManagement/accvoucherView/'.$vc_id);
	}
	
	public function voucherList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['voucher'] = $this->stockmanage_model->getVoucherList();
		$data['pnd_voucher'] = $this->stockmanage_model->getPendingVoucherList();
		$this->load->view('StockManagement/voucher_list',$data);
	}
	
	public function pendingVoucherList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['voucher'] = $this->stockmanage_model->getVoucherList();
		$data['pnd_voucher'] = $this->stockmanage_model->getPendingVoucherList();
		$this->load->view('StockManagement/pVoucher_list',$data);
	}

	public function voucherView($vid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['voucher'] = $this->stockmanage_model->getVoucher($vid);
		$data['voucher_detail'] = $this->stockmanage_model->getVoucherDetail($vid);
		$this->load->view('StockManagement/voucher_view',$data);
	}
	
	public function approveVoucher()
	{
		$voucher_id = $this->input->post('voucher_id');
		$apporval_date = date("Y-m-d");
		$query = $this->db->query("update voucher set approval_status='Approved',approval_date='$apporval_date' where voucher_id='$voucher_id'");
		redirect('StockManagement/voucherList/');
	}
	
	public function grnList(){
		$vname = $_POST['vname'];
		$data['vname'] = $_POST['vname'];
		$data['vndgrnlist']=$this->stockmanage_model->getGrnList($vname);
		$this->load->view('StockManagement/grn_list', $data);
	}
	
	public function mcVoucherList(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['voucher'] = $this->stockmanage_model->getMCVoucherList();
		$data['pnd_voucher'] = $this->stockmanage_model->getPendingMCVoucherList();
		$this->load->view('StockManagement/mcVoucherList',$data);
	}
	
	public function accVoucherList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['voucher'] = $this->stockmanage_model->getVoucherList();
		$data['pnd_voucher'] = $this->stockmanage_model->getPendingVoucherList();
		$this->load->view('StockManagement/accvoucher_list',$data);
	}
	
	public function accvoucherView($vid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['voucher'] = $this->stockmanage_model->getVoucher($vid);
		$data['voucher_detail'] = $this->stockmanage_model->getVoucherDetail($vid);
		$data['voucherparti'] = $this->stockmanage_model->get_voucher_particulars($vid);
		$this->load->view('StockManagement/voucherList',$data);
	}
	
	public function payadvice_email_sending(){
	        $vid= $this->input->post('vid');
			$vendor = $this->input->post('vendor');
			$tdate = $this->input->post('tdate');
			$address = $this->input->post('address');
			$address1 = $this->input->post('address1');
			$inv_no = $this->input->post('inv_no');
			$inv_date = $this->input->post('inv_date');
			$amt = $this->input->post('inv_amt');
			$icount = count($inv_no);
			$ttl_amt= $this->input->post('ttl_amt');
			$pay_mode= $this->input->post('pay_mode');
			$tr_detail= $this->input->post('tr_detail');
			$tr_date= $this->input->post('tr_date');
		    $to_id = $this->input->post('email_id');
		    //echo $to_id;
		    $this->db->query("update voucher set transaction_detail='$tr_detail',transaction_date='$tr_date' where voucher_id='$vid'");
		    $data=array(
			'voucher_id' => $vid
			);
			//echo $vid;
		    $this->data['paydata'] = $this->stockmanage_model->getPayData($vid);
		    $this->data['tr_detail']=$tr_detail;
		    $this->data['tr_date']=$tr_date;
			$this->load->library('html2pdf');
                
			$filename = 'Payment Advice'.'.pdf';
			$this->html2pdf->folder('./assets/pdfs/');
			$this->html2pdf->filename($filename);
			$this->html2pdf->paper('a4', 'portrait');
			
			//$this->html2pdf->html($mdg);
		//	$this->html2pdf->create('save');
			//$this->html2pdf->html(<h1>Some Title</h1><p>Some content in here</p>);
			//$data = array(	'title' => 'PDF Created',	'message' => 'Hello orld!'	);
			
			//Load html view
	//$this->load->view('pay_advice', $this->data);	
		$this->html2pdf->html($this->load->view('pay_advice', $this->data, true));	
		if($path = $this->html2pdf->create('save')) {
				//PDF was successfully saved or downloaded
				$this->load->library('email');
				$this->email->initialize();
				$this->email->from('info@gsrgroup.biz');
				$this->email->to($to_id,'Cakewala');
				$this->email->cc('navyashettyd@gmail.com');
				//$this->email->to('akshatha0001@gmail.com','Cakewla');
				//$this->email->to('navyashetty@gravitysoft.in');
				$this->email->subject('Payment Advice');
				$content = 'Greetings from Cakewala / Eshanya,'."\r\n\r\n".'Kindly refer to attached payment advice.'."\r\n\r\n".'This is a system-generated email. Please do not reply to this email. Queries raised here will not be responded. Kindly mail us at accounts@cakewala.in if you have any queries.';
				$this->email->message($content);
				$this->email->attach($path);
				$this->email->send();
		        $this->email->print_debugger();
							
			}
			//redirect('Ceo_controller/seller');
			redirect('StockManagement/accVoucherList/');
		}
		
	public function exportStockLedger(){
		$branchname = $_SESSION['branch_name'];
		$branch_id = $_SESSION['branch_id'];
		$fdate = $this->input->post('fdate');
		$tdate = $this->input->post('tdate');
		$iname = $this->input->post('iname');
		
        $this->load->library('Excel');
        $listInfo = $this->stockmanage_model->exportStockLedger($fdate,$tdate,$iname,$branchname);
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'From_date');
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'To_date');
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Item_name');
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Branch_name');
        
        $objPHPExcel->getActiveSheet()->SetCellValue('A2', $fdate);
        $objPHPExcel->getActiveSheet()->SetCellValue('B2', $tdate);
        $objPHPExcel->getActiveSheet()->SetCellValue('C2', $iname);
        $objPHPExcel->getActiveSheet()->SetCellValue('D2', $branchname);
       
        $objPHPExcel->getActiveSheet()->SetCellValue('A3', 'stock_id');
        $objPHPExcel->getActiveSheet()->SetCellValue('B3', 'item_name');
        $objPHPExcel->getActiveSheet()->SetCellValue('C3', 'trans_ref_no');
        $objPHPExcel->getActiveSheet()->SetCellValue('D3', 'transaction_date');
        $objPHPExcel->getActiveSheet()->SetCellValue('E3', 'opening_stock');
        $objPHPExcel->getActiveSheet()->SetCellValue('F3', 'in_qty');
        $objPHPExcel->getActiveSheet()->SetCellValue('G3', 'out_qty');
        $objPHPExcel->getActiveSheet()->SetCellValue('H3', 'closing_stock');
        $objPHPExcel->getActiveSheet()->SetCellValue('I3', 'last_modified');
        $objPHPExcel->getActiveSheet()->SetCellValue('J3', 'branchname');
        $objPHPExcel->getActiveSheet()->SetCellValue('K3', 'branch_id');
        $objPHPExcel->getActiveSheet()->SetCellValue('L3', 'item_id');
        $objPHPExcel->getActiveSheet()->SetCellValue('M3', 'itm_id');
        $objPHPExcel->getActiveSheet()->SetCellValue('N3', 'recipe_no');
        $objPHPExcel->getActiveSheet()->SetCellValue('O3', 'category_id');
        
        // set Row
        
        $rowCount = 4;
        foreach ($listInfo as $list) {
           //if($list->itm_id != '') {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $list['stock_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $list['item_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $list['trans_ref_no']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $list['trans_date']);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, $list['opening_stock']);
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $list['in_qty']);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $list['out_qty']);
                $objPHPExcel->getActiveSheet()->SetCellValue('H' . $rowCount, $list['closing_stock']);
                $objPHPExcel->getActiveSheet()->SetCellValue('I' . $rowCount, $list['last_modified']);
                $objPHPExcel->getActiveSheet()->SetCellValue('J' . $rowCount, $list['branchname']);
                $objPHPExcel->getActiveSheet()->SetCellValue('K' . $rowCount, $list['branch_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('L' . $rowCount, $list['item_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('M' . $rowCount, $list['itm_id']);
                $objPHPExcel->getActiveSheet()->SetCellValue('N' . $rowCount, $list['recipe_no']);
                $objPHPExcel->getActiveSheet()->SetCellValue('O' . $rowCount, $list['category_id']);
                
                
                $rowCount++;
           //}
        }
        $filename = "StockLedger". date("d-m-Y").".csv";
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'.$filename.'"');
        header('Cache-Control: max-age=0');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'CSV');  
        $objWriter->save('php://output');
	}
	
	public function angacc_vendorledger(){
	    $data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$cw_ceo = $_SESSION['cw_ceo'];
		if($cw_ceo=='CW')
        {
            $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname!='CW4' and G.branchname!='CMS-STR' and G.branchname!='CW5' ORDER BY G.gnr_id desc limit $row,$rowperpage");
        }
        else{
            $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='$cw_ceo' ORDER BY G.gnr_id desc limit $row,$rowperpage");
        }
		/*if($branch_name=='CW-ACC'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname!='CW4' and G.branchname!='CMS-STR' and G.branchname!='CW5' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}else if($branch_name=='CW4_ACC'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='CW4' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}
		else if($branch_name=='CW5-ACC'){
		    $query = $this->db->query("SELECT *,DATE_FORMAT(P.purchase_date, '%d-%m-%Y') as purchase_date, G.gnr_id as mid, DATE_FORMAT(G.grn_date, '%d-%m-%Y') as grn_date FROM purchase_order P inner join gnr_creation G on P.purchase_id=G.purchase_id where G.rjn_status='Pending' and G.branchname='CW5' ORDER BY G.gnr_id desc limit $row,$rowperpage");
		}*/
		foreach($query->result_array() as $row){
		
    	$data[] = array("grn_date"=>$row['grn_date'],
    	"gnr_id"=>$row['mid'],
    	"grn_no"=>$row['grn_no'],
    	"vendor_name"=>$row['vendor_name'],
    	"total_amount"=>$row['total_amount'],
    	"reject_amt"=>$row['reject_amt']);
		}
		echo json_encode($data);
	}
	
	
	public function paypdfdownload($vid){
	    $this->data['paydata'] = $this->stockmanage_model->getPayData($vid);
		    $this->load->library('html2pdf');
            $filename = 'Payment Advice'.'.pdf';
			$this->html2pdf->folder('./assets/pdfs/');
			$this->html2pdf->filename($filename);
			$this->html2pdf->paper('a4', 'portrait');
			//$this->html2pdf->html($mdg);
		    //	$this->html2pdf->create('save');
			//$this->html2pdf->html(<h1>Some Title</h1><p>Some content in here</p>);
			//$data = array(	'title' => 'PDF Created',	'message' => 'Hello orld!'	);
			//Load html view
	      //	$this->load->view('pay_advice_pdf', $this->data);	
		$this->html2pdf->html($this->load->view('pay_advice_pdf', $this->data, true));	
		$this->html2pdf->create('download');
	}
	
	public function angacc_getvendorledger(){
	    $data1 = file_get_contents("php://input");
		$request = json_decode($data1);
		$row = $request->row;
		$rowperpage = $request->rowperpage;
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		if($branch_name=='CW4_CEO')
		{
		    $query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,g.total_amount,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='CW4' group by p.gnr_id limit $row,$rowperpage");
		}
		else if($branch_name=='CW5_CEO')
		{
		    $query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,g.total_amount,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='CW5' group by p.gnr_id limit $row,$rowperpage");
		}
		else if($branch_name=='CW6_CEO')
		{
		    $query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,g.total_amount,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='CW6' group by p.gnr_id limit $row,$rowperpage");
		}
		else{
		    $query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,g.total_amount,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname!='CW4' and g.branchname!='CW5' group by p.gnr_id limit $row,$rowperpage");
		}    
		foreach($query->result_array() as $row){
			
			$data[] = array("grn_date"=>$row['grn_date'],
    			"gnr_id"=>$row['gnr_id'],
    			"grn_no"=>$row['grn_no'],
    			"vendor_name"=>$row['vendor_name'],
    			"total_amount"=>$row['total_amount'],
    			"reject_amt"=>$row['reject_amt']);
		}
		echo json_encode($data);
	}
	
	
	public function Apresent_stock()
	{
		$user_id = $_SESSION['user_id'];
		
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['prstock'] = $this->stockmanage_model->getAPresentStock();
		$data['branchs'] = $this->stockmanage_model->get_Abranch();
		$this->load->view('StockManagement/admPrsentStk',$data);
	}
	
	public function searchAPresentStock()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
				
		$branch = $this->input->post('branch');
		
		$data1 = array(
		'branch' => $branch
		);
		if ($branch == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->stockmanage_model->getPrStock($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['branchs'] = $this->stockmanage_model->get_Abranch();
		$data['category'] = $this->master_model->getCategory();
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('StockManagement/admPrsentStk',$data);
	}
	
	public function cwPresent_stock()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		//$data['prstock'] = $this->stockmanage_model->getPresentStock($branch_id);
		$this->load->view('StockManagement/cwPresentStock',$data);
	}
	public function getCWPrsentStk(){
		
		$data = $this->stockmanage_model->getCWPresentStock();
        $count=1;
        $test = array();
        $test1 = array();
        foreach($data as $row)
    	{
    	    $tax_a = ($row->item_price * $row->item_tax)/100;
    	    $total_amt = round(($row->item_price + $tax_a),2);
    	    $test[] = array(
    	       $row->item_name,
    	        $row->uom,
    	        $row->stock_item,
    	        $row->item_price,
    	        $row->item_tax,
    	        $total_amt,
    	        $row->branchname
    	   );
    	        
    	        $count++;
    	}
    	
    	$data1 = $this->stockmanage_model->getGDWPresentStock();
        foreach($data1 as $row1)
    	{
    	    $tax_a1 = ($row1->price * $row1->tax)/100;
    	    $total_amt1 = round(($row1->price + $tax_a1),2);
    	    $test[] = array(
    	       $row1->item_name,
    	        $row1->uom,
    	        $row1->stock,
    	        $row1->price,
    	        $row1->tax,
    	        $total_amt1,
    	        $row1->branchname
    	   );
    	}
    	//array_push($test,$test1);
    	
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
}
?>