<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transfer extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		$this->load->model('report_model');
		$this->load->model('transfer_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	
	//var $master_url='https://gsrgroup.biz/inv_final_test';
    var $master_url='https://bigcashew.com/inventory';
    
	public function stock_transfer()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$smod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		if($branch_name=='GDW'){
		    $data['items'] = $this->master_model->get_GDWItems();
		}
		else{
		    $data['items'] = $this->master_model->get_Items($branch_id);
		}
		$data['tr_user'] = $this->transfer_model->get_users($branch_id,$smod_id);
		$this->load->view('Transfer/stock_transfer',$data);
	}
	
	public function stock_GDWtransfer()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$smod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		if($branch_name=='GDW'){
		    $data['items'] = $this->master_model->get_GDWItems();
		}
		else{
		    $data['items'] = $this->master_model->get_Items($branch_id);
		}
		$data['tr_user'] = $this->transfer_model->get_users($branch_id,$smod_id);
		$this->load->view('Transfer/gdw_stk_transfer',$data);
	}
	
	public function addStkTransfer()
	{
		$sid=$this->transfer_model->addStkTransfer($this->input->post());
		if($sid)
		{
		    redirect('Transfer/stk_transfer_inv/'.$sid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Transfer/stock_transfer/');
		}
	}
	
	public function addGDWStkTransfer()
	{
		$sid=$this->transfer_model->addGdwStkTransfer($this->input->post());
		if($sid)
		{
		    redirect('Transfer/stk_GDWtransfer_inv/'.$sid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Transfer/stock_GDWtransfer/');
		}
	}
	
	public function stk_transfer_inv($sid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['stk_transfer'] = $this->transfer_model->getStkTransfer($sid);
		$data['stk_transfer_item'] = $this->transfer_model->getStkTransferItem($sid);
		$this->load->view('Transfer/preview_stk_transfer',$data);
	}
	
	public function stk_GDWtransfer_inv($sid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['stk_transfer'] = $this->transfer_model->getStkTransfer($sid);
		$data['stk_transfer_item'] = $this->transfer_model->getStkTransferItem($sid);
		$this->load->view('Transfer/preview_GDWstk_transfer',$data);
	}
	
	public function stk_transfer_list()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['items'] = $this->master_model->get_Items($branch_id);
	//	$data['stk_transfer'] = $this->transfer_model->getStkTransferList($branch_id);
		$this->load->view('Transfer/stk_transfer_list',$data);
	}
	
	public function getStkTransfer(){
		
		$branch_id = $_SESSION['branch_id'];
		$data = $this->transfer_model->getStkTransferList($branch_id);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Transfer/stk_transfer_inv/$row->stk_tr_id' class=''><i class='ft-eye'></i></a>";
    	    $stk_tr_date=date('d-m-Y',strtotime($row->stk_tr_date));
    	    
    	    $test[] = array(
    	        $count,
    	        $row->stk_tr_no,
    	        $stk_tr_date,
    	        $row->to_branchname,
    	        $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function gdw_stk_trans_list()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		$data['items'] = $this->master_model->get_GDWItems();
	//	$data['stk_transfer'] = $this->transfer_model->getStkTransferList($branch_id);
		$this->load->view('Transfer/gdw_stk_trans_list',$data);
	}
	
	public function getGDWStkTransfer(){
		
		$branch_id = $_SESSION['branch_id'];
		$branch_name = $_SESSION['branch_name'];
		$data = $this->transfer_model->get_godown_stk_transfer_list($branch_name);
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Transfer/stk_transfer_inv/$row->stk_tr_id' class=''><i class='ft-eye'></i></a>";
    	    $stk_tr_date=date('d-m-Y',strtotime($row->stk_tr_date));
    	    
    	    $test[] = array(
    	        $count,
    	        $row->stk_tr_no,
    	        $stk_tr_date,
    	        $row->to_branchname,
    	        $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	
	public function searchGDWStkTransfer()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
				
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$item_name = $this->input->post('item_name');
		$sub_mod_id=$this->input->post('sub_mod_id');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'item_name' => $item_name,
		'branch_id' =>$branch_id
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->transfer_model->getGDWStkTransferResult($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['items'] = $this->master_model->get_GDWItems();
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Transfer/gdw_stk_trans_list',$data);
	}
	
	public function gdw_trans_recipt(){
		$sid = $_POST['sid'];
		
		$data['stk_transfer'] = $this->transfer_model->getStkTransfer($sid);
		$data['stk_transfer_item'] = $this->transfer_model->getStkTransferItem($sid);
		$this->load->view('Transfer/gdw_trans_recipt', $data);
	}
	
	public function searchStkTransfer()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
				
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$to_branch = $this->input->post('to_branch_name');
		$item_name = $this->input->post('item_name');
		$sub_mod_id=$this->input->post('sub_mod_id');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'to_branch' => $to_branch,
		'item_name' => $item_name,
		'branch_id' =>$branch_id
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->transfer_model->getStkTransferResult($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['items'] = $this->master_model->get_Items($branch_id);
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Transfer/stk_transfer_list',$data);
	}
	
	public function transfer()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['outlet'] = $this->transfer_model->getOutlets();
		//$data['outlet'] = $this->transfer_model->getOutletsdept();
		$data['items'] = $this->master_model->get_Items($branch_id);
		$this->load->view('Transfer/transfer',$data);
	}
	
	/*public function getItemProduct()
	{
		$itype = $this->input->post('item_type');
		$br_id = $this->input->post('branch_id');
		$this->transfer_model->getItemProduct($itype,$br_id);
	}*/
	

	public function getItemProduct()
	{
		$itype = $this->input->post('item_type');
		$br_id = $this->input->post('branch_id');
		$temp = Array();
		if($itype == 'Raw Material')
		{
			$query = $this->db->query("select item_name,uom from item_creation where branch_id='$br_id' and status='Enabled' order by item_name");
			$result = $query->result();
			foreach($result as $res)
			{
				$temp[] = $res;
				/*$temp[] = array(
					'item_name' => $res->item_name,
					'uom' => $res->uom
				); */
			}
			/*$item = array(
			'items' => $temp
			);*/
			echo json_encode($temp);
			file_put_contents('itm_list.json', json_encode($temp));
		}
		else if($itype == 'Finished Product')
		{
			$query = $this->db->query("select rname as item_name from recipe where branch_id='$br_id' and status='Enabled' order by rname");
			$result = $query->result();
			foreach($result as $res)
			{
				$temp[] = $res;
				/*$temp[] = array(
					'item_name' => $res->item_name,
					'uom' => $res->uom	
				);*/
			}
			/*$item = array(
			'items' => $temp
			);*/
			echo json_encode($temp);
			file_put_contents('itm_list.json', json_encode($temp));
		}
	}
	
	public function addTransfer()
	{
		$trid=$this->transfer_model->addTransfer($this->input->post());
		if($trid)
		{
		    redirect('Transfer/transferView/'.$trid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Transfer/transfer/');
		}
	}
	
	public function transferView($trid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['transfer'] = $this->transfer_model->getTransfer($trid);
		$data['transfer_item'] = $this->transfer_model->getTransferItem($trid);
		$this->load->view('Transfer/transfer_view',$data);
	}
	
	public function transfeList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['transfer_list'] = $this->transfer_model->getTransferList($branch);
		$this->load->view('Transfer/transfer_list',$data);
	}
	
	public function transferInward($trid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['transfer'] = $this->transfer_model->getCloseTransfer($trid);
		$data['transfer_item'] = $this->transfer_model->getTransferItem($trid);
		$this->load->view('Transfer/transfer_inward',$data);
	}
	
	public function addTransferInward()
	{
		$trinid=$this->transfer_model->addTransferInward($this->input->post());
		$tr_id = $this->input->post('tr_id');
		if($trinid)
		{
		    redirect('Transfer/transferInwardView/'.$trinid);
		}
		else
		{
		    $this->session->set_flashdata('error', 'Something went wrong, please do the entries again');
		    redirect('Transfer/transferInward/'.$tr_id);
		}
	}
	
	public function transferInwardView($trinid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['transfer_in'] = $this->transfer_model->getTransferInward($trinid);
		$data['transfer_initem'] = $this->transfer_model->getTransferInwardItem($trinid);
		$this->load->view('Transfer/transfer_inward_view',$data);
	}
	
	public function transfeClosedList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['transfer_list'] = $this->transfer_model->getTransferClosedList($branch);
		$this->load->view('Transfer/transfer_closed_list',$data);
	}
	
	public function transferCloseView($trid)
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['transfer'] = $this->transfer_model->getCloseTransfer($trid);
		$data['transfer_item'] = $this->transfer_model->getTransferItem($trid);
		$this->load->view('Transfer/transfer_close_view',$data);
	}
	
	public function inwardList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$branch = $_SESSION['branch_name'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['trinward_list'] = $this->transfer_model->getTransferInwardList($branch_id);
		$this->load->view('Transfer/transfer_inward_list',$data);
	}
	public function transferRmkissUpdate(){
		$tr_id = $this->input->post('tr_id');
		$trans_remark = $this->input->post('trans_remark');
		$branch = $this->input->post('branch');
		$trbranch = $this->input->post('trbranch');
		if($branch == $trbranch)
		{
			$this->db->query("update transfer set to_status='Closed',to_remark='$trans_remark' where tr_id='$tr_id'");
		}
		else
		{
			$this->db->query("update transfer set from_status='Closed',from_remark='$trans_remark' where tr_id='$tr_id'");
		}
		echo 1;
	}
	public function stkCtransferList()
	{
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$sub_mod_id = $this->uri->segment(3);
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$data['submod_id']=$sub_mod_id;
		
		$data['stk_transfer'] = $this->transfer_model->getCStkTransferList();
		$this->load->view('Transfer/stkCtransferList',$data);
	}

    public function getCStkTransfer(){
		
		$data = $this->transfer_model->getCStkTransferList();
        $count=1;
        $test = array();
        foreach($data as $row)
    	{
    	    
    	    $view = "<a href='$this->master_url/index.php/Transfer/stk_transfer_inv/$row->stk_tr_id' class=''><i class='ft-eye'></i></a>";
    	    $stk_tr_date=date('d-m-Y',strtotime($row->stk_tr_date));
    	    
    	    $test[] = array(
    	        $count,
    	        $row->stk_tr_no,
    	        $stk_tr_date,
    	        $row->to_branchname,
    	        $row->total,
                $view
    	   );
    	        
    	        $count++;
    	}
    	$datas = array(
    	    "data" =>$test
    	);
    	
    	echo json_encode($datas);
	}
	
	public function searchCStkTransfer(){
		$user_id = $_SESSION['user_id'];
		$branch_id = $_SESSION['branch_id'];
		$data['branch_name'] = $_SESSION['branch_name'];
				
		$from_date = $this->input->post('from_date');
		$to_date = $this->input->post('to_date');
		$to_branch = $this->input->post('to_branch_name');
		
		$sub_mod_id=$this->input->post('sub_mod_id');
		
		$data1 = array(
		'from_date' => $from_date,
		'to_date' => $to_date,
		'to_branch' => $to_branch,
		'branch_id' =>$branch_id
		);
		if ($from_date == "" && $to_date == "") {
			$data['date_range_error_message'] = "All feilds are required";
			} else {
			$result = $this->transfer_model->getCStkTransfer($data1);
			if ($result != false) {
				$data['result_display'] = $result;
				} else {
				$data['result_display'] = "No record found !";
			}
		}
		$data['submod_id']=$sub_mod_id;
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['thead_permission'] = $this->user_model->get_thead_permission($user_id,$sub_mod_id);
		$this->load->view('Transfer/stkCtransferList',$data);
	}
}