<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library('session');
		$this->load->model('user_model');
		$this->load->model('master_model');
		
		if(!isset($_SESSION['user_logged'])) {
			$this->session->set_flashdata("error", "please login first to view dashboard");
			redirect("Login/login");
		}
	}
	
	//Module
	public function module_creation()
	{
		$this->load->view('Backend_user/module_creation');
	}
	
	public function module_insert(){
		$module_name= $this->input->post('module_name');
		$data = array('module_name' => $module_name);
		$insert = $this->user_model->insert_module($data);
		redirect('User/module_list');
	}
	
	public function module_list()
	{
		$data['module_view'] = $this->user_model->get_module();
		$this->load->view('Backend_user/module_list',$data);
	}
	
	public function module_edit($module_id){
		$data['module_view'] = $this->user_model->get_module_id($module_id);
		$this->load->view('Backend_user/edit_module',$data);
	}
	public function module_update($module_id){
		$module_name= $this->input->post('module_name');
		$data = array('module_name' => $module_name);
		$this->db->where('module_id',$module_id);
		$this->db->update('module',$data);
		redirect('User/module_list');
	}
	public function module_delete($module_id){
	    $query = $this->db->query("delete from sub_module where module_id='$module_id'");
		$query = $this->db->query("delete from module where module_id='$module_id'");
		redirect('User/module_list');
	}
	
	//Sub Module
	public function sub_module()
	{
		$data['module_data'] = $this->user_model->get_module();
		$this->load->view('Backend_user/sub_module',$data);
	}
	
	public function sub_module_insert(){
		$sub_module_name= $this->input->post('sub_module_name');
		$module_url= $this->input->post('module_url');
		$module_icon= $this->input->post('module_icon');
		$module_id= $this->input->post('module_id');
		$user_ref= $this->input->post('user_ref');
		$data = array('sub_mod_name' => $sub_module_name,
		'module_url' => $module_url,
		'module_id' => $module_id,
		'module_icon' => $module_icon,
		'user_reference' => $user_ref
		);
		$insert = $this->user_model->insert_sub_module($data);
		redirect('User/sub_module_list');
	}
	
	public function sub_module_list()
	{
		$data['module_view'] = $this->user_model->get_sub_module();
		$this->load->view('Backend_user/sub_module_list',$data);
	}
	
	public function sub_module_edit($sub_mod_id){
		$data['module_data'] = $this->user_model->get_module();
		$data['module_view'] = $this->user_model->get_sub_module_id($sub_mod_id);
		$this->load->view('Backend_user/edit_sub_module',$data);
	}
	public function sub_module_update($sub_mod_id){
		$sub_module_name= $this->input->post('sub_module_name');
		$module_url= $this->input->post('module_url');
		$module_icon= $this->input->post('module_icon');
		$module_id= $this->input->post('module_id');
		$user_ref= $this->input->post('user_ref');
		$data = array('sub_mod_name' => $sub_module_name,
		'module_url' => $module_url,
		'module_id' => $module_id,
		'module_icon' => $module_icon,
		'user_reference' => $user_ref
		);
		$this->db->where('sub_mod_id',$sub_mod_id);
		$this->db->update('sub_module',$data);
		redirect('User/sub_module_list');
	}
	public function sub_module_delete($sub_mod_id){
	    $query = $this->db->query("delete from user_module_access where sub_mod_id='$sub_mod_id'");
		$query1 = $this->db->query("delete from sub_module where sub_mod_id='$sub_mod_id'");
		redirect('User/sub_module_list');
	}
	
	//Address
	public function address()
	{
		$this->load->view('Backend_user/address');
	}
	
	public function address_insert(){
		$outlet_name= $this->input->post('outlet_name');
		$org_name= $this->input->post('org_name');
		$address1= $this->input->post('address1');
		$address2= $this->input->post('address2');
		$address3= $this->input->post('address3');
		$gst_no= $this->input->post('gst_no');
		$data = array('outlet' => $outlet_name,
		'org_name' => $org_name,
		'address1' => $address1,
		'address2' => $address2,
		'address3' => $address3,
		'gstin_no' => $gst_no);
		$insert = $this->user_model->insert_address($data);
		redirect('User/address_list');
	}
	
	public function address_list()
	{
		$data['address_view'] = $this->user_model->get_address();
		$this->load->view('Backend_user/address_list',$data);
	}
	
	public function address_edit($address_id){
		$data['address_view'] = $this->user_model->get_address_id($address_id);
		$this->load->view('Backend_user/edit_address',$data);
	}
	public function address_update($address_id){
		$outlet_name= $this->input->post('outlet_name');
		$org_name= $this->input->post('org_name');
		$address1= $this->input->post('address1');
		$address2= $this->input->post('address2');
		$address3= $this->input->post('address3');
		$gst_no= $this->input->post('gst_no');
		$data = array('outlet' => $outlet_name,
		'org_name' => $org_name,
		'address1' => $address1,
		'address2' => $address2,
		'address3' => $address3,
		'gstin_no' => $gst_no);
		$this->db->where('address_id',$address_id);
		$this->db->update('address',$data);
		redirect('User/address_list');
	}
	public function address_delete($address_id){
		$query = $this->db->query("delete from address where address_id='$address_id'");
		redirect('User/address_list');
	}
	
	//Tax
	public function tax()
	{
		$this->load->view('Backend_user/tax_creation');
	}
	
	public function tax_insert(){
		$tax_name= $this->input->post('tax_name');
		$data = array('tax_percentage' => $tax_name);
		$insert = $this->user_model->insert_tax($data);
		redirect('User/tax_list');
	}
	
	public function tax_list()
	{
		$data['tax_view'] = $this->user_model->get_tax();
		$this->load->view('Backend_user/tax_list',$data);
	}
	
	public function tax_delete($tax_id){
		$query = $this->db->query("delete from tax where tax_id='$tax_id'");
		redirect('User/tax_list');
	}
	
	//Permission
	public function permission()
	{
		$this->load->view('Backend_user/permission');
	}
	
	public function addPermission()
	{
		$this->user_model->addPermission($this->input->post());
		redirect('User/permissionList');
	}
	
	public function permissionList()
	{
		$data['permission'] = $this->user_model->get_permission();
		$this->load->view('Backend_user/permission_list', $data);
	}
	
	public function deletePermission($id)
	{
		$this->db->query("delete from sub_permission where permission_id='$id'");
		$this->db->query("delete from permission where permission_id='$id'");
		redirect('User/permissionList');
	}
	
	//Sub Permission
	public function subPermission()
	{
		$data['permission'] = $this->user_model->get_permission();
		$this->load->view('Backend_user/sub_permission', $data);
	}
	
	public function addSubPermission()
	{
		$this->user_model->addSubPermission($this->input->post());
		redirect('User/subPermissionList');
	}
	
	public function subPermissionList()
	{
		$data['sub_permission'] = $this->user_model->get_subpermission();
		$this->load->view('Backend_user/subpermission_list', $data);
	}
	
	public function deleteSubPermission($id)
	{
		$this->db->query("delete from sub_permission where sub_permsn_id='$id'");
		redirect('User/subPermissionList');
	}
	
	//Group
	public function usergroup()
	{
		$this->load->view('Backend_user/usergroup');
	}
	
	public function addUsergroup()
	{
		$this->user_model->addUsergroup($this->input->post());
		redirect('User/usergroupList');
	}
	
	public function usergroupList()
	{
		$data['usergroup'] = $this->user_model->get_usergroup();
		$this->load->view('Backend_user/usergroup_list', $data);
	}
	
	public function editUsergroup($id)
	{
		$data['usergroup'] = $this->user_model->getUsergroup($id);
		$this->load->view('Backend_user/edit_usergroup', $data);
	}
	
	public function updateUsergroup()
	{
		$this->user_model->updateUsergroup($this->input->post());
		redirect('User/usergroupList');
	}
	
	public function deleteUsergroup($id)
	{
		$this->db->query("delete from user_group where group_id='$id'");
		redirect('User/usergroupList');
	}
	
	//Branch
	public function branch()
	{
		$this->load->view('Backend_user/branch');
	}
	
	public function addBranch()
	{
		$this->user_model->addBranch($this->input->post());
		redirect('User/branchList');
	}
	
	public function branchList()
	{
		$data['branch'] = $this->user_model->get_branch();
		$this->load->view('Backend_user/branch_list', $data);
	}
	
	public function editBranch($id)
	{
		$data['branch'] = $this->user_model->getBranch($id);
		$this->load->view('Backend_user/edit_branch', $data);
	}
	
	public function updateBranch()
	{
		$this->user_model->updateBranch($this->input->post());
		redirect('User/branchList');
	}
	
	public function deleteBranch($id)
	{
		$this->db->query("delete from branch where branch_id='$id'");
		redirect('User/branchList');
	}
	
	//User
	public function user()
	{
		$data['usergroup'] = $this->user_model->get_usergroup();
		$data['branch'] = $this->user_model->get_allbranch();
		$data['address'] = $this->user_model->get_address();
		$this->load->view('Backend_user/user', $data);
	}
	
	public function addUser()
	{
		$this->user_model->addUser($this->input->post());
		redirect('User/UserList');
	}
	
	public function UserList()
	{
		$data['user'] = $this->user_model->get_user();
		$this->load->view('Backend_user/user_list', $data);
	}
	
	public function editUser($id)
	{
		$data['user'] = $this->user_model->getUser($id);
		$data['usergroup'] = $this->user_model->get_usergroup();
		$data['branch'] = $this->user_model->get_branch();
		$data['address'] = $this->user_model->get_address();
		$this->load->view('Backend_user/edit_user', $data);
	}
	
	public function updateUser()
	{
		$this->user_model->updateUser($this->input->post());
		redirect('User/UserList');
	}
	
	public function deleteUser($id)
	{
		$this->db->query("delete from user where user_id='$id'");
		redirect('User/UserList');
	}
	
	//User Module
	public function userModule()
	{
		$data['user'] = $this->user_model->get_user();
		$data['module'] = $this->user_model->get_sub_module();
		$this->load->view('Backend_user/user_module', $data);
	}
	
	public function addUserModule()
	{
		$this->user_model->addUserModule($this->input->post());
		redirect('User/userModuleList');
	}
	
	//User Permission
	public function userModuleList()
	{
		$data['user_module'] = $this->user_model->get_userModule();
		$this->load->view('Backend_user/user_modulelist', $data);
	}

	public function viewPermission($user_id)
	{
		$data['user_module_per'] = $this->user_model->get_userModuleId($user_id);
		$this->load->view('Backend_user/viewPermission', $data);
	}
	
	public function updateModules($user_id)
	{
		$data['user_module'] = $this->user_model->get_userModules($user_id);
		$this->load->view('Backend_user/updateModule', $data);
	}
	
	public function change_menu_status(){
		$um_id = $this->input->post('um_id');
		$status = $this->input->post('menu_status');
		
		if($status != ''){
			$this->db->query("update user_module_access set status='$status' where user_module_id='$um_id'");
			echo 1;
		}else{
			echo 0;
		}
	}

	public function addModulePermission(){
		$this->user_model->modulePermission($this->input->post());
		redirect('User/userModuleList');
	}
	
	//User Sub Permission
	public function userSubPermission($user_id)
	{
		$data['user_sub_per'] = $this->user_model->get_userSubPermission($user_id);
		$this->load->view('Backend_user/user_subpermission', $data);
	}
	
	public function addUserSubPermission(){
		$this->user_model->addUserSubPermission($this->input->post());
		redirect('User/userModuleList');
	}
	
	public function dashboard()
	{
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$this->load->view('dashboard',$data);
	}

	public function userAccess()
	{
		$data['modules'] = $this->user_model->get_sub_module();
		$data['branch'] = $this->user_model->get_allbranch();
		$data['username'] = $this->user_model->get_username();
		$data['category'] = $this->master_model->get_Category();
		$this->load->view('Backend_user/user_access', $data);
	}

	public function addUserAccess(){
		$this->user_model->addUserAccess($this->input->post());
		redirect('User/userAccessList');
	}

	public function userAccessList()
	{
		$data['user_access'] = $this->user_model->get_userAccessList();
		$this->load->view('Backend_user/user_accesslist', $data);
	}
	
	public function productIndentAccess()
	{
		$branch_id = 34;
		$data['username'] = $this->user_model->get_username();
		$data['category'] = $this->master_model->get_Category();
		$data['recipe'] = $this->master_model->getCatRecipe($branch_id);
		$this->load->view('Backend_user/prindent_access', $data);
	}

	public function updatePrIndent(){
		$this->user_model->updatePrIndent($this->input->post());
		redirect('User/productIndentAccess');
	}

	public function dcPrice()
	{
		$branch_id = 3;
		$data['username'] = $this->user_model->get_username();
		$data['category'] = $this->master_model->get_Category();
		$data['tax'] = $this->master_model->get_Tax();
		$data['recipe'] = $this->master_model->getDCCatRecipe($branch_id);
		$this->load->view('Backend_user/dcprice', $data);
	}
	
	public function updateDcPrice(){
		$this->user_model->updateDcPrice($this->input->post());
		redirect('User/dcprice');
	}
	
	public function dcPriceC()
	{
		$branch_id = 3;
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['username'] = $this->user_model->get_username();
		$data['category'] = $this->master_model->get_Category();
		$data['tax'] = $this->master_model->get_Tax();
		$data['recipe'] = $this->master_model->getDCCatRecipe($branch_id);
		$this->load->view('Backend_user/dcpricec', $data);
	}
	
	public function updateDcPriceC(){
		$this->user_model->updateDcPrice($this->input->post());
		redirect('User/dcPriceC');
	}
	
	public function cDcPrice()
	{
		$branch_id = 3;
		$user_id = $_SESSION['user_id'];
		$data['side_bar_data'] = $this->user_model->get_SideBarData($user_id);
		$data['username'] = $this->user_model->get_username();
		$data['category'] = $this->master_model->get_Category();
		$data['tax'] = $this->master_model->get_Tax();
		$data['recipe'] = $this->master_model->getDCCatRecipe($branch_id);
		$this->load->view('master/dcprice', $data);
	}
	
	public function updateCDcPrice(){
		$this->user_model->updateDcPrice($this->input->post());
		redirect('User/cDcPrice');
	}
	
	public function customer()
	{
		$branch_id = 3;
		$data['username'] = $this->user_model->get_username();
		$data['category'] = $this->master_model->get_Category();
		$data['customer'] = $this->user_model->get_Customer();
		$this->load->view('Backend_user/customer', $data);
	}
	
	public function addCustomer(){
		$this->user_model->addCustomer($this->input->post());
		redirect('User/customer');
	}
	
	public function editCustomer($id)
	{
		$data['customer'] = $this->user_model->getCustomer($id);
		$data['username'] = $this->user_model->get_username();
		$data['category'] = $this->master_model->get_Category();
		$this->load->view('Backend_user/edit_customer', $data);
	}
	
	public function updateCustomer()
	{
		$this->user_model->updateCustomer($this->input->post());
		redirect('User/customer');
	}
	
	public function deleteCustomer($id)
	{
		$this->db->query("delete from customer where cust_id='$id'");
		redirect('User/customer');
	}
}
