<?php
class Eshanya_model extends CI_model
{
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->db2 = $this->load->database('otherdb', TRUE);
		$this->db3 = $this->load->database('otherdb1', TRUE);
	}
	
	public function get_Items($branch_id)
	{
		$query = $this->db->query("SELECT item_name,uom,item_price from item_creation where branch_id='$branch_id' and status='Enabled'");
		return $query->result();
	}
	
	public function getProductCategory(){
		$query = $this->db->query("select pr_cat_id,pr_cat_name,status from EshProduct_category");
		return $query->result();
	}
	
	public function getCombination(){
		$query = $this->db->query("select comb_id,combination,quantity,price from combination");
		return $query->result();
	}
	
	public function get_CounterUser()
	{
		$query = $this->db->query("SELECT user_id,branch_name,branch_id,branch_code,ibranch_code from user where user_group='9'");
		return $query->result();
	}
	
	public function addRecipeCategory($postdata){
		extract($postdata);
	   if(!empty($combination))
	   {
		    $comb = implode(',',$combination);
	   }
	   else
	   {
	       $comb = '';
	   }
	   
	   if($effective == '')
		{
		    $effect_from = '';
		}
		else
		{
		    $effect_from = date('Y-m-d',strtotime($this->input->post('effective')));
		}
	   
	   $crt_date = date('Y-m-d H:i:s');
		$data = array(
			'pr_cat_name' => $cat_name,
			'effective_from' => $effect_from,
			//'applicable_for' => $applicable,
			'combination' => $comb,
			'combo_qty_limit' => $qty_limit,
			//'social_order' => $fdelivery
		);
		$this->db->insert('EshProduct_category', $data);
		$rc_id = $this->db->insert_id();
	}
	
	public function getRecipeCategoryId($pr_cat_id){
		$query = $this->db->query("select pr_cat_id,pr_cat_name,status,effective_from,combination,combo_qty_limit,applicable_for,social_order from EshProduct_category where pr_cat_id='$pr_cat_id'");
		return $query->result();
	}
	
	public function get_Products($branch_id)
	{
		$query = $this->db->query("SELECT rname from eshRecipe where branch_id='$branch_id'");
		return $query->result();
	}
	
	public function get_RcpItems()
	{
		$query = $this->db->query("SELECT item_name,uom,item_price from item_creation where branchname='ESH'");
		return $query->result();
	}
	
	public function get_Category()
	{
		$query = $this->db->query("SELECT pr_cat_id,pr_cat_name from 	EshProduct_category");
		return $query->result();
	}
		
	public function get_Tax()
	{
		$query = $this->db->query("SELECT tax_percentage from tax");
		return $query->result();
	}
	
	public function get_KitchenUser()
	{
		$query = $this->db->query("SELECT user_id,username from user where user_group='8'");
		return $query->result();
	}
	
	public function get_Chef()
	{
		$query = $this->db->query("SELECT chef_id,chef_name from chef");
		return $query->result();
	}
	
	public function addProduct($postdata)
	{
		extract($postdata);
		$pname1 = preg_replace('/[^a-zA-Z0-9_ \[\]\.\(\)-]/s','',$product_name);
        $pname = trim($pname1);
        
        if($effective != '')
		{
			$effctv = date('Y-m-d',strtotime($effective));
		}
		else
		{
		    $effctv = $effective;
		}
		
		$cq = $this->db->query("SELECT rname FROM eshRecipe where rname='$pname'");
		if($cq->num_rows() > 0)
		{
		    return $cq;
		}
		else
		{
			if(!empty($combination))
			{
				$comb = implode(',',$combination);
			}
			else
			{
			    $comb = '';
			}
			//product image upload
			if(!empty($_FILES['pd_upload']['name'])){
				$config['upload_path'] = 'product_image/';
				$config['allowed_types'] = 'gif|jpg|png|jpeg';
				$filename = $_FILES['pd_upload']['name'];
				$config['file_name'] = $filename;
				//Load upload library and initialize configuration
				$this->load->library('upload',$config);
				$this->upload->initialize($config);

				if($this->upload->do_upload('pd_upload')){
					$uploadData = $this->upload->data();
					//$pd_upload = $uploadData['file_name'];
					$pd_upload = 'product_image/'.$uploadData['file_name'];
					//$file_name = 'upload/'.$_FILES['in_upload']['name'];
				}else{
					$pd_upload = '';
				}
			}else{
				$pd_upload = '';
			}
			
			//recipe number
			$this->db->select('MAX(recipe_no) as recipe_no',false);
			$result = $this->db->get('eshRecipe')->row();
			$recipe_no = $result->recipe_no;
			if($recipe_no == 0){
				$recipe_no = 1;
			}
			else{
				$recipe_no = $recipe_no+1;
			}
			
			$cur_date = date('Y-m-d');
	//		$upd_in = implode(',',$updated_in);
			$data = array(
				'recipe_no' => $recipe_no,
				'hsn_code' => $hsn_code,
				'raised_date' => $cur_date,
				'rname' => $pname,
				'f_code' => $fcode,
				'yeild' => $yield,
				'uom' => $uom,
				'price' => $base_price,
				'tax' => $gst_rate,
				'tax_amount' => $gst,
				'total_price' => $tprice,
				'discount' => $discount,
				'recipe_price' => $ttl_amt,
				'product_image' => $pd_upload,
				'raised_on' => $raised_on,
				'od_time' => $od_time,
				'shelf_life' => $s_life,
				'spl_ord' => $spl_ord,
				'food_delivery' => $food_delivery,
				'tprice' => $tbase_price,
				'ttax' => $tgst_rate,
				'ttax_amount' => $tgst,
				'ttotal_price' => $ttprice,
				'santhe_sales' => $santhe,
				'prepared_by' => $prepared,
				'effective_from' => $effctv,
			//	'updated_in' => $upd_in,
				'recipe_cat' => $recipe_cat,
				'flavour' => $fcode,
				'sqcode' => $sqcode,
				'status' => 'Disabled',
				'aprvl_status' => 'Pending',
				'pr_cat_id' => $category,
				'branchname' => $branch_name,
				'branch_id' => $branch_id,
			    'combination' => $comb,
			    'product_type' => $prtype,
			    'carnival_sale' => $carnival,
			    'fd_status' => 'Pending',
			    'institution_sales' => $inst_sales
			);
			$this->db->insert('eshRecipe', $data);
			$rc_id = $this->db->insert_id();
			//insert to item
			$icount = count($item_name);
			for($i=0;$i<$icount;$i++)			{
			    if($item_name[$i] != '')
			    {
					$data3 = array(
						'item_name' => $item_name[$i],
						'qty' => $quantity[$i],
						'price' => $price[$i],
						'uom' => $iuom[$i],
						'total' => $total[$i],
						'recipe_id' => $rc_id,
						'recipe_no' => $recipe_no,
						'item_id' => $item_id[$i],
						'category_id' => $cat_id[$i],
						'itm_id' => $itm_id[$i]
					);
					$this->db->insert('eshRecipe_item', $data3);
				}
			}
			//insert to sub item
			$scount = count($sub_item_name);
			for($i=0;$i<$scount;$i++)
			{
			    if($sub_item_name[$i] != '')
			    {
					$data4 = array(
						'item_name' => $sub_item_name[$i],
						'qty' => $sub_quantity[$i],
						'price' => $sub_price[$i],
						'uom' => $sub_uom[$i],
						'total' => $sub_total[$i],
						'recipe_id' => $rc_id,
						'rc_no' => $recipe_no,
						'sub_recipe_id' => $sub_item_id[$i],
						'category_id' => $sub_cat_id[$i],
						'recipe_no' => $rcp_no[$i]
					);
					$this->db->insert('eshSub_recipe_item', $data4);
			    }
			}
		}
	}
	
	public function get_RecipeItems($id){
		$query = $this->db->query("select rc_item_id,item_name,qty,price,uom,total,recipe_id,item_id,category_id,itm_id,recipe_no from eshRecipe_item where recipe_id='$id'");
		return $query->result();
	}
	public function get_SubRecipeItems($id){
		$query = $this->db->query("select sub_rc_item_id,item_name,qty,price,uom,total,recipe_id,sub_recipe_id,pr_cat_id,recipe_no,rc_no from eshSub_recipe_item where recipe_id='$id'");
		return $query->result();
	}
	public function getProducts($branch_id){
		$query = $this->db->query("select *,R.status as rstatus from eshRecipe R inner join EshProduct_category C on R.pr_cat_id=C.pr_cat_id where R.branch_id='$branch_id'");
		return $query->result();
	}
	
	public function get_eshItems()
	{
		$query = $this->db->query("SELECT * from item_creation where branchname='ESH'");
		return $query->result();
	}
	public function getApproveProducts(){
		$query = $this->db->query("select recipe_id,rname from eshRecipe where aprvl_status='Pending'");
		return $query->result();
	}
	
	public function getProductDetails($id){
		$query = $this->db->query("select recipe_id,recipe_no,hsn_code,raised_date,f_code,rname,yeild,uom,price,tax,tax_amount,total_price,discount,recipe_price,product_image,raised_on,od_time,shelf_life,spl_ord,food_delivery,tprice,ttax,ttax_amount,ttotal_price,santhe_sales,prepared_by,effective_from,updated_in,status_effective,recipe_cat,flavour,sqcode,status,aprvl_status,pr_cat_id,branchname,branch_id,combination,product_type,carnival_sale,institution_sales from eshRecipe where recipe_id='$id'");
		return $query->result();
	}
	
	public function getProductBranch($rc_no){
		$query = $this->db->query("select recipe_id,recipe_no,hsn_code,raised_date,f_code,rname,yeild,uom,price,tax,tax_amount,total_price,discount,recipe_price,product_image,raised_on,od_time,shelf_life,spl_ord,food_delivery,tprice,ttax,ttax_amount,ttotal_price,santhe_sales,prepared_by,effective_from,updated_in,status_effective,recipe_cat,flavour,sqcode,status,aprvl_status,pr_cat_id,branchname,branch_id from eshRecipe where recipe_no='$rc_no' and branchname not like 'ST%'");
		return $query->result();
	}
	
	public function approveProduct($postdata)
	{
			$db2 = $this->load->database('otherdb', TRUE);
			$db3 = $this->load->database('otherdb1', TRUE);
			extract($postdata);
			$pname1 = preg_replace('/[^a-zA-Z0-9_ \[\]\.\(\)-]/s','',$product_name);
            $pname = trim($pname1);
			if(!empty($combination))
			{
				$comb = implode(',',$combination);
			}
			else
			{
			    $comb = '';
			}
			
			if($effective != '')
			{
				$effctv = date('Y-m-d',strtotime($effective));
			}
			else
			{
			    $effctv = $effective;
			}
			
			//product image upload
			if(!empty($_FILES['pd_upload']['name'])){
				$config['upload_path'] = 'product_image/';
				$config['allowed_types'] = 'gif|jpg|png|jpeg';
				$filename = $_FILES['pd_upload']['name'];
				$config['file_name'] = $filename;
				//Load upload library and initialize configuration
				$this->load->library('upload',$config);
				$this->upload->initialize($config);

				if($this->upload->do_upload('pd_upload')){
					$uploadData = $this->upload->data();
					$pd_upload = $uploadData['file_name'];
					$pdimage = $fpath.$pd_upload;
				}else{
					$pd_upload = '';
					if($pd_upload1 == '')
    			    {
    			        $pdimage = '';
    			    }
    			    else
    			    {
    			        $pdimage = $fpath.$pd_upload1;
    			    }
				}
			}else{
				$pd_upload = '';
				if($pd_upload1 == '')
			    {
			        $pdimage = '';
			    }
			    else
			    {
			        $pdimage = $fpath.$pd_upload1;
			    }
			}
									
			$cur_date = date('Y-m-d');
		//	$upd_in = implode(',',$updated_in);
			$data = array(
				'hsn_code' => $hsn_code,
				'rname' => $pname,
				'f_code' => $fcode,
				'yeild' => $yield,
				'uom' => $uom,
				'price' => $base_price,
				'tax' => $gst_rate,
				'tax_amount' => $gst,
				'total_price' => $tprice,
				'discount' => $discount,
				'recipe_price' => $ttl_amt,
				'product_image' => $pd_upload,
				'raised_on' => $raised_on,
				'od_time' => $od_time,
				'shelf_life' => $s_life,
				'spl_ord' => $spl_ord,
				'food_delivery' => $food_delivery,
				'tprice' => $tbase_price,
				'ttax' => $tgst_rate,
				'ttax_amount' => $tgst,
				'ttotal_price' => $ttprice,
				'santhe_sales' => $santhe,
				'prepared_by' => $prepared,
				'effective_from' => $effctv,
			//	'updated_in' => $upd_in,
				'recipe_cat' => $recipe_cat,
				'flavour' => $fcode,
				'sqcode' => $sqcode,
				'status' => 'Enabled',
				'aprvl_status' => 'Approved',
				'pr_cat_id' => $category,
				'combination' => $comb,
				'product_type' => $prtype,
				'carnival_sale' => $carnival,
                'fd_status' => 'Pending',
                'institution_sales' => $inst_sales
			);
			$this->db->where('recipe_id', $recipe_id);
			$this->db->update('eshRecipe', $data);
			
			//insert to sales price
		
			$brcount = count($up_branch);
			//$br = explode(',',$up_brname);
			for($i=0;$i<$brcount;$i++)
			{
				$data3 = array(
					'recipe_no' => $recipe_no,
					'hsn_code' => $hsn_code,
					'raised_date' => $raised_date,
					'rname' => $pname,
					'f_code' => $fcode,
					'yeild' => $yield,
					'uom' => $uom,
					'price' => $base_price,
					'tax' => $gst_rate,
					'tax_amount' => $gst,
					'total_price' => $tprice,
					'discount' => $discount,
					'recipe_price' => $ttl_amt,
					'product_image' => $pd_upload,
					'raised_on' => $raised_on,
					'od_time' => $od_time,
					'shelf_life' => $s_life,
					'spl_ord' => $spl_ord,
					'food_delivery' => $food_delivery,
					'tprice' => $tbase_price,
					'ttax' => $tgst_rate,
					'ttax_amount' => $tgst,
					'ttotal_price' => $ttprice,
					'santhe_sales' => $santhe,
					'prepared_by' => $prepared,
					'effective_from' => $effctv,
				//	'updated_in' => $upd_in,
					'recipe_cat' => $recipe_cat,
					'flavour' => $fcode,
					'sqcode' => $sqcode,
					'status' => 'Enabled',
					'aprvl_status' => 'Approved',
					'pr_cat_id' => $category,
					'branchname' => $up_brname[$i],
					'branch_id' => $up_branch[$i],
					'combination' => $comb,
					'product_type' => $prtype,
					'carnival_sale' => $carnival,
                    'fd_status' => 'Pending',
                    'institution_sales' => $inst_sales
				);
				$this->db->insert('eshRecipe', $data3);
			}
			
			if($inst_sales == 'No')
			{
    			if($base_price != '' && $base_price != '0')
    			{
    				if($santhe == 'Yes')
    				{
    					$stcount = count($st_branch);
    					for($i=0;$i<$stcount;$i++)
    					{
    					    $sgst_tax = $gst_rate/2;
    						$sgst_tax_amt = $gst/2;
    						
    						$data6 = array(
    							'recipe_no' => $recipe_no,
    							'hsn_code' => $hsn_code,
    							'raised_date' => $raised_date,
    							'rname' => $pname,
    							'f_code' => $fcode,
    							'yeild' => $yield,
    							'uom' => $uom,
    							'price' => $base_price,
    							'tax' => $gst_rate,
    							'tax_amount' => $gst,
    							'total_price' => $tprice,
    							'discount' => $discount,
    							'recipe_price' => $ttl_amt,
    							'product_image' => $pd_upload,
    							'raised_on' => $raised_on,
    							'od_time' => $od_time,
    							'shelf_life' => $s_life,
    							'spl_ord' => $spl_ord,
    							'food_delivery' => $food_delivery,
    							'tprice' => $tbase_price,
    							'ttax' => $tgst_rate,
    							'ttax_amount' => $tgst,
    							'ttotal_price' => $ttprice,
    							'santhe_sales' => $santhe,
    							'prepared_by' => $prepared,
    							'effective_from' => $effctv,
    						//	'updated_in' => $upd_in,
    							'recipe_cat' => $recipe_cat,
    							'flavour' => $fcode,
    							'sqcode' => $sqcode,
    							'status' => 'Enabled',
    							'aprvl_status' => 'Approved',
    							'pr_cat_id' => $category,
    							'branchname' => $st_branch[$i],
    							'branch_id' => $st_branch_id[$i],
    							'combination' => $comb,
    							'product_type' => $prtype,
    							'carnival_sale' => $carnival,
                                'fd_status' => 'Pending',
                                'institution_sales' => $inst_sales
    						);
    						$this->db->insert('eshRecipe', $data6);
    					}
    				}
    				
    				
    			}
	        }
	        else
	        {
	            
    			
	        }
		}
		
	public function updateProduct($postdata)
		{
			extract($postdata);
			$pname1 = preg_replace('/[^a-zA-Z0-9_ \[\]\.\(\)-]/s','',$product_name);
            $pname = trim($pname1);
			
			if(!empty($combination))
			{
				$comb = implode(',',$combination);
			}
			else
			{
			    $comb = '';
			}
			
			if($effective != '')
			{
				$effctv = date('Y-m-d',strtotime($effective));
			}
			else
			{
			    $effctv = $effective;
			}
			
			//product image upload
			if(!empty($_FILES['pd_upload']['name'])){
			    //removing previous file
			    $ImagePathAndName = $pd_upload1;
    			$do = unlink($ImagePathAndName);
              /*  if($do == "1")
                {
                    echo "The file was deleted successfully.";
                }
                else
                {
                    echo "There was an error trying to delete the file.";
                } */
				$config['upload_path'] = 'product_image/';
				$config['allowed_types'] = 'gif|jpg|png|jpeg';
				$filename = $_FILES['pd_upload']['name'];
				$config['file_name'] = $filename;
				//Load upload library and initialize configuration
				$this->load->library('upload',$config);
				$this->upload->initialize($config);

				if($this->upload->do_upload('pd_upload')){
					$uploadData = $this->upload->data();
					$pd_upload = 'product_image/'.$uploadData['file_name'];
					$pdimage = $fpath.$pd_upload;
				}else{
					$pd_upload = $pd_upload1;
					if($pd_upload1 == '')
				    {
				        $pdimage = '';
				    }
				    else
				    {
				        $pdimage = $fpath.$pd_upload1;
				    }
				}
			}else{
				$pd_upload = $pd_upload1;
				if($pd_upload1 == '')
			    {
			        $pdimage = '';
			    }
			    else
			    {
			        $pdimage = $fpath.$pd_upload1;
			    }
			}
			
			$cur_date = date('Y-m-d');
			//$upd_in = implode(',',$updated_in);
			$data = array(
				'hsn_code' => $hsn_code,
				'rname' => $pname,
				'f_code' => $fcode,
				'yeild' => $yield,
				'uom' => $uom,
				'price' => $base_price,
				'tax' => $gst_rate,
				'tax_amount' => $gst,
				'total_price' => $tprice,
				'discount' => $discount,
				'recipe_price' => $ttl_amt,
				'product_image' => $pd_upload,
				'raised_on' => $raised_on,
				'od_time' => $od_time,
				'shelf_life' => $s_life,
				'spl_ord' => $spl_ord,
				'food_delivery' => $food_delivery,
				'tprice' => $tbase_price,
				'ttax' => $tgst_rate,
				'ttax_amount' => $tgst,
				'ttotal_price' => $ttprice,
				'santhe_sales' => $santhe,
				'prepared_by' => $prepared,
				'effective_from' => $effctv,
				//'updated_in' => $upd_in,
				'recipe_cat' => $recipe_cat,
				'flavour' => $fcode,
				'sqcode' => $sqcode,
				'status' => 'Enabled',
				'aprvl_status' => 'Approved',
				'pr_cat_id' => $category,
				'combination' => $comb,
				'product_type' => $prtype,
				'carnival_sale' => $carnival,
                'fd_status' => 'Pending',
                'institution_sales' => $inst_sales
			);
			$this->db->where('recipe_id',$recipe_id);
			$this->db->update('eshRecipe', $data);
			
		
			$brcount = count($up_branch);
			//$br = explode(',',$up_brname);
			
			for($i=0;$i<$brcount;$i++)
			{
				$q2 = $this->db->query("select * from eshRecipe where recipe_no='$recipe_no' and branch_id='$up_branch[$i]'");
				if($q2->num_rows() > 0){
				//	$upd_in = implode(',',$updated_in);
					$data = array(
						'hsn_code' => $hsn_code,
						'rname' => $pname,
						'f_code' => $fcode,
						'yeild' => $yield,
						'uom' => $uom,
						'price' => $base_price,
						'tax' => $gst_rate,
						'tax_amount' => $gst,
						'total_price' => $tprice,
						'discount' => $discount,
						'recipe_price' => $ttl_amt,
						'product_image' => $pd_upload,
						'raised_on' => $raised_on,
						'od_time' => $od_time,
						'shelf_life' => $s_life,
						'spl_ord' => $spl_ord,
						'food_delivery' => $food_delivery,
						'tprice' => $tbase_price,
						'ttax' => $tgst_rate,
						'ttax_amount' => $tgst,
						'ttotal_price' => $ttprice,
						'santhe_sales' => $santhe,
						'prepared_by' => $prepared,
						'effective_from' => $effctv,
					//	'updated_in' => $upd_in,
						'recipe_cat' => $recipe_cat,
						'flavour' => $fcode,
						'sqcode' => $sqcode,
						'status' => 'Enabled',
						'aprvl_status' => 'Approved',
						'pr_cat_id' => $category,
						'branchname' => $up_brname[$i],
						'branch_id' => $up_branch[$i],
						'combination' => $comb,
						'product_type' => $prtype,
						'carnival_sale' => $carnival,
                        'fd_status' => 'Pending',
                        'institution_sales' => $inst_sales
                        
					);
					$this->db->where('recipe_no',$recipe_no);
					$this->db->where('branch_id',$up_branch[$i]);
					$this->db->update('eshRecipe', $data);
				}
				else
				{
					$data3 = array(
						'recipe_no' => $recipe_no,
						'hsn_code' => $hsn_code,
						'raised_date' => $raised_date,
						'rname' => $pname,
						'f_code' => $fcode,
						'yeild' => $yield,
						'uom' => $uom,
						'price' => $base_price,
						'tax' => $gst_rate,
						'tax_amount' => $gst,
						'total_price' => $tprice,
						'discount' => $discount,
						'recipe_price' => $ttl_amt,
						'product_image' => $pd_upload,
						'raised_on' => $raised_on,
						'od_time' => $od_time,
						'shelf_life' => $s_life,
						'spl_ord' => $spl_ord,
						'food_delivery' => $food_delivery,
						'tprice' => $tbase_price,
						'ttax' => $tgst_rate,
						'ttax_amount' => $tgst,
						'ttotal_price' => $ttprice,
						'santhe_sales' => $santhe,
						'prepared_by' => $prepared,
						'effective_from' => $effctv,
					//	'updated_in' => $upd_in,
						'recipe_cat' => $recipe_cat,
						'flavour' => $fcode,
						'sqcode' => $sqcode,
						'status' => 'Enabled',
						'aprvl_status' => 'Approved',
						'pr_cat_id' => $category,
						'branchname' => $up_brname[$i],
						'branch_id' => $up_branch[$i],
						'combination' => $comb,
						'product_type' => $prtype,
						'carnival_sale' => $carnival,
                        'fd_status' => 'Pending',
                        'institution_sales' => $inst_sales
					);
					$this->db->insert('eshRecipe', $data3);
				}
			}
			
			if($inst_sales == 'No')
			{
    				if($santhe == 'Yes')
    				{
    					$stcount = count($st_branch);
    					for($i=0;$i<$stcount;$i++)
    					{
    						$sgst_tax = $gst_rate/2;
    						$sgst_tax_amt = $gst/2;
    						$q2 = $this->db->query("select * from eshRecipe where recipe_no='$recipe_no' and branchname='$st_branch[$i]'");
    						if($q2->num_rows() > 0){
    							
    							$data6 = array(
    								'recipe_no' => $recipe_no,
    								'hsn_code' => $hsn_code,
    								'raised_date' => $raised_date,
    								'rname' => $pname,
    								'f_code' => $fcode,
    								'yeild' => $yield,
    								'uom' => $uom,
    								'price' => $base_price,
    								'tax' => $gst_rate,
    								'tax_amount' => $gst,
    								'total_price' => $tprice,
    								'discount' => $discount,
    								'recipe_price' => $ttl_amt,
    								'product_image' => $pd_upload,
    								'raised_on' => $raised_on,
    								'od_time' => $od_time,
    								'shelf_life' => $s_life,
    								'spl_ord' => $spl_ord,
    								'food_delivery' => $food_delivery,
    								'tprice' => $tbase_price,
    								'ttax' => $tgst_rate,
    								'ttax_amount' => $tgst,
    								'ttotal_price' => $ttprice,
    								'santhe_sales' => $santhe,
    								'prepared_by' => $prepared,
    								'effective_from' => $effctv,
    								//'updated_in' => $upd_in,
    								'recipe_cat' => $recipe_cat,
    								'flavour' => $fcode,
    								'sqcode' => $sqcode,
    								'status' => 'Enabled',
    								'aprvl_status' => 'Approved',
    								'pr_cat_id' => $category,
    								'branchname' => $st_branch[$i],
    								'branch_id' => $st_branch_id[$i],
    								'combination' => $comb,
    								'product_type' => $prtype,
    								'carnival_sale' => $carnival
    							);
    							$this->db->where('recipe_no',$recipe_no);
    							$this->db->where('branch_id',$st_branch_id[$i]);
    							$this->db->update('eshRecipe', $data6);
    						}
    						else
    						{
    							$data6 = array(
    								'recipe_no' => $recipe_no,
    								'hsn_code' => $hsn_code,
    								'raised_date' => $raised_date,
    								'rname' => $pname,
    								'f_code' => $fcode,
    								'yeild' => $yield,
    								'uom' => $uom,
    								'price' => $base_price,
    								'tax' => $gst_rate,
    								'tax_amount' => $gst,
    								'total_price' => $tprice,
    								'discount' => $discount,
    								'recipe_price' => $ttl_amt,
    								'product_image' => $pd_upload,
    								'raised_on' => $raised_on,
    								'od_time' => $od_time,
    								'shelf_life' => $s_life,
    								'spl_ord' => $spl_ord,
    								'food_delivery' => $food_delivery,
    								'tprice' => $tbase_price,
    								'ttax' => $tgst_rate,
    								'ttax_amount' => $tgst,
    								'ttotal_price' => $ttprice,
    								'santhe_sales' => $santhe,
    								'prepared_by' => $prepared,
    								'effective_from' => $effctv,
    							//	'updated_in' => $upd_in,
    								'recipe_cat' => $recipe_cat,
    								'flavour' => $fcode,
    								'sqcode' => $sqcode,
    								'status' => 'Enabled',
    								'aprvl_status' => 'Approved',
    								'pr_cat_id' => $category,
    								'branchname' => $st_branch[$i],
    								'branch_id' => $st_branch_id[$i],
    								'combination' => $comb,
    								'product_type' => $prtype,
    								'carnival_sale' => $carnival,
                                    'fd_status' => 'Pending'
    							);
    							$this->db->insert('eshRecipe', $data6);
    						}
    					}
    				}
    				else{
    					$stcount = count($st_branch);
    					for($i=0;$i<$stcount;$i++)
    					{
    						$sgst_tax = $gst_rate/2;
    						$sgst_tax_amt = $gst/2;
    					
    						$data6 = array(
    							'recipe_no' => $recipe_no,
    							'hsn_code' => $hsn_code,
    							'raised_date' => $raised_date,
    							'rname' => $pname,
    							'f_code' => $fcode,
    							'yeild' => $yield,
    							'uom' => $uom,
    							'price' => $base_price,
    							'tax' => $gst_rate,
    							'tax_amount' => $gst,
    							'total_price' => $tprice,
    							'discount' => $discount,
    							'recipe_price' => $ttl_amt,
    							'product_image' => $pd_upload,
    							'raised_on' => $raised_on,
    							'od_time' => $od_time,
    							'shelf_life' => $s_life,
    							'spl_ord' => $spl_ord,
    							'food_delivery' => $food_delivery,
    							'tprice' => $tbase_price,
    							'ttax' => $tgst_rate,
    							'ttax_amount' => $tgst,
    							'ttotal_price' => $ttprice,
    							'santhe_sales' => $santhe,
    							'prepared_by' => $prepared,
    							'effective_from' => $effctv,
    							//'updated_in' => $upd_in,
    							'recipe_cat' => $recipe_cat,
    							'flavour' => $fcode,
    							'sqcode' => $sqcode,
    							'status' => 'Disabled',
    							'aprvl_status' => 'Approved',
    							'pr_cat_id' => $category,
    							'branchname' => $st_branch[$i],
    							'branch_id' => $st_branch_id[$i],
    							'combination' => $comb,
    							'product_type' => $prtype,
    							'carnival_sale' => $carnival,
                                'fd_status' => 'Pending'
    						);
    						$this->db->where('recipe_id',$recipe_id);
    						$this->db->where('branch_id',$st_branch_id[$i]);
    						$this->db->update('eshRecipe', $data6);
    					}
    				}
	    	}
			
			if(!empty($inames))
			{
    			for($i=0;$i<count($inames);$i++) 
    			{
    				$data3 = array(
    					'item_name' => $inames[$i],
    					'qty' => $quantitys[$i],
    					'price' => $prices[$i],
    					'uom' => $uoms[$i],
    					'total' => $totals[$i]
    				);
    				$this->db->where('recipe_id',$recipe_id);
    				$this->db->where('rc_item_id',$rcitem_ids[$i]);
    				$this->db->update('eshRecipe_item', $data3);
    				
    			}
    		}
			//insert to item
			$icount = count($item_name);
			for($i=0;$i<$icount;$i++)
			{
				if($item_name[$i] == '')
			    {
					$data3 = array(
						'item_name' => $item_name[$i],
						'qty' => $quantity[$i],
						'price' => $price[$i],
						'uom' => $iuom[$i],
						'total' => $total[$i],
						'recipe_id' => $recipe_id,
						'recipe_no' => $recipe_no,
						'item_id' => $item_id[$i],
						'category_id' => $cat_id[$i],
						'itm_id' => $itm_id[$i]
					);
					$this->db->insert('eshRecipe_item', $data3);
			    }
			}
			if(!empty($sub_inames))
			{
    			for($i=0;$i<count($sub_inames);$i++)
    			{
    
    				$data4 = array(
    					'item_name' => $sub_inames[$i],
    					'qty' => $sub_quantitys[$i],
    					'price' => $sub_prices[$i],
    					'uom' => $sub_uoms[$i],
    					'total' => $sub_totals[$i]
    				);
    				$this->db->where('recipe_id',$recipe_id);
    				$this->db->where('sub_rc_item_id',$sub_item_ids[$i]);
    				$this->db->update('eshSub_recipe_item', $data4);
    				
    			}
    		}
			//insert to sub item
			$scount = count($sub_item_name);
			for($i=0;$i<$scount;$i++)
			{
				if($sub_item_name[$i] == '')
				{
    				$data4 = array(
    					'item_name' => $sub_item_name[$i],
    					'qty' => $sub_quantity[$i],
    					'price' => $sub_price[$i],
    					'uom' => $sub_uom[$i],
    					'total' => $sub_total[$i],
    					'recipe_id' => $recipe_id,
    					'rc_no' => $recipe_no,
    					'sub_recipe_id' => $sub_item_id[$i],
    					'category_id' => $sub_cat_id[$i],
    					'recipe_no' => $rcp_no[$i]
    				);
    				$this->db->insert('eshSub_recipe_item', $data4);
				}
			}
		}
	
	
	/*** Stock Update ***/	
	public function getProductDetail($branch_id){
		$query = $this->db->query("select R.recipe_id,R.pr_cat_id,C.pr_cat_name,R.rname as product_name,R.uom,'0' as closing_stk,R.branchname as branch_name from EshProduct_category C inner join eshRecipe R on C.pr_cat_id=R.pr_cat_id where R.branch_id='$branch_id' and R.status='Enabled' order by C.pr_cat_name,R.rname");
		return $query->result_array();
	}
	
	public function stock_update($stk_id) {
		$query = $this->db->query("SELECT *,DATE_FORMAT(stk_date, '%d-%m-%Y') as stk_date FROM stock_update where stck_id='$stk_id'");
		return $query->result();
	}

	public function stk_update_items($stk_id) {
		$query = $this->db->query("SELECT * FROM  stock_update_item where stck_id='$stk_id'");
		return $query->result();
	}
	
	public function stock_update_list($branch_id) {
		$query = $this->db->query("SELECT *, DATE_FORMAT(stk_date, '%d-%m-%Y') as stk_date FROM stock_update where branch_id='$branch_id' and stock_no LIKE 'S%' ORDER BY stck_id desc");
		return $query->result();
	}
	
	public function daily_stock_update_list($branch_id) {
		$query = $this->db->query("SELECT *, DATE_FORMAT(stk_date, '%d-%m-%Y') as stk_date FROM stock_update where branch_id='$branch_id' and stock_no LIKE 'D%' ORDER BY stck_id desc");
		return $query->result();
	}
	
	public function dailyStock_update_by_branch($data){
		$fdate =date('Y-m-d', strtotime($data['from_date']));
		$tdate =date('Y-m-d', strtotime($data['to_date']));
		$branch_id =$data['branch_id'] ;
		$query = $this->db->query("SELECT *, DATE_FORMAT(stk_date, '%d-%m-%Y') as stk_date FROM stock_update where stk_date between '$fdate' and '$tdate' and branch_id='$branch_id' and stock_no LIKE 'D%' ORDER BY stck_id desc");
		
		return $query->result();
	}

	public function stock_update_by_branch($data){
		$fdate =date('Y-m-d', strtotime($data['from_date']));
		$tdate =date('Y-m-d', strtotime($data['to_date']));
		$branch_id =$data['branch_id'] ;
		$query = $this->db->query("SELECT *, DATE_FORMAT(stk_date, '%d-%m-%Y') as stk_date FROM stock_update where stk_date between '$fdate' and '$tdate' and branch_id='$branch_id' and stock_no LIKE 'S%' ORDER BY stck_id desc");
		
		return $query->result();
	}
	
	/*** Damage ***/
	public function getDamage($damage_id) {
		$query = $this->db->query("SELECT *,DATE_FORMAT(damage_date, '%d-%m-%Y') as damage_date FROM damage_order_creation where damage_id='$damage_id'");
		return $query->result();
	}
	
	public function get_damage_item($damage_id) {
		$query = $this->db->query("SELECT * FROM  damage_order_creation D inner join damage_order_item T on D.damage_id=T.damage_id where D.damage_id='$damage_id'");
		return $query->result();
	}

	public function get_damage_list($branch_id) {
		$query = $this->db->query("SELECT *,damage_id as mid, DATE_FORMAT(damage_date, '%d-%m-%Y') as damage_date FROM damage_order_creation where branch_id='$branch_id' ORDER BY damage_id desc");
		return $query->result();
	}
	
	/*** PRODUCTION ***/
	
	
	public function getCatRecipe($branch_id){
		$query = $this->db->query("select * from EshProduct_category p inner join eshRecipe r on p.pr_cat_id=r.pr_cat_id where r.branch_id='$branch_id' and r.status='Enabled' order by rname asc");
		return $query->result();
	}
	
	public function addProduction($postdata)
		{
			extract($postdata);
			$prd_date = date("Y-m-d", strtotime($prd_date));
			$prd_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			$this->db->select('MAX(bno) as bno',false);
			$this->db->where('branch_id',$branch_id);
			$result = $this->db->get('billdetails')->row();
			$bno = $result->bno;
			if($bno == 0){
				$bno = 1;
			}
			else{
				$bno = $bno+1;
			}
			$bill_no = "BOM"."/".$branch_name."/".$bno;
			
			$k=0;
			for($j=0;$j<count($actual_yeild);$j++)
			{
				if($actual_yeild[$j]!='0' && $actual_yeild[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			$data = array('bno'=> $bno,
			'bill_id'=> $bill_no,
			'pr_cat_id'=> $category,
			'orderdate'=> $prd_date,
			'ordertime'=> $prd_time,
			'chef'=> $chef,
			'outlet'=> $full_name,
			'branch_id'=> $branch_id
			);
			$this->db->insert('billdetails', $data);
			$bill_id = $this->db->insert_id();
			}
			
			if($bill_id)
			{
			$count = count($pname);
			for($i=0;$i<$count;$i++)
			{
				$q1 = $this->db->query("select * from eshRecipe where recipe_id='$pname[$i]'");
				if($q1->num_rows() > 0)
				{
					$row = $q1->row_array();
					$pstock[$i] = $row['production_stock'];
					$pstock1[$i] = $pstock[$i] + $actual_yeild[$i];
					
					$q2 = $this->db->query("update eshRecipe set production_stock='$pstock1[$i]' where recipe_id='$pname[$i]'");
				}
				$data2 = array(
					'pname' => $names[$i],
					'uom' => $uom[$i],
					'actual_yeild' => $actual_yeild[$i],
					'yeild' => $yeild[$i],
					'billno' => $bill_id,
					'recipe_id' => $rc_id[$i],
					'recipe_no' => $rc_no[$i],
					'pr_cat_id' => $category
					);
				$this->db->insert('bom_product', $data2);
				
				$data3 = array(
					'item_name' => $names[$i],
					'trans_ref_no' => $bill_no,
					'trans_type'=>'BOM',
					'transaction_date' => $prd_date,
					'opening_stock' => $pstock[$i],
					'in_qty' => $actual_yeild[$i],
					'closing_stock' => $pstock1[$i],
					'last_modified' => $lm,
					'branchname' => $branch_name,
					'item_id' => $rc_id[$i],
					'recipe_no' => $rc_no[$i],
					'category_id' => $category,
					'branch_id' => $branch_id
					);
				$this->db->insert('stock_detail', $data3);
			}
		}
			return $bill_id;
		}
		
		public function getProduction($bid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(orderdate, '%d-%m-%Y') as orderdate FROM billdetails where billno='$bid'");
			return $query->result();	
		}
		
		public function getProductionItem($bid)
		{
			$query = $this->db->query("SELECT * FROM  bom_product where billno='$bid'");
			return $query->result();	
		}
		
		public function getProductionList($branch_id)
		{
			$query = $this->db->query("select *,DATE_FORMAT(orderdate, '%d-%m-%Y') as orderdate from billdetails where branch_id='$branch_id' order by billno desc");
			return $query->result();	
		}
		
    	public function get_RcpDetails($iname,$br_id)
    	{
    		$query = $this->db->query("select rname,uom,price,tax,recipe_id,pr_cat_id,recipe_no,yeild,production_stock from eshRecipe where recipe_id='$iname' and branch_id='$br_id'");//20 4
    		$row=$query->row_array();
    		if($row)
    		{
    			$price = $row['price'];
    			$tax = $row['tax'];
    			$tax_a = ($price * $tax)/100;
    			$tot_price = $price + $tax_a;
    			$data=array("rname" => $row['rname'], "uom" => $row['uom'], "price" => $tot_price, "recipe_id" => $row['recipe_id'], "pr_cat_id" => $row['pr_cat_id'], "recipe_no" => $row['recipe_no'], "yeild" => $row['yeild'], "aprice"=> $row['price'], "tax"=> $row['tax'], "stock"=> $row['production_stock']);
    			echo json_encode($data);
    		}
    		else
    		{
    			$data = array("uom" => '0');
    			echo json_encode($data);
    		}
    	}
    	
    	public function get_RecipeDetails($iname,$br_id)
    	{
    		$query = $this->db->query("select rname,uom,price,tax,recipe_id,pr_cat_id,recipe_no,production_stock from eshRecipe where rname='$iname' and branch_id='$br_id'");
    		$row=$query->row_array();
    		if($row)
    		{
    			$price = $row['price'];
    			$tax = $row['tax'];
    			$tax_a = ($price * $tax)/100;
    			$tot_price = $price + $tax_a;
    			$data=array("rname" => $row['rname'], "uom" => $row['uom'], "price" => $tot_price, "recipe_id" => $row['recipe_id'], "pr_cat_id" => $row['pr_cat_id'], "recipe_no" => $row['recipe_no'], "aprice" => $row['price'], "tax" => $row['tax'], "stock" => $row['tax']);
    			echo json_encode($data);
    		}
    		else
    		{
    			$data = array("uom" => '0');
    			echo json_encode($data);
    		}
    	}
    	
    	public function get_ItemDetails($iname,$br_id)
	{
		$query = $this->db->query("select item_name,uom,item_price,item_tax,stock_item,item_id,category_id,itm_id from item_creation where item_name='$iname' and branchname='ESH'");
		$row=$query->row_array();
		if($row)
		{
			$price = $row['item_price'];
			$tax = $row['item_tax'];
			$tax_a = ($price * $tax)/100;
			$tot_price = $price + $tax_a;
			$data=array("item_name" => $row['item_name'], "uom" => $row['uom'], "item_price" => $tot_price, "item_tax" => $row['item_tax'], "item_id" => $row['item_id'], "stock_item"=> $row['stock_item'], "category_id" => $row['category_id'], "itm_id" => $row['itm_id']);
			echo json_encode($data);
		}
		else
		{
			$data = array("uom" => '0');
			echo json_encode($data);
		}
	}
	
	public function get_rcpbranch()
	{
		$query = $this->db->query("select branch_id,branch_name from branch where branch_name not like 'ST%' and branch_name in ('ESH','ESH-TDR','ESH-IND','ESH-CHN','ESH-PNT','ESH-PK','ESH-HK','ESH-SVC','ESH-KTN','ESH-STR2')");
		return $query->result();
	}
	
	public function getcatdata1($branchname){
	    $branchname = $_SESSION['branch_name'];
	    if($branchname=='ESH-GDW'){
	         $query = $this->db->query("select I.item_id,I.category_id,C.category_name,I.item_name,I.uom,'0' as closing_stk,I.branchname as branch_name from category C inner join esh_godown I on C.category_id=I.category_id order by C.category_name,I.item_name");
	    }else{
	        $query = $this->db->query("select I.item_id,I.category_id,C.category_name,I.item_name,I.uom,'0' as closing_stk,I.branchname as branch_name from category C inner join item_creation I on C.category_id=I.category_id where I.branchname='$branchname' and I.status='Enabled' order by C.category_name,I.item_name");
	    }
		
		return $query->result_array();
	}
	
	public function getGPresentStock()
	{
		$query = $this->db->query("SELECT `gd_id`, `item_name`, `uom`, `price`, `tax`, `stock`, `from_branchname`, `branchname`, `item_id`, `itm_id`, `category_id` FROM `esh_godown`");
		return $query->result();	
	}
	
	public function get_GDWItems()
	{
		$query = $this->db->query("SELECT * from esh_godown");
		return $query->result();
	}
	
	public function get_users($branch_id,$smod_id){
		$query = $this->db->query("SELECT * from user_access where branch_id='$branch_id' and module_id='$smod_id'");
		return $query->result();	
	}
	
	public function get_GDWItemDetails($iname,$br_id)
	{
		$query = $this->db->query("SELECT `gd_id`, `item_name`, `uom`, `price`, `tax`, `stock`, `from_branchname`, `branchname`, `item_id`, `itm_id`, `category_id` FROM `esh_godown` WHERE  item_name='$iname'");
		$row=$query->row_array();
		if($row)
		{
			$price = $row['price'];
			$tax = $row['tax'];
			$tax_a = ($price * $tax)/100;
			$tot_price = $price + $tax_a;
			$data=array("item_name" => $row['item_name'], "uom" => $row['uom'], "item_price" => $tot_price, "item_tax" => $row['tax'], "item_id" => $row['item_id'], "stock_item"=> $row['stock'], "category_id" => $row['category_id'], "itm_id" => $row['itm_id']);
			echo json_encode($data);
		}
		else
		{
			$data = array("uom" => '0');
			echo json_encode($data);
		}
	}
	
	public function addGdwStkTransfer($postdata)
	{
		extract($postdata);
		$st_trans_date = date("Y-m-d", strtotime($st_trans_date));
		$order_time = date("h:i A");
		$lm=date("Y-m-dH:i:s",time());
		$this->db->select('MAX(st_tr_no) as st_tr_no',false);
		$this->db->where('frm_branchname',$branch);
		$result = $this->db->get('stock_transfer')->row();
		$st_tr_no = $result->st_tr_no;
		if($st_tr_no == 0){
			$st_tr_no = 1;
		}
		else{
			$st_tr_no = $st_tr_no+1;
		}
		$stk_tr_no = "TNS"."/".$branch."-".$branch_name."/".$st_tr_no;
		
		$k=0;
		for($j=0;$j<count($quantity);$j++)
		{
			if($quantity[$j]!='0' && $quantity[$j]!='')
			{
				$k=$k+1;
			}
		}
		if($k>0)
		{
		$data = array('st_tr_no'=> $st_tr_no,
		'stk_tr_no'=> $stk_tr_no,
		'stk_tr_date'=> $st_trans_date,
		'frm_branchname'=> $branch,
		'to_branchname'=> $branch_name,
		'total'=> $total,
		'user_name'=> $full_name,
		'tr_time'=> $order_time,
		'branch_id'=> $branch_id
		);
		$this->db->insert('stock_transfer', $data);
		$sid = $this->db->insert_id();
		}
		
		if($sid)
		{
		//insert to sales price
		$count = count($item_name);
		for($i=0;$i<$count;$i++)
		{
			$q1 = $this->db->query("select * from esh_godown where item_id='$item_id[$i]'");
			if($q1->num_rows() > 0)
			{
				$row = $q1->row_array();
				$qty[$i] = $row['stock'];
				$qty1[$i] = $qty[$i] - $quantity[$i];
				
				$q2 = $this->db->query("UPDATE esh_godown set stock='$qty1[$i]' WHERE item_id= '$item_id[$i]'");
			}
			$data2 = array(
				'item_name' => $item_name[$i],
				'uom' => $uom[$i],
				'present_stock' => $close_stock[$i],
				'quantity' => $quantity[$i],
				'price' => $price[$i],
				'total_amount' => $total_amount[$i],
				'remarks' => $remarks[$i],
				'item_id' => $item_id[$i],
				'stk_tr_id' => $sid,
				'itm_id' => $itm_id[$i],
				'category_id' => $category_id[$i]
				);
			$this->db->insert('stock_transfer_item', $data2);
			
			if($branch_name == 'ESH')
			{
				$q5 = $this->db->query("select * from item_creation where item_name='$item_name[$i]' and branchname='$branch_name'");
				if($q5->num_rows() > 0)
				{
					$row4 = $q5->row_array();
					$stock[$i] = $row4['stock_item'];
					$stk[$i] = $stock[$i] + $quantity[$i];
					$item_sid[$i] = $row4['item_id'];
					
					$q6 = $this->db->query("UPDATE item_creation set stock_item='$stk[$i]' WHERE item_name='$item_name[$i]' and branchname='$branch_name'");
				}
				$br = $this->db->query("select branch_id from branch where branch_name='$branch_name'");
				$brow = $br->row_array();
				$br_id = $brow['branch_id'];
				
				$data5 = array(
					'item_name' => $item_name[$i],
					'trans_ref_no' => $stk_tr_no,
					'trans_type'=>'transIn',
					'transaction_date' => $st_trans_date,
					'opening_stock' => $stock[$i],
					'in_qty' => $quantity[$i],
					'closing_stock' => $stk[$i],
					'last_modified' => $lm,
					'branchname' => $branch_name,
					'item_id' => $item_sid[$i],
					'itm_id' => $itm_id[$i],
					'category_id' => $category_id[$i],
					'branch_id' => $br_id
					);
				$this->db->insert('stock_detail', $data5);
			}
			$data6 = array(
				'item_name' => $item_name[$i],
				'trans_ref_no' => $stk_tr_no,
				'trans_type'=>'transOut',
				'transaction_date' => $st_trans_date,
				'opening_stock' => $qty[$i],
				'out_qty' => $quantity[$i],
				'closing_stock' => $qty1[$i],
				'last_modified' => $lm,
				'branchname' => $branch,
				'item_id' => $item_id[$i],
				'itm_id' => $itm_id[$i],
				'category_id' => $category_id[$i],
				'branch_id' => $branch_id
				);
			$this->db->insert('stock_detail', $data6);
		}
	}
		return $sid;
	}
	
	public function getStkTransfer($sid)
	{
		$query = $this->db->query("select stk_tr_no,stk_tr_date,to_branchname,user_name from stock_transfer where stk_tr_id='$sid'");
		return $query->result();	
	}
	
	public function getStkTransferItem($sid)
	{
		$query = $this->db->query("select item_name,uom,quantity,remarks from stock_transfer_item where stk_tr_id='$sid'");
		return $query->result();	
	}
	
	public function get_godown_stk_transfer_list($branch_name)
	{
		$query = $this->db->query("select *,DATE_FORMAT(stk_tr_date, '%d-%m-%Y') as stk_tr_date from stock_transfer where frm_branchname='$branch_name' ORDER by stk_tr_id");
		return $query->result();	
	}
	
	public function getGDWStkTransferResult($data)
	{
		$f_date =date('Y-m-d', strtotime($data['from_date']));
		$t_date =date('Y-m-d', strtotime($data['to_date']));
		$branch_name = $_SESSION['branch_name'];
		$branch_id = $data['branch_id'];
		$iname = $data['item_name'];
		if($f_date!="" && $t_date!="" && $iname=="")
		{
			$query = $this->db->query("select *,DATE_FORMAT(stk_tr_date, '%d-%m-%Y') as stk_tr_date from stock_transfer where frm_branchname='$branch_name' and stk_tr_date between '$f_date' and '$t_date' ORDER by stk_tr_id");
			
		}
		else if($f_date!="" && $t_date!=""  && $iname!="")
		{
			if($iname=="All")
			{
				$query = $this->db->query("SELECT s.item_name,st.to_branchname,sum(s.quantity)as qty,sum(s.total_amount) as total FROM stock_transfer_item s inner join stock_transfer st on s.stk_tr_id=st.stk_tr_id WHERE st.to_branchname='ESH' and st.frm_branchname='ESH-GDW' and st.stk_tr_date between '$f_date' and '$t_date' group by s.item_name");
			}
			else if($iname!="All")
			{
				$query = $this->db->query("SELECT s.item_name,st.to_branchname,sum(s.quantity)as qty,sum(s.total_amount) as total FROM stock_transfer_item s inner join stock_transfer st on s.stk_tr_id=st.stk_tr_id WHERE s.item_name='$iname' and st.frm_branchname='ESH-GDW' and st.stk_tr_date between '$f_date' and '$t_date' group by st.to_branchname");
			}
		}
		return $query->result_array();	
	}
}