<?php
	class Materialrequest_model extends CI_model
	{
		public function __construct()
		{
			parent::__construct();
			$this->load->database();
		}
		public function addRequest($postdata)
		{
			extract($postdata);
			$req_date = date("Y-m-d", strtotime($req_date));
			$order_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			$this->db->select('MAX(req_no) as req_no',false);
			$this->db->where('branch_id',$branch_id);
			$result = $this->db->get('material_request')->row();
			$req_no = $result->req_no;
			if($req_no == 0){
				$req_no = 1;
			}
			else{
				$req_no = $req_no+1;
			}
			$order_no = $branch_name."/REQ/".$req_no;
			
			$k=0;
			for($j=0;$j<count($quantity);$j++)
			{
				if($quantity[$j]!='0' && $quantity[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			$data = array('req_no'=> $req_no,
			'mat_req_no'=> $order_no,
			'request_date'=> $req_date,
			'store'=> $store,
			'branchname'=> $branch_name,
			'status'=> 'Pending',
			'receipt_status'=> 'Pending',
			'request_time'=> $order_time,
			'branch_id'=> $branch_id
			);
			$this->db->insert('material_request', $data);
			$rqid = $this->db->insert_id();
			}
			
			if($rqid)
			{
			$count = count($item_name);
			for($i=0;$i<$count;$i++)
			{
			    if($quantity[$i]!='0' && $quantity[$i]!='')
			    {
			    if($store == 'Eshanya')
			    {
			        $q1 = $this->db->query("select i.item_name,i.stock_item,i.item_id,i.itm_id,i.uom,i.category_id,ic.item_price,ic.item_tax from(select * from item_creation where item_name='$item_name[$i]' and branch_id='$branch_id') i inner join (select * from item_creation where item_name='$item_name[$i]' and branchname='ESH') ic on i.item_name=ic.item_name");
			    }
			    else
			    {
			        $q1 = $this->db->query("select i.item_name,i.stock_item,i.item_id,i.itm_id,i.uom,i.category_id,ic.item_price,ic.item_tax from(select * from item_creation where item_name='$item_name[$i]' and branch_id='$branch_id') i inner join (select * from item_creation where item_name='$item_name[$i]' and branchname='CW') ic on i.item_name=ic.item_name");
			    }
					if($q1->num_rows() > 0)
					{
						$row = $q1->row_array();
						$qty[$i] = $row['stock_item'];
						$item_id1[$i] = $row['item_id'];
						$itm_id1[$i] = $row['itm_id'];
						$category_id1[$i] = $row['category_id'];
						$uom1[$i] = $row['uom'];
						$item_price[$i] = $row['item_price'];
						$item_tax[$i] = $row['item_tax'];
						
			    //calculation
		        $totbasic[$i] = round(((float)$item_price[$i] * (float)$quantity[$i]),2);
			    $taxamt[$i] = round((($totbasic[$i] * $item_tax[$i])/100),2);
			    $totalprice[$i] = round(($totbasic[$i] + $taxamt[$i]),2);
			    
				$data2 = array(
					'item_name' => $item_name[$i],
					'uom' => $uom1[$i],
					'required_qty' => $quantity[$i],
					'item_price' => $item_price[$i],
					'total_price' => $totbasic[$i],
					'tax' => $item_tax[$i],
					'tax_amount' => $taxamt[$i],
					'total_amount' => $totalprice[$i],
					'remarks' => $remarks[$i],
					'request_id' => $rqid,
					'item_id' => $item_id1[$i],
					'category_id' => $category_id1[$i],
					'status' => 'Pending',
					'receipt_status' => 'Pending',
					'itm_id' => $itm_id1[$i]
					);
				$this->db->insert('material_request_item', $data2);
					}
			}
			}
		}
			return $rqid;
		}
		
		public function getMatRequest($rid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(request_date, '%d-%m-%Y') as request_date FROM material_request where request_id='$rid'");
			return $query->result();	
		}
		
		public function getMatRequestItem($rid)
		{
			$query = $this->db->query("SELECT * FROM  material_request_item where request_id='$rid'");
			return $query->result();	
		}
		
		public function getRequestList($branch_id)
		{
			$query = $this->db->query("SELECT *, DATE_FORMAT(request_date, '%d-%m-%Y') as request_date,DATE_FORMAT(approval_date, '%d-%m-%Y') as approval_date FROM material_request where branch_id='$branch_id' and receipt_status='Pending' ORDER BY request_id desc");
			return $query->result();	
		}
		
		public function updateRequest($postdata)
		{
			extract($postdata);
			$count = count($item_names);
			for($i=0;$i<$count;$i++)
			{
			    if($quantitys[$i]!='0' && $quantitys[$i]!='')
			    {
				$data2 = array(
					'required_qty' => $quantitys[$i],
					'item_price' => $prices[$i],
					'total_price' => $ttl_prices[$i],
					'tax' => $taxs[$i],
					'tax_amount' => $tax_amts[$i],
					'total_amount' => $totals[$i],
					'remarks' => $remarkss[$i],
				);
				$this->db->where('request_item_id', $req_item_id[$i]);
				$this->db->update('material_request_item', $data2);
			    }
			}
			
			$count2 = count($item_name);
			for($i=0;$i<$count2;$i++)
			{
			    if($quantity[$i]!='0' && $quantity[$i]!='')
			    {
				$data3 = array(
					'item_name' => $item_name[$i],
					'uom' => $uom[$i],
					'required_qty' => $quantity[$i],
					'item_price' => $price[$i],
					'total_price' => $ttl_price[$i],
					'tax' => $tax[$i],
					'tax_amount' => $tax_amt[$i],
					'total_amount' => $total[$i],
					'remarks' => $remarks[$i],
					'request_id' => $req_id,
					'item_id' => $item_id[$i],
					'category_id' => $cat_id[$i],
					'status' => 'Pending',
					'receipt_status' => 'Pending',
					'itm_id' => $itm_id[$i]
					);
				$this->db->insert('material_request_item', $data3);
			    }
			}
			return $req_id;
		}
		
		public function getIssuePendingList($uname)
		{
			$query = $this->db->query("SELECT *, DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,DATE_FORMAT(M.approval_date, '%d-%m-%Y') as approval_date FROM material_request M inner join user L on M.branch_id=L.branch_id where (M.status='Pending' or M.status='Approved') and M.store='$uname' ORDER BY request_id desc");
			return $query->result();	
		}
		
		public function getMatRequestIss($rid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join user L on M.branch_id=L.branch_id where request_id='$rid'");
			return $query->result();	
		}
		
		public function getMatRequestIssItem($rid)
		{
			$branch_name = $_SESSION['branch_name'];
			//$query = $this->db->query("SELECT *, (R.required_qty-R.recieved_qty) as item_balance_qty FROM material_request M inner join material_request_item R on  M.request_id=R.request_id inner join item_creation I on I.item_name=R.item_name where R.request_id='$rid' and I.branchname='CW'");
			$query = $this->db->query("SELECT *, (R.required_qty-R.recieved_qty) as item_balance_qty FROM material_request M inner join material_request_item R on  M.request_id=R.request_id inner join item_creation I on I.item_name=R.item_name where R.request_id='$rid' and I.branchname='$branch_name'");
			return $query->result();	
		}
		
		public function addIssue($postdata)
		{
			extract($postdata);
			$issue_date = date("Y-m-d", strtotime($issue_date));
			$issue_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			
			$k=0;
			$gtotal=0;
			for($j=0;$j<count($is_quantity);$j++)
			{
			    if($is_quantity[$j]!='0' && $is_quantity[$j]!='')
			    {
			        $k=$k+1;
			        $gtotal=$gtotal+$total_amount[$j];
			        $totalprice[$j] = round(($is_price[$j] * $is_quantity[$j]),2);
    				$taxamt[$j] = round((($totalprice[$j] * $tax[$j])/100),2);
    				$totalamount[$j] = round(($totalprice[$j] + $taxamt[$j]),2);
			        $gtotal=$gtotal+$totalamount[$j];
			    }
			}
			if($k>0)
			{
				$this->db->select('MAX(is_no) as is_no',false);
				$this->db->where('branch_id',$branch_id);
				$result = $this->db->get('issues_order_creation')->row();
				$is_no = $result->is_no;
				if($is_no == 0){
					$is_no = 1;
				}
				else{
					$is_no = $is_no+1;
				}
				$issue_no = "ISSU"."/".$branchname."/".$outlet_branch."/".$is_no;
				
				$data = array('is_no'=> $is_no,
				'issue_no'=> $issue_no,
				'issue_date'=> $issue_date,
				'issue_time'=> $issue_time,
				'outlet_name'=> $outlet,
				'total'=> $gtotal,
				'branchname'=> $branchname,
				'request_id'=> $req_id,
				'issue_status'=> 'Pending',
				'user_name' => $user_name,
				'branch_id' => $branch_id
				);
				$this->db->insert('issues_order_creation', $data);
				$isid = $this->db->insert_id();
			}
			if(isset($isid))
			{
				$count = count($item_name);
				for($i=0;$i<$count;$i++)
				{
					$q1 = $this->db->query("select * from item_creation where item_id='$item_id[$i]'");
					if($q1->num_rows() > 0)
					{
					    if($is_quantity[$i]!='0' && $is_quantity[$i]!='')
					    {
    						$row = $q1->row_array();
    						$qty[$i] = $row['stock_item'];
        					$qty1[$i] = (float)$qty[$i] - (float)$is_quantity[$i];
        					
        					//calculation
        					$totalprice[$i] = round(((float)$is_price[$i] * (float)$is_quantity[$i]),2);
        				    $taxamt[$i] = round((($totalprice[$i] * $tax[$i])/100),2);
        				    $totalamount[$i] = round(($totalprice[$i] + (float)$taxamt[$i]),2);
    						
    						$data2 = array(
    							'indent_item_name' => $item_name[$i],
    							'indent_uom' => $uom[$i],
    							'stock_transfer' => $qty[$i],
    							'indent_qty' => $is_quantity[$i],
    							'issues_price' => $is_price[$i],
    							'basic_price' => $totalprice[$i],
    							'tax' => $tax[$i],
    							'tax_amount' => $taxamt[$i],
    							'total_amount' => $totalamount[$i],
    							'indent_remarks' => $remarks[$i],
    							'issue_id' => $isid,
    							'request_item_id' => $req_item_id[$i],
    							'item_id' => $item_id[$i],
    							'rcv_status' => 'Pending',
    							'cat_id' => $cat_id[$i],
    							'itm_id' => $itm_id[$i]
    						);
    						$this->db->insert('issues_order_item', $data2);
    						$isitid = $this->db->insert_id();
    						
    						$q2 = $this->db->query("UPDATE item_creation set stock_item='$qty1[$i]' WHERE item_id= '$item_id[$i]'");
    						
    						$data3 = array(
    							'item_name' => $item_name[$i],
    							'trans_ref_no' => $issue_no,
    							'trans_type'=>'Issue',
    							'transaction_date' => $issue_date,
    							'opening_stock' => $qty[$i],
    							'out_qty' => $is_quantity[$i],
    							'closing_stock' => $qty1[$i],
    							'last_modified' => $lm,
    							'branchname' => $branchname,
    							'item_id' => $item_id[$i],
    							'itm_id' => $itm_id[$i],
    							'category_id' => $cat_id[$i],
    							'branch_id' => $branch_id	
    						);
    						$this->db->insert('stock_detail', $data3);
    						
    						
    						$rc_qty[$i] = (float)$is_quantity[$i] + (float)$issued_qty[$i];
    						
    						$q3 = $this->db->query("update material_request_item set recieved_qty='$rc_qty[$i]' where request_item_id='$req_item_id[$i]'");
    						
    						if (empty($is_quantity[$i])) {
    							$q4 = $this->db->query("DELETE FROM issues_order_item WHERE issue_order_id='$isitid'");
    						}
    						if($rc_qty[$i] == $req_qty[$i] && $is_quantity[$i]!='') {
    							$q5 = $this->db->query("update material_request_item set status='Closed' where request_item_id='$req_item_id[$i]'");
    						}
    						$q6 = $this->db->query("SELECT count(*) as `num` FROM material_request_item where request_id='$req_id'");
    						if($q6->num_rows() > 0)
    						{
    							$row1 = $q6->row_array();
    							$count1 = $row1['num'];
    						}
    						$q7 = $this->db->query("SELECT count(*) as `num1` FROM material_request_item where status='Closed' and request_id='$req_id'");
    						if($q7->num_rows() > 0)
    						{
    							$row2 = $q7->row_array();
    							$count2 = $row2['num1'];
    						}
					    }
					}
				}
			return $isid;
		}
		}
		
		public function getIssue($isid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,M.branchname as out_branch FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id where I.issue_id='$isid'");
			return $query->result();	
		}
		
		public function getIssueItem($isid)
		{
			$query = $this->db->query("SELECT * FROM material_request M inner join material_request_item MI on M.request_id=MI.request_id inner join issues_order_item I on MI.request_item_id=I.request_item_id where I.issue_id='$isid' and I.indent_qty !=''");
			return $query->result();	
		}
		
		public function getRequesIssuetList($req_id)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(request_date, '%d-%m-%Y') as request_date FROM material_request where request_id='$req_id'");
			return $query->result();	
		}
		
		public function getRequesIssuetLists($req_id)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id where I.request_id='$req_id'");
			return $query->result();	
		}
		
		public function getIssuedItem($issue_id)
		{
			$query = $this->db->query("SELECT *, R.item_id as itm_id,(R.required_qty-R.recieved_qty) as item_balance_qty FROM material_request M inner join material_request_item R on  M.request_id=R.request_id inner join issues_order_item O on R.request_item_id=O.request_item_id inner join  item_creation I on O.item_id=I.item_id where O.issue_id='$issue_id'");
			return $query->result();
		}
		
		public function addInward($postdata)
		{
			extract($postdata);
			$inward_date = date("Y-m-d", strtotime($inward_date));
			$inward_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			
			$this->db->select('MAX(rec_no) as rec_no',false);
			$this->db->where('branch_id',$branch_id);
			$result = $this->db->get('request_receipt')->row();
			$rec_no = $result->rec_no;
			if($rec_no == 0){
				$rec_no = 1;
			}
			else{
				$rec_no = $rec_no+1;
			}
			$receipt_no = "RCP"."/".$branchname."/".$rec_no;
			
			$k=0;
			for($j=0;$j<count($in_quantity);$j++)
			{
				if($in_quantity[$j]!='0' && $in_quantity[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			$data = array('rec_no'=> $rec_no,
			'req_rec_no'=> $receipt_no,
			'receipt_date'=> $inward_date,
			'receipt_time'=> $inward_time,
			'branchname'=> $branchname,
			'receipt_approval'=> 'Pending',
			'store'=> $store,
			'request_id'=> $req_id,
			'issue_id'=> $iss_id,
			'branch_id' => $branch_id
			);
			$this->db->insert('request_receipt', $data);
			$rcid = $this->db->insert_id();
			}
			
			if(isset($rcid))
			{
			$count = count($item_name);
			for($i=0;$i<$count;$i++)
			{
			    if($in_quantity[$i] != '0' && $in_quantity[$i] != '')
				{
				if($bal_iss_qty[$i] >= $in_quantity[$i])
				{
					$qty[$i] = (float)$in_quantity[$i] + (float)$received_qty[$i];
					$qty2[$i] = (float)$in_quantity[$i] + (float)$rec_issue_qty[$i];
					
					$q1 = $this->db->query("update material_request_item set receipt_qty='$qty[$i]' where request_item_id='$req_item_id[$i]'");
					$q2 = $this->db->query("update issues_order_item set rec_issue_qty='$qty2[$i]' where issue_order_id='$issue_item_id[$i]'");
					
					$q3 = $this->db->query("select * from item_creation where item_id='$item_id[$i]'");
					if($q3->num_rows() > 0)
					{
						$row = $q3->row_array();
						$stock[$i] = $row['stock_item'];
						$stk[$i] = (float)$stock[$i] + (float)$in_quantity[$i];
						$direct_sales[$i] = $row['direct_sales'];
						$itm_id[$i]= $row['itm_id'];
						$q4 = $this->db->query("SELECT U.user_id,U.username,U.full_name,U.password,G.group_name,U.ph_no,U.user_group,U.branch_id FROM user U,user_group G where U.user_group=G.group_id and U.branch_id='$branch_id'");
						$row2 = $q4->row_array();
						$group = $row2['group_name'];
						if($direct_sales[$i] == 'Yes' && $group == 'Counter')
						{
							$q5 = $this->db->query("select * from recipe where raw_item_code='$item_id[$i]' and branchname='$branchname'");
							if($q5->num_rows() > 0)
							{
								$row3 = $q5->row_array();
								$qty[$i] = $row3['production_stock'];
								$qty1[$i] = $qty[$i] + $in_quantity[$i];
								$recipe_id[$i] = $row3['recipe_id'];
								$recipe_no[$i] = $row3['recipe_no'];
								$pr_cat_id[$i] = $row3['pr_cat_id'];
								
								$q6 = $this->db->query("UPDATE recipe set production_stock='$qty1[$i]' WHERE  raw_item_code='$item_id[$i]' and branchname='$branchname'");
							
								$data2 = array(
									'item_name' => $item_name[$i],
									'trans_ref_no' => $receipt_no,
									'trans_type'=>'Inward',
									'transaction_date' => $inward_date,
									'opening_stock' => $qty[$i],
									'in_qty' => $in_quantity[$i],
									'closing_stock' => $qty1[$i],
									'last_modified' => $lm,
									'branchname' => $branchname,
									'item_id' => $recipe_id[$i],
									'recipe_no' => $recipe_no[$i],
									'category_id' => $pr_cat_id[$i],
									'branch_id' => $branch_id	
								);
								$this->db->insert('stock_detail', $data2);
							}
						}
						else
						{
							$q7 = $this->db->query("UPDATE item_creation set stock_item='$stk[$i]' WHERE item_id='$item_id[$i]'");
							$data2 = array(
								'item_name' => $item_name[$i],
								'trans_ref_no' => $receipt_no,
								'trans_type'=>'Inward',
								'transaction_date' => $inward_date,
								'opening_stock' => $stock[$i],
								'in_qty' => $in_quantity[$i],
								'closing_stock' => $stk[$i],
								'last_modified' => $lm,
								'branchname' => $branchname,
								'item_id' => $item_id[$i],
								'itm_id' => $itm_id[$i],
								'category_id' => $cat_id[$i],
								'branch_id' => $branch_id	
							);
							$this->db->insert('stock_detail', $data2);
						}
						$data3 = array(
							'item_name' => $item_name[$i],
							'quantity' => $in_quantity[$i],
							'issued_qty' => $issued_qty[$i],
							'rc_item_price' => '0',
							'rc_total_price' => '0',
							'rc_tax' => '0',
							'rc_tax_amount' => '0',
							'rc_total_amount' => '0',
							'req_rec_id' => $rcid,
							'requset_item_id' => $req_item_id[$i],
							'issue_order_id' => $issue_item_id[$i],
							'item_id' => $item_id[$i],
							'itm_id' => $itm_id[$i],
							'category_id' => $cat_id[$i]
						);
						$this->db->insert('request_receipt_item', $data3);
						$rcitid = $this->db->insert_id();
					}
					if (empty($in_quantity[$i])) {
						$q8 = $this->db->query("DELETE FROM request_receipt_item WHERE receipt_item_id='$rcitid'");
					}
					$q9 = $this->db->query("select recieved_qty,receipt_qty from material_request_item where request_item_id='$req_item_id[$i]'");
					if($q9->num_rows() > 0)
					{
						$row4 = $q9->row_array();
						$issued_quantity[$i] = $row4['receipt_qty'];
					}
					if($issued_quantity[$i] == $req_qty[$i] && $in_quantity[$i]!='') {
						$q10 = $this->db->query("update material_request_item set receipt_status='Closed' where request_item_id='$req_item_id[$i]'");
					}
					$q11 = $this->db->query("SELECT count(*) as `num` FROM material_request_item where request_id='$req_id'");
					$row5 = $q11->row_array();
					$count1 = $row5['num'];
					
					$q12 = $this->db->query("SELECT count(*) as `num1` FROM material_request_item where receipt_status='Closed' and request_id='$req_id'");
					$row6 = $q12->row_array();
					$count2 = $row6['num1'];
					
					if($count1 == $count2) {
						$q13 = $this->db->query("update material_request set receipt_status='Closed',status='Closed' where request_id='$req_id'");
					}
					else{
						$q13 = $this->db->query("update material_request set receipt_status='Pending',status='Pending' where request_id='$req_id'");
					}
					$q14 = $this->db->query("select indent_qty,rec_issue_qty from issues_order_item where issue_order_id='$issue_item_id[$i]'");
					if($q14->num_rows() > 0)
					{
						$row7 = $q14->row_array();
						$isd_qty[$i] = $row7['indent_qty'];
						$rcvd_qty[$i] = $row7['rec_issue_qty'];
						if($isd_qty[$i] == $rcvd_qty[$i])
						{
							$q15 = $this->db->query("update issues_order_item set rcv_status='Closed' where issue_order_id='$issue_item_id[$i]'");
						}
						$q16 = $this->db->query("SELECT count(*) as `num` FROM issues_order_item where issue_id='$iss_id'");
						$row7 = $q16->row_array();
						$count3 = $row7['num'];
						$q17 = $this->db->query("SELECT count(*) as `num1` FROM issues_order_item where rcv_status='Closed' and issue_id='$iss_id'");
						$row8 = $q17->row_array();
						$count4 = $row8['num1'];
						if($count3 == $count4 ) {
							$q18 = $this->db->query("update issues_order_creation set issue_status='Accepted' where issue_id='$iss_id'");
						}
					}
				}
				}	
			}
		}
		if(isset($rcid))
		{
			return $rcid;
		}
		}
		
		public function getInward($inid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(IO.issue_date, '%d-%m-%Y') as issue_date FROM material_request M inner join issues_order_creation IO on M.request_id=IO.request_id inner join request_receipt R on IO.issue_id=R.issue_id where R.req_rec_id='$inid'");
			return $query->result();
		}
		
		public function getInwardItem($inid)
		{
			$query = $this->db->query("SELECT * FROM material_request M inner join material_request_item MI on M.request_id=MI.request_id inner join issues_order_item IT on MI.request_item_id=IT.request_item_id inner join request_receipt_item RI on IT.issue_order_id=RI.issue_order_id where RI.req_rec_id='$inid' and RI.quantity !=''");
			return $query->result();
		}
		
		public function getMatReqItem($req_id)
		{
			$query = $this->db->query("SELECT *, (R.required_qty-R.recieved_qty) as item_balance_qty,R.item_price as rate FROM material_request M inner join material_request_item R on  M.request_id=R.request_id inner join item_creation I on I.item_id=R.item_id where R.request_id='$req_id'");
			return $query->result();
		}
		
		public function addPrideInward($postdata)
		{
			extract($postdata);
			$inward_date = date("Y-m-d", strtotime($rcdate));
			$inward_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			
			$this->db->select('MAX(rec_no) as rec_no',false);
			$this->db->where('branch_id',$brid);
			$result = $this->db->get('request_receipt')->row();
			$rec_no = $result->rec_no;
			if($rec_no == 0){
				$rec_no = 1;
			}
			else{
				$rec_no = $rec_no+1;
			}
			$receipt_no = "RCP"."/".$brname."/".$rec_no;
			
			$k=0;
			for($j=0;$j<count($in_qty);$j++)
			{
				if($in_qty[$j]!='0' && $in_qty[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			/*if(!empty($_FILES['dc_upload']['name'])){
				$config['upload_path'] = 'dc_upload/';
				$config['allowed_types'] = 'jpg|jpeg|png|gif|JPG|JPEG|PNG|GIF';
				$filename = 'upload/'.$_FILES['dc_upload']['name'];
			}
			$randno=rand(10000, 990000);
			foreach($_FILES['dc_upload']['name'] as $key=>$val){
				$extension = pathinfo($_FILES["dc_upload"]["name"][$key], PATHINFO_EXTENSION);
				$fileName = 'bill_upload/'.$randno. "_". time().".".$extension;
				$filename .= $fileName;
			}*/
			$insertValuesSQL = $insertfiles = '';
			$randno=rand(10000, 990000);
			foreach($_FILES['dc_upload']['name'] as $key=>$val){
				$extension = pathinfo($_FILES["dc_upload"]["name"][$key], PATHINFO_EXTENSION);
				$fileName = 'bill_upload/'.rand(10000, 990000). "_". time().".".$extension;
				$insertfiles .= $fileName;
			}
			
			if(!empty(array_filter($_FILES['dc_upload']['name']))){
				$data = array('rec_no'=> $rec_no,
					'req_rec_no'=> $receipt_no,
					'invoice_no' => $dcno,
					'receipt_date'=> $inward_date,
					'receipt_time'=> $inward_time,
					'branchname'=> $brname,
					'receipt_approval'=> 'Pending',
					'store'=> $str,
					'request_id'=> $reqid,
					'issue_id'=> '0',
					'bill_upload' => $insertfiles,
					'branch_id' => $brid
				);
				$this->db->insert('request_receipt', $data);
			}
			else{
				$data = array('rec_no'=> $rec_no,
					'req_rec_no'=> $receipt_no,
					'invoice_no' => $dcno,
					'receipt_date'=> $inward_date,
					'receipt_time'=> $inward_time,
					'branchname'=> $brname,
					'receipt_approval'=> 'Pending',
					'store'=> $str,
					'request_id'=> $reqid,
					'issue_id'=> '0',
					'branch_id' => $brid
				);
				$this->db->insert('request_receipt', $data);
			}
			$rcid = $this->db->insert_id();
			function compressImage($source, $destination, $quality) {

				$info = getimagesize($source);

				if ($info['mime'] == 'image/jpeg') 
				$image = imagecreatefromjpeg($source);

				elseif ($info['mime'] == 'image/gif') 
				$image = imagecreatefromgif($source);

				elseif ($info['mime'] == 'image/png') 
				$image = imagecreatefrompng($source);

				imagejpeg($image, $destination, $quality);

			}
			
			$folderName = date('M-Y');
			$targetDir = "bill_upload/".$folderName."/";
			if ( ! file_exists($targetDir) )
            {
                $create = mkdir($targetDir, 0777, TRUE);
                $createThumbsFolder = mkdir($targetDir . '/thumbs', 0777, TRUE);
                if ( ! $create || ! $createThumbsFolder)
                return;
            }
			$allowTypes = array('jpg','png','jpeg','gif', 'JPG', 'JPEG', 'PNG', 'GIF');
	
			//$statusMsg = $errorMsg = $insertValuesSQL = $errorUpload = $errorUploadType = '';
			if(!empty(array_filter($_FILES['dc_upload']['name']))){
				foreach($_FILES['dc_upload']['name'] as $key=>$val){
					// File upload path
					//$fileName = basename($_FILES['in_upload']['name'][$key]);
					$extension = pathinfo($_FILES["dc_upload"]["name"][$key], PATHINFO_EXTENSION);
					$fileName = rand(10000, 990000). "_". time().".".$extension;
					//$fileName1 = $grn_no . $fileName;
					$targetFilePath = $targetDir . $fileName;
				
					// Check whether file type is valid
					$fileType = pathinfo($_FILES["dc_upload"]["name"][$key],PATHINFO_EXTENSION);
					//$fileType = pathinfo($targetFilePath,PATHINFO_EXTENSION);
					if(in_array($fileType, $allowTypes)){
						// Upload file to server
						if(move_uploaded_file($_FILES["dc_upload"]["tmp_name"][$key], $targetFilePath)){
						$location = "bill_upload/".$folderName."/".$fileName;
							compressImage($targetFilePath,$location,25);
							// Image db insert sql
							$insertValuesSQL .= "('".$location."', NOW(), '".$rcid."','Pride Grn'),";
						}else{
							//$errorUpload .= $_FILES['in_upload']['name'][$key].', ';
						}
					}else{
						//$errorUploadType .= $_FILES['in_upload']['name'][$key].', ';
					}
				}
			
			$insertValuesSQL = trim($insertValuesSQL,',');
			$this->db->query("INSERT INTO uploaded_invoice (file_name, uploaded_on,invoice_ref_id,gstatus) VALUES $insertValuesSQL");
				//
			}
		}
			/*if(!empty($_FILES['dc_upload']['name'])){
				$config['upload_path'] = 'dc_upload/';
				$config['allowed_types'] = 'jpg|jpeg|png|gif|JPG|JPEG|PNG|GIF';
				$filename = $_FILES['dc_upload']['name'];
				$file_name = 'dc_upload/'.$_FILES['dc_upload']['name'];
				$config['file_name'] = $filename;
				//Load upload library and initialize configuration
				$this->load->library('upload',$config);
				$this->upload->initialize($config);
				
				if($this->upload->do_upload('dc_upload')){
					
					$data = $this->upload->data();  
					 $config['image_library'] = 'gd2';  
					 $config['source_image'] = 'dc_upload/'.$data["file_name"];  
					 $config['create_thumb'] = FALSE;  
					 $config['maintain_ratio'] = FALSE;  
					 $config['quality'] = '60%';  
					 $config['width'] = 200;  
					 $config['height'] = 200;  
					 $config['new_image'] = 'dc_upload/'.$data["file_name"];  
					 $this->load->library('image_lib', $config);  
					 $this->image_lib->resize();  
					 $image_data = array(  
						  'file_name' => $file_name,
						  'uploaded_on'=>date('Y-m-d H:i:s'),
						   'invoice_ref_id'=>$rcid,
						   'gstatus'=>'Pride Grn'
						  );  
					  $this->db->insert("uploaded_invoice", $image_data);
					}else{
					$dc_upload = '';
				}
			}else{
				$dc_upload = '';
			}*/
			if($rcid)
			{
			$count = count($itm_name);
			for($i=0;$i<$count;$i++)
			{
				$rcqty[$i] = $in_qty[$i] + $bal_qty[$i];
				
				$q1 = $this->db->query("update material_request_item set recieved_qty='$rcqty[$i]' where request_item_id='$rq_itm_id[$i]'");
				$q3 = $this->db->query("select * from item_creation where item_id='$itmid[$i]'");
				if($q3->num_rows() > 0)
				{
					$row = $q3->row_array();
					$stock[$i] = $row['stock_item'];
					$stk[$i] = $stock[$i] + $in_qty[$i];
					$direct_sales[$i] = $row['direct_sales'];
											
					if($direct_sales[$i] == 'Yes')
					{
						$q5 = $this->db->query("select * from recipe where raw_item_code='$it_id[$i]' and branchname='$brname'");
						if($q5->num_rows() > 0)
						{
							$row3 = $q5->row_array();
							$qty[$i] = $row3['production_stock'];
							$qty1[$i] = $qty[$i] + $in_qty[$i];
							$recipe_id[$i] = $row3['recipe_id'];
							$recipe_no[$i] = $row3['recipe_no'];
							$pr_cat_id[$i] = $row3['pr_cat_id'];
							
							$q6 = $this->db->query("UPDATE recipe set production_stock='$qty1[$i]' WHERE  raw_item_code='$it_id[$i]' and branchname='$brname'");
							if($in_qty[$i] != '0' && $in_qty[$i] != '')
							{
								$data2 = array(
									'item_name' => $itm_name[$i],
									'trans_ref_no' => $receipt_no,
									'trans_type'=>'Inward',
									'transaction_date' => $inward_date,
									'opening_stock' => $qty[$i],
									'in_qty' => $in_qty[$i],
									'closing_stock' => $qty1[$i],
									'last_modified' => $lm,
									'branchname' => $brname,
									'item_id' => $recipe_id[$i],
									'recipe_no' => $recipe_no[$i],
									'category_id' => $pr_cat_id[$i],
									'branch_id' => $brid	
								);
								$this->db->insert('stock_detail', $data2);
							}
						}
					}
					else
					{
						$q7 = $this->db->query("UPDATE item_creation set stock_item='$stk[$i]' WHERE item_id='$itmid[$i]'");
						if($in_qty[$i] != '0' && $in_qty[$i] != '')
						{
							$data2 = array(
								'item_name' => $itm_name[$i],
								'trans_ref_no' => $receipt_no,
								'trans_type'=>'Inward',
								'transaction_date' => $inward_date,
								'opening_stock' => $stock[$i],
								'in_qty' => $in_qty[$i],
								'closing_stock' => $stk[$i],
								'last_modified' => $lm,
								'branchname' => $brname,
								'item_id' => $itmid[$i],
								'itm_id' => $it_id[$i],
								'category_id' => $cid[$i],
								'branch_id' => $brid	
							);
							$this->db->insert('stock_detail', $data2);
						}
					}
					$data3 = array(
						'item_name' => $itm_name[$i],
						'quantity' => $in_qty[$i],
						'rc_item_price' => $in_price[$i],
						'rc_total_price' => $in_tt_amt[$i],
						'rc_tax' => $rtax[$i],
						'rc_tax_amount' => $txamt[$i],
						'rc_total_amount' => $in_grd_amt[$i],
						'req_rec_id' => $rcid,
						'requset_item_id' => $rq_itm_id[$i],
						'issue_order_id' => '0',
						'item_id' => $itmid[$i],
						'itm_id' => $it_id[$i],
						'category_id' => $cid[$i]
					);
					$this->db->insert('request_receipt_item', $data3);
					$rcitid = $this->db->insert_id();
				}
				if (empty($in_qty[$i])) {
					$q8 = $this->db->query("DELETE FROM request_receipt_item WHERE receipt_item_id='$rcitid'");
				}
				
				if($rcqty[$i] == $iqty[$i] && $in_qty[$i]!='') {
					$q10 = $this->db->query("update material_request_item set receipt_status='Closed',status='Closed' where request_item_id='$rq_itm_id[$i]'");
				}
				else
				{
					$q10 = $this->db->query("update material_request_item set receipt_status='test',status='test' where request_item_id='$rq_itm_id[$i]'");
				}
				$q11 = $this->db->query("SELECT count(*) as `num` FROM material_request_item where request_id='$reqid'");
				$row5 = $q11->row_array();
				$count1 = $row5['num'];
				
				$q12 = $this->db->query("SELECT count(*) as `num1` FROM material_request_item where status='Closed' and request_id='$reqid'");
				$row6 = $q12->row_array();
				$count2 = $row6['num1'];
				
				if($count1 == $count2) {
					$q13 = $this->db->query("update material_request set receipt_status='Closed',status='Closed' where request_id='$reqid'");
				}
			}
		}
			return $rcid;
		}
		
		public function getPrideInward($inid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date FROM material_request M inner join request_receipt R on M.request_id=R.request_id where R.req_rec_id='$inid'");
			return $query->result();
		}
		
		public function getPrideInwardItem($inid)
		{
			$query = $this->db->query("SELECT *,MI.item_name as it_name FROM material_request M inner join material_request_item MI on M.request_id=MI.request_id inner join request_receipt_item RI on MI.request_item_id=RI.requset_item_id where RI.req_rec_id='$inid' and RI.quantity !=''");
			return $query->result();
		}
		
		public function getRequestClosedList($branch_id)
		{
			$query = $this->db->query("SELECT *, DATE_FORMAT(request_date, '%d-%m-%Y') as request_date FROM material_request  where branch_id='$branch_id' and receipt_status='Closed' ORDER BY request_id desc");
			return $query->result();
		}
		
		public function getMatReceipt($rid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,sum(RI.rc_total_amount) as rc_total_amount,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(IO.issue_date, '%d-%m-%Y') as issue_date FROM material_request M inner join issues_order_creation IO on M.request_id=IO.request_id inner join request_receipt R on IO.issue_id=R.issue_id inner join request_receipt_item RI on R.req_rec_id=RI.req_rec_id where R.request_id='$rid' group by RI.req_rec_id ORDER BY R.req_rec_id desc");
			return $query->result();
		}
		
		public function getPrideMatReceipt($rid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,sum(RI.rc_total_amount) as rc_total_amount,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date FROM material_request M inner join request_receipt R on M.request_id=R.request_id inner join request_receipt_item RI on R.req_rec_id=RI.req_rec_id where R.request_id='$rid' group by RI.req_rec_id ORDER BY R.req_rec_id desc");
			return $query->result();
		}
		
		public function getReceiptList($branch_id)
		{
			$query = $this->db->query("SELECT *, DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,DATE_FORMAT(IO.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date FROM material_request M inner join issues_order_creation IO on M.request_id=IO.request_id inner join request_receipt R on IO.issue_id=R.issue_id where R.branch_id='$branch_id' ORDER BY R.req_rec_id desc");
			return $query->result();
		}
		
		public function getPrideReceiptList($branch_id)
		{
			$query = $this->db->query("SELECT *, DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date FROM material_request M inner join request_receipt R on M.request_id=R.request_id where R.branch_id='$branch_id' and R.store='Pride Bakers' ORDER BY R.req_rec_id desc");
			return $query->result();
		}
		
		public function getIssueClosedList($uname)
		{
			//$query = $this->db->query("SELECT *, DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join login L on M.branchname=L.branch_name where M.status='Closed' and M.store='$uname' ORDER BY M.request_id desc");
			$query = $this->db->query("SELECT *, DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join user L on M.branch_id=L.branch_id where M.status='Closed' and M.store='$uname' ORDER BY M.request_id desc");
			return $query->result();
		}
		
		public function getMatIssues($rid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,I.total,DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,M.branchname as branch FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id inner join issues_order_item IT on I.issue_id=IT.issue_id where I.request_id='$rid' group by I.issue_id ORDER BY I.issue_id desc");
			return $query->result();
		}
		
		public function getIssueList($branch_id)
		{
			$query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id where I.branch_id='$branch_id' ORDER BY I.issue_id desc");
			return $query->result();
		}
		
		public function getCmsIssueList($branch_id)
		{
			$query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation where branch_id='$branch_id' ORDER BY issue_id desc");
			return $query->result();
		}
		
		public function getAllIssueList($branch_id)
		{
			$query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation where branch_id='$branch_id' ORDER BY issue_id desc");
			return $query->result();
		}
		
		public function getrjReceipt($rcid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date FROM issues_order_creation I inner join request_receipt R on I.issue_id=R.issue_id where R.req_rec_id='$rcid'");
			return $query->result();
		}
		
		public function getrjReceiptItem($rcid)
		{
			$query = $this->db->query("SELECT *, (RI.quantity-RI.rejected_qty) as rejection_bal_qty FROM issues_order_creation I inner join issues_order_item  IT on  I.issue_id=IT.issue_id inner join request_receipt_item RI on IT.issue_order_id=RI.issue_order_id where RI.req_rec_id='$rcid'");
			return $query->result();
		}
		
		public function addRejection($postdata)
		{
			extract($postdata);
			$rjn_date = date("Y-m-d", strtotime($rjn_date));
			$rjn_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			
			$this->db->select('MAX(rn_no) as rn_no',false);
			$this->db->where('branch_id',$branch_id);
			$result = $this->db->get('rcp_rejection')->row();
			$rn_no = $result->rn_no;
			if($rn_no == 0){
				$rn_no = 1;
			}
			else{
				$rn_no = $rn_no+1;
			}
			$rejection_no = "RJN"."/".$branchname."/".$rn_no;
			
			$k=0;
			for($j=0;$j<count($rjn_quantity);$j++)
			{
				if($rjn_quantity[$j]!='0' && $rjn_quantity[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			$data = array('rn_no'=> $rn_no,
			'rejection_no'=> $rejection_no,
			'rejection_date'=> $rjn_date,
			'branchname'=> $rjn_time,
			'req_rec_id'=> $rcp_id,
			'rtime'=> $rjn_time,
			'branch_id' => $branch_id
			);
			$this->db->insert('rcp_rejection', $data);
			$rjid = $this->db->insert_id();
			}
			
			if($rjid)
			{
			$count = count($item_name);
			for($i=0;$i<$count;$i++)
			{
				$rejctd_qty[$i] = $rjn_quantity[$i] + $rejected_qty[$i];
				
				$q1 = $this->db->query("update request_receipt_item set rejected_qty='$rejctd_qty[$i]' where receipt_item_id='$rcp_item_id[$i]'");
								
				$q3 = $this->db->query("select * from item_creation where item_id='$item_id[$i]'");
				if($q3->num_rows() > 0)
				{
					$row = $q3->row_array();
					$qty[$i] = $row['stock_item'];//opening stock
					$qty1[$i] = $qty[$i] - $rjn_quantity[$i];//closing stock
					
					$q4 = $this->db->query("UPDATE item_creation set stock_item='$qty1[$i]' WHERE item_id='$item_id[$i]'");
					
					$data2 = array(
						'item_name' => $item_name[$i],
						'rejection_qty' => $rjn_quantity[$i],
						'rejection_remarks' => $rjn_remarks[$i],
						'rejection_id' => $rjid,
						'receipt_item_id' => $rcp_item_id[$i],
						'item_id' => $item_id[$i],
						'itm_id' => $itm_id[$i],
						'category_id' => $cat_id[$i]
					);
					$this->db->insert('rcp_rejection_item', $data2);
					$rjitid = $this->db->insert_id();
					
					if($rjn_quantity[$i] != '0' && $rjn_quantity[$i] != '')
					{
						$data3 = array(
							'item_name' => $item_name[$i],
							'trans_ref_no' => $rejection_no,
							'transaction_date' => $rjn_date,
							'opening_stock' => $qty[$i],
							'out_qty' => $rjn_quantity[$i],
							'closing_stock' => $qty1[$i],
							'last_modified' => $lm,
							'branchname' => $branchname,
							'item_id' => $item_id[$i],
							'itm_id' => $itm_id[$i],
							'category_id' => $cat_id[$i],
							'branch_id' => $branch_id	
						);
						$this->db->insert('stock_detail', $data3);
					}
					
					$q9 = $this->db->query("select quantity,rejected_qty from request_receipt_item where receipt_item_id='$rcp_item_id[$i]'");
					if($q9->num_rows() > 0)
					{
						$row4 = $q9->row_array();
						$rcp_qty[$i] = $row4['quantity'];
						$rej_qty[$i] = $row4['rejected_qty'];
						
						if($rcp_qty[$i] == $rej_qty[$i] && $rjn_quantity[$i]!='') {
							$q10 = $this->db->query("update request_receipt_item set rjn_status='Closed' where receipt_item_id='$rcp_item_id[$i]'");
						}
					}
				
					$q11 = $this->db->query("SELECT count(*) as `num` FROM request_receipt_item where req_rec_id='$rcp_id'");
					$row5 = $q11->row_array();
					$count1 = $row5['num'];
					
					$q12 = $this->db->query("SELECT count(*) as `num1` FROM request_receipt_item where rjn_status='Closed' and req_rec_id='$rcp_id'");
					$row6 = $q12->row_array();
					$count2 = $row6['num1'];
					
					if($count1 == $count2) {
						$q13 = $this->db->query("update request_receipt set rjn_status='Closed' where req_rec_id='$rcp_id'");
					}
				}
			}
		}
			return $rjid;
		}
		
		public function getRejection($rjid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(RJ.rejection_date, '%d-%m-%Y') as rejection_date FROM issues_order_creation I inner join request_receipt R on I.issue_id=R.issue_id inner join rcp_rejection RJ on R.req_rec_id=RJ.req_rec_id where RJ.rejection_id='$rjid'");
			return $query->result();
		}
		
		public function getRejectionItem($rjid)
		{
			$query = $this->db->query("SELECT *, I.item_id as item_id FROM issues_order_item I inner join request_receipt_item R on I.issue_order_id=R.issue_order_id inner join rcp_rejection_item RJ on R.receipt_item_id=RJ.receipt_item_id where RJ.rejection_id='$rjid' and RJ.rejection_qty !=''");
			return $query->result();
		}
		
		public function getRejectionList($branch_id)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(RJ.rejection_date, '%d-%m-%Y') as rejection_date FROM issues_order_creation I inner join request_receipt R on I.issue_id=R.issue_id inner join rcp_rejection RJ on R.req_rec_id=RJ.req_rec_id where RJ.branch_id='$branch_id' ORDER BY RJ.rejection_id desc");
			return $query->result();
		}
		
		public function getPrideInwardRemark($inid)
		{
			$query = $this->db->query("select * from cmn_ticket as A inner join(select ticket_no,max(ticket_id) as maxtid,inw_id from cmn_ticket where inw_id='$inid' group by inw_id) as B on A.inw_id=B.inw_id and A.ticket_id=B.maxtid");
			return $query->result();
		}
		
		public function addinwardTicket($postdata)
		{
			extract($postdata);
			$inw_date = date("Y-m-d", strtotime($inw_date));
			$ticket_time = date("h:i A");
						
			$this->db->select('MAX(tno) as tno',false);
			$this->db->where('branch_id',$br_id);
			$result = $this->db->get('cmn_ticket')->row();
			$tno = $result->tno;
			if($tno == 0){
				$tno = 1;
			}
			else{
				$tno = $tno+1;
			}
			$ticket_no = "TCKT"."/".$tno;
			
			$data = array('tno'=> $tno,
				'ticket_no'=> $ticket_no,
				'ticket_date'=> $rmk_date,
				'ticket_time'=> $ticket_time,
				'remarks'=> $remark,
				'inw_no'=> $inw_no,
				'inw_date' => $inw_date,
				'dept'=> $dept,
				'dc_no'=> $dc_no,
				'branch'=> $branch,
				'inw_id'=> $inw_id,
				'branch_id' => $br_id
			);
			$this->db->insert('cmn_ticket', $data);
		}
		
		public function addDcUpload($postdata)
		{
			extract($postdata);
			function compressImage($source, $destination, $quality) {

				$info = getimagesize($source);

				if ($info['mime'] == 'image/jpeg') 
				$image = imagecreatefromjpeg($source);

				elseif ($info['mime'] == 'image/gif') 
				$image = imagecreatefromgif($source);

				elseif ($info['mime'] == 'image/png') 
				$image = imagecreatefrompng($source);

				imagejpeg($image, $destination, $quality);

			}
			$insertValuesSQL = $insertfiles = '';
			$randno=rand(10000, 990000);
			foreach($_FILES['bill_upload']['name'] as $key=>$val){
				$extension = pathinfo($_FILES["bill_upload"]["name"][$key], PATHINFO_EXTENSION);
				$fileName = 'bill_upload/'.rand(10000, 990000). "_". time().".".$extension;
				$insertfiles .= $fileName;
			}
			
		/*	if(!empty($_FILES['bill_upload']['name'])){
				$config['upload_path'] = 'upload/';
				$config['allowed_types'] = 'jpg|jpeg|png|gif|JPG|JPEG|PNG|GIF';
				$filename = 'upload/'.$_FILES['bill_upload']['name'];
			}*/
			if(!empty(array_filter($_FILES['bill_upload']['name']))){
		    	$this->db->query("update request_receipt set bill_upload='$insertfiles' where req_rec_id='$rcp_id'");
			}
			//invoice upload
			$folderName = date('M-Y');
			$targetDir = "bill_upload/".$folderName."/";
			if ( ! file_exists($targetDir) )
            {
                $create = mkdir($targetDir, 0777, TRUE);
                $createThumbsFolder = mkdir($targetDir . '/thumbs', 0777, TRUE);
                if ( ! $create || ! $createThumbsFolder)
                return;
            }
			$allowTypes = array('jpg','png','jpeg','gif');
    
			if(!empty(array_filter($_FILES['bill_upload']['name']))){
				foreach($_FILES['bill_upload']['name'] as $key=>$val){
					// File upload path
					//$fileName = basename($_FILES['grn_in_upload']['name'][$key]);
					$extension = pathinfo($_FILES["bill_upload"]["name"][$key], PATHINFO_EXTENSION);
					$fileName = rand(10000, 990000). "_". time().".".$extension;
					//$fileName1 = $grn_no . $fileName;
					$targetFilePath = $targetDir . $fileName;
				
					// Check whether file type is valid
					$fileType = pathinfo($_FILES["bill_upload"]["name"][$key],PATHINFO_EXTENSION);
					//$fileType = pathinfo($targetFilePath,PATHINFO_EXTENSION);
					if(in_array($fileType, $allowTypes)){
						// Upload file to server
						if(move_uploaded_file($_FILES["bill_upload"]["tmp_name"][$key], $targetFilePath)){
						$location = "bill_upload/".$folderName."/".$fileName;
							compressImage($targetFilePath,$location,25);
							// Image db insert sql
							$insertValuesSQL .= "('".$location."', NOW(), '".$rcp_id."','Pride Grn'),";
						}else{
							//$errorUpload .= $_FILES['grn_in_upload']['name'][$key].', ';
						}
					}else{
						//$errorUploadType .= $_FILES['grn_in_upload']['name'][$key].', ';
					}
				}
			
			$insertValuesSQL = trim($insertValuesSQL,',');
			$this->db->query("INSERT INTO uploaded_invoice (file_name, uploaded_on,invoice_ref_id,gstatus) VALUES $insertValuesSQL");
			}
			
		/*	if(!empty($_FILES['bill_upload']['name'])){
				$config['upload_path'] = 'dc_upload/';
				$config['allowed_types'] = 'jpg|jpeg|png|gif|JPG|JPEG|PNG|GIF';
				$filename = $_FILES['bill_upload']['name'];
				$file_name = 'dc_upload/'.$_FILES['bill_upload']['name'];
				$config['file_name'] = $filename;
				//Load upload library and initialize configuration
				$this->load->library('upload',$config);
				$this->upload->initialize($config);
				
				if($this->upload->do_upload('bill_upload')){
					
					$data = $this->upload->data();  
					 $config['image_library'] = 'gd2';  
					 $config['source_image'] = 'dc_upload/'.$data["file_name"];  
					 $config['create_thumb'] = FALSE;  
					 $config['maintain_ratio'] = FALSE;  
					 $config['quality'] = '60%';  
					 $config['width'] = 200;  
					 $config['height'] = 200;  
					 $config['new_image'] = 'dc_upload/'.$data["file_name"];  
					 $this->load->library('image_lib', $config);  
					 $this->image_lib->resize();  
					 $image_data = array( 
						  'file_name' => $file_name,
						  'uploaded_on'=>date('Y-m-d H:i:s'),
						   'invoice_ref_id'=>$rcp_id,
						   'gstatus'=>'Pride Grn'
						  );  
					  $this->db->insert("uploaded_invoice", $image_data); 
				}else{
					$bill_upload = '';
				}
			}else{
				$bill_upload = '';
			}*/
		}
		
		public function getDcUpload($inid)
		{
			$query = $this->db->query("select * from uploaded_invoice where invoice_ref_id='$inid'");
			return $query->result();
		}
		
		public function getInwardTicket($branch_id)
		{
			$c_date = date('Y-m-d');
			$cdate = date('Y-m-d',strtotime($c_date. '- 6 days'));
			$query = $this->db->query("select * from cmn_ticket where ticket_date between '$cdate' and '$c_date' and branch_id='$branch_id' order by ticket_id desc");
			return $query->result();
		}
		
		public function getcInwardTicket()
		{
			$c_date = date('Y-m-d');
			$cdate = date('Y-m-d',strtotime($c_date. '- 6 days'));
			$query = $this->db->query("select * from cmn_ticket order by ticket_id desc");
			return $query->result();
		}
		
		public function getRequestIssueList(){
			$query = $this->db->query("SELECT *, DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date,DATE_FORMAT(M.approval_date, '%d-%m-%Y') as approval_date FROM material_request M inner join user L on M.branchname=L.branch_name where (M.status='Pending' or M.status='Approved') and M.store='Cakewala' ORDER BY request_id desc");
			return $query->result();	
		}


		public function getCRequestClosedList()
		{
			$query = $this->db->query("SELECT *, DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join user L on M.branchname=L.branch_name where M.status='Closed'  ORDER BY M.request_id desc ");
			return $query->result();
		}

		public function getCIssueList($row,$rowperpage){
			$query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation ORDER BY issue_id desc limit $row,$rowperpage");
			return $query->result();
		}

        public function get_CIssueList(){
			//query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation ORDER BY issue_id desc");
			$query = $this->db->query("SELECT i.invoice_type,i.issue_no,i.dc_no,i.issue_date,i.outlet_name,sum(it.`basic_price`) as `basic`,sum(it.tax_amount) as `tax_amt`,sum(it.total_amount) as tot_amt,i.issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation i inner join issues_order_item it on i.issue_id=it.issue_id where i.invoice_type='dc_invoice_23' group by i.issue_id ORDER BY i.issue_id desc");
			return $query->result();
		}
		
		public function getIssueListReport($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$branch = $data['branch'];
			$query = $this->db->query("SELECT i.invoice_type,i.issue_no,i.dc_no,i.issue_date,i.outlet_name,sum(it.`basic_price`) as `basic`,sum(it.tax_amount) as `tax_amt`,sum(it.total_amount) as tot_amt,i.issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation i inner join issues_order_item it on i.issue_id=it.issue_id where i.invoice_type='dc_invoice_23' and (i.issue_date between '$f_date' and '$t_date') and i.outlet_name='$branch' group by i.issue_id ORDER BY i.issue_id desc");
		
			return $query->result();
		}

		public function getCPrideIssueList()
		{
			$branch_name = $_SESSION['branch_name'];
			$cw_ceo = $_SESSION['cw_ceo'];
			if($cw_ceo=='CW')
            {
                $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join user L on R.branchname=L.branch_name where R.store='Pride Bakers' group by RI.req_rec_id order by R.req_rec_id desc");
            }
            else{
                $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join login L on R.branchname=L.branch_name where R.store='Pride Bakers' and R.branchname LIKE '$cw_ceo%' group by RI.req_rec_id order by R.req_rec_id desc");
            }
			/*if($branch_name=='CW4_CEO'){
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join login L on R.branchname=L.branch_name where R.store='Pride Bakers' and R.branchname LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else if($branch_name=='CW5_CEO'){
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join login L on R.branchname=L.branch_name where R.store='Pride Bakers' and R.branchname LIKE 'CW5%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else if($branch_name=='CW6_CEO'){
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join login L on R.branchname=L.branch_name where R.store='Pride Bakers' and R.branchname LIKE 'CW6%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else{
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join user L on R.branchname=L.branch_name where R.store='Pride Bakers' group by RI.req_rec_id order by R.req_rec_id desc");
			}*/
			return $query->result();
		}

        public function getPrideIssueListReport($data)
		{
			$from_date =date('Y-m-d', strtotime($data['from_date']));
			$to_date =date('Y-m-d', strtotime($data['to_date']));
			$branch = $data['branch'];
			$branch_name = $_SESSION['branch_name'];
			$cw_ceo = $_SESSION['cw_ceo'];
			if($cw_ceo=='CW')
            {
                if($branch == 'All')
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else if($branch == 'cw4_out') {
    			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else if($branch == 'cw5_out') {
    			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW5%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else
    			{
    			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$branch' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id order by R.req_rec_id desc");
    			}
            }
            else{
                if($branch == 'All')
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE '$cw_ceo%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$branch' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id order by R.req_rec_id desc");
    			}
            }
			/*if($branch_name=='CW4_CEO'){
			    if($branch == 'All')
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$branch' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id order by R.req_rec_id desc");
    			}
			}
			else if($branch_name=='CW5_CEO'){
			    if($branch == 'All')
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW5%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$branch' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id order by R.req_rec_id desc");
    			}
			}
			else if($branch_name=='CW6_CEO'){
			    if($branch == 'All')
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW6%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$branch' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id order by R.req_rec_id desc");
    			}
			}
			else{
			    if($branch == 'All')
    			{
    				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else if($branch == 'cw4_out') {
    			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else if($branch == 'cw5_out') {
    			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW5%' group by RI.req_rec_id order by R.req_rec_id desc");
    			}
    			else
    			{
    			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$branch' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id order by R.req_rec_id desc");
    			}
			}*/
			return $query->result();
		}
		public function get_pride_issue_report_byOutlet($from_date,$to_date,$outlet_name) {
			$from_date = date("Y-m-d", strtotime($from_date));
			$to_date = date("Y-m-d", strtotime($to_date));
			if($outlet_name == 'All')
			{
				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else if($outlet_name == 'cw4_out') {
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else
			{
				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$outlet_name' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id order by R.req_rec_id desc");
			}
			return $sql;
		}
		
		public function getStore($sub_mod_id,$branch_id){
			$query = $this->db->query("SELECT access_username from user_access where module_id='$sub_mod_id' and branch_id='$branch_id'");
			return $query->result();	
		}
		
		public function getprMatRequest($rid)
		{
			$query = $this->db->query("SELECT *,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join user U on M.branchname=U.branch_name where request_id='$rid'");
			return $query->result();	
		}
		
		public function getPrdReceiptList($uname)
		{
		    $uname = $_SESSION['username'];
			if($uname=='Cakewala4'){
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id  where R.store='Pride Bakers' and (R.branchname LIKE 'CW4%' or R.branchname='ST4') group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else{
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join user U on R.branchname=U.branch_name where R.store='$uname' and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			
			return $query->result();
		}
		
		public function get_AccPrideRecList() {
		    $branch_name = $_SESSION['branch_name'];
		    $cw_ceo = $_SESSION['cw_ceo'];
			if($cw_ceo=='CW')
            {
                $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join user U on R.branchname=U.branch_name where R.store='Pride Bakers' and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
            }
            else{
                $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join user U on R.branchname=U.branch_name where R.store='Pride Bakers' and R.branchname LIKE '$cw_ceo%' group by RI.req_rec_id order by R.req_rec_id desc");
            }
            /*if($branch_name=='CW4_ACC')
            {
                $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join user U on R.branchname=U.branch_name where R.store='Pride Bakers' and R.branchname LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
            }
            else if($branch_name=='CW5-ACC')
            {
                $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join user U on R.branchname=U.branch_name where R.store='Pride Bakers' and R.branchname LIKE 'CW5%' group by RI.req_rec_id order by R.req_rec_id desc");
            }
            else
            {
                $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join user U on R.branchname=U.branch_name where R.store='Pride Bakers' and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
            }*/
			return $query->result();
		}
		
		public function rcp_total_sum_calc($inid) {
			$query = $this->db->query("SELECT sum(rc_total_amount) as `rc_total_amount`, sum(rc_tax_amount) as `rc_tax_amount` FROM  request_receipt_item where req_rec_id='$inid'");
			return $query->result();
		}
		
		public function getAccIssueList($row,$rowperpage,$branch){
			$branch_name = $_SESSION['branch_name'];
			$cw_ceo = $_SESSION['cw_ceo'];
			if($cw_ceo=='CW')
            {
                $query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id where I.branchname='$branch' or I.branchname='CW3' ORDER BY I.issue_id desc limit $row,$rowperpage");
            }
            else{
                $query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id where I.branchname='$cw_ceo' ORDER BY I.issue_id desc limit $row,$rowperpage");
            }
            /*if($branch_name=='CW4_ACC')
            {
                $query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id where I.branchname='CW4' ORDER BY I.issue_id desc limit $row,$rowperpage");
            }
            else if($branch_name=='CW5-ACC')
            {
                $query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id where I.branchname='CW5' ORDER BY I.issue_id desc limit $row,$rowperpage");
            }
            else
            {
                $query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(I.issue_date, '%d-%m-%Y') as issue_date,DATE_FORMAT(M.request_date, '%d-%m-%Y') as request_date FROM material_request M inner join issues_order_creation I on M.request_id=I.request_id where I.branchname='$branch' or I.branchname='CW3' ORDER BY I.issue_id desc limit $row,$rowperpage");
            }*/
			return $query->result();
		}
		
		public function get_issue_report_byOutlet($data) {
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$outlet_name = $data['outlet_name'];
			$iname = $data['item_name'];
			$branch_name = $data['br_name'];
			//echo $branch_name;
			if($f_date!="" && $t_date!="" && $outlet_name!="" && $iname=="")
			{
			    $query = $this->db->query("SELECT *, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation where branchname='$branch_name' and outlet_name='$outlet_name' and (issue_date between '$f_date' and '$t_date')");
			}
			else if($f_date!="" && $t_date!="" && $outlet_name!="" && $iname!="")
			{
			     if($outlet_name != 'All' && $iname == 'All')
    			{
    				$query = $this->db->query("SELECT i.indent_item_name,c.outlet_name,sum(i.indent_qty)as qty,round(sum(i.total_amount),2) as total FROM issues_order_item i inner join issues_order_creation c on i.issue_id=c.issue_id WHERE c.outlet_name='$outlet_name' and c.branchname='$branch_name' and issue_date between '$f_date' and '$t_date' group by i.indent_item_name");
    				
    			}
    			else if($outlet_name == 'All' && $iname != 'All'){
    				$query = $this->db->query("SELECT i.indent_item_name,c.outlet_name,sum(i.indent_qty)as qty,round(sum(i.total_amount),2) as total FROM issues_order_item i inner join issues_order_creation c on i.issue_id=c.issue_id WHERE i.indent_item_name='$iname' and c.branchname='$branch_name' and issue_date between '$f_date' and '$t_date' group by c.outlet_name");
    				
    			}
    			else if($outlet_name != 'All' && $iname != 'All'){
    				$query = $this->db->query("SELECT i.indent_item_name,c.outlet_name,sum(i.indent_qty)as qty,round(sum(i.total_amount),2) as total FROM issues_order_item i inner join issues_order_creation c on i.issue_id=c.issue_id WHERE i.indent_item_name='$iname' and c.outlet_name='$outlet_name' and c.branchname='$branch_name' and issue_date between '$f_date' and '$t_date' group by c.outlet_name");
    				
    			}
			}
			return $query->result_array();
		}
		
		public function getMatRequestStatus($rid){
		    $query = $this->db->query("SELECT * FROM material_request where request_id='$rid'");
			return $query->result_array();	
		}
		
		public function getAIssueList($row,$rowperpage){
		    $branch_name = $_SESSION['branch_name'];
		    
            if($branch_name=='CW4_CEO')
            {
                $branch='CW4';
            }else if($branch_name=='CW5_CEO')
            {
                $branch='CW5';
            }
            else if($branch_name=='CW6_CEO')
            {
                $branch='CW6';
            }
			$query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation where branchname='$branch' ORDER BY issue_id desc limit $row,$rowperpage");
			return $query->result();
		}

		public function getAIssueListReport($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$branch = $data['branch'];
			$query = $this->db->query("SELECT *,issue_id as mid, DATE_FORMAT(issue_date, '%d-%m-%Y') as issue_date FROM issues_order_creation where (issue_date between '$f_date' and '$t_date') and branchname='$branch' ORDER BY issue_id desc");
			return $query->result();
		}
		
		public function get_outlet_for_pride() {
		    $branch_name = $_SESSION['branch_name'];
            if($branch_name=='CW4_ACC')
            {
                $query = $this->db->query("SELECT * from user where assignedto='cakewala4'");
            }
            else if($branch_name=='CW5-ACC')
            {
                $query = $this->db->query("SELECT * from user where assignedto='cakewala5'");
            }
            else if($branch_name=='CW6_ACC')
            {
                $query = $this->db->query("SELECT * from user where assignedto='cakewala6'");
            }
            else
            {
                $query = $this->db->query("SELECT * from user WHERE assignedto='admin' or assignedto='cakewala3' or assignedto='cakewala4'");
            }
			return $query->result();
		}
		
		public function get_outlet_forCW4_pride() {
		    
			$query = $this->db->query("select * from user WHERE assignedto='cakewala4'");
			return $query->result();
		}
		
		public function get_pride_receipt_byOutlet($data) {
		    $from_date =date('Y-m-d', strtotime($data['from_date']));
			$to_date =date('Y-m-d', strtotime($data['to_date']));
			$outlet_name = $data['branch'];
			
			if($outlet_name == 'All')
			{
				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else if($outlet_name == 'cw4_out') {
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else if($outlet_name == 'cw5_out') {
			    $query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and (R.receipt_date between '$from_date' and '$to_date') and R.branchname LIKE 'CW5%' group by RI.req_rec_id order by R.req_rec_id desc");
			}
			else
			{
				
				$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id where R.store='Pride Bakers' and R.branchname='$outlet_name' and (R.receipt_date between '$from_date' and '$to_date') group by RI.req_rec_id order by R.req_rec_id desc");
			}
			return $query->result();
		}
		
		public function get_PrideList() {
			$query = $this->db->query("SELECT *, DATE_FORMAT(R.receipt_date, '%d-%m-%Y') as receipt_date,DATE_FORMAT(R.approval_date, '%d-%m-%Y') as approval_date,round(sum(RI.rc_total_amount),2) as total FROM request_receipt_item RI inner join request_receipt R on RI.req_rec_id=R.req_rec_id inner join login L on R.branchname=L.branch_name where R.store='Pride Bakers' and R.branchname NOT LIKE 'CW4%' group by RI.req_rec_id order by R.req_rec_id desc");
			return $query->result();
		}
	}
?>