<?php
	class StockManage_model extends CI_model
	{
		public function __construct()
		{
			parent::__construct();
			$this->load->database();
		}
				
		public function getPresentStock($branch_id)
		{
			$query = $this->db->query("SELECT * FROM item_creation where branch_id='$branch_id' and status='Enabled'  ORDER BY item_id desc");
			return $query->result();	
		}
		
		public function getCPresentStock()
		{
			$query = $this->db->query("SELECT * FROM item_creation where branchname='CW' or branchname='ESH' ORDER BY item_id desc");
			return $query->result();	
		}
		
		public function getGPresentStock()
		{
			$query = $this->db->query("SELECT `gd_id`, `item_name`, `uom`, `price`, `tax`, `stock`, `from_branchname`, `branchname`, `item_id`, `itm_id`, `category_id` FROM `godown_stock`");
			return $query->result();	
		}
		
		public function getPrStock($data)
		{
			$branch = $data['branch'];
			$query = $this->db->query("SELECT * FROM item_creation I inner join category C on I.category_id=C.category_id where I.branchname='$branch' ORDER BY I.item_id desc");
			return $query->result_array();	
		}
		
		public function getStockLedger($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$branch_id = $data['branch_id'];
			$iname = $data['item_name'];
			$query = $this->db->query("select *,DATE_FORMAT(transaction_date, '%d-%m-%Y') as trans_date from stock_detail where item_name='$iname' and branch_id='$branch_id' and (transaction_date between '$f_date' and '$t_date') order by stock_id asc");
			return $query->result_array();	
		}
		
		public function getCStockLedger($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$branch = $data['branch'];
			$iname = $data['item_name'];
			$query = $this->db->query("select *,DATE_FORMAT(transaction_date, '%d-%m-%Y') as trans_date from stock_detail where item_name='$iname' and branchname='$branch' and (transaction_date between '$f_date' and '$t_date') order by stock_id asc");
			return $query->result_array();
		}
		
		public function getStockMovement($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$branch_id = $data['branch_id'];
			$query = $this->db->query("select s2.item_name,s2.opening_stock,s2.inward,s2.outward,s3.closing_stock from (select opening_stock,item_name,transaction_date,sum(in_qty)as inward,sum(out_qty) as outward,branchname from stock_detail where branch_id='$branch_id' and (transaction_date between '$f_date' and '$t_date') group by item_name) s2 inner join (select * from stock_detail where branch_id='$branch_id') s3 on s2.item_name=s3.item_name inner join (select item_name,transaction_date,closing_stock,max(last_modified) as maxdate,branchname from stock_detail where branch_id='$branch_id' and (transaction_date between '$f_date' and '$t_date') group by item_name) s4 on s3.item_name=s4.item_name and s3.last_modified=s4.maxdate");
			return $query->result_array();	
		}
		
		public function getCStockMovement($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$branch = $data['branch'];
			$query = $this->db->query("select s2.item_name,s2.opening_stock,s2.inward,s2.outward,s3.closing_stock from (select opening_stock,item_name,transaction_date,sum(in_qty)as inward,sum(out_qty) as outward,branchname from stock_detail where branchname='$branch' and (transaction_date between '$f_date' and '$t_date') group by item_name) s2 inner join (select * from stock_detail where branchname='$branch') s3 on s2.item_name=s3.item_name inner join (select item_name,transaction_date,closing_stock,max(last_modified) as maxdate,branchname from stock_detail where branchname='$branch' and (transaction_date between '$f_date' and '$t_date') group by item_name) s4 on s3.item_name=s4.item_name and s3.last_modified=s4.maxdate");
			return $query->result_array();	
		}
		
		public function getVendorLedger($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$supplier = $data['supplier'];
			$branch_id = $data['branch_id'];
			$branch_name = $_SESSION['branch_name'];
			$cw_ceo = $_SESSION['cw_ceo'];
			if($f_date!="" && $t_date!="" && $supplier=="All")
			{
			    
    			if($cw_ceo=='CW')
                {
                    $query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,vendor_name,reject_amt,grn_date,branchname from gnr_creation where branch_id='$branch_id' and grn_date between '$f_date' and '$t_date') g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
                }
                else{
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,vendor_name,reject_amt,grn_date,branchname from gnr_creation where branchname='$cw_ceo' and grn_date between '$f_date' and '$t_date') g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
                }
			    /*if($branch_name=='CW4_CEO')
                {
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,vendor_name,reject_amt,grn_date,branchname from gnr_creation where branchname='CW4' and grn_date between '$f_date' and '$t_date') g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
                }
                else if($branch_name=='CW5_CEO')
                {
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,vendor_name,reject_amt,grn_date,branchname from gnr_creation where branchname='CW5' and grn_date between '$f_date' and '$t_date') g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
                }
                else if($branch_name=='CW6_CEO')
                {
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,vendor_name,reject_amt,grn_date,branchname from gnr_creation where branchname='CW6' and grn_date between '$f_date' and '$t_date') g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
                }
                else
                {
                    $query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,vendor_name,reject_amt,grn_date,branchname from gnr_creation where branch_id='$branch_id' and grn_date between '$f_date' and '$t_date') g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
                }*/
			}
			else if($f_date!="" && $t_date!="" && $supplier!="All")
			{
			    if($cw_ceo=='CW')
                {
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branch_id='$branch_id' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
                }
                else{
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='$cw_ceo' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
                }
			    /*if($branch_name=='CW4_CEO')
                {
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='CW4' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
                }
                else if($branch_name=='CW5_CEO')
                {
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='CW5' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
                }
                else if($branch_name=='CW6_CEO')
                {
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='CW6' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
                }
                else
                {
                    $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branch_id='$branch_id' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
                }*/
			}
			return $query->result_array();	
		}
		
		public function getBAdmVendorLedger()
		{
		    $branch_name = $_SESSION['branch_name'];
		    $cw_ceo = $_SESSION['cw_ceo'];
		    if($cw_ceo=='CW')
            {
                $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='$branch_name' group by p.gnr_id order by p.gnr_id desc");
            }
            else{
                $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='$cw_ceo' group by p.gnr_id");
            }
		    /*if($branch_name=='CW4_CEO')
            {
                $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='CW4' group by p.gnr_id");
            }
		    else if($branch_name=='CW5_CEO')
            {
                $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='CW5' group by p.gnr_id ");
            }
            else if($branch_name=='CW6_CEO')
            {
                $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='CW6' group by p.gnr_id ");
            }
            else
            {
                $query = $this->db->query("select g.purchase_id,g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.reject_amt,round(sum(p.grn_grand),2) as value from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.branchname='$branch_name' group by p.gnr_id order by p.gnr_id desc");
            }*/
		    return $query->result();
		}
		
		public function getAccVendorLedger($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$supplier = $data['supplier'];
			$branch = $data['branch'];
			$branch_name = $_SESSION['branch_name'];
			$cw_ceo = $_SESSION['cw_ceo'];
			if($cw_ceo=='CW')
            {
                if($f_date!="" && $t_date!="" && $branch=="All")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.total_amount) as total_amount,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,sum(total_amount) as total_amount,sum(reject_amt) as reject_amt,vendor_name,grn_date,branchname from gnr_creation where grn_date between '$f_date' and '$t_date' and branchname!='CW4' group by vendor_name) g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
    			}
    			else if($f_date!="" && $t_date!="" && $branch!="" && $supplier!="")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='$branch' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
    			}
    			else if($f_date!="" && $t_date!="" && $branch!="")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.total_amount) as total_amount,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,sum(total_amount) as total_amount,sum(reject_amt) as reject_amt,vendor_name,grn_date,branchname from gnr_creation where grn_date between '$f_date' and '$t_date' and branchname!='$branch' group by vendor_name) g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name order by vendor_name asc");
    			}
            }
            else{
                if($f_date!="" && $t_date!="" && $branch=="All")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.total_amount) as total_amount,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,sum(total_amount) as total_amount,sum(reject_amt) as reject_amt,vendor_name,grn_date,branchname from gnr_creation where grn_date between '$f_date' and '$t_date' and branchname='$cw_ceo' group by vendor_name) g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
    			}
    			else if($f_date!="" && $t_date!="" && $branch!="" && $supplier!="")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='$branch' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
    			}
            }
            /*if($branch_name=='CW4_ACC')
            {
    			if($f_date!="" && $t_date!="" && $branch=="All")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.total_amount) as total_amount,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,sum(total_amount) as total_amount,sum(reject_amt) as reject_amt,vendor_name,grn_date,branchname from gnr_creation where grn_date between '$f_date' and '$t_date' and branchname='CW4' group by vendor_name) g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
    			}
    			else if($f_date!="" && $t_date!="" && $branch!="" && $supplier!="")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='$branch' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
    			}
		    } 
		    else if($branch_name=='CW5-ACC')
		    {
		        if($f_date!="" && $t_date!="" && $branch=="All")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.total_amount) as total_amount,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,sum(total_amount) as total_amount,sum(reject_amt) as reject_amt,vendor_name,grn_date,branchname from gnr_creation where grn_date between '$f_date' and '$t_date' and branchname='CW5' group by vendor_name) g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
    			}
    			else if($f_date!="" && $t_date!="" && $branch!="" && $supplier!="")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='$branch' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
    			}
		    }
		    else if($branch_name=='CW6_ACC')
		    {
		        if($f_date!="" && $t_date!="" && $branch=="All")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.total_amount) as total_amount,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,sum(total_amount) as total_amount,sum(reject_amt) as reject_amt,vendor_name,grn_date,branchname from gnr_creation where grn_date between '$f_date' and '$t_date' and branchname='CW6' group by vendor_name) g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
    			}
    			else if($f_date!="" && $t_date!="" && $branch!="" && $supplier!="")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='$branch' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
    			}
		    }
		    else
		    {
		        if($f_date!="" && $t_date!="" && $branch=="All")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.total_amount) as total_amount,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,sum(total_amount) as total_amount,sum(reject_amt) as reject_amt,vendor_name,grn_date,branchname from gnr_creation where grn_date between '$f_date' and '$t_date' and branchname!='CW4' group by vendor_name) g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name");
    			}
    			else if($f_date!="" && $t_date!="" && $branch!="" && $supplier!="")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$supplier' and g.branchname='$branch' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
    			}
    			else if($f_date!="" && $t_date!="" && $branch!="")
    			{
    				$query = $this->db->query("select g.gnr_id,g.grn_no,g.vendor_name,g.branchname,sum(g.total_amount) as total_amount,sum(g.reject_amt) as reject_amt,round(sum(p.grand),2) as grand from (select gnr_id,grn_no,sum(total_amount) as total_amount,sum(reject_amt) as reject_amt,vendor_name,grn_date,branchname from gnr_creation where grn_date between '$f_date' and '$t_date' and branchname!='$branch' group by vendor_name) g inner join (select gnr_id,round(sum(grn_grand),2) as grand from purchase_order_grn group by gnr_id) p on g.gnr_id=p.gnr_id group by g.vendor_name order by vendor_name asc");
    			}
		    }*/
			return $query->result_array();	
		}
		
		public function getGrns($f_date,$t_date,$vndname)
		{
			$query = $this->db->query("select g.gnr_id,g.grn_no,g.invoice_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$vndname' and (g.grn_date between '$f_date' and '$t_date') group by p.gnr_id");
			return $query->result();
		}
		
		public function getGrnDetails($f_date,$t_date,$vndname)
		{
			$query = $this->db->query("select g.gnr_id,g.grn_no,g.invoice_no,g.invoice_date,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$vndname' and (g.grn_date between '$f_date' and '$t_date') and g.branchname!='CW4' group by p.gnr_id");
			return $query->result();
		}
		
		public function generateVoucher($postdata)
		{
			extract($postdata);
			$vdate = date('Y-m-d');
			$lm=date("Y-m-dH:i:s",time());
			//$br=$branch;
			if($pay_mode == 'Cash')
			{
				$this->db->select('MAX(vno) as vno',false);
				$this->db->where('branch',$br);
				$this->db->where('pay_mode','Cash');
				$result = $this->db->get('voucher')->row();
				$vno = $result->vno;
				if($vno == 0){
					$vno = 1;
				}
				else{
					$vno = $vno+1;
				}
				$vocher_no = $br."/".$vno;
			}
			else
			{
				$parray = array('NEFT/RTGS','Cheque');
				$this->db->select('MAX(vno) as vno',false);
				$this->db->where('branch',$br);
				$this->db->where_in('pay_mode',$parray);
				$result = $this->db->get('voucher')->row();
				$vno = $result->vno;
				if($vno == 0){
					$vno = 1;
				}
				else{
					$vno = $vno+1;
				}
				$vocher_no = $br."/".$vno;
			}
			
			if(!empty($_FILES['chq_upload']['name'])){
				$config['upload_path'] = 'chq_upload/';
				$config['allowed_types'] = 'jpg|jpeg|png|gif|JPG|JPEG|PNG|GIF';
				$filename = 'chq_upload/'.$_FILES['chq_upload']['name'];
			}
			if(!empty($_FILES['chq_upload']['name'])){
				$data = array('vno'=> $vno,
					'voucher_no'=> $vocher_no,
					'vdate'=> $vdate,
					'vendor_name'=> $vendor_name,
					'pay_mode'=> $pay_mode,
					'bank_name'=> $bname,
					'transaction_no'=> $trans_no,
					'total_amt'=> $total_pay_amt,
					'branch'=> $br,
					'contact_no'=> $ph_no,
					'email_id'=> $email_id,
					'address'=> $address,
					'address1'=> $address1,
					'round_off'=> $roundoff,
					'final_amt'=> $total_payamt,
					'chq_uploaded'=> $filename
				);
				$this->db->insert('voucher', $data);
			}
			else{
				$data = array('vno'=> $vno,
				'voucher_no'=> $vocher_no,
				'vdate'=> $vdate,
				'vendor_name'=> $vendor_name,
				'pay_mode'=> $pay_mode,
				'bank_name'=> $bname,
				'transaction_no'=> $trans_no,
				'total_amt'=> $total_pay_amt,
				'branch'=> $br,
				'contact_no'=> $ph_no,
				'email_id'=> $email_id,
				'address'=> $address,
				'address1'=> $address1,
				'round_off'=> $roundoff,
				'final_amt'=> $total_payamt
			);
			$this->db->insert('voucher', $data);
			}
			$vc_id = $this->db->insert_id();
			
			if(!empty($_FILES['chq_upload']['name'])){
				$config['upload_path'] = 'chq_upload/';
				$config['allowed_types'] = 'jpg|jpeg|png|gif|JPG|JPEG|PNG|GIF';
				$filename = $_FILES['chq_upload']['name'];
				$file_name = 'chq_upload/'.$_FILES['chq_upload']['name'];
				$config['file_name'] = $filename;
				//Load upload library and initialize configuration
				$this->load->library('upload',$config);
				$this->upload->initialize($config);
				
				if($this->upload->do_upload('chq_upload')){
					
					$data = $this->upload->data();  
					 $config['image_library'] = 'gd2';  
					 $config['source_image'] = 'chq_upload/'.$data["file_name"];  
					 $config['create_thumb'] = FALSE;  
					 $config['maintain_ratio'] = FALSE;  
					 $config['quality'] = '60%';  
					 $config['width'] = 200;  
					 $config['height'] = 200;  
					 $config['new_image'] = 'chq_upload/'.$data["file_name"];  
					 $this->load->library('image_lib', $config);  
					 $this->image_lib->resize();  
					 $image_data = array(  
						  'file_name' => $file_name,
						  'uploaded_on'=>'NOW()',
						   'invoice_ref_id'=>$vc_id
						  );  
					  $this->db->insert("uploaded_invoice", $image_data); 
					}else{
					$chq_upload = '';
				}
			}else{
				$chq_upload = '';
			}
			
			$count = count($grn_chk);
			for($i=0;$i<$count;$i++)
			{
				$ind = $grn_chk[$i];
				$grn_date[$ind] = date("Y-m-d", strtotime($grn_date[$ind]));
				$data2 = array(
					'grn_no' => $grn_no[$ind],
					'grn_date' => $grn_date[$ind],
					'invoice_no' => $invoice_no[$ind],
					'grn_pay_amt' => $grn_pay_amt[$ind],
					'branch' => $branch[$ind],
					'voucher_id' => $vc_id,
					'grn_id' => $grn_id[$ind],
					'invoice_date' => $invoice_date[$ind]
				);
				$this->db->insert('voucher_particulars', $data2);
				$q1 = $this->db->query("update gnr_creation set payment_status='Closed' where gnr_id='$grn_id[$ind]'");
			}
			return $vc_id;
		}
		
		public function getVoucher($vid)
		{
			$query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate,DATE_FORMAT(transaction_date, '%d-%m-%Y') as transaction_date from voucher where voucher_id='$vid'");
			return $query->result();
		}
		
		public function getVoucherDetail($vid)
		{
			$query = $this->db->query("select *,DATE_FORMAT(grn_date, '%d-%m-%Y') as grn_date from voucher_particulars where voucher_id='$vid'");
			return $query->result();
		}
		
		public function getGrnList($vname)
		{
		    $branch_name = $_SESSION['branch_name'];
		    $cw_ceo = $_SESSION['cw_ceo'];
			if($cw_ceo=='CW')
            {
                $query = $this->db->query("select *,DATE_FORMAT(grn_date, '%d-%m-%Y') as grn_date from gnr_creation where vendor_name='$vname' order by gnr_id desc limit 10");
            }
            else{
                $query = $this->db->query("select *,DATE_FORMAT(grn_date, '%d-%m-%Y') as grn_date from gnr_creation where vendor_name='$vname' and branchname='$cw_ceo' order by gnr_id desc limit 10");
            }
			/*if($branch_name=='CW4_CEO')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(grn_date, '%d-%m-%Y') as grn_date from gnr_creation where vendor_name='$vname' and branchname='CW4' order by gnr_id desc limit 10");
			}
			else if($branch_name=='CW5_CEO')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(grn_date, '%d-%m-%Y') as grn_date from gnr_creation where vendor_name='$vname' and branchname='CW5' order by gnr_id desc limit 10");
			}
			else if($branch_name=='CW6_CEO')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(grn_date, '%d-%m-%Y') as grn_date from gnr_creation where vendor_name='$vname' and branchname='CW6' order by gnr_id desc limit 10");
			}
			else
			{
			    $query = $this->db->query("select *,DATE_FORMAT(grn_date, '%d-%m-%Y') as grn_date from gnr_creation where vendor_name='$vname' order by gnr_id desc limit 10");
			}*/
			return $query->result();
		}
		
		public function getMCVoucherList()
		{
			$query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where branch='MC' order by voucher_id desc");
			return $query->result();
		}
		
		public function getPendingMCVoucherList()
		{
			$query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where approval_status='Pending' and branch='MC' order by voucher_id desc");
			return $query->result();
		}
		
		public function get_voucher_particulars($vid)
		{
			$query = $this->db->query("select *,DATE_FORMAT(grn_date, '%d-%m-%Y') as grn_date from voucher_particulars where voucher_id='$vid'");
		    return $query->result();
		}
		public function getPayData($vid){
		    $query = $this->db->query("select *,DATE_FORMAT(v.vdate, '%d-%m-%Y') as vdate,DATE_FORMAT(v.transaction_date, '%d-%m-%Y') as transaction_date from voucher v inner join voucher_particulars vp on v.voucher_id=vp.voucher_id where v.voucher_id='$vid'");
			return $query->result();
		}
		
		public function exportStockLedger($fdate,$tdate,$iname,$branchname){
		    $f_date1 =date('Y-m-d', strtotime($fdate));
			$t_date1 =date('Y-m-d', strtotime($tdate));
		//	$branchname1 = $branchname;
			//$iname1 = $iname;
			$query = $this->db->query("select `stock_id`, `item_name`, `trans_ref_no`, DATE_FORMAT(transaction_date, '%d-%m-%Y') as trans_date, `opening_stock`, `in_qty`, `out_qty`, `closing_stock`, `last_modified`, `branchname`, `branch_id`, `item_id`, `itm_id`, `recipe_no`, `category_id` from stock_detail where item_name='$iname' and branchname='$branchname' and (transaction_date between '$f_date1' and '$t_date1') order by stock_id asc");
			return $query->result_array();	
		}
		
		public function getVoucherList()
		{
			$branch_name = $_SESSION['branch_name'];
			
			if($branch_name=='CW4_CEO' || $branch_name=='CW4_ACC')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where branch='MC' order by voucher_id desc");
			}
			else if($branch_name=='CW5_CEO' || $branch_name=='CW5-ACC')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where branch='CW5' order by voucher_id desc");
			}
			else if($branch_name=='CW6_CEO' || $branch_name=='CW6_ACC')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where branch='CW6' order by voucher_id desc");
			}
			else
			{
		    	//$query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where branch!='MC' order by voucher_id desc");
		    	$query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where (branch='CW' or branch='ESH') order by voucher_id desc");
			}
			return $query->result();
		}
	
		public function getPendingVoucherList()
		{
			$branch_name = $_SESSION['branch_name'];
			if($branch_name=='CW4_CEO')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where approval_status='Pending' and branch='MC' order by voucher_id desc");
			}
			else if($branch_name=='CW5_CEO')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where approval_status='Pending' and branch='CW5' order by voucher_id desc");
			}
			else if($branch_name=='CW6_CEO')
			{
			    $query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where approval_status='Pending' and branch='CW6' order by voucher_id desc");
			}
			else
			{
			    $query = $this->db->query("select *,DATE_FORMAT(vdate, '%d-%m-%Y') as vdate from voucher where approval_status='Pending' and branch!='MC' order by voucher_id desc");
			}
			return $query->result();
		}
		
		public function getAPresentStock()
		{
			$branch_name = $_SESSION['branch_name'];
			$cw_ceo = $_SESSION['cw_ceo'];
			if($cw_ceo=='CW')
            {
                
            }
            else{
                $query = $this->db->query("SELECT * FROM item_creation where branchname='$cw_ceo' ORDER BY item_id desc");
            }
			/*if($branch_name=='CW4_CEO')
			{
			    $query = $this->db->query("SELECT * FROM item_creation where branchname='CW4' ORDER BY item_id desc");
			}
			else if($branch_name=='CW5_CEO')
			{
			    $query = $this->db->query("SELECT * FROM item_creation where branchname='CW5' ORDER BY item_id desc");
			}
			else if($branch_name=='CW6_CEO')
			{
			    $query = $this->db->query("SELECT * FROM item_creation where branchname='CW6' ORDER BY item_id desc");
			}*/
			
			return $query->result();	
		}
		
		
		public function get_Abranch()
		{
			$branch_name = $_SESSION['branch_name'];
			if($branch_name=='CW4_CEO' || $branch_name=='CW4_ACC')
			{
			    $query = $this->db->query("SELECT * FROM branch where branch_name like 'CW4%' order by branch_name");
			}
			else if($branch_name=='CW5_CEO' || $branch_name=='CW5-ACC')
			{
			    $query = $this->db->query("SELECT * FROM branch where branch_name like 'CW5%' order by branch_name");
			}
			else if($branch_name=='CW6_CEO' || $branch_name=='CW6-ACC')
			{
			    $query = $this->db->query("SELECT * FROM branch where branch_name like 'CW6%' order by branch_name");
			}
			else{
			    $query = $this->db->query("select branch_id,branch_name from branch where branch_name not like 'ST%'");
			}
			return $query->result();
		}
		
		public function getCWPresentStock()
		{
			$query = $this->db->query("SELECT * FROM item_creation where branchname IN ('CW','ESH','GDW','ESH-GDW') and status='Enabled'  ORDER BY item_id desc");
			return $query->result();	
		}
		public function getGDWPresentStock()
		{
			$query = $this->db->query("select * from godown_stock");
			return $query->result();	
		}
		
	}
?>