<?php
    #[\AllowDynamicProperties]
	class Transfer_model extends CI_model
	{
		public function __construct()
		{
			parent::__construct();
			$this->load->database();
		}
		public function addStkTransfer($postdata)
		{
			extract($postdata);
			$st_trans_date = date("Y-m-d", strtotime($st_trans_date));
			$order_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			$this->db->select('MAX(st_tr_no) as st_tr_no',false);
			$this->db->where('frm_branchname',$branch);
			$result = $this->db->get('stock_transfer')->row();
			$st_tr_no = $result->st_tr_no;
			if($st_tr_no == 0){
				$st_tr_no = 1;
			}
			else{
				$st_tr_no = $st_tr_no+1;
			}
			$stk_tr_no = "TNS"."/".$branch."-".$branch_name."/".$st_tr_no;
			
			$k=0;
			for($j=0;$j<count($quantity);$j++)
			{
				if($quantity[$j]!='0' && $quantity[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			$data = array('st_tr_no'=> $st_tr_no,
			'stk_tr_no'=> $stk_tr_no,
			'stk_tr_date'=> $st_trans_date,
			'frm_branchname'=> $branch,
			'to_branchname'=> $branch_name,
			'total'=> $total,
			'user_name'=> $full_name,
			'tr_time'=> $order_time,
			'branch_id'=> $branch_id
			);
			$this->db->insert('stock_transfer', $data);
			$sid = $this->db->insert_id();
			}
			
			if($sid)
			{
			//insert to sales price
			$count = count($item_name);
			for($i=0;$i<$count;$i++)
			{
				$q1 = $this->db->query("select * from item_creation where item_id='$item_id[$i]'");
				if($q1->num_rows() > 0)
				{
					$row = $q1->row_array();
					$qty[$i] = $row['stock_item'];
					$qty1[$i] = $qty[$i] - $quantity[$i];
					
					$q2 = $this->db->query("UPDATE item_creation set stock_item='$qty1[$i]' WHERE item_id= '$item_id[$i]'");
				}
				$data2 = array(
					'item_name' => $item_name[$i],
					'uom' => $uom[$i],
					'present_stock' => $close_stock[$i],
					'quantity' => $quantity[$i],
					'price' => $price[$i],
					'total_amount' => $total_amount[$i],
					'remarks' => $remarks[$i],
					'item_id' => $item_id[$i],
					'stk_tr_id' => $sid,
					'itm_id' => $itm_id[$i],
					'category_id' => $category_id[$i]
					);
				$this->db->insert('stock_transfer_item', $data2);
				
				if($branch_name == 'GDW')
				{
					$q3 = $this->db->query("select stock from godown_stock where item_id='$item_id[$i]' and from_branchname='$branch'");
					if($q3->num_rows() > 0)
					{
						$row3 = $q3->row_array();
						$stock[$i] = $row3['stock'];
						$stk[$i] = $stock[$i] + $quantity[$i];
						
						$br = $this->db->query("select branch_id from branch where branch_name='$branch_name'");
						$brow = $br->row_array();
						$br_id = $brow['branch_id'];
						
						$q4 = $this->db->query("UPDATE godown_stock set price='$price[$i]',tax='$tax[$i]',stock='$stk[$i]',itm_id='$itm_id[$i]',category_id='$category_id[$i]' WHERE  item_id='$item_id[$i]' and from_branchname='$branch'");
						
						$data3 = array(
							'item_name' => $item_name[$i],
							'trans_ref_no' => $stk_tr_no,
							'trans_type'=>'transIn',
							'transaction_date' => $st_trans_date,
							'opening_stock' => $stock[$i],
							'in_qty' => $quantity[$i],
							'closing_stock' => $stk[$i],
							'last_modified' => $lm,
							'branchname' => $branch_name,
							'item_id' => $item_id[$i],
							'itm_id' => $itm_id[$i],
							'category_id' => $category_id[$i],
							'branch_id' => $br_id
							);
						$this->db->insert('stock_detail', $data3);
					}
					else
					{
						$data4 = array(
							'item_name' => $item_name[$i],
							'uom' => $uom[$i],
							'price' => $price[$i],
							'tax' => $tax[$i],
							'stock' => $quantity[$i],
							'from_branchname' => $branch,
							'branchname' => $branch_name,
							'item_id' => $item_id[$i],
							'itm_id' => $itm_id[$i],
							'category_id' => $category_id[$i]
							);
						$this->db->insert('godown_stock', $data4);
						
						$br = $this->db->query("select branch_id from branch where branch_name='$branch_name'");
						$brow = $br->row_array();
						$br_id = $brow['branch_id'];
						
						$data3 = array(
							'item_name' => $item_name[$i],
							'trans_ref_no' => $stk_tr_no,
							'trans_type'=>'transIn',
							'transaction_date' => $st_trans_date,
							'opening_stock' => '0',
							'in_qty' => $quantity[$i],
							'closing_stock' => $quantity[$i],
							'last_modified' => $lm,
							'branchname' => $branch_name,
							'item_id' => $item_id[$i],
							'itm_id' => $itm_id[$i],
							'category_id' => $category_id[$i],
							'branch_id' => $br_id
							);
						$this->db->insert('stock_detail', $data3);
					}
				}
				
				if($branch_name == 'ESH-GDW')
				{
					$q3 = $this->db->query("select stock from esh_godown where item_id='$item_id[$i]' and from_branchname='$branch'");
					if($q3->num_rows() > 0)
					{
						$row3 = $q3->row_array();
						$stock[$i] = $row3['stock'];
						$stk[$i] = $stock[$i] + $quantity[$i];
						
						$br = $this->db->query("select branch_id from branch where branch_name='$branch_name'");
						$brow = $br->row_array();
						$br_id = $brow['branch_id'];
						
						$q4 = $this->db->query("UPDATE esh_godown set price='$price[$i]',tax='$tax[$i]',stock='$stk[$i]',itm_id='$itm_id[$i]',category_id='$category_id[$i]' WHERE  item_id='$item_id[$i]' and from_branchname='$branch'");
						
						$data3 = array(
							'item_name' => $item_name[$i],
							'trans_ref_no' => $stk_tr_no,
							'trans_type'=>'transIn',
							'transaction_date' => $st_trans_date,
							'opening_stock' => $stock[$i],
							'in_qty' => $quantity[$i],
							'closing_stock' => $stk[$i],
							'last_modified' => $lm,
							'branchname' => $branch_name,
							'item_id' => $item_id[$i],
							'itm_id' => $itm_id[$i],
							'category_id' => $category_id[$i],
							'branch_id' => $br_id
							);
						$this->db->insert('stock_detail', $data3);
					}
					else
					{
						$data4 = array(
							'item_name' => $item_name[$i],
							'uom' => $uom[$i],
							'price' => $price[$i],
							'tax' => $tax[$i],
							'stock' => $quantity[$i],
							'from_branchname' => $branch,
							'branchname' => $branch_name,
							'item_id' => $item_id[$i],
							'itm_id' => $itm_id[$i],
							'category_id' => $category_id[$i]
							);
						$this->db->insert('esh_godown', $data4);
						
						$br = $this->db->query("select branch_id from branch where branch_name='$branch_name'");
						$brow = $br->row_array();
						$br_id = $brow['branch_id'];
						
						$data3 = array(
							'item_name' => $item_name[$i],
							'trans_ref_no' => $stk_tr_no,
							'trans_type'=>'transIn',
							'transaction_date' => $st_trans_date,
							'opening_stock' => '0',
							'in_qty' => $quantity[$i],
							'closing_stock' => $quantity[$i],
							'last_modified' => $lm,
							'branchname' => $branch_name,
							'item_id' => $item_id[$i],
							'itm_id' => $itm_id[$i],
							'category_id' => $category_id[$i],
							'branch_id' => $br_id
							);
						$this->db->insert('stock_detail', $data3);
					}
				}
				
				if($branch_name == 'ESH' || $branch_name == 'CW')
				{
					$q5 = $this->db->query("select * from item_creation where item_name='$item_name[$i]' and branchname='$branch_name'");
					if($q5->num_rows() > 0)
					{
						$row4 = $q5->row_array();
						$stock[$i] = $row4['stock_item'];
						$stk[$i] = $stock[$i] + $quantity[$i];
						$item_sid[$i] = $row4['item_id'];
						
						$q6 = $this->db->query("UPDATE item_creation set stock_item='$stk[$i]' WHERE item_name='$item_name[$i]' and branchname='$branch_name'");
					}
					$br = $this->db->query("select branch_id from branch where branch_name='$branch_name'");
					$brow = $br->row_array();
					$br_id = $brow['branch_id'];
					
					$data5 = array(
						'item_name' => $item_name[$i],
						'trans_ref_no' => $stk_tr_no,
						'trans_type'=>'transIn',
						'transaction_date' => $st_trans_date,
						'opening_stock' => $stock[$i],
						'in_qty' => $quantity[$i],
						'closing_stock' => $stk[$i],
						'last_modified' => $lm,
						'branchname' => $branch_name,
						'item_id' => $item_sid[$i],
						'itm_id' => $itm_id[$i],
						'category_id' => $category_id[$i],
						'branch_id' => $br_id
						);
					$this->db->insert('stock_detail', $data5);
				}
				$data6 = array(
					'item_name' => $item_name[$i],
					'trans_ref_no' => $stk_tr_no,
					'trans_type'=>'transOut',
					'transaction_date' => $st_trans_date,
					'opening_stock' => $qty[$i],
					'out_qty' => $quantity[$i],
					'closing_stock' => $qty1[$i],
					'last_modified' => $lm,
					'branchname' => $branch,
					'item_id' => $item_id[$i],
					'itm_id' => $itm_id[$i],
					'category_id' => $category_id[$i],
					'branch_id' => $branch_id
					);
				$this->db->insert('stock_detail', $data6);
			}
		}
			return $sid;
		}
		
		public function addGdwStkTransfer($postdata)
		{
			extract($postdata);
			$st_trans_date = date("Y-m-d", strtotime($st_trans_date));
			$order_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			$this->db->select('MAX(st_tr_no) as st_tr_no',false);
			$this->db->where('frm_branchname',$branch);
			$result = $this->db->get('stock_transfer')->row();
			$st_tr_no = $result->st_tr_no;
			if($st_tr_no == 0){
				$st_tr_no = 1;
			}
			else{
				$st_tr_no = $st_tr_no+1;
			}
			$stk_tr_no = "TNS"."/".$branch."-".$branch_name."/".$st_tr_no;
			
			$k=0;
			for($j=0;$j<count($quantity);$j++)
			{
				if($quantity[$j]!='0' && $quantity[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			$data = array('st_tr_no'=> $st_tr_no,
			'stk_tr_no'=> $stk_tr_no,
			'stk_tr_date'=> $st_trans_date,
			'frm_branchname'=> $branch,
			'to_branchname'=> $branch_name,
			'total'=> $total,
			'user_name'=> $full_name,
			'tr_time'=> $order_time,
			'branch_id'=> $branch_id
			);
			$this->db->insert('stock_transfer', $data);
			$sid = $this->db->insert_id();
			}
			
			if($sid)
			{
			//insert to sales price
			$count = count($item_name);
			for($i=0;$i<$count;$i++)
			{
				$q1 = $this->db->query("select * from godown_stock where item_id='$item_id[$i]'");
				if($q1->num_rows() > 0)
				{
					$row = $q1->row_array();
					$qty[$i] = $row['stock'];
					$qty1[$i] = $qty[$i] - $quantity[$i];
					
					$q2 = $this->db->query("UPDATE godown_stock set stock='$qty1[$i]' WHERE item_id= '$item_id[$i]'");
				}
				$data2 = array(
					'item_name' => $item_name[$i],
					'uom' => $uom[$i],
					'present_stock' => $close_stock[$i],
					'quantity' => $quantity[$i],
					'price' => $price[$i],
					'total_amount' => $total_amount[$i],
					'remarks' => $remarks[$i],
					'item_id' => $item_id[$i],
					'stk_tr_id' => $sid,
					'itm_id' => $itm_id[$i],
					'category_id' => $category_id[$i]
					);
				$this->db->insert('stock_transfer_item', $data2);
				
				if($branch_name == 'ESH' || $branch_name == 'CW')
				{
					$q5 = $this->db->query("select * from item_creation where item_name='$item_name[$i]' and branchname='$branch_name'");
					if($q5->num_rows() > 0)
					{
						$row4 = $q5->row_array();
						$stock[$i] = $row4['stock_item'];
						$stk[$i] = $stock[$i] + $quantity[$i];
						$item_sid[$i] = $row4['item_id'];
						
						$q6 = $this->db->query("UPDATE item_creation set stock_item='$stk[$i]' WHERE item_name='$item_name[$i]' and branchname='$branch_name'");
					}
					$br = $this->db->query("select branch_id from branch where branch_name='$branch_name'");
					$brow = $br->row_array();
					$br_id = $brow['branch_id'];
					
					$data5 = array(
						'item_name' => $item_name[$i],
						'trans_ref_no' => $stk_tr_no,
						'trans_type'=>'transIn',
						'transaction_date' => $st_trans_date,
						'opening_stock' => $stock[$i],
						'in_qty' => $quantity[$i],
						'closing_stock' => $stk[$i],
						'last_modified' => $lm,
						'branchname' => $branch_name,
						'item_id' => $item_sid[$i],
						'itm_id' => $itm_id[$i],
						'category_id' => $category_id[$i],
						'branch_id' => $br_id
						);
					$this->db->insert('stock_detail', $data5);
				}
				$data6 = array(
					'item_name' => $item_name[$i],
					'trans_ref_no' => $stk_tr_no,
					'trans_type'=>'transOut',
					'transaction_date' => $st_trans_date,
					'opening_stock' => $qty[$i],
					'out_qty' => $quantity[$i],
					'closing_stock' => $qty1[$i],
					'last_modified' => $lm,
					'branchname' => $branch,
					'item_id' => $item_id[$i],
					'itm_id' => $itm_id[$i],
					'category_id' => $category_id[$i],
					'branch_id' => $branch_id
					);
				$this->db->insert('stock_detail', $data6);
			}
		}
			return $sid;
		}
		
		public function getStkTransfer($sid)
		{
			$query = $this->db->query("select stk_tr_no,stk_tr_date,to_branchname,user_name from stock_transfer where stk_tr_id='$sid'");
			return $query->result();	
		}
		
		public function getStkTransferItem($sid)
		{
			$query = $this->db->query("select item_name,uom,quantity,remarks from stock_transfer_item where stk_tr_id='$sid'");
			return $query->result();	
		}
		
		public function getStkTransferList($branch_id){
			$query = $this->db->query("select stk_tr_no,stk_tr_date,to_branchname,user_name,stk_tr_id,total from stock_transfer where branch_id='$branch_id' order by stk_tr_id desc");
			return $query->result();	
		}
		
		public function get_godown_stk_transfer_list($branch_name){
			$query = $this->db->query("select *,DATE_FORMAT(stk_tr_date, '%d-%m-%Y') as stk_tr_date from stock_transfer where frm_branchname='$branch_name' ORDER by stk_tr_id");
			return $query->result();	
		}
		
		public function getStkTransferResult($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$to_branch = $data['to_branch'];
			$branch_id = $data['branch_id'];
			$iname = $data['item_name'];
			if($f_date!="" && $t_date!="" && $to_branch!="" && $iname=="")
			{
				$query = $this->db->query("select *,DATE_FORMAT(stk_tr_date, '%d-%m-%Y') as stk_tr_date from stock_transfer where branch_id='$branch_id' and to_branchname='$to_branch' and stk_tr_date between '$f_date' and '$t_date' ORDER by stk_tr_id");
			}
			else if($f_date!="" && $t_date!="" && $to_branch!="" && $iname!="")
			{
				if($iname=="All")
				{
					$query = $this->db->query("SELECT s.item_name,st.to_branchname,sum(s.quantity)as qty,sum(s.total_amount) as total FROM stock_transfer_item s inner join stock_transfer st on s.stk_tr_id=st.stk_tr_id WHERE st.to_branchname='$to_branch' and st.branch_id='$branch_id' and st.stk_tr_date between '$f_date' and '$t_date' group by s.item_name");
				}
				else if($iname!="All")
				{
					$query = $this->db->query("SELECT s.item_name,st.to_branchname,sum(s.quantity)as qty,sum(s.total_amount) as total FROM stock_transfer_item s inner join stock_transfer st on s.stk_tr_id=st.stk_tr_id WHERE s.item_name='$iname' and st.to_branchname='$to_branch' and st.branch_id='$branch_id' and st.stk_tr_date between '$f_date' and '$t_date' group by st.to_branchname");
				}
			}
			return $query->result_array();	
		}
		
		public function getGDWStkTransferResult($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$branch_name = $_SESSION['branch_name'];
			$branch_id = $data['branch_id'];
			$iname = $data['item_name'];
			if($f_date!="" && $t_date!="" && $iname=="")
			{
				$query = $this->db->query("select *,DATE_FORMAT(stk_tr_date, '%d-%m-%Y') as stk_tr_date from stock_transfer where frm_branchname='$branch_name' and stk_tr_date between '$f_date' and '$t_date' ORDER by stk_tr_id");
				
			}
			else if($f_date!="" && $t_date!=""  && $iname!="")
			{
				if($iname=="All")
				{
					$query = $this->db->query("SELECT s.item_name,st.to_branchname,sum(s.quantity)as qty,sum(s.total_amount) as total FROM stock_transfer_item s inner join stock_transfer st on s.stk_tr_id=st.stk_tr_id WHERE st.to_branchname='CW' and st.frm_branchname='GDW' and st.stk_tr_date between '$f_date' and '$t_date' group by s.item_name");
				}
				else if($iname!="All")
				{
					$query = $this->db->query("SELECT s.item_name,st.to_branchname,sum(s.quantity)as qty,sum(s.total_amount) as total FROM stock_transfer_item s inner join stock_transfer st on s.stk_tr_id=st.stk_tr_id WHERE s.item_name='$iname' and st.frm_branchname='GDW' and st.stk_tr_date between '$f_date' and '$t_date' group by st.to_branchname");
				}
			}
			return $query->result_array();	
		}
		
		public function getOutlets()
		{
			$query = $this->db->query("select * from user where username!='CEO'");
			return $query->result();	
		}
		
		public function getItemProduct($itype,$br_id)
		{
			$temp = Array();
			if($itype == 'Raw Material')
			{
				$query = $this->db->query("select item_name,uom from item_creation where branch_id='$br_id' and status='Enabled' order by item_name");
				$result = $query->result();
				foreach($result as $res)
				{
					$temp[] = $res;
					/*$temp[] = array(
						'item_name' => $res->item_name,
						'uom' => $res->uom
					); */
				}
				/*$item = array(
				'items' => $temp
				);*/
				echo json_encode($temp);
				file_put_contents('itm_list.json', json_encode($temp));
			}
			else if($itype == 'Finished Product')
			{
				$query = $this->db->query("select rname as item_name from recipe where branch_id='$br_id' and status='Enabled' order by rname");
				$result = $query->result();
				foreach($result as $res)
				{
					$temp[] = $res;
					/*$temp[] = array(
						'item_name' => $res->item_name,
						'uom' => $res->uom	
					);*/
				}
				/*$item = array(
				'items' => $temp
				);*/
				echo json_encode($temp);
				file_put_contents('itm_list.json', json_encode($temp));
			}
		}
		
		public function addTransfer($postdata)
		{
			extract($postdata);
			$trans_date = date("Y-m-d", strtotime($trans_date));
			$tr_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			$this->db->select('MAX(tr_no) as tr_no',false);
			$this->db->where('branch_id',$branch_id);
			$result = $this->db->get('transfer')->row();
			$tr_no = $result->tr_no;
			if($tr_no == 0){
				$tr_no = 1;
			}
			else{
				$tr_no = $tr_no+1;
			}
			$trans_no = "TRNS"."/".$branch_name."/".$to_branch."/".$tr_no;
			
			$k=0;
			for($j=0;$j<count($quantity);$j++)
			{
				if($quantity[$j]!='0' && $quantity[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			$data = array(
			'tr_no'=> $tr_no,
			'trans_no'=> $trans_no,
			'trans_date'=> $trans_date,
			'dept_name'=> $outlet,
			'branchname'=> $branch_name,
			'to_branch'=> $to_branch,
			'trans_time'=> $tr_time,
			'branch_id'=> $branch_id
			);
			$this->db->insert('transfer', $data);
			$trid = $this->db->insert_id();
			}
			
			if($trid)
			{
			$count = count($item_name);
			for($i=0;$i<$count;$i++)
			{
				if($item_type[$i] == 'Raw Material')
				{
					$q1 = $this->db->query("select * from item_creation where item_id='$item_id[$i]'");
					if($q1->num_rows() > 0)
					{
						$row = $q1->row_array();
						$qty[$i] = $row['stock_item'];//opening stock
						$qty1[$i] = $qty[$i] - $quantity[$i];//closing stock
						
						$q2 = $this->db->query("UPDATE item_creation set stock_item='$qty1[$i]' WHERE  item_id= '$item_id[$i]'");
					}
					$data2 = array(
						'item_type' => $item_type[$i],
						'item_name' => $item_name[$i],
						'uom' => $uom[$i],
						'quantity' => $quantity[$i],
						'remarks' => $remarks[$i],
						'status' => 'Pending',
						'tr_id' => $trid,
						'item_id' => $item_id[$i],
						'cat_id' => $cat_id[$i],
						'item_no' => $itm_id[$i]
					);
					$this->db->insert('transfer_item', $data2);
					
					$data3 = array(
						'item_name' => $item_name[$i],
						'trans_ref_no' => $trans_no,
						'trans_type'=>'transIssue',
						'transaction_date' => $trans_date,
						'opening_stock' => $qty[$i],
						'out_qty' => $quantity[$i],
						'closing_stock' => $qty1[$i],
						'last_modified' => $lm,
						'branchname' => $branch_name,
						'item_id' => $item_id[$i],
						'category_id' => $cat_id[$i],
						'itm_id' => $itm_id[$i],
						'branch_id' => $branch_id
					);
					$this->db->insert('stock_detail', $data3);
				}
				if($item_type[$i] == 'Finished Product')
				{
					$q1 = $this->db->query("select * from recipe where recipe_id='$item_id[$i]'");
				
						$row = $q1->row_array();
						$qty[$i] = $row['production_stock'];//opening stock
						$qty1[$i] = $qty[$i] - $quantity[$i];//closing stock
						
						$this->db->query("UPDATE recipe set production_stock='$qty1[$i]' WHERE recipe_id='$item_id[$i]'");
				
					$data2 = array(
						'item_type' => $item_type[$i],
						'item_name' => $item_name[$i],
						'uom' => $uom[$i],
						'quantity' => $quantity[$i],
						'remarks' => $remarks[$i],
						'status' => 'Pending',
						'tr_id' => $trid,
						'item_id' => $item_id[$i],
						'cat_id' => $cat_id[$i],
						'recipe_no' => $itm_id[$i]
					);
					$this->db->insert('transfer_item', $data2);
					
					$data3 = array(
						'item_name' => $item_name[$i],
						'trans_ref_no' => $trans_no,
						'trans_type'=>'transPrIssue',
						'transaction_date' => $trans_date,
						'opening_stock' => $qty[$i],
						'out_qty' => $quantity[$i],
						'closing_stock' => $qty1[$i],
						'last_modified' => $lm,
						'branchname' => $branch_name,
						'item_id' => $item_id[$i],
						'category_id' => $cat_id[$i],
						'recipe_no' => $itm_id[$i],
						'branch_id' => $branch_id
					);
					$this->db->insert('stock_detail', $data3);
				}
			}
		}
			return $trid;
		}
		
		public function addTransferInward($postdata)
		{
			extract($postdata);
			$inward_date = date("Y-m-d", strtotime($inward_date));
			$tr_time = date("h:i A");
			$lm=date("Y-m-dH:i:s",time());
			$this->db->select('MAX(tr_in_no) as tr_in_no',false);
			$this->db->where('branch_id',$branch_id);
			$result = $this->db->get('transfer_inward')->row();
			$tr_in_no = $result->tr_in_no;
			if($tr_in_no == 0){
				$tr_in_no = 1;
			}
			else{
				$tr_in_no = $tr_in_no+1;
			}
			$trans_in_no = "TRNS/IN"."/".$branchname."/".$tr_in_no;
			
			$k=0;
			for($j=0;$j<count($inward_quantity);$j++)
			{
				if($inward_quantity[$j]!='0' && $inward_quantity[$j]!='')
				{
					$k=$k+1;
				}
			}
			if($k>0)
			{
			$data = array(
			'tr_in_no'=> $tr_in_no,
			'trans_in_no'=> $trans_in_no,
			'tr_in_date'=> $inward_date,
			'from_dept'=> $frm_dept,
			'tr_id'=> $tr_id,
			'branchname'=> $branchname,
			'in_time'=> $tr_time,
			'branch_id'=> $branch_id
			);
			$this->db->insert('transfer_inward', $data);
			$trinid = $this->db->insert_id();
			}
			
			if($trinid)
			{
			$count = count($item_name);
			for($i=0;$i<$count;$i++)
			{
				$qty[$i] = $inward_quantity[$i];
				$this->db->query("update transfer_item set received_qty='$qty[$i]' where tr_item_id='$tr_item_id[$i]'");
				if($item_type[$i] == 'Raw Material')
				{
					$q1 = $this->db->query("select * from item_creation where item_name='$item_name[$i]' and branch_id='$branch_id'");
					if($q1->num_rows() > 0)
					{
						$row = $q1->row_array();
						$stock[$i] = $row['stock_item'];//opening stock
						$stk[$i] = $stock[$i] + $inward_quantity[$i];//closing stock
						$itemid[$i]=$row['item_id'];
						
						$q2 = $this->db->query("UPDATE item_creation set stock_item='$stk[$i]' WHERE  item_id= '$itemid[$i]' and branch_id='$branch_id'");
					}
					$data2 = array(
						'item_type' => $item_type[$i],
						'item_name' => $item_name[$i],
						'uom' => $uom[$i],
						'quantity' => $inward_quantity[$i],
						'remarks' => $remarks[$i],
						'tr_in_id' => $trinid,
						'tr_item_id' => $tr_item_id[$i],
						'item_id' => $itemid[$i],
						'cat_id' => $cat_id[$i],
						'item_no' => $itm_id[$i]
					);
					$this->db->insert('transfer_inward_item', $data2);
					$trinitid = $this->db->insert_id();
					
					if($inward_quantity[$i] != '0' && $inward_quantity[$i] != '')
					{
						$data3 = array(
							'item_name' => $item_name[$i],
							'trans_ref_no' => $trans_in_no,
							'trans_type'=>'transInward',
							'transaction_date' => $inward_date,
							'opening_stock' => $stock[$i],
							'in_qty' => $inward_quantity[$i],
							'closing_stock' => $stk[$i],
							'last_modified' => $lm,
							'branchname' => $branchname,
							'item_id' => $itemid[$i],
							'category_id' => $cat_id[$i],
							'itm_id' => $itm_id[$i],
							'branch_id' => $branch_id
						);
						$this->db->insert('stock_detail', $data3);
					}
				}
				else if($item_type[$i] == 'Finished Product')
				{
					$q1 = $this->db->query("select * from recipe where rname='$item_name[$i]' and branch_id='$branch_id'");
					if($q1->num_rows() > 0)
					{
						$row = $q1->row_array();
						$stock[$i] = $row['production_stock'];//opening stock
						$stk[$i] = (float)$stock[$i] + (float)$inward_quantity[$i];//closing stock
						$recipe_id[$i]=$row['recipe_id'];
						$q2 = $this->db->query("UPDATE recipe set production_stock='$stk[$i]' WHERE recipe_id= '$recipe_id[$i]'");
					}
					$data2 = array(
						'item_type' => $item_type[$i],
						'item_name' => $item_name[$i],
						'uom' => $uom[$i],
						'quantity' => $inward_quantity[$i],
						'remarks' => $remarks[$i],
						'tr_in_id' => $trinid,
						'tr_item_id' => $tr_item_id[$i],
						'item_id' => $recipe_id[$i],
						'cat_id' => $cat_id[$i],
						'recipe_no' => $recipe_no[$i]
					);
					$this->db->insert('transfer_inward_item', $data2);
					$trinitid = $this->db->insert_id();
					
					if($inward_quantity[$i] != '0' && $inward_quantity[$i] != '')
					{
						$data3 = array(
							'item_name' => $item_name[$i],
							'trans_ref_no' => $trans_in_no,
							'trans_type'=>'transPrInward',
							'transaction_date' => $inward_date,
							'opening_stock' => $stock[$i],
							'in_qty' => $inward_quantity[$i],
							'closing_stock' => $stk[$i],
							'last_modified' => $lm,
							'branchname' => $branchname,
							'item_id' => $recipe_id[$i],
							'category_id' => $cat_id[$i],
							'recipe_no' => $recipe_no[$i],
							'branch_id' => $branch_id
						);
						$this->db->insert('stock_detail', $data3);
					}
				}
				if (empty($inward_quantity[$i])) {
					$q3 = $this->db->query("DELETE FROM transfer_inward_item WHERE tr_in_item_id='$trinitid'");
				}
				if($qty[$i] == $trans_qty[$i] && $inward_quantity[$i]!='') {
					$q4 = $this->db->query("update transfer_item set status='Closed' where tr_item_id='$tr_item_id[$i]'");
				}
				$q5 = $this->db->query("SELECT count(*) as `num` FROM transfer_item where tr_id='$tr_id'");
				$row2 = $q5->row_array();
				$count1 = $row2['num'];
				$q6 = $this->db->query("SELECT count(*) as `num1` FROM transfer_item where status='Closed' and tr_id='$tr_id'");
				$row3 = $q6->row_array();
				$count2 = $row3['num1'];
				if($count1 == $count2 ) {
					$q7 = $this->db->query("update transfer set to_status='Closed',from_status='Closed' where tr_id='$tr_id'");
				}
				$q8 = $this->db->query("update transfer set rcv_status='Received' where tr_id='$tr_id'");
			}
		}
			return $trinid;
		}
		
		public function getTransfer($trid)
		{
			$query = $this->db->query("select *,DATE_FORMAT(trans_date, '%d-%m-%Y') as trans_date from transfer where tr_id='$trid'");
			return $query->result();	
		}
		
		public function getTransferItem($trid)
		{
			$query = $this->db->query("select * from transfer_item where tr_id='$trid'");
			return $query->result();	
		}
		
		public function getTransferList($branch)
		{
			$query = $this->db->query("select *,DATE_FORMAT(trans_date, '%d-%m-%Y') as trans_date from transfer where (branchname='$branch' and to_status='Pending') or (to_branch='$branch' and from_status='Pending') order by tr_id desc");
			return $query->result();	
		}
		
		public function getTransferInward($trinid)
		{
			$query = $this->db->query("select *,DATE_FORMAT(T.trans_date, '%d-%m-%Y') as trans_date,DATE_FORMAT(tr_in_date, '%d-%m-%Y') as tr_in_date from transfer T inner join transfer_inward TI on T.tr_id=TI.tr_id where TI.tr_in_id='$trinid'");
			return $query->result();	
		}
		
		public function getTransferInwardItem($trinid)
		{
			$query = $this->db->query("select * from transfer_inward_item where tr_in_id='$trinid'");
			return $query->result();	
		}
		
		public function getTransferInwardList($branch_id)
		{
			$query = $this->db->query("select *,DATE_FORMAT(T.trans_date, '%d-%m-%Y') as trans_date,DATE_FORMAT(TI.tr_in_date, '%d-%m-%Y') as tr_in_date from transfer T inner join transfer_inward TI on T.tr_id=TI.tr_id where TI.branch_id='$branch_id' order by tr_in_id desc");
			return $query->result();	
		}
		
		public function getTransferClosedList($branch)
		{
			$query = $this->db->query("select *,DATE_FORMAT(trans_date, '%d-%m-%Y') as trans_date from transfer where (branchname='$branch' and to_status='Closed') or (to_branch='$branch' and from_status='Closed') order by tr_id desc");
			return $query->result();	
		}
		
		public function getCloseTransfer($trid)
		{
			$query = $this->db->query("select *,DATE_FORMAT(trans_date, '%d-%m-%Y') as trans_date from transfer as T,user as L where T.tr_id='$trid' and T.branch_id=L.branch_id");
			return $query->result();	
		}
		public function getCStkTransferList(){
			$query = $this->db->query("SELECT stk_tr_no,stk_tr_date,to_branchname,user_name,stk_tr_id,total from stock_transfer  order by stk_tr_id desc");
			return $query->result();	
		}

		public function getCStkTransfer($data)
		{
			$f_date =date('Y-m-d', strtotime($data['from_date']));
			$t_date =date('Y-m-d', strtotime($data['to_date']));
			$to_branch = $data['to_branch'];
			$query = $this->db->query("SELECT *,DATE_FORMAT(stk_tr_date, '%d-%m-%Y') as stk_tr_date from stock_transfer where frm_branchname='$to_branch' and stk_tr_date between '$f_date' and '$t_date' ORDER by stk_tr_id");
			
			return $query->result();	
		}
		
		public function get_users($branch_id,$smod_id){
			$query = $this->db->query("SELECT * from user_access where branch_id='$branch_id' and module_id='$smod_id'");
			return $query->result();	
		}
		
		/*public function get_taluk($item_type,$branch_id){
		    if($item_type=='Raw Material'){
		     $query = $this->db->query("select item_name,uom from item_creation where branch_id='$branch_id' and status='Enabled' order by item_name");
		
		    }
		    else if($item_type=='Finished Product'){
		        $query = $this->db->query("select rname as item_name from recipe where branch_id='$branch_id' and status='Enabled' order by rname");
		    }
            	return $query->result();
		}*/
		
		public function getOutletsdept()
    	{
    		$query = $this->db->query("select * from user where authority='cw1_dept'");
    		return $query->result();	
    	}
	}
?>