<?php
	class User_model extends CI_model
	{
		public function __construct()
		{
			parent::__construct();
			$this->load->database();
		}
		
		//Module
		public function insert_module($data){
			$this->db->insert('module',$data);
			return true;
		}
		
		public function get_module(){
			$this->db->select('module_id,module_name');  
			$this->db->from('module'); 
			$query = $this->db->get();  
			return $query->result(); 
		}
		
		public function getModule(){
			$this->db->select('module_id,module_name');  
			$this->db->from('module'); 
			$query = $this->db->get();  
			foreach($query->result_array() as $row){  
				$data[$row['module_id']]=$row['module_name'];  
			}  
		  return $data; 
		}	
		 
		public function get_module_id($module_id){
			$this->db->select('module_id,module_name');
			$this->db->from('module');
			$this->db->where('module_id',$module_id);
			$query = $this->db->get();
			if($query->num_rows() > 0)
			{
				return $query->result_array();
			}
			else{
				return '';
			}
		}
		
		//Sub Module
		public function insert_sub_module($data){
			$this->db->insert('sub_module',$data);
			return true;
		}
		
		public function get_sub_module(){
			$query = $this->db->query("select M.module_id,M.module_name,S.sub_mod_id,S.sub_mod_name,S.module_url,S.module_icon,S.user_reference from module M inner join sub_module S on M.module_id=S.module_id");
			return $query->result();
		}
				
		public function get_sub_module_id($sub_mod_id){
			$this->db->select('sub_mod_id,sub_mod_name,module_id,module_url,module_icon,user_reference');
			$this->db->from('sub_module');
			$this->db->where('sub_mod_id',$sub_mod_id);
			$query = $this->db->get();
			if($query->num_rows() > 0)
			{
				return $query->result_array();
			}
			else{
				return '';
			}
		}
		
		//Permission
		public function addPermission($postdata)
		{
			extract($postdata);
			$data = array(
				'permission_name' => $permission_name
			);
			$this->db->insert('permission', $data);
		}
		
		public function get_permission()
		{
			$query = $this->db->query("select permission_id,permission_name from permission");
			/*foreach($query->result_array() as $row)
			{  
				$data[$row['permission_id']]=$row['permission_name'];  
			}  */
			//return $data;
			return $query->result();
		}
		
		//Sub Permission
		public function addSubPermission($postdata)
		{
			extract($postdata);
			$data = array(
				'sub_permsn_name' => $subpermission_name,
				'permission_id' => $permission
			);
			$this->db->insert('sub_permission', $data);
		}
		
		public function get_subpermission()
		{
			$query = $this->db->query("select P.permission_id,P.permission_name,S.sub_permsn_id,S.sub_permsn_name from sub_permission S inner join permission P on P.permission_id=S.permission_id");
			return $query->result();
		}
		
		//Group
		public function addUsergroup($postdata)
		{
			extract($postdata);
			$data = array(
				'group_name' => $group_name
			);
			$this->db->insert('user_group', $data);
		}
		
		public function get_usergroup()
		{
			$query = $this->db->query("select group_id,group_name from user_group");
			return $query->result();
		}
		
		public function getUsergroup($id)
		{
			$query = $this->db->query("select group_id,group_name from user_group where group_id='$id'");
			return $query->result();
		}
		
		public function updateUsergroup($postdata)
		{
			extract($postdata);
			$data = array(
				'group_name' => $group_name
			);
			$this->db->where('group_id', $group_id);
			$this->db->update('user_group', $data);
		}
		
		//Branch
		public function addBranch($postdata)
		{
			extract($postdata);
			$data = array(
				'branch_name' => $branch_name
			);
			$this->db->insert('branch', $data);
		}
		
		public function get_branch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_name not like 'ST%'");
			return $query->result();
		}
		
		public function get_CWbranch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_name not like 'ST%' and branch_name not like 'E%'");
			return $query->result();
		}
		
		public function get_ESHbranch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_name  like 'E%'");
			return $query->result();
		}
		
		public function get_ctrbranch()
		{
			$query = $this->db->query("select branch_id,branch_name,branch_code from user where user_group='6'");
			return $query->result();
		}
		
		public function get_ktnbranch()
		{
			$query = $this->db->query("select branch_id,branch_name,username from user where (user_group='8' or user_group='17')");
			return $query->result();
		}
		
		public function get_supbranch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_name in('STR')");
			return $query->result();
		}
		
		public function get_rcpbranch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_name not like 'ST%' and branch_name not in ('CW','ESH','GDW','SEC','FNC','MTC','PRD','CW4','CW-PR','CTR_USR','MIS','CW-STR','CMS-STR','CW-ACC','CW5','CW4_ACC','CW4_CEO','CW5_CEO','CW5-EHK','CW5-EICK','CW5-ESRV','CW5-HKP','CW5-OFC','CW5-SK','CW5-ACC','CW5-DCK','CW5-ADM','CW-SF','CW_CHF')");
			return $query->result();
		}
		
		public function get_rmbranch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_name not like 'ST%' and branch_name not in ('GDW','SEC','FNC','MTC','PRD','CTR_USR','MIS','CW-STR','CW4_ACC','CW4_CEO','CW5_CEO','CW5-EHK','CW5-EICK','CW5-ESRV','CW5-HKP','CW5-OFC','CW5-SK','CW5-ACC','CW5-DCK','CW5-ADM','CW_CHF')");
			return $query->result();
		}
		
		public function get_rmrcpbranch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_name not like 'ST%' and branch_name not in ('CW','ESH','GDW','SEC','FNC','MTC','PRD','CW4','CW-PR','CTR_USR','MIS','CW-STR','CMS-STR','CW-ACC','CW5','CW4_ACC','CW4_CEO','CW5_CEO','CW5-EHK','CW5-EICK','CW5-ESRV','CW5-HKP','CW5-OFC','CW5-SK','CW5-ACC','CW5-DCK','CW5-ADM','CW-SF')");
			return $query->result();
		}
		
		public function get_allbranch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch");
			return $query->result();
		}
				
		public function getBranch($id)
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_id='$id'");
			return $query->result();
		}
		
		public function updateBranch($postdata)
		{
			extract($postdata);
			$data = array(
				'branch_name' => $branch_name
			);
			$this->db->where('branch_id', $branch_id);
			$this->db->update('branch', $data);
		}
		
		//Address
		public function insert_address($data){
			$this->db->insert('address',$data);
			return true;
		}

		public function get_address(){
			$query = $this->db->query("select address_id,outlet,org_name,address1,address2,address3,gstin_no from address");
			return $query->result();
		}

		public function get_address_id($address_id)	{
			$this->db->select('*');
			$this->db->from('address');
			$this->db->where('address_id',$address_id);
			$query = $this->db->get();
			if($query->num_rows() > 0)
			{
				return $query->result_array();
			}
			else{
				return '';
			}
		}
		
		//Tax
		public function insert_tax($data){
			$this->db->insert('tax',$data);
			return true;
		}

		public function get_tax(){
			$query = $this->db->query("select tax_id,tax_percentage from tax");
			return $query->result();
		}
	
		//User
		public function addUser($postdata)
		{
			extract($postdata);
			$hash_password = password_hash($password,PASSWORD_DEFAULT);
			$data = array(
				'username' => $user_name,
				'full_name' => $full_name,
				'password' => $hash_password,
				'user_group' => $group,
				'branch_id' => $branch,
				'branch_name' => $branch_name,
				'ph_no' => $ph_no,
				'address_id' => $address,
				'br_id' => $password,
				'branch_title' => $full_name,
			);
			$this->db->insert('user', $data);
		}
		
		public function get_user()
		{
			$query = $this->db->query("SELECT U.user_id,U.username,U.full_name,U.password,G.group_name,B.branch_name,U.ph_no,A.outlet,U.user_group,U.branch_id,A.address_id FROM user U,user_group G,branch B,address A where U.user_group=G.group_id and U.branch_id=B.branch_id and U.address_id=A.address_id");
			return $query->result();
		}
		
		public function getUser($id)
		{
			$query = $this->db->query("SELECT U.user_id,U.username,U.full_name,U.password,G.group_name,B.branch_name,U.ph_no,A.outlet,U.user_group,U.branch_id,U.br_id,A.address_id FROM user U,user_group G,branch B,address A where U.user_group=G.group_id and U.branch_id=B.branch_id and U.address_id=A.address_id and U.user_id='$id'");
			return $query->result();
		}
		
		public function updateUser($postdata)
		{
			extract($postdata);
			$hash_password = password_hash($password,PASSWORD_DEFAULT);
			$data = array(
				'username' => $user_name,
				'full_name' => $full_name,
				'password' => $hash_password,
				'user_group' => $group,
				'branch_id' => $branch,
				'branch_name' => $branch_name,
				'ph_no' => $ph_no,
				'address_id' => $address,
				'br_id' => $password,
				'branch_title' => $full_name,
			);
			$this->db->where('user_id', $user_id);
			$this->db->update('user', $data);
		}
		
		//User Module
		public function addUserModule($postdata)
		{
			extract($postdata);
			//$mcount = count($mod_chk);
			$scount = count($submod_chk);
			for($j=0;$j<$scount;$j++)
			{
				$sindx = $submod_chk[$j];
				$data = array(
					'username' => $user_name,
					'user_id' => $user,
					'module_id' => $module_id[$sindx],
					'sub_mod_id' => $submodule[$sindx],
					'url' => $surl[$sindx]
				);
				$this->db->insert('user_module_access', $data);
			}	
		}
		
		//User Permission
		public function get_userModule(){
			$query = $this->db->query("SELECT user_id,username,user_module_id,module_id FROM user_module_access group by user_id");
			return $query->result();
		}

		public function get_userModuleId($user_id){
			$query = $this->db->query("SELECT M.module_name,M.`module_id`,S.sub_mod_name,S.`sub_mod_id`, U.user_id,U.username,U.user_module_id,P.`permission_name`,P.`permission_id` FROM user_module_access U,module M,sub_module S,permission P where U.module_id=M.module_id and U.sub_mod_id=S.sub_mod_id and U.user_id='$user_id'");
			return $query->result();
		}
		
		public function get_userModules($user_id){
			$query = $this->db->query("SELECT M.module_name,M.`module_id`,S.sub_mod_name,S.`sub_mod_id`, U.user_id,U.username,U.status,U.user_module_id FROM user_module_access U,module M,sub_module S where U.module_id=M.module_id and U.sub_mod_id=S.sub_mod_id and U.user_id='$user_id'");
			return $query->result();
		}

		public function modulePermission($postdata)
		{
			extract($postdata);
			$pcount = count($per_chk);
			for($j=0;$j<$pcount;$j++)
			{
				$pindx = $per_chk[$j];
				$data = array(
				'username' => $user_name,
				'user_id' => $user_id,
				'module_id' => $module_id[$pindx],
				'sub_mod_id' => $submodule[$pindx],
				'permission_id' => $permission_id[$pindx],
				'user_module_id' => $user_module_id[$pindx],
				'url' => $purl[$pindx]
				);
				$this->db->insert('permission_access', $data);
			}
			/*$pcount1 = count($per_chk1);
			for($j=0;$j<$pcount1;$j++)
			{
				$pindx1 = $per_chk1[$j];
				$data = array(
				'url' => $pur11[$pindx1]
				);
				$this->db->where('user_permission_id', $user_permission_id);
				$this->db->update('permission_access', $data);
		
			}*/
		}
		
		//User Sub Permission
		public function get_userSubPermission($user_id){
			$query = $this->db->query("select M.module_id,M.module_name,S.sub_mod_id,S.sub_mod_name,P.permission_id,P.permission_name,SP.sub_permsn_id,SP.sub_permsn_name,PA.username,PA.user_id,PA.user_module_id,PA.user_permission_id from module M inner join sub_module S on M.module_id=S.module_id inner join permission_access PA on S.sub_mod_id=PA.sub_mod_id inner join permission P on PA.permission_id=P.permission_id left join sub_permission SP on P.permission_id=SP.permission_id where PA.user_id='$user_id' order by PA.module_id,PA.sub_mod_id,PA.permission_id");
			return $query->result();
		}
		
		public function addUserSubPermission($postdata)
		{
			extract($postdata);
			$pcount = count($subper_chk);
			for($j=0;$j<$pcount;$j++)
			{
				$spindx = $subper_chk[$j];
				$data = array(
				'username' => $user_name,
				'user_id' => $user_id,
				'module_id' => $module_id[$spindx],
				'sub_mod_id' => $submodule[$spindx],
				'permission_id' => $permission_id[$spindx],
				'sub_permsn_id' => $subpermission_id[$spindx],
				'user_module_id' => $user_module_id[$spindx],
				'user_permission_id' => $user_permission_id[$spindx],
				'url' => $spurl[$spindx]
				);
				$this->db->insert('subpermission_access', $data);
			}
		}
		
		public function get_SideBarData($user_id){
		//	$query = $this->db->query("SELECT M.module_id,M.module_name FROM module M,user_module_access U WHERE U.module_id=M.module_id and U.user_id='$user_id' group by M.module_id");
			$query = $this->db->query("SELECT M.module_id,M.module_name FROM module M inner join user_module_access U on U.module_id=M.module_id where U.user_id='$user_id' and U.status='Enabled' group by M.module_id");
			if($query->num_rows()>0)
			{
			    return $query->result();
			}
			else
			{
			    return false;
			}
		}
		
		public function get_thead_permission($user_id,$sub_mod_id){
			$query = $this->db->query("select M.module_id,M.module_name,S.sub_mod_id,S.sub_mod_name,P.permission_id,P.permission_name,PA.username,PA.user_id,PA.user_module_id,PA.user_permission_id,PA.url,PA.url_id from module M inner join sub_module S on M.module_id=S.module_id inner join permission_access PA on S.sub_mod_id=PA.sub_mod_id inner join permission P on PA.permission_id=P.permission_id where PA.user_id='$user_id' and PA.sub_mod_id='$sub_mod_id'");
			return $query->result();
		}
		
		public function get_username()
		{
			$query = $this->db->query("select * from user");
			return $query->result();
		}

		public function addUserAccess($postdata)
		{
			extract($postdata);

			$data = array(
			'module_name' => $module_name,
			'module_id' => $module_id,
			'branch_name' => $branch_name,
			'branch_id' => $branch,
			'access_name' => $access_name,
			'access_branch' => $access_branch,
			'access_username' => $access_uname,
			'access_uid' => $access_uid,
			'access_category' => $access_category,
			'access_cat_id' => $access_cat_id,
			'access_tab' => $access_tab
			);
			$this->db->insert('user_access', $data);
		}

		public function get_userAccessList(){
			$query = $this->db->query("SELECT `access_id`, `module_name`, `module_id`, `branch_name`, `branch_id`, `access_name`, `access_branch`, `access_username`, `access_uid`, `access_category`, `access_cat_id`, `access_tab`, `access_bank` FROM user_access");
			return $query->result();
		}

		public function updatePrIndent($postdata)
		{
			extract($postdata);

			$pcount = count($pname);
			for($i=0;$i<$pcount;$i++)
			{
			$query = $this->db->query("update recipe set product_indent='$branch_name' where branch_id='$branch_id' and recipe_no='$pname[$i]'");
			}
		}

		public function get_accessTab($sub_mod_id,$branch_id)
		{
			$query = $this->db->query("SELECT * FROM user_access where branch_id='$branch_id' and module_id='$sub_mod_id'");
			return $query->result();	
		}
		
		public function updateDcPrice($postdata)
		{
			extract($postdata);
			
			if($outlet == 'cw123')
			{
			    $pcount = count($pname);
    			for($i=0;$i<$pcount;$i++)
    			{
    			   // $query = $this->db->query("update recipe set product_indent='$branch_name' where branch_id='$branch_id' and recipe_no='$pname[$i]'");
    			    $query = $this->db->query("update recipe set cw_price='$base_price[$i]',cw_tax='$gst_rate[$i]',cw_tax_amount='$gst[$i]',cw_total_price='$tprice[$i]' where branch_id='$branch_id' and recipe_no='$pname[$i]'");
    			}
			}
			else if($outlet == 'cw4')
			{
			    $pcount = count($pname);
    			for($i=0;$i<$pcount;$i++)
    			{
			        $query = $this->db->query("update recipe set cw4_price='$base_price[$i]',cw4_tax='$gst_rate[$i]',cw4_tax_amount='$gst[$i]',cw4_total_price='$tprice[$i]' where branch_id='$branch_id' and recipe_no='$pname[$i]'");
    			}
			}
			else
			{
			    $pcount = count($pname);
    			for($i=0;$i<$pcount;$i++)
    			{
			        $query = $this->db->query("update recipe set cw5_price='$base_price[$i]',cw5_tax='$gst_rate[$i]',cw5_tax_amount='$gst[$i]',cw5_total_price='$tprice[$i]' where branch_id='$branch_id' and recipe_no='$pname[$i]'");
    			}
			}
		}
		
		public function addCustomer($postdata)
		{
			extract($postdata);

			$data = array(
    			'cust_name' => $cust_name,
    			'username' => $uname,
    			'out_branch_id' => $branch_id
			);
			$this->db->insert('customer', $data);
		}
		
		public function get_Customer()
		{
			$query = $this->db->query("SELECT * FROM customer");
			return $query->result();	
		}
		
		public function getCustomer($id)
		{
			$query = $this->db->query("SELECT * FROM customer where cust_id='$id'");
			return $query->result();	
		}
		
		public function updateCustomer($postdata)
		{
			extract($postdata);
			
			$data = array(
				'cust_name' => $cust_name,
    			'username' => $uname,
    			'out_branch_id' => $branch_id
			);
			$this->db->where('cust_id', $cust_id);
			$this->db->update('customer', $data);
		}
	
	    public function getOutlet()
		{
		    $branch_name = $_SESSION['branch_name'];
            if($branch_name=='CW4_ACC')
            {
                $query = $this->db->query("select * from user where branch_name like 'CW4%'");
            }
            else if($branch_name=='CW5-ACC')
            {
                $query = $this->db->query("select * from user where branch_name like 'CW5%'");
            }
            else
            {
                $query = $this->db->query("select * from user where user_group='8' or user_group='9'");
            }
			return $query->result();
		}
		
		public function get_outlet_by_branch_cw() {
		    $authority='admin';
			$query = $this->db->query("SELECT * FROM user  WHERE (assignedto='$authority' or assignedto like '%cakewala3%' or assignedto='cakewala2')");
			return $query->result();
		}
		
		public function get_outlet_by_branch_esh() {
		    $authority='admin';
			$query = $this->db->query("SELECT * FROM user  WHERE (assignedto='eshanya')");
			return $query->result();
		}
		
		public function get_outlet_by_branch_cw5() {
		   // $query = $this->db->query("SELECT * FROM user  WHERE assignedto='cakewala5'");
			
			$branch_name = $_SESSION['branch_name'];
            if($branch_name=='CW3')
            {
                $query = $this->db->query("SELECT * from user where assignedto like '%cakewala3%'");
            }
            else if($branch_name=='CW4')
            {
                $query = $this->db->query("SELECT * from user where assignedto='cakewala4'");
            }
            else
            {
                $query = $this->db->query("SELECT * from user where assignedto='cakewala5'");
            }
			return $query->result();
		}
		
		public function getItemCW()
		{
			$query = $this->db->query("select * from item_creation where branchname='CW'");
			return $query->result();
		}
		
		public function getrecipeDetail(){
			$query = $this->db->query("SELECT r.`recipe_id`, r.`rname`, r.`yeild`, r.`uom`, r.`pr_cat_id`, r.`branchname`, r.`branch_id`,ri.`rc_item_id`, ri.`item_name`, ri.uom as uoms,ri.`qty`, ri.`price` as basicPrice, ri.`total` as totalA, ri.`item_id` as item_ids, ri.`category_id` as category_ids FROM `recipe` r inner join recipe_item ri on r.recipe_id=ri.recipe_id where r.branch_id='34'");
			return $query->result();
		}
		
		public function getsubrecipeDetail(){
			$query = $this->db->query("SELECT r.`recipe_id`,r.`rname`,r.`yeild`, r.`uom`,r.`pr_cat_id`, r.`branchname`,ri.`sub_rc_item_id`, ri.`item_name`, ri.`qty`,ri.uom as uoms, ri.`price` as basicPrice, ri.`total` as totalA, ri.`recipe_id` as item_ids, ri.`rc_no`, ri.`sub_recipe_id` as rc_item_id, ri.`pr_cat_id` as category_ids, ri.`recipe_no`   FROM `recipe` r inner join sub_recipe_item ri on r.recipe_id=ri.recipe_id where r.branch_id='34'");
			return $query->result();
		}
		
		public function get_Rawbranch()
		{
			$query = $this->db->query("select branch_id,branch_name from branch where branch_name not in ('CEO') and user_type='No Tax'");
			return $query->result();
		}
	}
?>