<?php 
	$header_file=APPPATH.'views/include/header.php';
	require($header_file);
	$sidenav_file=APPPATH.'views/include/sidenav.php';
	require($sidenav_file);	?>
  
    <!-- BEGIN: Content-->
    <div class="app-content content" ng-app="prodreq" ng-controller="prrequest" >
      <div class="content-overlay"></div>
      <div class="content-wrapper">
        <div class="content-header row">
          <div class="content-header-left col-md-12 col-12 mb-2 breadcrumb-new">
            <h3 class="content-header-title mb-0 d-inline-block">Product Request</h3>
            <div class="row breadcrumbs-top d-inline-block">
              <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="#">Home</a>
                  </li>
                  <li class="breadcrumb-item"><a href="#">Product Request </a>
                  </li>
                  <li class="breadcrumb-item active">Product Request
                  </li>
                </ol>
              </div>
            </div>
          </div>
          
        </div>
        <div class="content-body"><!-- Basic form layout section start -->
<section id="basic-form-layouts">
	<div class="row justify-content-md-center">
		<div class="col-md-12">
			<div class="card">
				<!--<div class="card-header">
					<h4 class="card-title" id="basic-layout-form-center">Product Request</h4>
					<a class="heading-elements-toggle"><i class="la la-ellipsis-v font-medium-3"></i></a>
					<div class="heading-elements">
						<ul class="list-inline mb-0">
							<li><a data-action="collapse"><i class="ft-minus"></i></a></li>
							<li><a data-action="reload"><i class="ft-rotate-cw"></i></a></li>
							<li><a data-action="expand"><i class="ft-maximize"></i></a></li>
							<li><a data-action="close"><i class="ft-x"></i></a></li>
						</ul>
					</div>
				</div>-->
				<div class="card-content collapse show">
					<div class="card-body">
						<form class="form" autocomplete="off" action="<?php echo site_url('ProductRequest/addStRequest');?>" method="post">
							<div class="row justify-content-md-left">
								<div class="col-md-3 mleft">
									<div class="form-body">
										<div class="form-group">
										<?php $cur_date = date("d-m-Y"); 
										$branch_id = $_SESSION['branch_id'];
										$branch_name = $_SESSION['branch_name'];
										$full_name = $_SESSION['full_name']; ?>
											<label for="eventInput1">Request Date</label>
											<input class="form-control" type="text" name="req_date" id="req_date" value="<?php echo $cur_date ?>" readonly >
										</div>
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-body">
										<div class="form-group">
											<label for="eventInput1">Kitchen</label>
											<select name="dept" id="dept" class="form-control select2" ng-model='dept' ng-change='fetchProduct()' required>
												<option value="0">Select Kitchen</option>
												<?php  foreach($kitchen as $row)
													{
												?>
													<option value="<?php echo $row->access_uid ?>"><?php echo $row->access_username ?></option>
												<?php
													} 
												?>
											</select>
											<input type="hidden" name="dept1" id="dept1" class="form-control" />
											<input type="hidden" id="branch_id" class="form-control"  name="branch_id" value="<?php echo $branch_id;?>">
											<input type="hidden" id="branch_name" class="form-control"  name="branch_name" value="<?php echo $branch_name;?>">
											<input type="hidden" id="full_name" class="form-control"  name="full_name" value="<?php echo $full_name;?>">
											
										</div>
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-body">
										<div class="form-group">
											<label for="eventInput1">Order</label>
											<select id="orders" name="orders" class="select2" required >
												<option value="">Select</option>
												<option value="Santhe">Regular Order</option>
												<option value="Santhe Special Order">Special Order</option>
											</select>
										</div>
									</div>
								</div>
							</div>
							<div class="row justify-content-md-center">
								<div class="col-md-3 mleft del_date" id="del_date" style="display:none">
									<div class="form-body">
										<div class="form-group">
											<label for="eventInput1">Del Date</label>
											<!--<input class="form-control pickadate datepicker picker__input picker__input--active" type="text" name="delivery_date" id="delivery_date" data-uk-datepicker="{format:'DD-MM-YYYY'}" onChange="return checkTimeP();" placeholder="Delivery Date" readonly required >-->
											<input class="form-control" type="text" name="delivery_date" id="delivery_date" onChange="return checkTimeP();" placeholder="Delivery Date" readonly required >
										</div>
									</div>
								</div>
								<div class="col-md-3 del_time" id="del_time" style="display:none">
									<div class="form-body">
										<div class="form-group">
											<label for="eventInput1">Del Time</label>
											<select name="delivery_time"  class="select2" id="delivery_time" required >
												<option value="" selected="selected">Hour</option>
											</select>
										</div>
									</div>
								</div>
								<div class="col-md-3 del_rmk" id="del_rmk" style="display:none">
									<div class="form-body">
										<div class="form-group">
											<label for="eventInput1">Order Remark</label>
											<input class="form-control" type="text" name="ord_remark" id="ord_remark" placeholder="Order Remark" >
										</div>
									</div>
								</div>
							</div>
							<div class="row justify-content-md-right">
								<table class="table" >
									<thead>
										<tr>
											<th>Item Name</th>
											<th>UOM</th>
											<th>Qty</th>
										</tr>
									</thead>
									<tbody>
										<tr ng-repeat="item in items">
											<td>{{item.iname}}</td>
											<td>{{item.uom}}</td>
											<td style="width:203px;">
												<input class="form-control" type="hidden" name="product_name[]" id="product_name" value={{item.iname}} readonly />
												<input class="form-control" type="hidden" value={{item.cat_id}} name="cat_id[]" id="cat_id" readonly />
												<input class="form-control" type="hidden" value={{item.flavour}} name="flavour[]" id="flavour" readonly />
												<input class="form-control" type="hidden" value={{item.f_code}} name="f_code[]" id="f_code" readonly />
												<input class="form-control" type="hidden" value={{item.uom}} name="uom[]" id="uom" readonly />
												<input class="form-control" type="text" ng-model="item.qty" name="quantity[]"  id="quantity" placeholder="Req Qty" ng-keyup='qtyUpdate(item,"qty")' />
												<input class="form-control batch_no" type="hidden" name="remarks[]" id="remarks" Placeholder="Remarks"/>
												<input class="form-control" type="hidden" value={{item.id}} name="item_id[]" id="item_id" readonly />
												<input class="form-control" type="hidden" value={{item.rno}} name="recipe_no[]" id="recipe_no" readonly />
											</td>
										</tr>
									</tbody>
								</table>
							</div>

							<div class="form-actions text-center">
								<button type="reset" class="btn btn-warning mr-1">
									<i class="ft-x"></i> Cancel
								</button>
								<button type="submit" class="btn btn-primary">
									<i class="la la-check-square-o"></i> Save
								</button>
								
							</div>
						</form>	
							<button class="btn btn-warning mr-1" onclick="return alert('Updated Successfully')">Update</button>
					</div>
				</div>
			</div>
			<br/>
		</div>
	</div>

</section>
<!-- // Basic form layout section end -->
        </div>
      </div>
    </div>
    <?php //require('include/theme_customizer.php');?>

   <?php 
  $footer_file=APPPATH.'views/include/footer.php';
	require($footer_file);
	?>
	<script>
		var mainApp = angular.module('prodreq', ['ngStorage']);

		mainApp.controller('prrequest', ['$scope', '$http', function ($scope, $http) {
					
			$scope.dept = '0';
			$scope.cat = '0';
			var branch_id1 = angular.element(document.getElementById("branch_id"));
			$scope.branch_id = branch_id1.val();
			//fetch data
			console.log($scope.dept);
						
			$scope.fetchProduct = function() {
				$http({
					method: 'post',
					url: '<?php echo base_url(); ?>index.php/ProductRequest/fetchStProduct',
					headers: {'Content-Type': 'application/json'},
					data: JSON.stringify({branch_id:$scope.branch_id,dept:$scope.dept})
				}).then(function successCallback(response) {
					$scope.items = response.data;
					console.log(response.data);
				});
			}
			
			$scope.qtyUpdate = function(item,feild) {
				var item_id = item.id;
				var value = item.qty;
				$http({
					method: 'post',
					url: '<?php echo base_url(); ?>index.php/ProductRequest/updateIndentQty',
					headers: {'Content-Type': 'application/json'},
					data: JSON.stringify({value: value,item_id: item_id})
				}).then(function successCallback(response) {
					console.log('Updated successfully');
				}); 
			//console.log(item_id);
			}

		}]);
	</script>
	<script>
		 $("#dept").change(function(){
			var dept = $('#dept option:selected').text();
			$('#dept1').val(dept);
		});
	
      $("#orders").change(function(){
		var ord_type = $('#orders').val();
		//alert(ord_type);
		if(ord_type == 'Santhe')
		{
			$('#del_date').hide();
			$('#del_time').hide();
			$('#del_rmk').hide();
			//$('#ord_rmrk').css('visibility', 'hidden');
			//$("#ord_remark").attr('disabled','disabled');
			$("#delivery_date").prop('disabled', true);
			$("#delivery_time").prop('disabled', true);
			$("#ord_remark").prop('disabled', true);
			//$("#dcacl").children().attr("disabled","disabled");
		}
		else if(ord_type == 'Santhe Special Order')
		{
		    //alert(ord_type);
			$('#del_date').show();
			$('#del_time').show();
			$('#del_rmk').show();
			//$("#ord_remark").removeAttr('disabled');
			$("#delivery_date").prop('disabled', false);
			$("#delivery_time").prop('disabled', false);
			$("#ord_remark").prop('disabled', false);
			//$('#ord_rmrk').css('visibility', 'visible');
		}
	});
	
	$( function() {
		$( "#delivery_date" ).datepicker({
			format: 'DD-MM-YYYY',
			minDate: 'true'
		});
	} );
</script>
	<script>
		$(window).on('beforeunload', function () {
			//$("input[type=submit], input[type=button]").prop("disabled", "disabled");
			$("input[type=submit]").prop("disabled", "disabled");
			$("#submit").css("background-color","#dcdcdc");
		});
	</script>
	
  </body>
  <!-- END: Body-->

<!-- Mirrored from pixinvent.com/modern-admin-clean-bootstrap-4-dashboard-html-template/html/ltr/vertical-modern-menu-template/form-layout-basic.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 27 Apr 2020 09:38:02 GMT -->
</html>