<?php 
$header_file=APPPATH.'views/include/header.php';
require($header_file);
$sidenav_file=APPPATH.'views/include/sidenav.php';
require($sidenav_file);	?>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-overlay"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-6 col-12 mb-2 breadcrumb-new">
                <h3 class="content-header-title mb-0 d-inline-block">GRN Invoice </h3>
                <div class="row breadcrumbs-top d-inline-block">
                    <div class="breadcrumb-wrapper col-12">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item"><a href="#">Purchase Order</a>
                            </li>
                            <li class="breadcrumb-item active">GRN Invoice 
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="card">
                <div id="invoice-template" class="card-body p-4">
                    <div id="invoice-items-details" class="pt-2">
                        <div class="row">
                            <div class="table-responsive col-12">
                                <?php
                                    foreach($grn_data as $grn)
                                ?>
                                    <table class="table table-bordered table-responsive-lg">
                                        <thead>
                                            <tr class="main_heading">
                                                <th colspan="12">Goods Receive Note (GRN) Invoice<span class="pull-right"><?php echo $grn->user_name; ?></span></th>
                                            </tr>
                                            <tr class="data_details">
                                                <th>Purchase No : <?php echo $grn->purchase_no; ?></th>         
                                                <th colspan="2" >Purchase Date : <?php echo $grn->purchase_date; ?></th>
                                                <th colspan="2" >GRN No : <?php echo $grn->grn_no; ?></th>
                                                <th colspan="2" >GRN Date : <?php echo $grn->grn_date; ?></th>
                                                <th colspan="3">Supplier Name : <?php echo $grn->venders_name; ?></th>
                                                <th colspan="2" >Invoice : <?php echo $grn->invoice_no; ?></th>
                                            </tr>
                                            <tr class="data_details">
                                                <th colspan="6"><span>Purchase Order </th>
                                                <th colspan="6"><span>Goods Receive Notes</th>
                                            </tr>
                                            <tr class="data_heading">
                                                <th colspan="2">Product Name</th>
                                                <th>UOM</th>
                                                <th>Qty</th>
                                                <th>Price</th>
                                                <th>Qty</th>
                                                <th>Price</th>
                                                <th>Tax(%)</th>
                                                <th>Tax Amt</th>
                                                <th>Total Amount</th>
                                                <th>Remarks</th>                            
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php
                                            $count = 1;
                                            foreach($get_grn_item as $gitem){
                                        ?>
                                            <tr class="data_list">
                                                <td colspan="2"><?php echo $gitem->item_name; ?></td>
                                                <td><?php echo $gitem->unit_measurement; ?></td>
                                                <td><?php echo $gitem->required_qty; ?></td>
                                                <td><?php echo $gitem->item_price; ?></td>
                                                <td><?php echo $gitem->grn_item_qty; ?></td>
                                                <td><?php echo $gitem->grn_item_price; ?></td>
                                                <td><?php echo $gitem->grn_tax; ?></td>
                                                <td><?php echo $gitem->grn_tax_amount; ?></td>
                                                <td><?php echo $gitem->grn_grand; ?></td>
                                                <td><?php echo $gitem->grn_remarks; ?></td>                        
                                            </tr>
                                        <?php $count++; 
                                                } ?>  
                                        <?php
                                            foreach($grn_total_amount as $gamt){
                                        ?>
                                            <tr>
                                                <td colspan="8" >Total Amount</td>
                                                <td ><?php echo $gamt->sum_tax_amount; ?></td>
                                                <td ><?php echo $gamt->sum_amount; ?></td>
                                                <td></td>
                                            </tr>
                                            <?php if($grn->courier != 0) { ?>
                                                <tr>
                                                    <td colspan="8" >Courier Charge</td>
                                                    <td ><?php //echo $gamt->courier; ?></td>
                                                    <td ><?php echo $grn->courier; ?></td>
                                                    <td></td>
                                                </tr>
                                            <?php } ?>
                                            <?php if($grn->transport != 0) { ?>
                                                <tr>
                                                    <td colspan="8" >Transport Charge</td>
                                                    <td ><?php //echo $gamt->sum_tax_amount']; ?></td>
                                                    <td ><?php echo $grn->transport; ?></td>
                                                    <td></td>
                                                </tr>
                                            <?php } ?>
                                            <?php if($grn->insurance != 0) { ?>
                                                <tr>
                                                    <td colspan="8" >Insurance Charge</td>
                                                    <td ><?php //echo $row1['sum_tax_amount']; ?></td>
                                                    <td ><?php echo $grn->insurance; ?></td>
                                                    <td></td>
                                                </tr>
                                            <?php } ?>
                                            <tr>
                                                <td colspan="8" >Total Charge</td>
                                                <td ><?php //echo $row1['sum_tax_amount']; ?></td>
                                                <td ><?php echo $grn->tot_amt; ?></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td colspan="8" >Round Off</td>
                                                <td ><?php //echo $row1['sum_tax_amount']; ?></td>
                                                <td ><?php echo $grn->round_off; ?></td>
                                                <td></td>
                                            </tr>
                                            <tr>
                                                <td colspan="8" >Final Charge</td>
                                                <td ><?php //echo $row1['sum_tax_amount']; ?></td>
                                                <td ><?php echo $grn->total_amount; ?></td>
                                                <td></td>
                                            </tr>
                                        <?php
                                        }
                                        ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <!-- Invoice Footer -->
                        <div id="invoice-footer">
                            <div class="row">
                                <div class="col-sm-7 col-12 text-center text-sm-left">
                                    <!--<h6>Terms & Condition</h6>
                                    <p>Test pilot isn't always the healthiest business.</p>-->
                                </div>
                                <div class="col-sm-5 col-12 text-right">
                                    <button type="button" id="print_receipt" class="btn btn-info print_receipt  btn-sm my-1"><i class="fa ft-printer"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="row hidden-print ">
                            <?php if($grn->invoice_upload == ""){ ?>
                                <form class="uk-form-stacked" id="upload_form" method="post" action="<?php echo site_url('Purchase/grn_in_upload');?>" enctype="multipart/form-data">
                                    <h4>Invoice Upload</h4>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <div class="form-group">
                                                <!--<label>INVOICE UPLOAD</label>-->
                                                <input name="gid" id="gid" type="hidden" class="textbox" value="<?php echo $grn->gnr_id; ?>">
                                                <input type="file" name="grn_in_upload[]" id="grn_in_upload" class="form-control" onchange="preview_image();" multiple />
                                                <div id="errfn2" ></div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="submit" name="upload" id="upload"  class="btn btn-info" value="Upload">
                                            </div>
                                        </div>
                                    </div>
                                </form>
                                </br>
                            <?php } ?>
                        </div>
                        <div class="row hidden-print print_receipt">
                            <div class="col-md-12">
                                <?php if($grn->invoice_upload != ""){  ?>
                                <?php
                                    $i = 0;
                                    foreach($grn_upload as $gupload){
                                    $imageURL = $gupload->file_name;
                                ?>
                                <?php if($gupload->gstatus == 'Grn Status'){ ?>
                                    <a href="#demo1<?php echo $i; ?>" class='btn btn-primary category_list' data-toggle='collapse'>View File</a>
                                    <div id="demo1<?php echo $i; ?>" class='collapse'>
                                        <img src="<?php echo base_url(); ?><?php echo $imageURL; ?>" class="img-rounded" alt="Grn Document">
                                    </div>
                                    <?php } ?>
                                    <?php 
                                    $i++;
                                    } 
                                    ?>
                                <?php } ?>
                            </div>
                        </div>
                        <div id="image_preview"></div>
                        <div class="doc_viewer">
                            <img id="viewer" />
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
<?php 
    $footer_file=APPPATH.'views/include/footer.php';
    require($footer_file);
?>
<script>
    $("#print_receipt").click(function() {
        window.print();
        setTimeout("closePrintView()", 50);
    });
    function closePrintView() {
        window.location = '<?php echo site_url('Purchase/grn_list');?>';
    } 
</script>