<?php 
    $header_file=APPPATH.'views/include/header.php';
    require($header_file);
    $sidenav_file=APPPATH.'views/include/sidenav.php';
    require($sidenav_file); 
?>
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-overlay"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <div class="content-header-left col-md-6 col-12 mb-2 breadcrumb-new">
                <h3 class="content-header-title mb-0 d-inline-block">Purchase Order </h3>
                <div class="row breadcrumbs-top d-inline-block">
                    <div class="breadcrumb-wrapper col-12">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">Home</a>
                            </li>
                            <li class="breadcrumb-item"><a href="#">Purchase Invoice</a>
                            </li>
                            <li class="breadcrumb-item active">Purchase Invoice 
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section class="card">
                <div id="invoice-template" class="card-body p-4">
                    <div id="invoice-items-details" class="pt-2">
                        <div class="row">
                            <div class="table-responsive col-12">
                                <table class="table table-bordered table-responsive-lg">
                                    <thead>
                                        <?php
                                        foreach($purchase_order as $purchase)
                                        ?>
                                        <tr class="main_heading">
                                            <th colspan="11"><?php echo $branch_name; ?> - Purchase Order View <span class="pull-right"><?php echo $purchase->user_name; ?></span></th>
                                        </tr>
                                        <tr class="data_details">
                                            <th colspan="3" >PO  No: <?php echo $purchase->purchase_no; ?></th>
                                            <th colspan="3" >PO Date: <?php echo date('d-m-Y',strtotime($purchase->purchase_date)); ?></th>
                                            <th colspan="5">Supplier Name:<?php echo $purchase->venders_name; ?></th>
                                        </tr>
                                        <tr class="data_heading">
                                            <th>Sl.No</th>
                                            <th>Product Name</th>
                                            <th>UOM</th>
                                            <th>Quantity</th>
                                            <th>Closing Stock</th>
                                            <th>Price</th>
                                            <th>Total Amt</th>
                                            <th>Tax</th>
                                            <th>Tax Amount</th>
                                            <th>Amount</th>
                                            <th>Remarks</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $count=1;
                                        foreach($purchase_item as $pitem){
                                    ?>
                                        <tr class="data_list">
                                            <td><?php echo $count; ?></td>
                                            <td><?php echo $pitem->item_name; ?></td>
                                            <td><?php echo $pitem->unit_measurement; ?></td>
                                            <td><?php echo $pitem->required_qty; ?></td>
                                            <td><?php echo $pitem->close_stock; ?></td>
                                            <td><?php echo $pitem->item_price; ?></td>
                                            <td><?php echo $pitem->actual_amount; ?></td>
                                            <td><?php echo $pitem->po_tax; ?></td>
                                            <td><?php echo $pitem->po_tax_amount; ?></td>
                                            <td><?php echo $pitem->total_amount; ?></td>
                                            <td><?php echo $pitem->remarks; ?></td>
                                        </tr>
                                    <?php 
                                        $count++; 
                                        } 
                                    ?>
                                    <?php
                                        foreach($purchase_sum_amount as $pamt){
                                    ?>
                                        <tr>
                                            <td colspan="6">Total Amount</td>
                                            <td ><?php echo $pamt->sum_act_amount; ?></td>
                                            <td></td>
                                            <td ><?php echo $pamt->sum_tax_amount; ?></td>
                                            <td ><?php echo $pamt->sum_amount; ?></td>
                                            <td></td>
                                        </tr>
                                    <?php
                                        }
                                    ?>  
                                    </tbody>
                                </table>
                                <?php 
                                $user = 'CEO';
                                $vendor = $purchase->venders_name;
                                $branch = $purchase->branchname;
                                $q1 = $this->db->query("SELECT * FROM user where username='$user'");
                                foreach($q1->result_array() as $r1)
                                    $phone_no = $r1['ph_no'];
                                    $q2 = $this->db->query("select * from vendor_creation where company_name='$vendor' and branchname='$branch'");
                                foreach($q2->result_array() as $r2)
                                    $apr_status = $r2['aprv_status'];
                                ?>
                                    <input type="hidden" name="ph_no" id="ph_no" class="form-control" value="<?php echo $phone_no; ?>"/>
                                    <input type="hidden" name="po_no" id="po_no" class="form-control" value="<?php echo $purchase->purchase_no; ?>"/>
                                    <input type="hidden" name="aprv_status" id="aprv_status" class="form-control" value="<?php echo $apr_status; ?>"/>
                            </div>
                        </div>
                    </div>
                    <!-- Invoice Footer -->
                    <div id="invoice-footer">
                        <div class="row">
                            <div class="col-sm-7 col-12 text-center text-sm-left">
                                <!--<h6>Terms & Condition</h6>
                                <p>Test pilot isn't always the healthiest business.</p>-->
                            </div>
                            <div class="col-sm-5 col-12 text-right">
                                <button type="button" id="print_receipt" class="btn btn-info print_receipt  btn-sm my-1"><i class="fa ft-printer"></i></button>
                            </div>
                        </div>
                    </div>
                    <!-- Invoice Footer -->
                </div>
            </section>
        </div>
    </div>
</div>
<?php 
    $footer_file=APPPATH.'views/include/footer.php';
    require($footer_file);
?>
<script>
    window.onload = function(){
        req_fr_po_apprv();
    };
</script>
<script>
    $("#print_receipt").click(function() {
        window.print();
        setTimeout("closePrintView()", 50);
    });
    function closePrintView() {
        window.location = '<?php echo site_url('Purchase/purchase_order');?>';
    } 
</script>