<?php 
	$header_file=APPPATH.'views/include/header.php';
	require($header_file);
	
	?>

    <!-- BEGIN: Content-->
    <div class="app-content content">
      <div class="content-overlay"></div>
      <div class="content-wrapper" ng-app="anglist" ng-controller="anglistctlr">
        <div class="content-header row">
          <div class="content-header-left col-md-12 col-12 mb-2 breadcrumb-new">
            <h3 class="content-header-title mb-0 d-inline-block">Vendor Ledger</h3>
            <div class="row breadcrumbs-top d-inline-block">
              <div class="breadcrumb-wrapper col-12">
                <ol class="breadcrumb">
                  <li class="breadcrumb-item"><a href="#">Home</a>
                  </li>
                  <li class="breadcrumb-item"><a href="#">Stock Management</a>
                  </li>
                  <li class="breadcrumb-item active">Vendor Ledger
                  </li>
                </ol>
              </div>
            </div>
          </div>
        
        </div>
        <div class="content-body"><!-- Zero configuration table -->
<section id="configuration">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-content collapse show">
                    <div class="card-body card-dashboard">
							<form method="post" autocomplete="off" action="<?php echo site_url('StockManagement/searchAccVendorLedger/');?>" method="POST">
                        	<div class="row justify-content-md-center">
								<div class="col-md-3">
									<div class="form-group">
										<input class="form-control pickadate datepicker picker__input picker__input--active" type="text" name="from_date"  id="from_date" required data-uk-datepicker="{format:'DD-MM-YYYY'}" placeholder="From Date">
									</div>
								</div>
								<div class="col-md-3">
									<div class="form-group">
										<input class="form-control pickadate datepicker picker__input picker__input--active" type="text" name="to_date"  id="to_date" required data-uk-datepicker="{format:'DD-MM-YYYY'}" placeholder="To Date">
										<input class="form-control" type="hidden" name="sub_mod_id"  id="sub_mod_id" value="<?php echo $submodid; ?>" readonly >
									</div>
								</div>
								<div class="col-md-2">
									<div class="form-group">
										<select id="branch" name="branch" class="form-control select2" >
											<option value="">Branch</option>
											<option value="All">All</option>
											<?php  foreach($branch as $row)
												{
											?>
												<option value="<?php echo $row->access_branch; ?>"><?php echo $row->access_branch; ?></option>
											<?php
												} 
											?>
										</select>
									</div>
								</div>
								<div class="col-md-2">
									<div class="form-group">
										<select id="supplier" name="supplier" class="form-control select2" >
											<option value="">Select Supplier</option>
											<?php  foreach($supplier as $row)
												{
											?>
												<option value="<?php echo $row->company_name; ?>" class="<?php echo $row->branchname; ?>" ><?php echo $row->company_name; ?></option>
											<?php
												} 
											?>
										</select>
									</div>
								</div>
								<div class="col-md-2">
									<div class="form-group">
										<input type="submit" name="submit" class="btn btn-primary" value="Vendor Report">
									</div>
								</div>
							
						</div>
						</form>
						<div class="table-responsive">
						<?php
				if(isset($_POST['submit'])) {
					 
					if (isset($result_display)) {
						//echo "<p><u>Result</u></p>";
						if ($result_display == 'No record found !') {
							echo $result_display;
							} else {
						?>
						<?php if($_POST['from_date']!="" && $_POST['to_date']!="" && $_POST['branch']=="All"){ ?>

								 <table class="table table-striped table-bordered dataex-html5-export">
									<thead>
										<th>Vendor Name</th>
										<th>GRN Value</th>
										<th>Rejected Value</th>
										<th>Final Value</th>
										<th>Status</th>
										<th>View</th>
									</thead>
						<tbody>
							<?php 
							$fdate = $_POST['from_date'];
							$tdate = $_POST['to_date'];
							$tot_grn1 = 0;
							$tot_rjn1 = 0;
							$tot_final1 = 0;
							if(isset($result_display) && is_array($result_display) && count($result_display)): $i=1;
							foreach ($result_display as $data) { 
								$tot_grn1 = $tot_grn1 + $data['total_amount'];
								$tot_rjn1 = $tot_rjn1 + ($data['total_amount'] - $data['reject_amt']);
								$tot_final1 = $tot_final1 + $data['reject_amt'];
							?>
								<tr>
									<td><?php echo $data['vendor_name']; ?></td>
									<td><?php echo round($data['total_amount'],2); ?></td>
									<td><?php echo round(($data['total_amount'] - $data['reject_amt']),2); ?></td>
									<td><?php echo round($data['reject_amt'],2); ?></td>
									<?php 
										$vname = $data['vendor_name'];
										$q1 = $this->db->query("select g.gnr_id,g.grn_no,g.invoice_no,g.vendor_name,DATE_FORMAT(g.grn_date, '%d-%m-%Y') as grn_date,g.branchname,g.total_amount,g.reject_amt,round(sum(p.grn_grand),2) as value,g.payment_status from gnr_creation g inner join purchase_order_grn p on g.gnr_id=p.gnr_id where g.vendor_name='$vname' and (g.grn_date between '$fdate' and '$tdate') group by p.gnr_id");
										$vres = $q1->result();
										$count1 = 0;
										$count2 = 0;
										foreach($vres as $vrow)
										{
											if(($vrow->payment_status == 'Closed'))
											{	
												$count2++;	
											}
											$count1++;
										}
									?>
									<?php
										if($count1 == $count2) {
										?>
										<td class="success_data">Closed</td>
										<?php
											} else {
										?>	
										<td class="pending_data">Pending</td>
										<?php
										}
									?>
									<td>
									<a target="_blank" href="<?php echo site_url('StockManagement/voucherGeneration/'. $fdate.'/'.$tdate.'/'.$vname); ?>" class="btn btn-sm btn-info">View</a></td>
								</tr>
													
								<?php
									$i++;
									} ?>
									<td><strong>Total</strong></td>
									<td><strong><?php echo $tot_grn1; ?></strong></td>
									<td><strong><?php echo $tot_rjn1; ?></strong></td>
									<td><strong><?php echo $tot_final1; ?></strong></td>
									<td></td>
									<td></td>
									<?php else:
								?>
								<tr>
									<td colspan="8" align="center" >No Records Found..</td>
								</tr>
								<?php
									endif;
								?>
						</tbody>
					</table>

						
						<?php } else if($_POST['from_date']!="" && $_POST['to_date']!="" && $_POST['branch']!="" && $_POST['supplier']){ ?>
						<table class="table table-striped table-bordered dataex-html5-export">
							<thead>
								<th>Date</th>
								<th>Transaction</th>
								<th>GRN Value</th>
								<th>Rejected Value</th>
								<th>Final Value</th>
								<th>Status</th>
							</thead>
						<tbody>
							<?php 
							$tot_grn = 0;
							$tot_rjn = 0;
							$tot_final = 0;
							if(isset($result_display) && is_array($result_display) && count($result_display)): $i=1;
							foreach ($result_display as $data) { 
								$tot_grn = $tot_grn + $data['total_amount'];
								$tot_rjn = $tot_rjn + ($data['total_amount'] - $data['reject_amt']);
								$tot_final = $tot_final + $data['reject_amt'];
							?>
								<tr>
									<td><?php echo $data['grn_date']; ?></td>
									<td class="uk-text-nowrap">
										<a target="_blank" href="<?php echo site_url('Purchase/grn_detail/'. $data['gnr_id']); ?>" class="btn btn-sm btn-info"><?php echo $data['grn_no']; ?></a>
									</td>
									<td><?php echo $data['total_amount']; ?></td>
									<td><?php echo round(($data['total_amount'] - $data['reject_amt']),2); ?></td>
									<td><?php echo $data['reject_amt']; ?></td>
									<?php if($data['payment_status'] == 'Closed') { ?>
									<td class="success_data"><?php echo $data['payment_status']; ?></td>
									<?php } else { ?>
									<td class="pending_data"><?php echo $data['payment_status']; ?></td>
									<?php } ?>
								</tr>
													
								<?php
									$i++;
									} ?>
									
								<tr>
									<td><strong>Total</strong></td>
									<td></td>
									<td><strong><?php echo $tot_grn; ?></strong></td>
									<td><strong><?php echo $tot_rjn; ?></strong></td>
									<td><strong><?php echo $tot_final; ?></strong></td>
									<td></td>
								</tr>
									<?php else:
								?>
								<tr>
									<td colspan="8" align="center" >No Records Found..</td>
								</tr>
								<?php
									endif;
								?>
						</tbody>
					</table>
					<?php } else if($_POST['from_date']!="" && $_POST['to_date']!="" && $_POST['branch']!="" && $_POST['supplier']==""){ ?>
						<table class="table table-striped table-bordered dataex-html5-export">
									<thead>
										<th>Vendor Name</th>
										<th>GRN Value</th>
										<th>Rejected Value</th>
										<th>Final Value</th>
									</thead>
						<tbody>
							<?php 
							$fdate = $_POST['from_date'];
							$tdate = $_POST['to_date'];
							$tot_grn1 = 0;
							$tot_rjn1 = 0;
							$tot_final1 = 0;
							if(isset($result_display) && is_array($result_display) && count($result_display)): $i=1;
							foreach ($result_display as $data) { 
								$tot_grn1 = $tot_grn1 + $data['total_amount'];
								$tot_rjn1 = $tot_rjn1 + ($data['total_amount'] - $data['reject_amt']);
								$tot_final1 = $tot_final1 + $data['reject_amt'];
							?>
								<tr>
									<td><?php echo $data['vendor_name']; ?></td>
									<td><?php echo round($data['total_amount'],2); ?></td>
									<td><?php echo round(($data['total_amount'] - $data['reject_amt']),2); ?></td>
									<td><?php echo round($data['reject_amt'],2); ?></td>
								</tr>
													
								<?php
									$i++;
									} ?>
									<td><strong>Total</strong></td>
									<td><strong><?php echo $tot_grn1; ?></strong></td>
									<td><strong><?php echo $tot_rjn1; ?></strong></td>
									<td><strong><?php echo $tot_final1; ?></strong></td>
									<?php else:
								?>
								<tr>
									<td colspan="8" align="center" >No Records Found..</td>
								</tr>
								<?php
									endif;
								?>
						</tbody>
					</table>
							<?php }
					} 
					}
				}else{
				?>
				        <table class="table table-striped table-bordered dataex-html5-export">
                                <thead>
                               
                                    <tr>
                                        <th>Date</th>
										<th>Transaction</th>
										<th>Vendor</th>
										<th>GRN Value</th>
										<th>Rejected Value</th>
										<th>Final Value</th>
                                    </tr>
                                </thead>
                                <tbody>
                     <tr ng-repeat="res in results | filter : search">
            							<td>{{res.grn_date}}</td>
            							<td>
            							    
            							    <a target="_blank" href="<?php echo site_url('Purchase/grn_detail/{{res.gnr_id}}'); ?>" class="btn btn-sm btn-info">{{res.grn_no}}</a>
            							   </td>
            							<td>{{res.vendor_name}}</td>
            							<td>{{res.total_amount}}</td>
            							<td>{{res.total_amount - res.reject_amt | number:2}}</td>
            							<td>{{res.reject_amt}}</td>
            						</tr>
                                  </tbody>
                                </table>
                                 <div ng-show='loading' class='loading'>Loading...</div>
				
				<?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--/ Zero configuration table -->



<!--/ Language - Comma decimal place table -->

        </div>
      </div>
    </div>
    <!-- END: Content-->

   <?php //require('include/theme_customizer.php');?>
 <?php 
  $footer_file=APPPATH.'views/include/footer.php';
	require($footer_file);
	?>
	<script>
		$(document).ready(function() {
			$("#supplier").chained("#branch");
		});
	</script>
<script type="text/javascript">
     var fetch = angular.module('anglist', ['infinite-scroll']);
    
    fetch.controller('anglistctlr', ['$scope', '$http', function ($scope, $http) {
    
      // Variables
      //var branch1 = angular.element(document.getElementById("branch"));
 // $scope.branch = branch1.val();
      $scope.row = 0;
      $scope.rowperpage = 12;
      $scope.results = [];
      $scope.busy = false;
      $scope.loading = false;
    
      // Fetch data
      $scope.getResults = function(){
    
      if ($scope.busy) return;
    
        $scope.busy = true;
    
        // Fetch data
        $http({
          method: 'post',
          url: '<?php echo base_url() ?>index.php/StockManagement/angacc_vendorledger',
          data: {row:$scope.row,rowperpage:$scope.rowperpage}
        }).then(function successCallback(response) {
    
          if(response.data !='' ){
             // New row value 
             $scope.row+=$scope.rowperpage;
    
             $scope.loading = true;
             setTimeout(function() {
                $scope.$apply(function(){
    
                  // Assign response to results Array 
                  angular.forEach(response.data,function(item) {
                     $scope.results.push(item);
                  });
                  $scope.busy = false;
                  $scope.loading = false;
                });
    
             },500);
          }
        });
      }
    
      // Call function
      $scope.getResults();
    
    }]);
    </script>
</body>
  <!-- END: Body-->

<!-- Mirrored from pixinvent.com/modern-admin-clean-bootstrap-4-dashboard-html-template/html/ltr/vertical-modern-menu-template/form-layout-basic.html by HTTrack Website Copier/3.x [XR&CO'2014], Mon, 27 Apr 2020 09:38:02 GMT -->
</html>